/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;
import java.util.Objects;

@XmlRootElement
public class BigIntegerMultiplyModification
extends VariableModification<BigInteger> {
    @JsonProperty(required=true)
    private BigInteger factor;

    private BigIntegerMultiplyModification() {
    }

    public BigIntegerMultiplyModification(BigInteger factor) {
        this.factor = Objects.requireNonNull(factor, "Factor must not be null");
    }

    public BigIntegerMultiplyModification(BigIntegerMultiplyModification other) {
        this.factor = other.factor;
    }

    public BigIntegerMultiplyModification createCopy() {
        return new BigIntegerMultiplyModification(this);
    }

    @Override
    protected BigInteger modifyImplementationHook(BigInteger input) {
        if (input == null) {
            return null;
        }
        return input.multiply(this.factor);
    }

    public BigInteger getFactor() {
        return this.factor;
    }

    public void setFactor(BigInteger factor) {
        this.factor = Objects.requireNonNull(factor, "Factor must not be null");
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.factor);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerMultiplyModification other = (BigIntegerMultiplyModification)obj;
        return Objects.equals(this.factor, other.factor);
    }

    public String toString() {
        return "BigIntegerMultiplyModification{factor=" + String.valueOf(this.factor) + "}";
    }
}

