/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.model;

import de.rub.nds.asn1.constants.TagClass;
import de.rub.nds.asn1.constants.TagConstructed;
import de.rub.nds.asn1.constants.UniversalTagNumber;
import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.biginteger.ModifiableBigInteger;
import de.rub.nds.modifiablevariable.bool.ModifiableBoolean;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class Asn1Field
implements Asn1Encodable {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlElement(name="tagClass")
    private ModifiableInteger tagClass;
    @XmlElement(name="tagConstructed")
    private ModifiableBoolean tagConstructed;
    @XmlElement(name="tagNumber")
    private ModifiableInteger tagNumber;
    @XmlElement(name="length")
    private ModifiableBigInteger length;
    @XmlElement(name="content")
    private ModifiableByteArray content;
    @XmlAttribute(name="identifier")
    private String identifier;
    @XmlElement(name="tagOctets")
    private ModifiableByteArray tagOctets;
    @XmlElement(name="lengthOctets")
    private ModifiableByteArray lengthOctets;
    @XmlTransient
    private final TagClass tagClassType;
    @XmlTransient
    private final TagConstructed tagConstructedType;
    @XmlTransient
    private final UniversalTagNumber universalTagNumber;
    private final Integer tagNumberConfig;
    @XmlTransient
    private boolean optional = false;

    public Asn1Field(String identifier, TagClass tagClassType, TagConstructed tagConstructedType, UniversalTagNumber tagNumber) {
        assert (identifier != null);
        assert (tagClassType != null);
        assert (tagClassType == TagClass.UNIVERSAL);
        assert (tagConstructedType != null);
        this.identifier = identifier;
        this.tagClassType = tagClassType;
        this.tagConstructedType = tagConstructedType;
        this.universalTagNumber = tagNumber;
        this.tagNumberConfig = tagNumber.getIntValue();
    }

    public Asn1Field(String identifier, TagClass tagClassType, TagConstructed tagConstructedType, Integer implicitTagNumber) {
        assert (identifier != null);
        assert (tagClassType != null);
        assert (tagConstructedType != null);
        this.universalTagNumber = tagClassType == TagClass.UNIVERSAL ? UniversalTagNumber.fromIntValue(implicitTagNumber) : null;
        this.identifier = identifier;
        this.tagClassType = tagClassType;
        this.tagConstructedType = tagConstructedType;
        this.tagNumberConfig = implicitTagNumber;
    }

    protected Asn1Field() {
        this.tagClassType = null;
        this.tagConstructedType = null;
        this.tagNumberConfig = null;
        this.universalTagNumber = null;
    }

    @Override
    public final boolean matchesHeader(TagClass classType, Boolean constructed, Integer tagNumber) {
        if (!Objects.equals(tagNumber, this.tagNumberConfig)) {
            LOGGER.debug("{} not compatible because of the tagNumber Expected {} but found {}", (Object)this.identifier, (Object)this.tagNumberConfig, (Object)tagNumber);
            return false;
        }
        if (constructed.booleanValue() != this.tagConstructedType.getBooleanValue()) {
            LOGGER.debug("{} not compatible because of constructed type Expected {} but found {}", (Object)this.identifier, (Object)this.tagConstructedType.getBooleanValue(), (Object)constructed);
            return false;
        }
        if (classType != this.tagClassType) {
            LOGGER.debug("{} not compatible because of tag class type. Expected {} but found {}", (Object)this.identifier, (Object)this.tagClassType.getIntValue(), (Object)classType);
            return false;
        }
        LOGGER.debug("Asn1Field '{}' is compatible", (Object)this.identifier);
        return true;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public TagClass getTagClassType() {
        return this.tagClassType;
    }

    public TagConstructed getTagConstructedType() {
        return this.tagConstructedType;
    }

    public UniversalTagNumber getUniversalTagNumberType() {
        return this.universalTagNumber;
    }

    public ModifiableInteger getTagClass() {
        return this.tagClass;
    }

    public void setTagClass(ModifiableInteger tagClass) {
        this.tagClass = tagClass;
    }

    public void setTagClass(int tagClass) {
        this.tagClass = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.tagClass, (Integer)tagClass);
    }

    public ModifiableBoolean getTagConstructed() {
        return this.tagConstructed;
    }

    public void setTagConstructed(ModifiableBoolean tagConstructed) {
        this.tagConstructed = tagConstructed;
    }

    public void setTagConstructed(boolean tagConstructed) {
        this.tagConstructed = ModifiableVariableFactory.safelySetValue((ModifiableBoolean)this.tagConstructed, (Boolean)tagConstructed);
    }

    public ModifiableInteger getTagNumber() {
        return this.tagNumber;
    }

    public void setTagNumber(ModifiableInteger tagNumber) {
        this.tagNumber = tagNumber;
    }

    public void setTagNumber(int tagNumber) {
        this.tagNumber = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.tagNumber, (Integer)tagNumber);
    }

    public ModifiableBigInteger getLength() {
        return this.length;
    }

    public void setLength(ModifiableBigInteger length) {
        this.length = length;
    }

    public void setLength(BigInteger length) {
        this.length = ModifiableVariableFactory.safelySetValue((ModifiableBigInteger)this.length, (BigInteger)length);
    }

    @Override
    public ModifiableByteArray getContent() {
        return this.content;
    }

    public void setContent(ModifiableByteArray content) {
        this.content = content;
    }

    public void setContent(byte[] content) {
        this.content = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.content, (byte[])content);
    }

    @Override
    public ModifiableByteArray getTagOctets() {
        return this.tagOctets;
    }

    public void setTagOctets(ModifiableByteArray tagOctets) {
        this.tagOctets = tagOctets;
    }

    public void setTagOctets(byte[] tagOctets) {
        this.tagOctets = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.tagOctets, (byte[])tagOctets);
    }

    @Override
    public ModifiableByteArray getLengthOctets() {
        return this.lengthOctets;
    }

    public void setLengthOctets(ModifiableByteArray lengthOctets) {
        this.lengthOctets = lengthOctets;
    }

    public void setLengthOctets(byte[] lengthOctets) {
        this.lengthOctets = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.lengthOctets, (byte[])lengthOctets);
    }

    public Integer getTagNumberConfig() {
        return this.tagNumberConfig;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

