/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.constants;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum TagConstructed {
    PRIMITIVE(0, false),
    CONSTRUCTED(1, true);

    private static final Logger LOGGER;
    private final int intValue;
    private final boolean booleanValue;

    static {
        LOGGER = LogManager.getLogger();
    }

    private TagConstructed(int intValue, boolean booleanValue) {
        this.intValue = intValue;
        this.booleanValue = booleanValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public static TagConstructed fromIntValue(int intValue) {
        TagConstructed[] tagConstructedArray = TagConstructed.values();
        int n = tagConstructedArray.length;
        int n2 = 0;
        while (n2 < n) {
            TagConstructed currentTagConstructed = tagConstructedArray[n2];
            if (currentTagConstructed.getIntValue() == intValue) {
                return currentTagConstructed;
            }
            ++n2;
        }
        LOGGER.warn("Could not convert int value to TagConstructed");
        return null;
    }

    public static TagConstructed fromBooleanValue(boolean booleanValue) {
        TagConstructed[] tagConstructedArray = TagConstructed.values();
        int n = tagConstructedArray.length;
        int n2 = 0;
        while (n2 < n) {
            TagConstructed currentTagConstructed = tagConstructedArray[n2];
            if (currentTagConstructed.getBooleanValue() == booleanValue) {
                return currentTagConstructed;
            }
            ++n2;
        }
        return null;
    }

    public static TagConstructed fromIdentifierByte(byte identifierByte) {
        return TagConstructed.fromBooleanValue((identifierByte & 0x20) != 0);
    }
}

