/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.udp;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.udp.UdpTransportHandler;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientUdpTransportHandler
extends UdpTransportHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    protected String ipAddress;
    protected String hostname;
    protected Integer sourcePort;

    public ClientUdpTransportHandler(Connection con) {
        super(con);
        this.ipAddress = con.getIp();
        this.hostname = con.getHostname();
        this.port = con.getPort();
        this.sourcePort = con.getSourcePort();
    }

    public ClientUdpTransportHandler(long timeout, String ipAddress, int port) {
        super(timeout, ConnectionEndType.CLIENT);
        this.ipAddress = ipAddress;
        this.port = port;
    }

    @Override
    public void preInitialize() throws IOException {
    }

    @Override
    public void initialize() throws IOException {
        LOGGER.debug("Initializing ClientUdpTransportHandler host: {}, port: {}", (Object)this.hostname, (Object)this.port);
        this.socket = this.sourcePort == null || this.resetClientSourcePort ? new DatagramSocket() : new DatagramSocket(this.sourcePort);
        this.socket.connect(new InetSocketAddress(this.ipAddress, this.port));
        this.socket.setSoTimeout((int)this.timeout);
        this.cachedSocketState = null;
        this.initialized = true;
    }

    @Override
    public void closeClientConnection() throws IOException {
        this.closeConnection();
    }
}

