/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.tcp;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.tcp.TcpTransportHandler;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientTcpTransportHandler
extends TcpTransportHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    protected String hostname;
    protected long connectionTimeout;
    private boolean retryFailedSocketInitialization = false;
    private boolean clientInitializationFailed = false;

    public ClientTcpTransportHandler(Connection connection) {
        super(connection);
        this.connectionTimeout = connection.getConnectionTimeout().intValue();
        this.hostname = connection.getIp();
        this.dstPort = connection.getPort();
    }

    public ClientTcpTransportHandler(long firstTimeout, long timeout, String hostname, int port) {
        this(timeout, firstTimeout, timeout, hostname, port);
    }

    public ClientTcpTransportHandler(long connectionTimeout, long firstTimeout, long timeout, String hostname, int serverPort) {
        super(timeout, ConnectionEndType.CLIENT);
        this.hostname = hostname;
        this.dstPort = serverPort;
        this.connectionTimeout = connectionTimeout;
        this.srcPort = null;
    }

    public ClientTcpTransportHandler(long connectionTimeout, long timeout, String hostname, int serverPort, int clientPort) {
        super(timeout, ConnectionEndType.CLIENT);
        this.hostname = hostname;
        this.dstPort = serverPort;
        this.connectionTimeout = connectionTimeout;
        this.srcPort = clientPort;
    }

    @Override
    public void closeConnection() throws IOException {
        if (this.socket == null) {
            throw new IOException("TransportHandler is not initialized!");
        }
        this.socket.close();
    }

    @Override
    public void preInitialize() throws IOException {
    }

    @Override
    public void initialize() throws IOException {
        long timeoutTime = System.currentTimeMillis() + this.connectionTimeout;
        while (System.currentTimeMillis() < timeoutTime || this.connectionTimeout == 0L) {
            try {
                this.socket = new Socket();
                this.socket.setReuseAddress(true);
                if (this.srcPort != null && (this.clientInitializationFailed && this.retryFailedSocketInitialization || !this.resetClientSourcePort)) {
                    this.socket.bind(new InetSocketAddress(this.srcPort));
                }
                this.socket.connect(new InetSocketAddress(this.hostname, (int)this.dstPort), (int)this.connectionTimeout);
                if (!this.socket.isConnected()) {
                    throw new ConnectException("Could not connect to " + this.hostname + ":" + this.dstPort);
                }
                break;
            }
            catch (Exception e) {
                this.clientInitializationFailed = true;
                if (!this.retryFailedSocketInitialization) {
                    LOGGER.warn("Socket initialization to {}:{} failed", (Object)this.hostname, (Object)this.dstPort, (Object)e);
                    break;
                }
                LOGGER.warn("Server @{}:{} is not available yet", (Object)this.hostname, (Object)this.dstPort);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!this.socket.isConnected()) {
            throw new IOException("Could not connect to " + this.hostname + ":" + this.dstPort);
        }
        this.cachedSocketState = null;
        this.setStreams(new PushbackInputStream(this.socket.getInputStream()), this.socket.getOutputStream());
        this.srcPort = this.socket.getLocalPort();
        this.dstPort = this.socket.getPort();
        LOGGER.info("Connection established from ports {} -> {}", (Object)this.srcPort, (Object)this.dstPort);
        this.socket.setSoTimeout((int)this.timeout);
        this.socket.setSendBufferSize(65536);
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.socket.isClosed() || this.socket.isInputShutdown();
    }

    @Override
    public void closeClientConnection() throws IOException {
        this.closeConnection();
    }

    public boolean isRetryFailedSocketInitialization() {
        return this.retryFailedSocketInitialization;
    }

    public void setRetryFailedSocketInitialization(boolean retryFailedSocketInitialization) {
        this.retryFailedSocketInitialization = retryFailedSocketInitialization;
    }

    @Override
    public Integer getDstPort() {
        return this.dstPort;
    }

    @Override
    public Integer getSrcPort() {
        return this.srcPort;
    }

    @Override
    public void setDstPort(int serverPort) {
        if (this.isInitialized()) {
            throw new RuntimeException("Cannot change the server port once the TransportHandler is initialized");
        }
        this.dstPort = serverPort;
    }

    @Override
    public void setSrcPort(int clientPort) {
        if (this.isInitialized()) {
            throw new RuntimeException("Cannot change the client port once the TransportHandler is initialized");
        }
        this.srcPort = clientPort;
    }
}

