/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.stream;

import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.StreambasedTransportHandler;
import de.rub.nds.tlsattacker.transport.stream.TimeoutableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class StreamTransportHandler
extends StreambasedTransportHandler {
    private final OutputStream outputStream;
    private final TimeoutableInputStream timeoutableInputStream;
    private boolean closed = false;

    public StreamTransportHandler(long timeout, ConnectionEndType type, InputStream inputStream, OutputStream outputStream) {
        super(timeout, type);
        this.outputStream = outputStream;
        this.timeoutableInputStream = new TimeoutableInputStream(inputStream, timeout);
    }

    @Override
    public void closeConnection() throws IOException {
        if (this.isInitialized()) {
            try {
                this.timeoutableInputStream.close();
            }
            catch (IOException e) {
                throw new IOException("Could not close StreamTransportHandler");
            }
            try {
                this.timeoutableInputStream.close();
            }
            catch (IOException e) {
                throw new IOException("Could not close StreamTransportHandler");
            }
        }
        throw new IOException("Could not close StreamTransportHandler. Not Initialised");
        this.closed = true;
    }

    @Override
    public InputStream getInputStream() {
        return this.timeoutableInputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.closed;
    }

    @Override
    public void closeClientConnection() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
        this.timeoutableInputStream.setTimeout(timeout);
    }

    @Override
    public void preInitialize() throws IOException {
    }

    @Override
    public void initialize() throws IOException {
        this.cachedSocketState = null;
        this.setStreams(new PushbackInputStream(this.timeoutableInputStream), this.outputStream);
    }
}

