/*
 * Decompiled with CFR 0.152.
 */
package stigviewer;

import File_Operations.Legacy.File_Interfaces.CCIReader;
import Program_Tabs.Tab_STIG.STIGDriver;
import Program_Tabs.Tab_STIG.STIGsControllerSetup;
import Utility_Code.GlobalSettings.DisplayObject;
import Utility_Code.GlobalSettings.SV_Logger;
import Utility_Code.Static_Methods.ErrorHandlers;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.event.Event;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import stigviewer.SavePoint;
import stigviewer.TabDriver;

public class STIGViewer
extends Application {
    private static STIGViewer SVinst;
    private ArrayList<Window> WindowTracker;
    private Stage PrimaryStage;
    private BorderPane MainPane;
    private TabPane DefaultTabPane;
    private SavePoint MySP;
    private STIGsControllerSetup STIGTabControl;
    private ArrayList<DisplayObject> GraphicsObjs;
    private ArrayList<TabDriver> tabDrivers;
    private static final String CCI_DATA_FILE = "Resources/reference/U_CCI_List.xml";

    public void start(Stage ps) throws FileNotFoundException {
        SVinst = this;
        this.GraphicsObjs = new ArrayList();
        this.tabDrivers = new ArrayList();
        SV_Logger.getSVLog();
        Screen screen = Screen.getPrimary();
        Rectangle2D bounds = screen.getBounds();
        this.DefaultTabPane = this.createTabPane();
        this.PrimaryStage = ps;
        this.MainPane = new BorderPane();
        this.MainPane.setCenter((Node)this.DefaultTabPane);
        Scene scene = new Scene((Parent)this.MainPane);
        scene.getStylesheets().add((Object)"stigviewer/mainStyles.css");
        this.PrimaryStage.setHeight(bounds.getHeight() * 0.96);
        this.PrimaryStage.setWidth(bounds.getWidth());
        this.PrimaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("/Resources/images/SV_icon.png")));
        this.PrimaryStage.setTitle("DISA STIG Viewer : 2.8");
        this.PrimaryStage.setScene(scene);
        Logger.getLogger(STIGViewer.class.getName()).log(Level.INFO, "INFO: SV: DISA STIG Viewer START");
        this.PrimaryStage.setOnCloseRequest(e -> {
            boolean unsavedChanges = false;
            ArrayList<String> unsavedTabNames = new ArrayList<String>();
            for (TabDriver td : this.tabDrivers) {
                if (!td.isChanged()) continue;
                unsavedChanges = true;
                unsavedTabNames.add(td.getName());
            }
            if (unsavedChanges) {
                Alert closeConfirmation = new Alert(Alert.AlertType.CONFIRMATION, "There are unsaved checklists:\n" + String.join((CharSequence)"\n", unsavedTabNames) + "\n\nAre you sure you want to close the application without saving?", new ButtonType[0]);
                Button exitButton = (Button)closeConfirmation.getDialogPane().lookupButton(ButtonType.OK);
                Button cancelButton = (Button)closeConfirmation.getDialogPane().lookupButton(ButtonType.CANCEL);
                exitButton.setText("Close without saving");
                exitButton.setDefaultButton(false);
                cancelButton.setDefaultButton(true);
                closeConfirmation.setHeaderText("Unsaved Changes");
                closeConfirmation.initModality(Modality.APPLICATION_MODAL);
                closeConfirmation.initOwner((Window)this.getPrimaryStage());
                Optional closeResponse = closeConfirmation.showAndWait();
                if (!ButtonType.OK.equals(closeResponse.get())) {
                    e.consume();
                    Logger.getLogger(STIGViewer.class.getName()).log(Level.INFO, "INFO: SV: DISA STIG Viewer EXIT Cancelled at Unsaved Changes Prompt");
                    return;
                }
            }
            Logger.getLogger(STIGViewer.class.getName()).log(Level.INFO, "INFO: SV: DISA STIG Viewer EXIT");
            this.clean_close((WindowEvent)e);
        });
        this.PrimaryStage.show();
        InputStream fIn = CCIReader.getCCIReader().getClass().getClassLoader().getResourceAsStream(CCI_DATA_FILE);
        try {
            CCIReader.getCCIReader().open(fIn);
        }
        catch (Exception ex) {
            Logger.getLogger(STIGDriver.class.getName()).log(Level.SEVERE, "SEVERE: SB: CCI reader failed to open");
        }
        try {
            this.MySP = new SavePoint();
            this.MySP.CreateSavePoint();
        }
        catch (IOException e2) {
            Logger.getLogger(STIGViewer.class.getName()).log(Level.SEVERE, "SEVERE: SV: Local Data Cache Setup Failure");
            ErrorHandlers.saveFileError();
        }
        Logger.getLogger(STIGViewer.class.getName()).log(Level.INFO, "INFO: SV: Local Data Cache Setup");
        this.STIGTabControl = new STIGsControllerSetup();
        Logger.getLogger(STIGViewer.class.getName()).log(Level.INFO, "INFO: SV: STIG Explorer Tab Setup");
        this.WindowTracker = new ArrayList();
        this.WindowTracker.add((Window)this.PrimaryStage);
        Logger.getLogger(STIGViewer.class.getName()).log(Level.INFO, "INFO: SV: Window Tracker Setup");
    }

    public static void main(String[] args) {
        STIGViewer.launch((String[])args);
    }

    public Stage getPrimaryStage() {
        return this.PrimaryStage;
    }

    private void clean_close(WindowEvent e) {
        for (Window w : this.WindowTracker) {
            if (w == this.PrimaryStage) continue;
            w.fireEvent((Event)e);
        }
    }

    public void close() {
        this.PrimaryStage.fireEvent((Event)new WindowEvent((Window)this.PrimaryStage, WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    private TabPane createTabPane() {
        TabPane currTabPane = new TabPane();
        return currTabPane;
    }

    public boolean addWindow(Window w) {
        return this.WindowTracker.add(w);
    }

    public boolean removeWindow(Window w) {
        return this.WindowTracker.remove(w);
    }

    public void setWindowTitle(String title) {
        this.PrimaryStage.setTitle("DISA STIG Viewer : 2.8 : " + title);
    }

    public void OpenNewTab(TabDriver NewTabDriver) {
        this.tabDrivers.add(NewTabDriver);
        this.MainPane.setTop((Node)NewTabDriver.getMenuBar());
        NewTabDriver.getTab().selectedProperty().addListener((observable, oldValue, newValue) -> this.setWindowTitle(NewTabDriver.getTab().getText()));
        NewTabDriver.getTab().textProperty().addListener((observable, oldValue, newValue) -> this.setWindowTitle((String)newValue));
        this.DefaultTabPane.getTabs().add((Object)NewTabDriver.getTab());
        this.DefaultTabPane.getSelectionModel().select((Object)NewTabDriver.getTab());
        this.DefaultTabPane.setTabMaxWidth(350.0);
    }

    public void CloseTab(TabDriver tabDriver) {
        this.tabDrivers.remove(tabDriver);
    }

    public boolean isChecklistTabPresent() {
        return this.DefaultTabPane.getTabs().size() <= 1;
    }

    public BorderPane getMainPane() {
        return this.MainPane;
    }

    public SavePoint getSavePoint() {
        return this.MySP;
    }

    public void addDisplayObject(DisplayObject addDO) {
        this.GraphicsObjs.add(addDO);
    }

    public void removeDisplayObject(DisplayObject remDO) {
        this.GraphicsObjs.remove(remDO);
    }

    public void updateAllDisplays() {
        this.STIGTabControl.SDUpdateGraphics();
        for (DisplayObject j : this.GraphicsObjs) {
            j.graphicsUpdateRecursive();
        }
    }

    public static STIGViewer getSV() {
        return SVinst;
    }
}

