/*
 * Decompiled with CFR 0.152.
 */
package Utility_Code.Third_Party_Content;

import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;

public final class DialogFX
extends Stage {
    private Type type;
    private Stage stage;
    private Scene scene;
    private BorderPane pane = new BorderPane();
    private ImageView icon = new ImageView();
    private Label message = new Label();
    private HBox buttonBox = new HBox(10.0);
    private List<String> buttonLabels;
    private int buttonCount = 0;
    private int buttonSelected = 0;
    private List<String> stylesheets = new ArrayList<String>();

    public DialogFX() {
        this.initDialog(Type.INFO);
    }

    public DialogFX(Type t) {
        this.initDialog(t);
    }

    public void addButtons(List<String> labels) {
        this.addButtons(labels, -1, -1);
    }

    public void addButtons(List<String> labels, int defaultBtn, int cancelBtn) {
        this.buttonLabels = labels;
        for (int i = 0; i < labels.size(); ++i) {
            Button btn = new Button(labels.get(i));
            btn.setDefaultButton(i == defaultBtn);
            btn.setCancelButton(i == cancelBtn);
            btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent evt) {
                    DialogFX.this.buttonSelected = DialogFX.this.buttonLabels.indexOf(((Button)evt.getSource()).getText());
                    DialogFX.this.stage.close();
                }
            });
            this.buttonBox.getChildren().add((Object)btn);
        }
        this.buttonBox.setAlignment(Pos.CENTER);
        BorderPane.setAlignment((Node)this.buttonBox, (Pos)Pos.CENTER);
        BorderPane.setMargin((Node)this.buttonBox, (Insets)new Insets(2.0, 2.0, 2.0, 2.0));
        this.pane.setBottom((Node)this.buttonBox);
        this.buttonCount = labels.size();
    }

    private void addOKButton() {
        ArrayList<String> labels = new ArrayList<String>(1);
        labels.add("OK");
        this.addButtons(labels, 0, 0);
    }

    private void addYesNoButtons() {
        ArrayList<String> labels = new ArrayList<String>(2);
        labels.add("Yes");
        labels.add("No");
        this.addButtons(labels);
    }

    public void addStylesheet(String stylesheet) {
        try {
            String newStyle = ((Object)((Object)this)).getClass().getResource(stylesheet).toExternalForm();
            this.stylesheets.add(newStyle);
        }
        catch (Exception ex) {
            System.err.println("Unable to find specified stylesheet: " + stylesheet);
            System.err.println("Error message: " + ex.getMessage());
        }
    }

    private void initDialog(Type t) {
        this.stage = new Stage();
        this.setType(t);
        this.stage.initModality(Modality.APPLICATION_MODAL);
        this.stage.setMaxWidth(Screen.getPrimary().getVisualBounds().getWidth() / 2.0);
    }

    private void loadIconFromResource(String fileName) {
        Image imgIcon = new Image(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        this.icon.setPreserveRatio(true);
        this.icon.setFitHeight(48.0);
        this.icon.setImage(imgIcon);
    }

    public void setMessage(String msg) {
        this.message.setText(msg);
        this.message.setWrapText(true);
    }

    public void setModal(boolean isModal) {
        this.stage.initModality(isModal ? Modality.APPLICATION_MODAL : Modality.NONE);
    }

    public void setTitleText(String title) {
        this.stage.setTitle(title);
    }

    public void setType(Type typeToSet) {
        this.type = typeToSet;
    }

    private void populateStage() {
        String iconFile;
        switch (this.type) {
            case ACCEPT: {
                iconFile = "Dialog-accept.jpg";
                this.addOKButton();
                break;
            }
            case ERROR: {
                iconFile = "Dialog-error.jpg";
                this.addOKButton();
                break;
            }
            case INFO: {
                iconFile = "Dialog-info.jpg";
                this.addOKButton();
                break;
            }
            case QUESTION: {
                iconFile = "Dialog-question.jpg";
                break;
            }
            default: {
                iconFile = "Dialog-info.jpg";
            }
        }
        try {
            this.loadIconFromResource(iconFile);
        }
        catch (Exception ex) {
            System.err.println("Exception trying to load icon file: " + ex.getMessage());
        }
        BorderPane.setAlignment((Node)this.icon, (Pos)Pos.CENTER);
        BorderPane.setMargin((Node)this.icon, (Insets)new Insets(2.0, 2.0, 2.0, 2.0));
        this.pane.setLeft((Node)this.icon);
        BorderPane.setAlignment((Node)this.message, (Pos)Pos.CENTER);
        BorderPane.setMargin((Node)this.message, (Insets)new Insets(2.0, 2.0, 2.0, 2.0));
        this.pane.setCenter((Node)this.message);
        this.scene = new Scene((Parent)this.pane);
        for (int i = 0; i < this.stylesheets.size(); ++i) {
            try {
                this.scene.getStylesheets().add((Object)this.stylesheets.get(i));
                continue;
            }
            catch (Exception ex) {
                System.err.println("Unable to load specified stylesheet: " + this.stylesheets.get(i));
                System.err.println(ex.getMessage());
            }
        }
        this.stage.setScene(this.scene);
    }

    public int showDialog() {
        this.populateStage();
        if (this.type == Type.QUESTION && this.buttonCount == 0) {
            this.addYesNoButtons();
        }
        this.stage.setResizable(false);
        this.stage.sizeToScene();
        this.stage.centerOnScreen();
        this.stage.showAndWait();
        return this.buttonSelected;
    }

    public static enum Type {
        ACCEPT,
        ERROR,
        INFO,
        QUESTION;

    }
}

