/*
 * Decompiled with CFR 0.152.
 */
package Utility_Code.Static_Methods;

import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import Utility_Code.Static_Methods.Sorts;
import java.util.List;
import java.util.regex.Pattern;

public class TextReplace {
    public static String LtGt_toSymbol(String input) {
        String output = input.replaceAll("&lt", "<");
        output = output.replaceAll("&gt", ">");
        return output;
    }

    public static String Highlight(String text, List<String> highlights) {
        String highlightsO = "";
        highlights = Sorts.sortStrListLargeSmall(highlights);
        for (String s : highlights) {
            highlightsO = highlightsO + Pattern.quote(s) + "|";
        }
        if (highlightsO.length() > 1) {
            highlightsO = highlightsO.substring(0, highlightsO.length() - 1);
            text = text.replaceAll("(?i)(" + highlightsO + ")", "<span style='background-color:" + PrefSet.getPS().getSVFilterHighlight() + "'>$1</span>");
        }
        return text;
    }

    public static String NLToBreak_LtGtSwap(String text) {
        text = TextReplace.LtGtSwap(text);
        text = TextReplace.NLToBreak(text);
        return text;
    }

    public static String NLToBreak(String text) {
        text = text.replaceAll("\n", "<br>");
        return text;
    }

    public static String LtGtSwap(String text) {
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        return text;
    }

    public static String HTMLForm(String text, List<String> filterList) {
        text = text.trim();
        text = TextReplace.LtGtSwap(text);
        text = TextReplace.Highlight(text, filterList);
        text = TextReplace.NLToBreak(text);
        return text;
    }

    public static String getSevFromCat(String sev) {
        String cat = "";
        switch (sev) {
            case "CAT I": {
                cat = "high";
                break;
            }
            case "CAT II": {
                cat = "medium";
                break;
            }
            case "CAT III": {
                cat = "low";
                break;
            }
        }
        return cat;
    }

    public static String getCatFromSev(String cat) {
        String sev = "";
        switch (cat) {
            case "high": {
                sev = "CAT I";
                break;
            }
            case "medium": {
                sev = "CAT II";
                break;
            }
            case "low": {
                sev = "CAT III";
                break;
            }
        }
        return sev;
    }
}

