/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs;

import File_Operations.File_Objects.Vuln;
import Program_Tabs.interfaces.Controller;
import Program_Tabs.interfaces.DisplayTab;
import Utility_Code.GlobalSettings.DisplayObject;
import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import Utility_Code.GlobalSettings.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Paint;
import javafx.util.Callback;

public class VulnTable
extends DisplayObject {
    private final DisplayTab myParent;
    private final ArrayList<DispColumn> myDispSet;
    private ObservableList<VulnTableItem> data;
    private ObservableList<TableColumn> columns;
    private TableView myTable;
    private final TableColumn STIGIDColumn;
    private final TableColumn VulIDColumn;
    private final TableColumn RuleIDColumn;
    private final TableColumn CCIColumn;
    private final TableColumn STIGNameColumn;
    private final TableColumn CheckStateColumn;
    private final TableColumn PostureColumn;
    boolean bIsChecklist;
    private Label sb_VulCount;
    private Label sb_CurrVul;
    private int currentSelection = 0;
    private Vuln CurrentVuln;

    public VulnTable(DisplayTab Parent2, ArrayList<DispColumn> DispSet) {
        this.myParent = Parent2;
        this.myDispSet = DispSet;
        this.bIsChecklist = false;
        this.STIGIDColumn = new TableColumn("STIG ID");
        this.VulIDColumn = new TableColumn("Vul ID");
        this.RuleIDColumn = new TableColumn("Rule ID");
        this.CCIColumn = new TableColumn("CCI ID");
        this.STIGNameColumn = new TableColumn("Rule Name");
        this.CheckStateColumn = new TableColumn("Status");
        this.PostureColumn = new TableColumn("Posture");
    }

    private void createSTIGIDColumn(Vuln vComp) {
        this.STIGIDColumn.setEditable(false);
        this.STIGIDColumn.setResizable(true);
        this.STIGIDColumn.setMinWidth(80.0);
        this.STIGIDColumn.setPrefWidth(120.0);
        this.STIGIDColumn.setComparator((Comparator)vComp.getsVulnSTIGID());
        this.STIGIDColumn.setCellFactory(this.getCellRenderer());
    }

    private void createVulIDColumn(Vuln vComp) {
        this.VulIDColumn.setEditable(false);
        this.VulIDColumn.setResizable(true);
        this.VulIDColumn.setMinWidth(80.0);
        this.VulIDColumn.setPrefWidth(150.0);
        this.VulIDColumn.setComparator((Comparator)vComp.getsVulnIDs());
        this.VulIDColumn.setCellFactory(this.getCellRenderer());
    }

    private void createRuleIDColumn(Vuln vComp) {
        this.RuleIDColumn.setEditable(false);
        this.RuleIDColumn.setResizable(true);
        this.RuleIDColumn.setMinWidth(94.0);
        this.RuleIDColumn.setPrefWidth(150.0);
        this.RuleIDColumn.setComparator((Comparator)vComp.getsVulnRuleID());
        this.RuleIDColumn.setCellFactory(this.getCellRenderer());
    }

    private void createCCIColumn(Vuln vComp) {
        this.CCIColumn.setEditable(false);
        this.CCIColumn.setResizable(true);
        this.CCIColumn.setMinWidth(94.0);
        this.CCIColumn.setComparator((Comparator)vComp.getsVulnCCI_ID());
        this.CCIColumn.setCellFactory(this.getCellRenderer());
    }

    private void createSTIGNameColumn(Vuln vComp) {
        this.STIGNameColumn.setEditable(false);
        this.STIGNameColumn.setResizable(true);
        this.STIGNameColumn.setMinWidth(100.0);
        this.STIGNameColumn.setPrefWidth(250.0);
        this.STIGNameColumn.setCellFactory(this.getCellRenderer());
    }

    private void createCheckStateColumn(Vuln vComp) {
        this.CheckStateColumn.setEditable(false);
        this.CheckStateColumn.setResizable(true);
        this.CheckStateColumn.setMinWidth(30.0);
        this.CheckStateColumn.setCellFactory(this.getCellRenderer());
        this.bIsChecklist = true;
    }

    public void setSelectedCheckState(Vuln.CheckState state) {
        for (Object o : this.myTable.getSelectionModel().getSelectedItems()) {
            ((VulnTableItem)o).getVuln().setCheckState(state);
        }
        this.myParent.updateRuleDisplay(((VulnTableItem)this.myTable.getSelectionModel().getSelectedItem()).getVuln());
        this.myParent.updateDisplay();
    }

    public void setSelectedComments(String comments) {
        for (Object o : this.myTable.getSelectionModel().getSelectedItems()) {
            ((VulnTableItem)o).getVuln().setCheckComment(comments);
        }
        this.myParent.updateRuleDisplay(((VulnTableItem)this.myTable.getSelectionModel().getSelectedItem()).getVuln());
        this.myParent.updateDisplay();
    }

    public void setSelectedFindingDetails(String findingDetails) {
        for (Object o : this.myTable.getSelectionModel().getSelectedItems()) {
            ((VulnTableItem)o).getVuln().setCHK_Notes(findingDetails);
        }
        this.myParent.updateRuleDisplay(((VulnTableItem)this.myTable.getSelectionModel().getSelectedItem()).getVuln());
        this.myParent.updateDisplay();
    }

    public TableView createTable() {
        this.CurrentVuln = new Vuln();
        Vuln vComp = new Vuln();
        this.myTable = new TableView();
        this.myTable.setStyle(PrefSet.getPS().getJfxTableDefault());
        this.myTable.setRowFactory(this.vulnRowFactory());
        this.columns = FXCollections.observableArrayList();
        for (DispColumn dc : this.myDispSet) {
            switch (dc) {
                case STIGID: {
                    this.createSTIGIDColumn(vComp);
                    this.STIGIDColumn.setVisible(false);
                    this.columns.add((Object)this.STIGIDColumn);
                    break;
                }
                case VulID: {
                    this.createVulIDColumn(vComp);
                    this.VulIDColumn.setVisible(true);
                    this.columns.add((Object)this.VulIDColumn);
                    break;
                }
                case RuleID: {
                    this.createRuleIDColumn(vComp);
                    this.RuleIDColumn.setVisible(false);
                    this.columns.add((Object)this.RuleIDColumn);
                    break;
                }
                case CCI: {
                    this.createCCIColumn(vComp);
                    this.CCIColumn.setVisible(false);
                    this.columns.add((Object)this.CCIColumn);
                    break;
                }
                case STIGName: {
                    this.createSTIGNameColumn(vComp);
                    this.STIGNameColumn.setVisible(true);
                    this.columns.add((Object)this.STIGNameColumn);
                    break;
                }
                case CheckState: {
                    this.createCheckStateColumn(vComp);
                    this.CheckStateColumn.setVisible(true);
                    this.columns.add((Object)this.CheckStateColumn);
                    break;
                }
            }
        }
        this.myTable.getColumns().addAll(this.columns);
        this.myTable.setEditable(false);
        this.myTable.setTableMenuButtonVisible(true);
        this.myTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        if (this.bIsChecklist) {
            ContextMenu ctxMenu = new ContextMenu();
            this.myTable.setContextMenu(ctxMenu);
            Menu mStatus = new Menu("Set Status");
            ctxMenu.getItems().add((Object)mStatus);
            MenuItem miOpen = new MenuItem("Open");
            miOpen.setOnAction(e -> this.setSelectedCheckState(Vuln.CheckState.Open));
            mStatus.getItems().add((Object)miOpen);
            MenuItem miNotAFinding = new MenuItem("Not a Finding");
            miNotAFinding.setOnAction(e -> this.setSelectedCheckState(Vuln.CheckState.NotAFinding));
            mStatus.getItems().add((Object)miNotAFinding);
            MenuItem miNotApplicable = new MenuItem("Not Applicable");
            miNotApplicable.setOnAction(e -> this.setSelectedCheckState(Vuln.CheckState.Not_Applicable));
            mStatus.getItems().add((Object)miNotApplicable);
            MenuItem miNotReviewed = new MenuItem("Not Reviewed");
            miNotReviewed.setOnAction(e -> this.setSelectedCheckState(Vuln.CheckState.Not_Reviewed));
            mStatus.getItems().add((Object)miNotReviewed);
            Menu mPaste = new Menu("Paste Text");
            ctxMenu.getItems().add((Object)mPaste);
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ctxMenu.setOnShowing(e -> mPaste.setDisable(!clipboard.hasString()));
            MenuItem miPasteDetails = new MenuItem("Paste as finding details");
            mPaste.getItems().add((Object)miPasteDetails);
            miPasteDetails.setOnAction(e -> this.setSelectedFindingDetails(clipboard.getString()));
            MenuItem miPasteComments = new MenuItem("Paste as comments");
            mPaste.getItems().add((Object)miPasteComments);
            miPasteComments.setOnAction(e -> this.setSelectedComments(clipboard.getString()));
            MenuItem miSelectAll = new MenuItem("Select All");
            miSelectAll.setOnAction(e -> this.myTable.getSelectionModel().selectAll());
            ctxMenu.getItems().add((Object)miSelectAll);
            this.myTable.setOnKeyPressed(t -> {
                KeyEvent kt = t;
                switch (kt.getCode()) {
                    case O: {
                        this.setSelectedCheckState(Vuln.CheckState.Open);
                        break;
                    }
                    case N: {
                        this.setSelectedCheckState(Vuln.CheckState.NotAFinding);
                        break;
                    }
                    case X: {
                        this.setSelectedCheckState(Vuln.CheckState.Not_Applicable);
                        break;
                    }
                    case R: {
                        this.setSelectedCheckState(Vuln.CheckState.Not_Reviewed);
                        break;
                    }
                }
            });
        }
        this.myTable.getSelectionModel().selectedIndexProperty().addListener((ov, t, new_index) -> {
            block4: {
                this.currentSelection = this.myTable.getSelectionModel().getSelectedIndex();
                try {
                    if (new_index.intValue() == -1) {
                        this.myParent.changeCurrentRule(this.myTable.getItems() == null || this.myTable.getItems().isEmpty() ? null : (VulnTableItem)this.myTable.getItems().get(0));
                    } else {
                        this.myParent.changeCurrentRule(this.myTable.getItems() == null ? null : (VulnTableItem)this.myTable.getItems().get(new_index.intValue()));
                    }
                    this.updateTableStatusBar();
                }
                catch (Exception e) {
                    if (!Util.bAllowPrintln) break block4;
                    e.printStackTrace();
                }
            }
        });
        this.myTable.getSelectionModel().getSelectedItems().addListener(item -> {
            if (!PrefSet.getPS().getStyle().contains("Classic")) {
                this.myParent.updateCurrentSelectedVuls(new ArrayList<Vuln>(), false);
                for (Controller c : this.DOControllers) {
                    c.Signal_Update("c");
                }
            }
            this.myParent.updateCurrentSelectedVuls(this.getAllSelectedItemsArray(), false);
        });
        if (this.myParent.getClass().getSimpleName().equals("ChecklistViewTab")) {
            this.myTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        }
        return this.myTable;
    }

    public void deselectAll() {
        this.myTable.getSelectionModel().clearSelection();
    }

    public ArrayList<Vuln> getAllSelectedItemsArray() {
        ArrayList<Vuln> vuls = new ArrayList<Vuln>();
        for (Object o : this.myTable.getSelectionModel().getSelectedItems()) {
            if (o == null) continue;
            vuls.add(((VulnTableItem)o).getVuln());
        }
        return vuls;
    }

    public HBox createTableStatusBar() {
        HBox StatusBar = new HBox(20.0);
        this.sb_VulCount = new Label();
        this.sb_CurrVul = new Label();
        StatusBar.getChildren().addAll((Object[])new Node[]{this.sb_VulCount, this.sb_CurrVul});
        StatusBar.setMaxHeight(20.0);
        return StatusBar;
    }

    public void setStatusMessage(String message) {
        this.sb_VulCount.setText(message);
    }

    private void updateTableStatusBar() {
        block4: {
            try {
                if (this.myTable.getItems() != null && this.myTable.getItems().size() > 0) {
                    this.sb_VulCount.setText("Showing rule " + (this.myTable.getSelectionModel().getSelectedIndex() + 1) + " out of " + this.myTable.getItems().size());
                } else {
                    this.sb_VulCount.setText("No Rules Selected");
                }
            }
            catch (Exception e) {
                this.sb_VulCount.setText("");
                if (!Util.bAllowPrintln) break block4;
                e.printStackTrace();
            }
        }
    }

    public int getSelectedIndex() {
        return this.myTable.getSelectionModel().getSelectedIndex();
    }

    public int getCurrentListSize() {
        return this.myTable.getItems().size();
    }

    public boolean changeVulnList(ArrayList<Vuln> VulnList) {
        boolean emptyTableBool = true;
        ObservableList temp = this.myTable.getSortOrder();
        ArrayList sort = new ArrayList();
        for (Object o : temp) {
            sort.add(o);
        }
        if (VulnList != null) {
            if (this.myTable != null && this.myTable.getItems() != null) {
                emptyTableBool = false;
            }
            this.data = FXCollections.observableArrayList();
            for (int CurrentVulnIndex = 0; CurrentVulnIndex < VulnList.size(); ++CurrentVulnIndex) {
                Vuln tmpV = VulnList.get(CurrentVulnIndex);
                this.data.add((Object)new VulnTableItem(tmpV));
            }
            if (this.STIGIDColumn != null) {
                this.STIGIDColumn.setCellValueFactory((Callback)new PropertyValueFactory("STIG_ID"));
            }
            if (this.VulIDColumn != null) {
                this.VulIDColumn.setCellValueFactory((Callback)new PropertyValueFactory("Vuln_ID"));
            }
            if (this.RuleIDColumn != null) {
                this.RuleIDColumn.setCellValueFactory((Callback)new PropertyValueFactory("Rule_ID"));
            }
            if (this.CCIColumn != null) {
                this.CCIColumn.setCellValueFactory((Callback)new PropertyValueFactory("CCI_ID"));
            }
            if (this.STIGNameColumn != null) {
                this.STIGNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("Rule_Name"));
            }
            if (this.CheckStateColumn != null) {
                this.CheckStateColumn.setCellValueFactory((Callback)new PropertyValueFactory("Check_State"));
            }
            if (this.PostureColumn != null) {
                this.PostureColumn.setCellValueFactory((Callback)new PropertyValueFactory("Asset_Posture"));
            }
            this.myTable.setItems(this.data);
        } else {
            this.myTable.setItems(FXCollections.observableArrayList());
            this.myParent.changeCurrentRule(null);
        }
        this.runStoredSort(sort);
        this.updateTableStatusBar();
        return emptyTableBool;
    }

    public void selectionMonitor(boolean emptyTableBool) {
        if (emptyTableBool) {
            if (this.myTable.getItems().size() > 0) {
                this.myParent.changeCurrentRule((VulnTableItem)this.myTable.getItems().get(0));
                this.myTable.getSelectionModel().clearAndSelect(0);
            }
        } else if (this.myTable.getItems().size() > 0) {
            VulnTableItem selectVTI = (VulnTableItem)this.myTable.getItems().get(0);
            for (int i = 0; i < this.myTable.getItems().size(); ++i) {
                VulnTableItem tempVTI = (VulnTableItem)this.myTable.getItems().get(i);
                if (!tempVTI.getVuln().equals(this.CurrentVuln)) continue;
                selectVTI = tempVTI;
                break;
            }
            this.myParent.changeCurrentRule(selectVTI);
            this.myTable.getSelectionModel().clearSelection();
            this.myTable.getSelectionModel().select((Object)selectVTI);
        }
    }

    public void UpdateDisplay() {
        ObservableList temp = this.myTable.getSortOrder();
        ArrayList sort = new ArrayList();
        for (Object o : temp) {
            sort.add(o);
        }
        if (this.data != null) {
            for (VulnTableItem vti : this.data) {
                vti.UpdateEntry();
            }
        }
        this.myTable.refresh();
        this.runStoredSort(sort);
    }

    public void SetFocusOnRow(int index) {
        this.myTable.getSelectionModel().select(index);
    }

    public void runStoredSort(ArrayList sort) {
        if (!sort.isEmpty() && this.myTable.getSortOrder() != null) {
            this.myTable.getSortOrder().clear();
            this.myTable.getSortOrder().setAll((Collection)sort);
            for (int i = 0; i < sort.size(); ++i) {
                TableColumn tc = (TableColumn)sort.get(i);
                tc.setSortable(false);
                tc.setSortable(true);
            }
        }
    }

    private Callback<TableColumn, TableCell> getCellRenderer() {
        return new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn param) {
                TableCell<VulnTableItem, String> tc = new TableCell<VulnTableItem, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && this.getTableRow() != null) {
                            block27: {
                                try {
                                    int i = this.getTableRow().getIndex();
                                    Vuln v = ((VulnTableItem)this.getTableColumn().getTableView().getItems().get(i)).getVuln();
                                    block7 : switch (v.getCheckState().toString()) {
                                        case "O": {
                                            boolean oFlag = false;
                                            String sTemp = v.getAttr(Vuln.VulnAttr.Severity);
                                            String oStatus = v.getCheckSevOverride();
                                            if (oStatus != null && !oStatus.isEmpty()) {
                                                sTemp = oStatus;
                                            }
                                            switch (sTemp) {
                                                case "medium": {
                                                    this.setTextFill((Paint)PrefSet.getPS().getSV_FONT_OPEN2_COLOR_RGB_FX());
                                                    break block7;
                                                }
                                                case "low": {
                                                    this.setTextFill((Paint)PrefSet.getPS().getSV_FONT_OPEN3_COLOR_RGB_FX());
                                                    break block7;
                                                }
                                                case "high": {
                                                    this.setTextFill((Paint)PrefSet.getPS().getSV_FONT_OPEN1_COLOR_RGB_FX());
                                                }
                                            }
                                            break;
                                        }
                                        case "NF": {
                                            this.setTextFill((Paint)PrefSet.getPS().getSV_FONT_NAF_COLOR_RGB_FX());
                                            break;
                                        }
                                        case "NA": {
                                            this.setTextFill((Paint)PrefSet.getPS().getSV_FONT_NA_COLOR_RGB_FX());
                                            break;
                                        }
                                        case "NR": {
                                            this.setTextFill((Paint)PrefSet.getPS().getSV_FONT_NR_COLOR_RGB_FX());
                                        }
                                        default: {
                                            this.setTextFill((Paint)PrefSet.getPS().getSV_FONT_DEFAULT_COLOR());
                                            break;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    if (!Util.bAllowPrintln) break block27;
                                    e.printStackTrace();
                                }
                            }
                            this.setText(item);
                        } else {
                            this.setText(null);
                        }
                    }
                };
                tc.setStyle(PrefSet.getPS().getJfxFontSpec());
                return tc;
            }
        };
    }

    private Callback<TableView, TableRow> vulnRowFactory() {
        return new Callback<TableView, TableRow>(){

            public TableRow call(TableView p) {
                final TableRow tr = new TableRow();
                tr.setStyle(PrefSet.getPS().getJfxTableDefault());
                tr.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> ov, Boolean old, Boolean rec) {
                        if (rec.booleanValue()) {
                            tr.setStyle(PrefSet.getPS().getJfxTableHighlight());
                            VulnTableItem tempVTI = (VulnTableItem)VulnTable.this.myTable.getItems().get(tr.getIndex());
                            if (tempVTI != null) {
                                VulnTable.this.CurrentVuln = tempVTI.getVuln();
                            }
                        } else {
                            tr.setStyle(PrefSet.getPS().getJfxTableDefault());
                        }
                    }
                });
                return tr;
            }
        };
    }

    @Override
    public List<DisplayObject> getChildDisplayObjects() {
        ArrayList<DisplayObject> dispOs = new ArrayList<DisplayObject>();
        return dispOs;
    }

    @Override
    public void graphicsUpdate() {
        this.myTable.setStyle(PrefSet.getPS().getJfxTableDefault());
        this.myTable.setRowFactory(this.vulnRowFactory());
        this.STIGIDColumn.setCellFactory(this.getCellRenderer());
        this.VulIDColumn.setCellFactory(this.getCellRenderer());
        this.RuleIDColumn.setCellFactory(this.getCellRenderer());
        this.CCIColumn.setCellFactory(this.getCellRenderer());
        this.STIGNameColumn.setCellFactory(this.getCellRenderer());
        this.CheckStateColumn.setCellFactory(this.getCellRenderer());
        this.myParent.updateDisplay();
        if (this.myTable != null && !this.myTable.getSelectionModel().getSelectedCells().isEmpty() && this.myTable.getSelectionModel().getSelectedItems() != null && (VulnTableItem)this.myTable.getSelectionModel().getSelectedItems().get(this.myTable.getSelectionModel().getSelectedCells().size() - 1) != null) {
            this.myParent.updateRuleDisplay(((VulnTableItem)this.myTable.getSelectionModel().getSelectedItems().get(this.myTable.getSelectionModel().getSelectedCells().size() - 1)).getVuln());
        }
    }

    public class VulnTableItem {
        private final SimpleStringProperty Rule_ID;
        private final SimpleStringProperty Vuln_ID;
        private final SimpleStringProperty STIG_ID;
        private final SimpleStringProperty CCI_ID;
        private final SimpleStringProperty Rule_Name;
        private final SimpleStringProperty STIG_Name;
        private SimpleStringProperty Check_State;
        private SimpleStringProperty Asset_Posture;
        private final Vuln myVuln;

        public VulnTableItem(Vuln v) {
            this.myVuln = v;
            this.Rule_ID = new SimpleStringProperty(this.myVuln.getAttr(Vuln.VulnAttr.Rule_ID));
            this.STIG_ID = new SimpleStringProperty(this.myVuln.getAttr(Vuln.VulnAttr.Rule_Ver));
            this.Vuln_ID = new SimpleStringProperty(this.myVuln.getAttr(Vuln.VulnAttr.Vuln_Num));
            this.Rule_Name = new SimpleStringProperty(this.myVuln.getAttr(Vuln.VulnAttr.Group_Title));
            this.STIG_Name = new SimpleStringProperty(this.myVuln.getAttr(Vuln.VulnAttr.STIGRef));
            this.Asset_Posture = new SimpleStringProperty(this.myVuln.getAttr(Vuln.VulnAttr.TargetKey));
            this.CCI_ID = new SimpleStringProperty(this.myVuln.getAllCCIs());
            this.UpdateEntry();
        }

        public final void UpdateEntry() {
            this.Check_State = new SimpleStringProperty(this.myVuln.getCheckState().toString());
            this.Asset_Posture = new SimpleStringProperty(this.myVuln.getAttr(Vuln.VulnAttr.TargetKey));
        }

        public String getSTIG_Name() {
            return this.STIG_Name.get();
        }

        public String getRule_ID() {
            return this.Rule_ID.get();
        }

        public String getAsset_Posture() {
            return this.Asset_Posture.get();
        }

        public String getSTIG_ID() {
            return this.STIG_ID.get();
        }

        public String getVuln_ID() {
            return this.Vuln_ID.get();
        }

        public String getCCI_ID() {
            return this.CCI_ID.get();
        }

        public String getRule_Name() {
            return this.Rule_Name.get();
        }

        public String getCheck_State() {
            return this.Check_State.get();
        }

        public Vuln getVuln() {
            return this.myVuln;
        }

        public void setSTIG_Name(String StigRef) {
            this.STIG_Name.set(StigRef);
        }

        public void setRule_ID(String RI) {
            this.Rule_ID.set(RI);
        }

        public void setAsset_Posture(String sAP) {
            this.Asset_Posture.set(sAP);
        }

        public void setSTIG_ID(String SI) {
            this.STIG_ID.set(SI);
        }

        public void setVuln_ID(String VI) {
            this.Vuln_ID.set(VI);
        }

        public void setCCI_ID(String CI) {
            this.CCI_ID.set(CI);
        }

        public void setRule_Name(String RN) {
            this.Rule_Name.set(RN);
        }

        public void setCheck_State(String CS) {
            this.Check_State.set(CS);
        }
    }

    public static enum ContextMenuType {
        NONE,
        STANDARD,
        ASSETPOSTURE;

    }

    public static enum DispColumn {
        STIGID,
        VulID,
        RuleID,
        CCI,
        STIGName,
        CheckState,
        AssetPosture;

    }
}

