/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class ListSelectionDialog
extends Dialog<List<String>> {
    private ObservableList availableList;
    private ObservableList selectedList;
    private List<String> list;
    private int minimumSelectionCount = 0;

    public ListSelectionDialog(List<String> list, Set<String> selected) {
        this.list = list;
        this.availableList = FXCollections.observableArrayList();
        this.selectedList = FXCollections.observableArrayList();
        this.setResultConverter(this::convertDialogResult);
        for (String item : list) {
            if (selected.contains(item)) {
                this.selectedList.add((Object)item);
                continue;
            }
            this.availableList.add((Object)item);
        }
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        GridPane content = new GridPane();
        content.setMaxWidth(Double.MAX_VALUE);
        content.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Label availableLabel = new Label("Available:");
        Label selectedLabel = new Label("Selected:");
        ListView availableListView = new ListView();
        availableListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        availableListView.setItems(this.availableList);
        ListView selectedListView = new ListView();
        selectedListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        selectedListView.setItems(this.selectedList);
        VBox buttonBox = new VBox();
        buttonBox.setSpacing(10.0);
        buttonBox.setMaxHeight(Double.MAX_VALUE);
        buttonBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        buttonBox.setAlignment(Pos.CENTER);
        Button moveRightButton = new Button("\u2192");
        moveRightButton.setFont(Font.font((String)"sans-serif", (FontWeight)FontWeight.EXTRA_BOLD, (double)18.0));
        moveRightButton.setOnAction(event -> {
            for (Object item : availableListView.getSelectionModel().getSelectedItems()) {
                this.selectedList.add(item);
            }
            for (Object item : this.selectedList) {
                this.availableList.remove(item);
            }
        });
        Button moveLeftButton = new Button("\u2190");
        moveLeftButton.setFont(Font.font((String)"sans-serif", (FontWeight)FontWeight.EXTRA_BOLD, (double)18.0));
        moveLeftButton.setOnAction(event -> {
            for (Object item : selectedListView.getSelectionModel().getSelectedItems()) {
                this.availableList.add(item);
            }
            for (Object item : this.availableList) {
                this.selectedList.remove(item);
            }
        });
        buttonBox.getChildren().add((Object)moveRightButton);
        buttonBox.getChildren().add((Object)moveLeftButton);
        content.add((Node)availableLabel, 0, 0);
        content.add((Node)availableListView, 0, 1);
        content.add((Node)buttonBox, 2, 1);
        content.add((Node)selectedLabel, 3, 0);
        content.add((Node)selectedListView, 3, 1);
        this.getDialogPane().setContent((Node)content);
        Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        okButton.addEventFilter(ActionEvent.ACTION, ae -> {
            if (!this.isValid()) {
                ae.consume();
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle("Invalid Selection");
                alert.setHeaderText("Invalid Selection");
                alert.setContentText("You must select at least one field to export.");
                alert.showAndWait();
            }
        });
    }

    protected boolean isValid() {
        return this.selectedList.size() >= this.minimumSelectionCount;
    }

    private List convertDialogResult(ButtonType buttonType) {
        if (buttonType.equals(ButtonType.OK)) {
            ArrayList result = new ArrayList();
            for (Object item : this.selectedList) {
                result.add(item);
            }
            return result;
        }
        return null;
    }

    public void setMinimumSelectionCount(int count) {
        this.minimumSelectionCount = count;
    }

    public int getMinimumSelectionCount() {
        return this.minimumSelectionCount;
    }
}

