/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_Checklist.CklCompare;

import File_Operations.File_Objects.Checklist;
import File_Operations.File_Objects.STIG;
import File_Operations.File_Objects.Vuln;
import File_Operations.File_Readers.DetermineDocType_Ckl;
import Program_Tabs.Tab_Checklist.ChecklistDriver;
import Utility_Code.Static_Methods.ErrorHandlers;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChecklistCompare {
    private final ChecklistDriver CklDriver;
    private File CmpFile;

    public ChecklistCompare(ChecklistDriver cklDrive) {
        this.CklDriver = cklDrive;
        this.CmpFile = new File("");
    }

    public void process() {
        Checklist newCkl = this.populateNewCkl(this.CmpFile);
        if (this.transferVulnStatuses(newCkl)) {
            this.transferMetaData(newCkl);
        }
        this.CklDriver.UpdateCurrentSTIGList(this.CklDriver.getSTIGs());
    }

    private Checklist populateNewCkl(File f) {
        Checklist tempList = new Checklist();
        try {
            tempList = DetermineDocType_Ckl.getDetermineDoctype_Ckl().getChecklist(f);
        }
        catch (Exception ex) {
            Logger.getLogger(ChecklistCompare.class.getName()).log(Level.SEVERE, null, ex);
        }
        return tempList;
    }

    private void transferMetaData(Checklist n) {
        Checklist o = this.CklDriver.getChecklist();
        o.setBIsWebDB(n.getBIsWebDB());
        o.setFullyQualifiedDN(n.getFullyQualifiedDN());
        o.setHostName(n.getHostName());
        o.setIPAddress(n.getIPAddress());
        o.setInstance(n.getInstance());
        o.setIsComputing(n.getIsComputing());
        o.setMACAddress(n.getMACAddress());
        o.setRole(n.getRole());
        o.setSite(n.getSite());
        o.setTargetKey(n.getTargetKey());
        o.setTechnologyArea(n.getTechnologyArea());
    }

    private boolean transferVulnStatuses(Checklist n) {
        boolean sMatchFound = false;
        boolean vulnCmpOnly = false;
        boolean vMatchFound = false;
        block0: for (STIG nSTIG : n.getChecklistSTIGList()) {
            for (STIG oSTIG : this.CklDriver.getSTIGs()) {
                sMatchFound = false;
                if (!nSTIG.getSTIG_Title().equals(oSTIG.getSTIG_Title())) continue;
                sMatchFound = true;
                block2: for (Vuln oldV : oSTIG.getVulnList()) {
                    for (Vuln newV : nSTIG.getVulnList()) {
                        if (!oldV.getAttr(Vuln.VulnAttr.Rule_ID).equals(newV.getAttr(Vuln.VulnAttr.Rule_ID))) continue;
                        vMatchFound = true;
                        oldV.setCheckState(newV.getCheckState());
                        oldV.setCHK_Notes(newV.getCHK_Notes());
                        oldV.setCheckComment(newV.getCheckComment());
                        oldV.setCheckSevJust(newV.getCheckSevJust());
                        oldV.setCheckSevOverride(newV.getCheckSevOverride());
                        continue block2;
                    }
                }
                continue block0;
            }
        }
        if (!sMatchFound) {
            vulnCmpOnly = ErrorHandlers.vulnCmpOnly();
        }
        if (vulnCmpOnly) {
            ArrayList<Vuln> current = new ArrayList<Vuln>();
            ArrayList<Vuln> newVlist = new ArrayList<Vuln>();
            for (STIG s : n.getChecklistSTIGList()) {
                for (Vuln v : s.getVulnList()) {
                    newVlist.add(v);
                }
            }
            for (STIG s : this.CklDriver.getSTIGs()) {
                for (Vuln v : s.getVulnList()) {
                    current.add(v);
                }
            }
            block8: for (Vuln cv : current) {
                for (Vuln nv : newVlist) {
                    if (!cv.getAttr(Vuln.VulnAttr.Rule_ID).equals(nv.getAttr(Vuln.VulnAttr.Rule_ID))) continue;
                    vMatchFound = true;
                    cv.setCheckState(nv.getCheckState());
                    cv.setCHK_Notes(nv.getCHK_Notes());
                    cv.setCheckComment(nv.getCheckComment());
                    cv.setCheckSevJust(nv.getCheckSevJust());
                    cv.setCheckSevOverride(nv.getCheckSevOverride());
                    continue block8;
                }
            }
        }
        return vMatchFound;
    }

    public void setFile(File f) {
        this.CmpFile = f;
    }
}

