/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.Legacy.Export_Functions;

import File_Operations.File_Objects.Vuln;
import File_Operations.Legacy.File_Interfaces.CCIReader;
import Program_Tabs.Tab_STIG.STIGDriver;
import Utility_Code.GlobalSettings.ConfigurationController;
import Utility_Code.Static_Methods.ErrorHandlers;
import Utility_Code.Static_Methods.TextReplace;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;

public class RTF_Exporter {
    public static String GetRTFHeader(Vuln myVuln, boolean bUseLine) {
        String sHeader = "";
        String sNL = bUseLine ? "\\line " : "\\par ";
        sHeader = "{\\rtf1\\ansi\\f0\\pard {\\fonttbl {\\f0 " + ConfigurationController.getCC().sGetFont() + ";}}";
        sHeader = sHeader + "\\fs" + Integer.toString(ConfigurationController.getCC().getFontSize()) + " ";
        sHeader = sHeader + "{\\colortbl;\\red" + ConfigurationController.getCC().GetTextColor().getRed() + "\\green" + ConfigurationController.getCC().GetTextColor().getGreen() + "\\blue" + ConfigurationController.getCC().GetTextColor().getBlue() + ";}\\cf1";
        sHeader = sHeader + "{\\b STIG: }" + myVuln.getAttr(Vuln.VulnAttr.STIGRef) + sNL;
        sHeader = sHeader + "{\\b Rule Title: } " + myVuln.getAttr(Vuln.VulnAttr.Rule_Title) + sNL + "{\\b STIG ID: }" + myVuln.getAttr(Vuln.VulnAttr.Rule_Ver) + "{\\b   Rule ID: }" + myVuln.getAttr(Vuln.VulnAttr.Rule_ID) + "{\\b   Vul ID: }" + myVuln.getAttr(Vuln.VulnAttr.Vuln_Num) + sNL;
        sHeader = sHeader + "{\\b Severity: }";
        sHeader = myVuln.getAttr(Vuln.VulnAttr.Severity).equals("high") ? sHeader + "CAT I" : (myVuln.getAttr(Vuln.VulnAttr.Severity).equals("medium") ? sHeader + "CAT II" : (myVuln.getAttr(Vuln.VulnAttr.Severity).equals("low") ? sHeader + "CAT III" : sHeader + "Unknown"));
        sHeader = sHeader + "{\\b  Class: }" + myVuln.getAttr(Vuln.VulnAttr.Class) + sNL;
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.Check_Content_Ref)) && myVuln.getAttr(Vuln.VulnAttr.Check_Content_Ref).contains("oval:")) {
            sHeader = sHeader + "{\\b SCAP:}" + myVuln.getAttr(Vuln.VulnAttr.Check_Content_Ref);
        }
        sHeader = sHeader + sNL + "}";
        return sHeader;
    }

    public static String GetRTFBody(Vuln myVuln, boolean bUseLine) {
        ArrayList<CCIReader.CCI_Store> CCIs;
        String sNL = bUseLine ? "\\line " : "\\par ";
        String sBody = "{\\rtf1\\ansi\\f0\\pard {\\fonttbl {\\f0 " + ConfigurationController.getCC().sGetFont() + ";}}";
        sBody = sBody + "\\fs" + Integer.toString(ConfigurationController.getCC().getFontSize()) + " ";
        sBody = sBody + "{\\colortbl;\\red" + ConfigurationController.getCC().GetTextColor().getRed() + "\\green" + ConfigurationController.getCC().GetTextColor().getGreen() + "\\blue" + ConfigurationController.getCC().GetTextColor().getBlue() + ";}\\cf1";
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.Vuln_Discuss))) {
            sBody = sBody + RTF_Exporter.Body("Discussion", myVuln.getAttr(Vuln.VulnAttr.Vuln_Discuss), bUseLine);
        }
        String sTemp = myVuln.getAttr(Vuln.VulnAttr.Documentable).equals("true") ? "Yes" : "No";
        sBody = sBody + RTF_Exporter.Body("Documentable", sTemp, bUseLine, true);
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.False_Negatives))) {
            sBody = sBody + RTF_Exporter.Body("False Negatives", myVuln.getAttr(Vuln.VulnAttr.False_Negatives), bUseLine);
        }
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.False_Positives))) {
            sBody = sBody + RTF_Exporter.Body("False Positives", myVuln.getAttr(Vuln.VulnAttr.False_Positives), bUseLine);
        }
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.Mitigation_Control))) {
            sBody = sBody + RTF_Exporter.Body("Mitigation Control", myVuln.getAttr(Vuln.VulnAttr.Mitigation_Control), bUseLine);
        }
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.Mitigations))) {
            sBody = sBody + RTF_Exporter.Body("Mitigations", myVuln.getAttr(Vuln.VulnAttr.Mitigations), bUseLine);
        }
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.Potential_Impact))) {
            sBody = sBody + RTF_Exporter.Body("Potential Impacts", myVuln.getAttr(Vuln.VulnAttr.Potential_Impact), bUseLine);
        }
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.Responsibility))) {
            sBody = sBody + RTF_Exporter.Body("Responsibility", myVuln.getAttr(Vuln.VulnAttr.Responsibility), bUseLine);
        }
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.Security_Override_Guidance))) {
            sBody = sBody + RTF_Exporter.Body("Severity Override Guidance", myVuln.getAttr(Vuln.VulnAttr.Security_Override_Guidance), bUseLine);
        }
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.Third_Party_Tools))) {
            sBody = sBody + RTF_Exporter.Body("Third Party Tools", myVuln.getAttr(Vuln.VulnAttr.Third_Party_Tools), bUseLine);
        }
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.Check_Content))) {
            sBody = sBody + RTF_Exporter.Body("Check Content", myVuln.getAttr(Vuln.VulnAttr.Check_Content), bUseLine);
        }
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.Fix_Text))) {
            sBody = sBody + RTF_Exporter.Body("Fix Text", myVuln.getAttr(Vuln.VulnAttr.Fix_Text), bUseLine);
        }
        if (RTF_Exporter.bHasAlphNum(myVuln.getAttr(Vuln.VulnAttr.IA_Controls))) {
            sBody = sBody + "{\\b IA Controls:}";
            sBody = sBody + myVuln.getAttr(Vuln.VulnAttr.IA_Controls) + sNL;
        }
        if (myVuln.getmyCCI() != null && (CCIs = myVuln.GetCCIs()).size() == myVuln.GetCCIVals().size() && myVuln.GetCCIVals().size() > 0) {
            for (String sCCI : myVuln.GetCCIVals()) {
                sBody = sBody + "{\\b CCI: }";
                sBody = sBody + sCCI + sNL;
                CCIReader.CCI_Store cci = myVuln.GetCCIbyName(sCCI);
                if (cci != null) {
                    sBody = sBody + cci.sDefinition + sNL;
                    for (int k = 0; k < cci.sRefs.size(); ++k) {
                        sBody = sBody + cci.sRefs.get(k).getFirst() + " :: " + cci.sRefs.get(k).getSecond() + sNL;
                    }
                }
                sBody = sBody + sNL;
            }
        }
        sBody = !bUseLine ? sBody + " \\par}" : sBody + "}";
        return sBody;
    }

    private static String Body(String sTitle, String sData, boolean bUseLine) {
        return RTF_Exporter.Body(sTitle, sData, bUseLine, false);
    }

    private static String Body(String sTitle, String sData, boolean bUseLine, boolean bNoReturnAfterTitle) {
        sData = TextReplace.LtGt_toSymbol(sData);
        String sRet = "";
        if (sTitle != null) {
            sRet = "{\\b " + sTitle + ":} ";
            if (!bNoReturnAfterTitle) {
                sRet = bUseLine ? sRet + "\\line " : sRet + "\\par ";
            }
        }
        if (bUseLine) {
            sRet = sRet + RTF_Exporter.RTFnlX_loop_line(sData);
            sRet = sRet + "\\line \\line ";
        } else {
            sRet = sRet + RTF_Exporter.RTFnlX_loop_par(sData);
            sRet = sRet + "\\par \\par ";
        }
        return sRet;
    }

    public static boolean bHasAlphNum(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (!Character.isLetterOrDigit(s.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private static String RTFnlX_loop_par(String s) {
        String sRet = "";
        int iLast = 0;
        if (s.length() > 1) {
            for (int i = 1; i < s.length(); ++i) {
                if (s.charAt(i) != '\n' && s.charAt(i) != '\\' && s.charAt(i) != '{' && s.charAt(i) != '}') continue;
                if (iLast <= i) {
                    sRet = s.charAt(i) == '\n' ? sRet + s.substring(iLast, i) + "\\par " : (s.charAt(i) == '\\' ? sRet + s.substring(iLast, i) + "\\" : sRet + s.substring(iLast, i) + "\\");
                }
                iLast = i;
            }
            if (iLast <= s.length()) {
                sRet = sRet + s.substring(iLast, s.length());
            }
        }
        return sRet;
    }

    private static String RTFnlX_loop_line(String s) {
        String sRet = "";
        int iLast = 0;
        if (s.length() >= 1) {
            for (int i = 1; i < s.length(); ++i) {
                if (s.charAt(i) == '\n' || s.charAt(i) == '\\' || s.charAt(i) == '{' || s.charAt(i) == '}') {
                    if (iLast <= i) {
                        sRet = s.charAt(i) == '\n' ? sRet + s.substring(iLast, i) + "\\line " : (s.charAt(i) == '\\' ? sRet + s.substring(iLast, i) + "\\" : sRet + s.substring(iLast, i) + "\\");
                    }
                    iLast = i;
                }
                if (s.charAt(i) <= '\u007f' || iLast > i) continue;
                sRet = sRet + s.substring(iLast, i) + "\\uc1 \\u" + Integer.toString(s.charAt(i)) + ";";
                iLast = i + 1;
            }
            if (iLast <= s.length()) {
                sRet = sRet + s.substring(iLast, s.length());
            }
        }
        return sRet;
    }

    public static void export(String fileAbsPath, STIGDriver STIGDriverparent) {
        if (!fileAbsPath.endsWith(".rtf")) {
            fileAbsPath = fileAbsPath + ".rtf";
        }
        File FileToWrite = new File(fileAbsPath);
        String sOut = "";
        String sHeader = "";
        sHeader = RTF_Exporter.FormatSTIGHeader(STIGDriverparent);
        sOut = sOut + "{\\rtf1\\ansi\\ansicpg1252\\deff0\\titlepg {\\fonttbl {\\f0 " + ConfigurationController.getCC().sGetFont() + ";}}";
        sOut = sOut + "{\\header \\pard\\plain \\ltrpar\\qc " + STIGDriverparent.getMasterClassification() + "}";
        sOut = sOut + "{\\footer \\pard\\plain \\ltrpar\\qc " + STIGDriverparent.getMasterClassification() + "}";
        sOut = sOut + sHeader;
        sOut = sOut + "\\pard\\par \\page ";
        sOut = sOut + "\\f0 ";
        ArrayList<String> sVulns = RTF_Exporter.FormatVulnList(STIGDriverparent);
        for (int i = 0; i < sVulns.size(); ++i) {
            sOut = sOut + sVulns.get(i);
        }
        sOut = sOut + "\\par }";
        try {
            FileOutputStream FileWriter = new FileOutputStream(FileToWrite);
            BufferedOutputStream bos = new BufferedOutputStream(FileWriter);
            bos.write(sOut.getBytes("UTF-8"));
            bos.close();
        }
        catch (Exception e) {
            ErrorHandlers.ioExportError("STIG Document (.rtf) export file");
        }
    }

    private static String FormatSTIGHeader(STIGDriver STIGDriverparent) {
        String sRet = "";
        sRet = sRet + "\\par \\par \\par";
        sRet = sRet + "{\\pard\\plain \\ltrpar\\qc " + STIGDriverparent.getMasterClassification() + "\\par }";
        return sRet;
    }

    private static ArrayList<String> FormatVulnList(STIGDriver STIGDriverparent) {
        ArrayList<String> asRet = new ArrayList<String>();
        for (Vuln CurrentVuln : STIGDriverparent.getMasterVulnList()) {
            String sBody = "";
            sBody = sBody + "\\trowd\\trgaph144 ";
            sBody = sBody + "\\clbrdrt\\brdrs\\clbrdrl\\brdrs\\clbrdrb\\brdrs\\clbrdrr\\brdrs ";
            sBody = sBody + "\\cellx9360 ";
            sBody = sBody + RTF_Exporter.GetRTFHeader(CurrentVuln, true);
            sBody = sBody + " \\intbl\\cell \\row ";
            sBody = sBody + "\\trowd\\trgaph144 ";
            sBody = sBody + "\\clbrdrt\\brdrs\\clbrdrl\\brdrs\\clbrdrb\\brdrs\\clbrdrr\\brdrs ";
            sBody = sBody + "\\cellx9360 ";
            sBody = sBody + RTF_Exporter.GetRTFBody(CurrentVuln, true);
            sBody = sBody + " \\intbl\\cell \\row {\\pard \\par}";
            asRet.add(sBody);
        }
        return asRet;
    }
}

