/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.File_Readers;

import File_Operations.File_Objects.Checklist;
import File_Operations.File_Readers.Checklist_Read;
import File_Operations.File_Validators.Checklist_Validate;
import Utility_Code.CustomExceptions.NotChecklistException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DetermineDocType_Ckl {
    private static DetermineDocType_Ckl DocType_Ckl;
    private File CklF = new File("");
    private XMLStreamReader XMLRead = null;
    InputStream fInXML = null;
    private boolean validate = true;

    private DetermineDocType_Ckl() {
    }

    private Checklist parseChecklist(CKL_TYPE type) {
        Checklist retCkl = new Checklist();
        retCkl = Checklist_Read.getChecklist_Read_2x().ParseCkl(this.XMLRead);
        try {
            this.XMLRead.close();
        }
        catch (Exception e) {
            Logger.getLogger(DetermineDocType_Ckl.class.getName()).log(Level.WARNING, "Warning: DD: 1: Exception closing XMLRead.");
        }
        try {
            this.fInXML.close();
        }
        catch (Exception e) {
            Logger.getLogger(DetermineDocType_Ckl.class.getName()).log(Level.WARNING, "Warning: DD: 1: Exception closing FileInputStream.");
        }
        return retCkl;
    }

    private CKL_TYPE TypeDetermine() throws Exception {
        CKL_TYPE ct = CKL_TYPE.Twox;
        XMLInputFactory xmlFact = XMLInputFactory.newInstance();
        try {
            this.fInXML = new FileInputStream(this.CklF);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DetermineDocType_Ckl.class.getName()).log(Level.SEVERE, "SEVERE: DD: 1: IO error upon creating file reader");
        }
        try {
            this.XMLRead = xmlFact.createXMLStreamReader(this.fInXML);
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(DetermineDocType_Ckl.class.getName()).log(Level.SEVERE, "SEVERE: DD: 2: IO error upon creating file reader");
        }
        try {
            this.XMLRead.nextTag();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(DetermineDocType_Ckl.class.getName()).log(Level.SEVERE, "SEVERE: DD: 3: IO error upon creating file reader");
        }
        if (!this.XMLRead.isStartElement() || !this.XMLRead.getLocalName().equals("CHECKLIST")) {
            throw new NotChecklistException("Attempted to open a Checklist using a document that was not a Checklist");
        }
        this.XMLRead.nextTag();
        if (this.XMLRead.getLocalName().equals("SV_VERSION")) {
            ct = CKL_TYPE.Onex;
            this.XMLRead.next();
            this.XMLRead.nextTag();
        }
        return ct;
    }

    public static DetermineDocType_Ckl getDetermineDoctype_Ckl() {
        if (DocType_Ckl == null) {
            DocType_Ckl = new DetermineDocType_Ckl();
        }
        return DocType_Ckl;
    }

    private void setFile(File f) {
        this.CklF = f;
    }

    public Checklist getChecklist(File f) throws Exception {
        Checklist_Validate validate;
        this.setFile(f);
        CKL_TYPE type = this.TypeDetermine();
        if (type == CKL_TYPE.Twox && this.validate && !(validate = new Checklist_Validate()).validate(f)) {
            throw new Exception("Checklist failed XML schema validation for Checklist Schema V2.0.");
        }
        return this.parseChecklist(type);
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    private static enum CKL_TYPE {
        Onex,
        Twox;

    }
}

