# Sourcemapper

Sourcemapper is a bit of golang to parse a sourcemap, as generated by webpack or similar, and spit out the original JavaScript files, recreating the source tree based on the file paths in the sourcemap.

An article explaining its purpose is available here: [https://pulsesecurity.co.nz/articles/javascript-from-sourcemaps](https://pulsesecurity.co.nz/articles/javascript-from-sourcemaps)

## Install

If you have a recent version of Go installed:

```bash
go install github.com/denandz/sourcemapper@latest
```

Otherwise you can clone and build:

```bash
git clone https://github.com/denandz/sourcemapper
cd sourcemapper
go get
go build
```

If you are running [BlackArch Linux](https://blackarch.org/):

```bash
pacman -S sourcemapper
```

## Usage

```text
:~$ ./sourcemapper
Usage of ./sourcemapper:
  -header value
    	A header to send with the request, similar to curl's -H. Can be set multiple times, EG: "./sourcemapper --header "Cookie: session=bar" --header "Authorization: blerp"
  -help
    	Show help
  -insecure
    	Ignore invalid TLS certificates
  -jsurl string
    	URL to JavaScript file - cannot be used with url
  -output string
    	Source file output directory - REQUIRED
  -proxy string
    	Proxy URL
  -url string
    	URL or path to the Sourcemap file - cannot be used with jsurl
```

## Extracting SourceMaps from .map URLs or local files

The following example shows `sourcemapper` reading a `.map` file from Dockerhub. Note, Dockerhub have since removed this map file so the literal command below will not provide this output any more.

```text
doi@asov:~$ ./sourcemapper -output dhubsrc -url https://hub.docker.com/public/js/client.356c14916fb23f85707f.js.map
[+] Retriving Sourcemap from https://hub.docker.com/public/js/client.356c14916fb23f85707f.js.map
[+] Read 23045027 bytes, parsing JSON
[+] Retrieved Sourcemap with version 3, containing 1828 entries
[+] Writing 9076765 bytes to dhubsrc/webpack:/js/client.356c14916fb23f85707f.js
[+] Writing 1014 bytes to dhubsrc/webpack:/webpack/bootstrap 356c14916fb23f85707f
[+] Writing 3174 bytes to dhubsrc/webpack:/app/scripts/client.js
[+] Writing 281 bytes to dhubsrc/webpack:/~/babel-runtime/helpers/interop-require-default.js
[+] Writing 151 bytes to dhubsrc/webpack:/~/babel-core/polyfill.js
{snip}
[+] Writing 271 bytes to dhubsrc/webpack:/~/rc-tooltip/~/core-js/library/fn/object/set-prototype-of.js
[+] Writing 315 bytes to dhubsrc/webpack:/~/rc-tooltip/~/core-js/library/modules/es6.object.set-prototype-of.js
[+] Writing 1044 bytes to dhubsrc/webpack:/~/rc-tooltip/~/core-js/library/modules/_set-proto.js
[+] Writing 308 bytes to dhubsrc/webpack:/~/rc-tooltip/~/core-js/library/fn/object/create.js
[+] Writing 307 bytes to dhubsrc/webpack:/~/rc-tooltip/~/core-js/library/modules/es6.object.create.js
[+] Writing 360 bytes to dhubsrc/webpack:/~/rc-animate/~/core-js/library/fn/object/define-property.js
[+] Writing 371 bytes to dhubsrc/webpack:/~/rc-animate/~/core-js/library/modules/es6.object.define-property.js
[+] Writing 1041 bytes to dhubsrc/webpack:/~/rc-animate/~/babel-runtime/helpers/createClass.js
[+] done
doi@asov:~$ cd dhubsrc/
doi@asov:~/dhubsrc$ du -hs .
20M     .
doi@asov:~/dhubsrc$ cd webpack\:/
~/         app/       js/        webpack/   (webpack)/
doi@asov:~/dhubsrc$ cd webpack\:/app/scripts/
actions/     components/  middlewares/ reducers/    selectors/   stores/      vendor/
doi@asov:~/dhubsrc$ cd webpack\:/app/scripts/components/
```

Sourcemapper will download or read the map file at `url`, and then spit the sources out into the directory defined by `output`. `url` can be either an URL, or a path to a map file on disk. Extracting a sourcemap to a file can get around sourcemaps configured with `sourceMappingURL=data:application/json;.... base64 blob...` by decoding the blob into a file, then passing the file path to sourcemapper. Alternatively, `data:` URL can be handled by directly parsing the JavaScript file as discussed in the following section.

## Extracting SourceMaps directly from JavaScript files

`sourcemapper` can read a JavaScript file from a URL and try to determine whether a sourcemap reference is present. If it is, `sourcemapper` will download and parse the sourcemap. Absolute, relative and `data:` sourcemap references are currently supported. `sourcemapper` follows the rules outlined in https://tc39.es/source-map-spec/#linking-generated-code.

The following shows an example of an inline sourcemap being parsed by processing the JavaScript file directly:

```text
$ ./sourcemapper -output test -jsurl http://localhost:8080/main.js
024/01/05 18:43:53 [+] Retrieving JavaScript from URL: http://localhost:8080/main.js.
2024/01/05 18:43:53 [.] Found SourceMap in JavaScript body: data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFpbi5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBQVk7O0FBRVo7O0FBRUE7QUFDQSxtREFBbUQsSUFBSSxTQUFTLE1BQU0sSUFBSTs7QUFFMUU7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxDQUFDO0FBQ0Q7QUFDQSxDQUFDOztBQUVEO0FBQ0E7QUFDQSxXQUFXLFFBQVE7QUFDbkIsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHVDQUF1QztBQUN2QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsMkRBQTJEO0FBQzNEOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRzs7QUFFSDtBQUNBO0FBQ0EsR0FBRzs7QUFFSDtBQUNBOztBQUVBO0FBQ0E7QUFDQSxXQUFXLFFBQVE7QUFDbkI7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE9BQU87QUFDUDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLE1BQU07Q...
2024/01/05 18:43:53 [+] Retrieving Sourcemap from data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFpbi5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBQVk7O0FBRVo7O0FBRUE7QUFDQSxtREFBbUQsSUFBSSxTQUFTLE1BQU0sSUFBSTs7QUFFMUU7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxDQUFDO0FBQ0Q7QUFDQSxDQUFDOztBQUVEO0FBQ0E7QUFDQSxXQUFXLFFBQVE7QUFDbkIsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHVDQUF1QztBQUN2QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsMkRBQTJEO0FBQzNEOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRzs7QUFFSDtBQUNBO0FBQ0EsR0FBRzs7QUFFSDtBQUNBOztBQUVBO0FBQ0E7QUFDQSxXQUFXLFFBQVE7QUFDbkI7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE9BQU87QUFDUDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLE1BQU07Q...
2024/01/05 18:43:53 [+] Read 4708918 bytes, parsing JSON.
2024/01/05 18:43:54 [+] Retrieved Sourcemap with version 3, containing 535 entries.
2024/01/05 18:43:54 [+] Writing 4262 bytes to test/webpack:/app/node_modules/ansi-html-community/index.js.
2024/01/05 18:43:54 [+] Writing 40 bytes to test/webpack:/app/node_modules/axios/index.js.
```

**Note: sourcemapper will retrieve any URL referenced as a sourcemap, so a malicious JavaScript file parsed with sourcemapper can force sourcemapper to make a GET request to any URL**
