/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLSubCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLCollection
extends SimpleScriptable
implements Function,
NodeList {
    private boolean avoidObjectDetection_ = false;
    private String description_;
    private boolean attributeChangeSensitive_ = true;
    private List<Object> cachedElements_;
    private int currentIndex_ = 0;
    private boolean listenerRegistered_;

    @Deprecated
    public HTMLCollection() {
    }

    private HTMLCollection(ScriptableObject parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public HTMLCollection(DomNode parentScope, boolean attributeChangeSensitive, String description) {
        this(parentScope.getScriptObject());
        this.setDomNode(parentScope, false);
        this.description_ = description;
        this.attributeChangeSensitive_ = attributeChangeSensitive;
    }

    HTMLCollection(DomNode parentScope, List<?> initialElements) {
        this(parentScope.getScriptObject());
        this.cachedElements_ = new ArrayList(initialElements);
    }

    public static HTMLCollection emptyCollection(Window window) {
        final List list = Collections.emptyList();
        return new HTMLCollection((ScriptableObject)window){

            @Override
            protected List<Object> getElements() {
                return list;
            }
        };
    }

    public boolean avoidObjectDetection() {
        return this.avoidObjectDetection_;
    }

    public void setAvoidObjectDetection(boolean newValue) {
        this.avoidObjectDetection_ = newValue;
    }

    public final Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0) {
            throw Context.reportRuntimeError((String)"Zero arguments; need an index or a key.");
        }
        return this.nullIfNotFound(this.getIt(args[0]));
    }

    public final Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        return null;
    }

    private Object getIt(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(o);
        return this.get(key, (Scriptable)this);
    }

    public final Object get(int index, Scriptable start) {
        HTMLCollection array = (HTMLCollection)start;
        List<Object> elements = array.getElements();
        if (index >= 0 && index < elements.size()) {
            return this.getScriptableForElement(elements.get(index));
        }
        return NOT_FOUND;
    }

    protected List<Object> getElements() {
        List<Object> cachedElements = this.cachedElements_;
        if (cachedElements == null) {
            this.cachedElements_ = cachedElements = this.computeElements();
            if (!this.listenerRegistered_) {
                DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
                Object domNode = this.getDomNodeOrNull();
                ((DomNode)domNode).addDomChangeListener(listener);
                if (this.attributeChangeSensitive_ && domNode instanceof HtmlElement) {
                    ((HtmlElement)domNode).addHtmlAttributeChangeListener(listener);
                }
                this.listenerRegistered_ = true;
            }
        }
        return cachedElements;
    }

    protected List<Object> computeElements() {
        ArrayList<Object> response = new ArrayList<Object>();
        Object domNode = this.getDomNodeOrNull();
        if (domNode == null) {
            return response;
        }
        for (DomNode node : this.getCandidates()) {
            if (!(node instanceof DomElement) || !this.isMatching(node)) continue;
            response.add(node);
        }
        return response;
    }

    protected Iterable<DomNode> getCandidates() {
        Object domNode = this.getDomNodeOrNull();
        return ((DomNode)domNode).getDescendants();
    }

    protected boolean isMatching(DomNode node) {
        return false;
    }

    @Override
    protected Object getWithPreemption(String name) {
        if ("length".equals(name)) {
            return NOT_FOUND;
        }
        List<Object> elements = this.getElements();
        ArrayList<Object> matchingElements = new ArrayList<Object>();
        for (Object next : elements) {
            String id;
            if (!(next instanceof DomElement) || !name.equals(id = ((DomElement)next).getAttribute("id"))) continue;
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_IDENTICAL_IDS)) {
                return this.getScriptableForElement(next);
            }
            matchingElements.add(next);
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        if (!matchingElements.isEmpty()) {
            HTMLCollection collection = new HTMLCollection((DomNode)this.getDomNodeOrDie(), (List<?>)matchingElements);
            collection.setAvoidObjectDetection(!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_46));
            return collection;
        }
        for (Object next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !name.equals(nodeName = ((DomElement)next).getAttribute("name"))) continue;
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_IDENTICAL_IDS)) {
                return this.getScriptableForElement(next);
            }
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        Object domNode = this.getDomNodeOrNull();
        HTMLCollection collection = new HTMLCollection((DomNode)domNode, (List<?>)matchingElements);
        collection.setAvoidObjectDetection(!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_46));
        return collection;
    }

    public final int jsxGet_length() {
        return this.getElements().size();
    }

    public final Object jsxFunction_item(Object index) {
        return this.nullIfNotFound(this.getIt(index));
    }

    private Object nullIfNotFound(Object object) {
        if (object == NOT_FOUND) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_48)) {
                return null;
            }
            return Context.getUndefinedValue();
        }
        return object;
    }

    public final Object jsxFunction_namedItem(String name) {
        return this.nullIfNotFound(this.getIt(name));
    }

    public Object jsxFunction_nextNode() {
        List<Object> elements = this.getElements();
        Object nextNode = this.currentIndex_ >= 0 && this.currentIndex_ < elements.size() ? elements.get(this.currentIndex_) : null;
        ++this.currentIndex_;
        return nextNode;
    }

    public void jsxFunction_reset() {
        this.currentIndex_ = 0;
    }

    public Object jsxFunction_tags(String tagName) {
        final String tagNameLC = tagName.toLowerCase();
        HTMLSubCollection collection = new HTMLSubCollection(this, ".tags('" + tagName + "')"){

            protected boolean isMatching(DomNode node) {
                return tagNameLC.equalsIgnoreCase(node.getLocalName());
            }
        };
        return collection;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof HTMLCollection) {
            HTMLCollection otherArray = (HTMLCollection)other;
            Object domNode = this.getDomNodeOrNull();
            Object domNodeOther = otherArray.getDomNodeOrNull();
            if (this.getClass() == other.getClass() && domNode == domNodeOther && ((Object)this.getElements()).equals(otherArray.getElements())) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }

    public boolean has(String name, Scriptable start) {
        if (this.isPrototype()) {
            return super.has(name, start);
        }
        try {
            int index = Integer.parseInt(name);
            List<Object> elements = this.getElements();
            if (index >= 0 && index < elements.size()) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if ("length".equals(name)) {
            return true;
        }
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_49)) {
            JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(BrowserVersion.FIREFOX_3_6);
            for (String functionName : jsConfig.getClassConfiguration(this.getClassName()).functionKeys()) {
                if (!name.equals(functionName)) continue;
                return true;
            }
            return false;
        }
        return this.getWithPreemption(name) != NOT_FOUND;
    }

    public Object[] getIds() {
        if (this.isPrototype()) {
            return super.getIds();
        }
        ArrayList<String> idList = new ArrayList<String>();
        List<Object> elements = this.getElements();
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_50)) {
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                idList.add(Integer.toString(i));
            }
            idList.add("length");
            JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(BrowserVersion.FIREFOX_3_6);
            for (String name : jsConfig.getClassConfiguration(this.getClassName()).functionKeys()) {
                idList.add(name);
            }
        } else {
            idList.add("length");
            this.addElementIds(idList, elements);
        }
        return idList.toArray();
    }

    private boolean isPrototype() {
        return !(this.getPrototype() instanceof HTMLCollection);
    }

    protected void addElementIds(List<String> idList, List<Object> elements) {
        int index = 0;
        for (Object next : elements) {
            HtmlElement element = (HtmlElement)next;
            String name = element.getAttribute("name");
            if (name != DomElement.ATTRIBUTE_NOT_DEFINED) {
                idList.add(name);
            } else {
                String id = element.getId();
                if (id != DomElement.ATTRIBUTE_NOT_DEFINED) {
                    idList.add(id);
                } else {
                    idList.add(Integer.toString(index));
                }
            }
            ++index;
        }
    }

    @Override
    public int getLength() {
        return this.jsxGet_length();
    }

    protected EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
        return EffectOnCache.RESET;
    }

    @Override
    public Node item(int index) {
        return (DomNode)this.getElements().get(index);
    }

    protected Scriptable getScriptableForElement(Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return this.getScriptableFor(object);
    }

    @Override
    public String getClassName() {
        return "HTMLCollection";
    }

    private class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private DomHtmlAttributeChangeListenerImpl() {
        }

        public void nodeAdded(DomChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void nodeDeleted(DomChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(HTMLCollection.this.getEffectOnCache(event));
        }

        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(HTMLCollection.this.getEffectOnCache(event));
        }

        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            if (HTMLCollection.this.attributeChangeSensitive_) {
                this.handleChangeOnCache(HTMLCollection.this.getEffectOnCache(event));
            }
        }

        private void handleChangeOnCache(EffectOnCache effectOnCache) {
            if (EffectOnCache.NONE == effectOnCache) {
                return;
            }
            if (EffectOnCache.RESET == effectOnCache) {
                HTMLCollection.this.cachedElements_ = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum EffectOnCache {
        NONE,
        RESET;

    }
}

