/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSCharsetRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSImportRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSMediaRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

public class CSSRule
extends SimpleScriptable {
    public static final short UNKNOWN_RULE = 0;
    public static final short STYLE_RULE = 1;
    public static final short CHARSET_RULE = 2;
    public static final short IMPORT_RULE = 3;
    public static final short MEDIA_RULE = 4;
    public static final short FONT_FACE_RULE = 5;
    public static final short PAGE_RULE = 6;
    private final CSSStyleSheet stylesheet_;
    private final org.w3c.dom.css.CSSRule rule_;

    @Deprecated
    public CSSRule() {
        this.stylesheet_ = null;
        this.rule_ = null;
    }

    public static CSSRule create(CSSStyleSheet stylesheet, org.w3c.dom.css.CSSRule rule) {
        switch (rule.getType()) {
            case 1: {
                return new CSSStyleRule(stylesheet, rule);
            }
            case 3: {
                return new CSSImportRule(stylesheet, rule);
            }
            case 2: {
                return new CSSCharsetRule(stylesheet, (org.w3c.dom.css.CSSCharsetRule)rule);
            }
            case 4: {
                return new CSSMediaRule(stylesheet, (org.w3c.dom.css.CSSMediaRule)rule);
            }
        }
        throw new UnsupportedOperationException("CSSRule " + rule.getClass().getName() + " is not yet supported.");
    }

    protected CSSRule(CSSStyleSheet stylesheet, org.w3c.dom.css.CSSRule rule) {
        this.stylesheet_ = stylesheet;
        this.rule_ = rule;
        this.setParentScope((Scriptable)stylesheet);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public short jsxGet_type() {
        return this.rule_.getType();
    }

    public String jsxGet_cssText() {
        return this.rule_.getCssText();
    }

    public void jsxSet_cssText(String cssText) {
        this.rule_.setCssText(cssText);
    }

    public CSSStyleSheet jsxGet_parentStyleSheet() {
        return this.stylesheet_;
    }

    public CSSRule jsxGet_parentRule() {
        org.w3c.dom.css.CSSRule parentRule = this.rule_.getParentRule();
        if (parentRule != null) {
            return CSSRule.create(this.stylesheet_, parentRule);
        }
        return null;
    }

    protected org.w3c.dom.css.CSSRule getRule() {
        return this.rule_;
    }
}

