/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class JavascriptLibrary {
    static final String PREFIX = "/" + JavascriptLibrary.class.getPackage().getName().replace(".", "/") + "/selenium_atoms/";
    private final ConcurrentHashMap<String, String> scripts = new ConcurrentHashMap();
    private static final String injectableSelenium = "/org/openqa/selenium/internal/seleniumemulation/scripts/injectableSelenium.js";
    private static final String htmlUtils = "/org/openqa/selenium/internal/seleniumemulation/scripts/htmlutils.js";

    public String getSeleniumScript(String name) {
        String rawFunction = this.readScript(String.valueOf(PREFIX) + name);
        return String.format("function() { return (%s).apply(null, arguments);}", rawFunction);
    }

    public void callEmbeddedSelenium(WebDriver driver, String functionName, WebElement element, Object ... values) {
        StringBuilder builder = new StringBuilder(this.readScript(injectableSelenium));
        builder.append("return browserbot.").append(functionName).append(".apply(browserbot, arguments);");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(element);
        args.addAll(Arrays.asList(values));
        ((JavascriptExecutor)((Object)driver)).executeScript(builder.toString(), args.toArray());
    }

    public Object callEmbeddedHtmlUtils(WebDriver driver, String functionName, WebElement element, Object ... values) {
        StringBuilder builder = new StringBuilder(this.readScript(htmlUtils));
        builder.append("return htmlutils.").append(functionName).append(".apply(htmlutils, arguments);");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(element);
        args.addAll(Arrays.asList(values));
        return ((JavascriptExecutor)((Object)driver)).executeScript(builder.toString(), args.toArray());
    }

    public Object executeScript(WebDriver driver, String script, Object ... args) {
        if (driver instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)((Object)driver)).executeScript(script, args);
        }
        throw new UnsupportedOperationException("The underlying WebDriver instance does not support executing javascript");
    }

    private String readScript(String script) {
        String result = this.scripts.get(script);
        if (result == null) {
            result = this.readScriptImpl(script);
            this.scripts.put(script, result);
        }
        return result;
    }

    String readScriptImpl(String script) {
        URL url = this.getClass().getResource(script);
        if (url == null) {
            throw new RuntimeException("Cannot locate " + script);
        }
        try {
            return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

