/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.parser;

import java.io.IOException;
import java.util.BitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.descriptor.DefaultBodyDescriptor;
import org.apache.james.mime4j.descriptor.MaximalBodyDescriptor;
import org.apache.james.mime4j.descriptor.MutableBodyDescriptor;
import org.apache.james.mime4j.io.LineReaderInputStream;
import org.apache.james.mime4j.io.MaxHeaderLimitException;
import org.apache.james.mime4j.io.MaxLineLimitException;
import org.apache.james.mime4j.parser.EntityStateMachine;
import org.apache.james.mime4j.parser.Event;
import org.apache.james.mime4j.parser.Field;
import org.apache.james.mime4j.parser.MimeEntityConfig;
import org.apache.james.mime4j.parser.MimeParseEventException;
import org.apache.james.mime4j.parser.RawField;
import org.apache.james.mime4j.util.ByteArrayBuffer;

public abstract class AbstractEntity
implements EntityStateMachine {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final BodyDescriptor parent;
    protected final int startState;
    protected final int endState;
    protected final MimeEntityConfig config;
    protected final MutableBodyDescriptor body;
    protected int state;
    private final ByteArrayBuffer linebuf;
    private int lineCount;
    private Field field;
    private boolean endOfHeader;
    private int headerCount;
    private static final BitSet fieldChars;
    private static final int T_IN_BODYPART = -2;
    private static final int T_IN_MESSAGE = -3;

    AbstractEntity(BodyDescriptor parent, int startState, int endState, MimeEntityConfig config) {
        this.parent = parent;
        this.state = startState;
        this.startState = startState;
        this.endState = endState;
        this.config = config;
        this.body = this.newBodyDescriptor(parent);
        this.linebuf = new ByteArrayBuffer(64);
        this.lineCount = 0;
        this.endOfHeader = false;
        this.headerCount = 0;
    }

    public int getState() {
        return this.state;
    }

    protected MutableBodyDescriptor newBodyDescriptor(BodyDescriptor pParent) {
        DefaultBodyDescriptor result = this.config.isMaximalBodyDescriptor() ? new MaximalBodyDescriptor(pParent) : new DefaultBodyDescriptor(pParent);
        return result;
    }

    protected abstract int getLineNumber();

    protected abstract LineReaderInputStream getDataStream();

    private ByteArrayBuffer fillFieldBuffer() throws IOException, MimeException {
        byte ch;
        if (this.endOfHeader) {
            throw new IllegalStateException();
        }
        int maxLineLen = this.config.getMaxLineLen();
        LineReaderInputStream instream = this.getDataStream();
        ByteArrayBuffer fieldbuf = new ByteArrayBuffer(64);
        do {
            int len = this.linebuf.length();
            if (maxLineLen > 0 && fieldbuf.length() + len >= maxLineLen) {
                throw new MaxLineLimitException("Maximum line length limit exceeded");
            }
            if (len > 0) {
                fieldbuf.append(this.linebuf.buffer(), 0, len);
            }
            this.linebuf.clear();
            if (instream.readLine(this.linebuf) == -1) {
                this.monitor(Event.HEADERS_PREMATURE_END);
                this.endOfHeader = true;
                break;
            }
            len = this.linebuf.length();
            if (len > 0 && this.linebuf.byteAt(len - 1) == 10) {
                --len;
            }
            if (len > 0 && this.linebuf.byteAt(len - 1) == 13) {
                --len;
            }
            if (len == 0) {
                this.endOfHeader = true;
                break;
            }
            ++this.lineCount;
        } while (this.lineCount <= 1 || (ch = this.linebuf.byteAt(0)) == 32 || ch == 9);
        return fieldbuf;
    }

    protected boolean parseField() throws MimeException, IOException {
        int pos;
        ByteArrayBuffer fieldbuf;
        boolean valid;
        int maxHeaderLimit = this.config.getMaxHeaderCount();
        block0: do {
            if (this.endOfHeader) {
                return false;
            }
            if (this.headerCount >= maxHeaderLimit) {
                throw new MaxHeaderLimitException("Maximum header limit exceeded");
            }
            fieldbuf = this.fillFieldBuffer();
            ++this.headerCount;
            int len = fieldbuf.length();
            if (len > 0 && fieldbuf.byteAt(len - 1) == 10) {
                --len;
            }
            if (len > 0 && fieldbuf.byteAt(len - 1) == 13) {
                --len;
            }
            fieldbuf.setLength(len);
            valid = true;
            pos = fieldbuf.indexOf((byte)58);
            if (pos <= 0) {
                this.monitor(Event.INALID_HEADER);
                valid = false;
                continue;
            }
            for (int i = 0; i < pos; ++i) {
                if (fieldChars.get(fieldbuf.byteAt(i) & 0xFF)) continue;
                this.monitor(Event.INALID_HEADER);
                valid = false;
                continue block0;
            }
        } while (!valid);
        this.field = new RawField(fieldbuf, pos);
        this.body.addField(this.field);
        return true;
    }

    public BodyDescriptor getBodyDescriptor() {
        switch (this.getState()) {
            case -1: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                return this.body;
            }
        }
        throw new IllegalStateException("Invalid state :" + AbstractEntity.stateToString(this.state));
    }

    public Field getField() {
        switch (this.getState()) {
            case 4: {
                return this.field;
            }
        }
        throw new IllegalStateException("Invalid state :" + AbstractEntity.stateToString(this.state));
    }

    protected void monitor(Event event) throws MimeException, IOException {
        if (this.config.isStrictParsing()) {
            throw new MimeParseEventException(event);
        }
        this.warn(event);
    }

    protected String message(Event event) {
        String message = event == null ? "Event is unexpectedly null." : event.toString();
        int lineNumber = this.getLineNumber();
        if (lineNumber <= 0) {
            return message;
        }
        return "Line " + lineNumber + ": " + message;
    }

    protected void warn(Event event) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(this.message(event));
        }
    }

    protected void debug(Event event) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.message(event));
        }
    }

    public String toString() {
        return this.getClass().getName() + " [" + AbstractEntity.stateToString(this.state) + "][" + this.body.getMimeType() + "][" + this.body.getBoundary() + "]";
    }

    public static final String stateToString(int state) {
        String result;
        switch (state) {
            case -1: {
                result = "End of stream";
                break;
            }
            case 0: {
                result = "Start message";
                break;
            }
            case 1: {
                result = "End message";
                break;
            }
            case 2: {
                result = "Raw entity";
                break;
            }
            case 3: {
                result = "Start header";
                break;
            }
            case 4: {
                result = "Field";
                break;
            }
            case 5: {
                result = "End header";
                break;
            }
            case 6: {
                result = "Start multipart";
                break;
            }
            case 7: {
                result = "End multipart";
                break;
            }
            case 8: {
                result = "Preamble";
                break;
            }
            case 9: {
                result = "Epilogue";
                break;
            }
            case 10: {
                result = "Start bodypart";
                break;
            }
            case 11: {
                result = "End bodypart";
                break;
            }
            case 12: {
                result = "Body";
                break;
            }
            case -2: {
                result = "Bodypart";
                break;
            }
            case -3: {
                result = "In message";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        return result;
    }

    static {
        int i;
        fieldChars = new BitSet();
        for (i = 33; i <= 57; ++i) {
            fieldChars.set(i);
        }
        for (i = 59; i <= 126; ++i) {
            fieldChars.set(i);
        }
    }
}

