/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSMediaRuleImpl;
import com.steadystate.css.dom.CSSRuleListImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.MediaListImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS2;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;
import org.w3c.dom.stylesheets.StyleSheet;

public class CSSStyleSheetImpl
implements CSSStyleSheet,
Serializable {
    private static final long serialVersionUID = -2300541300646796363L;
    private boolean disabled = false;
    private Node ownerNode = null;
    private StyleSheet parentStyleSheet = null;
    private String href = null;
    private String title = null;
    private MediaList media = null;
    private CSSRule ownerRule = null;
    private boolean readOnly = false;
    private CSSRuleList cssRules = null;
    private String baseUri;

    public void setMedia(MediaList media) {
        this.media = media;
    }

    private String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getType() {
        return "text/css";
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public Node getOwnerNode() {
        return this.ownerNode;
    }

    public StyleSheet getParentStyleSheet() {
        return this.parentStyleSheet;
    }

    public String getHref() {
        return this.href;
    }

    public String getTitle() {
        return this.title;
    }

    public MediaList getMedia() {
        return this.media;
    }

    public CSSRule getOwnerRule() {
        return this.ownerRule;
    }

    public CSSRuleList getCssRules() {
        if (this.cssRules == null) {
            this.cssRules = new CSSRuleListImpl();
        }
        return this.cssRules;
    }

    public int insertRule(String rule, int index) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            CSSRule r;
            block8: {
                int msg;
                block11: {
                    block9: {
                        block10: {
                            InputSource is = new InputSource(new StringReader(rule));
                            CSSOMParser parser = new CSSOMParser();
                            parser.setParentStyleSheet(this);
                            r = parser.parseRule(is);
                            if (this.getCssRules().getLength() <= 0) break block8;
                            msg = -1;
                            if (r.getType() != 2) break block9;
                            if (index == 0) break block10;
                            msg = 15;
                            break block11;
                        }
                        if (this.getCssRules().item(0).getType() != 2) break block11;
                        msg = 16;
                        break block11;
                    }
                    if (r.getType() == 3 && index <= this.getCssRules().getLength()) {
                        for (int i = 0; i < index; ++i) {
                            short rt = this.getCssRules().item(i).getType();
                            if (rt == 2 && rt == 3) continue;
                            msg = 17;
                            break;
                        }
                    }
                }
                if (msg > -1) {
                    throw new DOMExceptionImpl(3, msg);
                }
            }
            ((CSSRuleListImpl)this.getCssRules()).insert(r, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        return index;
    }

    public void deleteRule(int index) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            ((CSSRuleListImpl)this.getCssRules()).delete(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean b) {
        this.readOnly = b;
    }

    public void setOwnerNode(Node ownerNode) {
        this.ownerNode = ownerNode;
    }

    public void setParentStyleSheet(StyleSheet parentStyleSheet) {
        this.parentStyleSheet = parentStyleSheet;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMediaText(String mediaText) {
        InputSource source = new InputSource(new StringReader(mediaText));
        try {
            SACMediaList sml = new SACParserCSS2().parseMedia(source);
            this.media = new MediaListImpl(sml);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setOwnerRule(CSSRule ownerRule) {
        this.ownerRule = ownerRule;
    }

    public void setCssRules(CSSRuleList rules) {
        this.cssRules = rules;
    }

    public String toString() {
        return this.getCssRules().toString();
    }

    public void importImports(boolean recursive) throws DOMException {
        for (int i = 0; i < this.getCssRules().getLength(); ++i) {
            CSSRule cssRule = this.getCssRules().item(i);
            if (cssRule.getType() != 3) continue;
            CSSImportRule cssImportRule = (CSSImportRule)cssRule;
            try {
                MediaList mediaList;
                URI importURI = new URI(this.getBaseUri()).resolve(cssImportRule.getHref());
                CSSStyleSheetImpl importedCSS = (CSSStyleSheetImpl)new CSSOMParser().parseStyleSheet(new InputSource(importURI.toString()), null, importURI.toString());
                if (recursive) {
                    importedCSS.importImports(recursive);
                }
                if ((mediaList = cssImportRule.getMedia()).getLength() == 0) {
                    mediaList.appendMedium("all");
                }
                CSSMediaRuleImpl cssMediaRule = new CSSMediaRuleImpl(this, null, mediaList);
                cssMediaRule.setRuleList((CSSRuleListImpl)importedCSS.getCssRules());
                this.deleteRule(i);
                ((CSSRuleListImpl)this.getCssRules()).insert(cssMediaRule, i);
                continue;
            }
            catch (URISyntaxException e) {
                throw new DOMException(12, e.getLocalizedMessage());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

