/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.NodeFilter;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.w3c.dom.DOMException;

public class TreeWalker
extends SimpleScriptable {
    private Node root_;
    private Node currentNode_;
    private int whatToShow_;
    private NodeFilter filter_;
    private boolean expandEntityReferences_;

    public TreeWalker() {
    }

    public TreeWalker(Node root, int whatToShow, NodeFilter filter, Boolean expandEntityReferences) throws DOMException {
        if (root == null) {
            Context.throwAsScriptRuntimeEx(new DOMException(9, "root must not be null"));
        }
        this.root_ = root;
        this.whatToShow_ = whatToShow;
        this.filter_ = filter;
        this.expandEntityReferences_ = expandEntityReferences;
        this.currentNode_ = this.root_;
    }

    public Node jsxGet_root() {
        return this.root_;
    }

    public long jsxGet_whatToShow() {
        return this.whatToShow_ == -1 ? 0xFFFFFFFFL : (long)this.whatToShow_;
    }

    public NodeFilter jsxGet_filter() {
        return this.filter_;
    }

    public boolean jsxGet_expandEntityReferences() {
        return this.expandEntityReferences_;
    }

    public Node jsxGet_currentNode() {
        return this.currentNode_;
    }

    public void jsxSet_currentNode(Node currentNode) throws DOMException {
        if (currentNode == null) {
            throw new DOMException(9, "currentNode cannot be set to null");
        }
        this.currentNode_ = currentNode;
    }

    private static int getFlagForNodeType(short type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 6: {
                return 32;
            }
            case 7: {
                return 64;
            }
            case 8: {
                return 128;
            }
            case 9: {
                return 256;
            }
            case 10: {
                return 512;
            }
            case 11: {
                return 1024;
            }
            case 12: {
                return 2048;
            }
        }
        return 0;
    }

    private short acceptNode(Node n) {
        short type = n.jsxGet_nodeType();
        int flag = TreeWalker.getFlagForNodeType(type);
        if ((this.whatToShow_ & flag) != 0) {
            return 1;
        }
        return 3;
    }

    private boolean isNodeVisible(Node n) {
        if (this.acceptNode(n) == 1 && (this.filter_ == null || this.filter_.acceptNode(n) == 1)) {
            return this.expandEntityReferences_ || n.getParent() == null || n.getParent().jsxGet_nodeType() != 5;
        }
        return false;
    }

    private boolean isNodeRejected(Node n) {
        if (this.acceptNode(n) == 2) {
            return true;
        }
        if (this.filter_ != null && this.filter_.acceptNode(n) == 2) {
            return true;
        }
        return !this.expandEntityReferences_ && n.getParent() != null && n.getParent().jsxGet_nodeType() == 5;
    }

    private boolean isNodeSkipped(Node n) {
        return !this.isNodeVisible(n) && !this.isNodeRejected(n);
    }

    public Node jsxFunction_parentNode() {
        if (this.currentNode_ == this.root_) {
            return null;
        }
        Node newNode = this.currentNode_;
        while ((newNode = newNode.getParent()) != null && !this.isNodeVisible(newNode) && newNode != this.root_) {
        }
        if (newNode == null || !this.isNodeVisible(newNode)) {
            return null;
        }
        this.currentNode_ = newNode;
        return newNode;
    }

    private Node getEquivalentLogical(Node n, boolean lookLeft) {
        Node child;
        if (n == null) {
            return null;
        }
        if (this.isNodeVisible(n)) {
            return n;
        }
        if (this.isNodeSkipped(n) && (child = lookLeft ? this.getEquivalentLogical(n.jsxGet_lastChild(), lookLeft) : this.getEquivalentLogical(n.jsxGet_firstChild(), lookLeft)) != null) {
            return child;
        }
        return this.getSibling(n, lookLeft);
    }

    private Node getSibling(Node n, boolean lookLeft) {
        if (n == null) {
            return null;
        }
        if (this.isNodeVisible(n)) {
            return null;
        }
        Node sibling = lookLeft ? n.jsxGet_previousSibling() : n.jsxGet_nextSibling();
        if (sibling == null) {
            if (n == this.root_) {
                return null;
            }
            return this.getSibling(n.getParent(), lookLeft);
        }
        return this.getEquivalentLogical(sibling, lookLeft);
    }

    public Node jsxFunction_firstChild() {
        Node newNode = this.getEquivalentLogical(this.currentNode_.jsxGet_firstChild(), false);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    public Node jsxFunction_lastChild() {
        Node newNode = this.getEquivalentLogical(this.currentNode_.jsxGet_lastChild(), true);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    public Node jsxFunction_previousSibling() {
        if (this.currentNode_ == this.root_) {
            return null;
        }
        Node newNode = this.getEquivalentLogical(this.currentNode_.jsxGet_previousSibling(), true);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    public Node jsxFunction_nextSibling() {
        if (this.currentNode_ == this.root_) {
            return null;
        }
        Node newNode = this.getEquivalentLogical(this.currentNode_.jsxGet_nextSibling(), false);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    public Node jsxFunction_previousNode() {
        Node newNode = this.getPreviousNode(this.currentNode_);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    private Node getPreviousNode(Node n) {
        Node toFollow;
        if (n == this.root_) {
            return null;
        }
        Node left = this.getEquivalentLogical(n.jsxGet_previousSibling(), true);
        if (left == null) {
            Node parent = n.getParent();
            if (parent == null) {
                return null;
            }
            if (this.isNodeVisible(parent)) {
                return parent;
            }
        }
        Node follow = left;
        while (follow.jsxFunction_hasChildNodes() && (toFollow = this.getEquivalentLogical(follow.jsxGet_lastChild(), true)) != null) {
            follow = toFollow;
        }
        return follow;
    }

    public Node jsxFunction_nextNode() {
        Node leftChild = this.getEquivalentLogical(this.currentNode_.jsxGet_firstChild(), false);
        if (leftChild != null) {
            this.currentNode_ = leftChild;
            return leftChild;
        }
        Node rightSibling = this.getEquivalentLogical(this.currentNode_.jsxGet_nextSibling(), false);
        if (rightSibling != null) {
            this.currentNode_ = rightSibling;
            return rightSibling;
        }
        Node uncle = this.getFirstUncleNode(this.currentNode_);
        if (uncle != null) {
            this.currentNode_ = uncle;
            return uncle;
        }
        return null;
    }

    private Node getFirstUncleNode(Node n) {
        if (n == this.root_ || n == null) {
            return null;
        }
        Node parent = n.getParent();
        if (parent == null) {
            return null;
        }
        Node uncle = this.getEquivalentLogical(parent.jsxGet_nextSibling(), false);
        if (uncle != null) {
            return uncle;
        }
        return this.getFirstUncleNode(parent);
    }
}

