/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.StorageImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Storage
extends SimpleScriptable {
    private static List<String> RESERVED_NAMES_ = Arrays.asList("clear", "key", "getItem", "length", "removeItem", "setItem");
    private Type type_;

    void setType(Type type) {
        this.type_ = type;
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.type_ == null || RESERVED_NAMES_.contains(name)) {
            super.put(name, start, value);
            return;
        }
        this.jsxFunction_setItem(name, Context.toString(value));
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (this.type_ == null || RESERVED_NAMES_.contains(name)) {
            return super.get(name, start);
        }
        return this.jsxFunction_getItem(name);
    }

    public int jsxGet_length() {
        return this.getMap().size();
    }

    public void jsxFunction_removeItem(String key) {
        this.getMap().remove(key);
    }

    public String jsxFunction_key(int index) {
        int counter = 0;
        for (String key : this.getMap().keySet()) {
            if (counter++ != index) continue;
            return key;
        }
        return null;
    }

    private Map<String, String> getMap() {
        return StorageImpl.getInstance().getMap(this.type_, (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage());
    }

    public Object jsxFunction_getItem(String key) {
        return this.getMap().get(key);
    }

    public void jsxFunction_setItem(String key, String data) {
        this.getMap().put(key, data);
    }

    public void jsxFunction_clear() {
        StorageImpl.getInstance().clear(this.type_, (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage());
    }

    @Override
    public String getClassName() {
        if (this.getWindow().getWebWindow() != null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.STORAGE_OBSOLETE)) {
            return "StorageObsolete";
        }
        return super.getClassName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        GLOBAL_STORAGE,
        LOCAL_STORAGE,
        SESSION_STORAGE;

    }
}

