# encoding: utf-8

# Copyright 2010-2013 Ayumu Nojima (野島 歩) and Martin J. Dürst (duerst@it.aoyama.ac.jp)
# available under the same licence as Ruby itself
# (see http://www.ruby-lang.org/en/LICENSE.txt)

# automatically generated by rake generate_tables

class Eprun

  ACCENTS = "
    [\u0300-\u034E\u0350-\u036F\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711" +
    "\u0730-\u074A\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08E4-\u08FE\u093C\u094D\u0951-\u0954\u09BCা\u09CDৗ\u0A3C" +
    "\u0A4D\u0ABC\u0ACD\u0B3Cା\u0B4Dୖୗா\u0BCDௗ\u0C4D\u0C55\u0C56\u0CBCೂ\u0CCDೕೖ" +
    "ാ\u0D4Dൗ\u0DCAාෟ\u0E38-\u0E3A\u0E48-\u0E4B\u0EB8\u0EB9\u0EC8-\u0ECB\u0F18\u0F19\u0F35\u0F37\u0F39\u0F71\u0F72\u0F74" +
    "\u0F7A-\u0F7D\u0F80\u0F82-\u0F84\u0F86\u0F87\u0FC6ီ\u1037\u1039\u103A\u108D\u135D-\u135F\u1714\u1734\u17D2\u17DD\u18A9\u1939-\u193B" +
    "\u1A17\u1A18\u1A60\u1A75-\u1A7C\u1A7F\u1B34ᬵ\u1B44\u1B6B-\u1B73\u1BAA\u1BAB\u1BE6\u1BF2\u1BF3\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1CF4" +
    "\u1DC0-\u1DE6\u1DFC-\u1DFF\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F\uA674-\uA67D\uA69F\uA6F0\uA6F1\uA806\uA8C4" +
    "\uA8E0-\uA8F1\uA92B-\uA92D\uA953\uA9B3\uA9C0\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAF6\uABED\uFB1E\uFE20-\uFE26\u{101FD}\u{10A0D}" +
    "\u{10A0F}\u{10A38}-\u{10A3A}\u{10A3F}\u{11046}\u{110B9}\u{110BA}\u{11100}-\u{11102}\u{11127}\u{11133}\u{11134}\u{111C0}\u{116B6}\u{116B7}\u{1D165}-\u{1D169}\u{1D16D}-\u{1D172}\u{1D17B}-\u{1D182}\u{1D185}-\u{1D18B}\u{1D1AA}-\u{1D1AD}\u{1D242}-\u{1D244}]
  "
  REGEXP_D_STRING = "  # composition starters and composition exclusions
    [À-ÅÇ-ÏÑ-ÖÙ-Ýà-åç-ïñ-öù-ýÿ-ďĒ-ĥĨ-İĴ-ķĹ-ľŃ-ňŌ-őŔ-ť" +
    "Ũ-žƠơƯưǍ-ǜǞ-ǣǦ-ǰǴǵǸ-țȞȟȦ-ȳ\u0340\u0341\u0343\u0344ʹ;΅-ΊΌ" +
    "Ύ-ΐΪ-ΰϊ-ώϓϔЀЁЃЇЌ-ЎЙйѐёѓїќ-ўѶѷӁӂ" +
    "Ӑ-ӓӖӗӚ-ӟӢ-ӧӪ-ӵӸӹآ-ئۀۂۓऩऱऴक़-य़োৌড়ঢ়" +
    "য়ਲ਼ਸ਼ਖ਼-ਜ਼ਫ਼ୈୋୌଡ଼ଢ଼ஔொ-ௌైೀೇೈೊೋൊ-ൌේ" +
    "ො-ෞགྷཌྷདྷབྷཛྷཀྵཱཱིུྲྀླཱྀྀྒྷྜྷྡྷྦྷྫྷ" +
    "ྐྵဦᬆᬈᬊᬌᬎᬒᬻᬽᭀᭁᭃḀ-ẙẛẠ-ỹἀ-ἕ" +
    "Ἐ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼι῁-ῄῆ-ΐῖ-Ί῝-`ῲ-ῴ" +
    "ῶ-´  ΩKÅ↚↛↮⇍-⇏∄∉∌∤∦≁≄≇≉" +
    "≠≢≭-≱≴≵≸≹⊀⊁⊄⊅⊈⊉⊬-⊯⋠-⋣⋪-⋭〈〉⫝̸がぎぐ" +
    "げござじずぜぞだぢづでどばぱびぴぶぷべぺ" +
    "ぼぽゔゞガギグゲゴザジズゼゾダヂヅ" +
    "デドバパビピブプベペボポヴヷ-ヺヾ豈-嗀塚晴凞-羽蘒諸" +
    "逸都飯-舘並-龎יִײַשׁ-זּטּ-לּמּנּסּףּפּצּ-פֿ\u{1109A}\u{1109C}\u{110AB}\u{1112E}\u{1112F}\u{1D15E}-\u{1D164}" +
    "\u{1D1BB}-\u{1D1C0}\u{2F800}-\u{2FA1D}]\[\u0300-\u034E\u0350-\u036F\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711" +
    "\u0730-\u074A\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08E4-\u08FE\u093C\u094D\u0951-\u0954\u09BCা\u09CDৗ\u0A3C" +
    "\u0A4D\u0ABC\u0ACD\u0B3Cା\u0B4Dୖୗா\u0BCDௗ\u0C4D\u0C55\u0C56\u0CBCೂ\u0CCDೕೖ" +
    "ാ\u0D4Dൗ\u0DCAාෟ\u0E38-\u0E3A\u0E48-\u0E4B\u0EB8\u0EB9\u0EC8-\u0ECB\u0F18\u0F19\u0F35\u0F37\u0F39\u0F71\u0F72\u0F74" +
    "\u0F7A-\u0F7D\u0F80\u0F82-\u0F84\u0F86\u0F87\u0FC6ီ\u1037\u1039\u103A\u108D\u135D-\u135F\u1714\u1734\u17D2\u17DD\u18A9\u1939-\u193B" +
    "\u1A17\u1A18\u1A60\u1A75-\u1A7C\u1A7F\u1B34ᬵ\u1B44\u1B6B-\u1B73\u1BAA\u1BAB\u1BE6\u1BF2\u1BF3\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1CF4" +
    "\u1DC0-\u1DE6\u1DFC-\u1DFF\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F\uA674-\uA67D\uA69F\uA6F0\uA6F1\uA806\uA8C4" +
    "\uA8E0-\uA8F1\uA92B-\uA92D\uA953\uA9B3\uA9C0\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAF6\uABED\uFB1E\uFE20-\uFE26\u{101FD}\u{10A0D}" +
    "\u{10A0F}\u{10A38}-\u{10A3A}\u{10A3F}\u{11046}\u{110B9}\u{110BA}\u{11100}-\u{11102}\u{11127}\u{11133}\u{11134}\u{111C0}\u{116B6}\u{116B7}\u{1D165}-\u{1D169}\u{1D16D}-\u{1D172}\u{1D17B}-\u{1D182}\u{1D185}-\u{1D18B}\u{1D1AA}-\u{1D1AD}\u{1D242}-\u{1D244}]*
    |  # characters that can be the result of a composition, except composition starters
    [<->A-PR-Za-pr-z¨ÆØæøſƷʒΑΕΗ" +
    "ΙΟΡΥΩαεηιορυωϒІА" +
    "ГЕ-ИКОУЧЫЭаге-икоучы" +
    "эіѴѵӘәӨөاويہےەनरळেେ" +
    "ஒெேెಿೆെേෙဥᬅᬇᬉᬋᬍᬑᬺᬼ" +
    "ᬾᬿᭂ᾿῾←→↔⇐⇒⇔∃∈∋∣∥∼" +
    "≃≅≈≍≡≤≥≲≳≶≷≺-≽⊂⊃⊆⊇⊑⊒⊢⊨⊩⊫⊲-⊵" +
    "うかきくけこさしすせそたちつてと" +
    "はひふへほゝウカキクケコサシスセ" +
    "ソタチツテトハヒフヘホワ-ヲヽ\u{11099}\u{1109B}\u{110A5}" +
    "\u{11131}\u{11132}]?\[\u0300-\u034E\u0350-\u036F\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711" +
    "\u0730-\u074A\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08E4-\u08FE\u093C\u094D\u0951-\u0954\u09BCা\u09CDৗ\u0A3C" +
    "\u0A4D\u0ABC\u0ACD\u0B3Cା\u0B4Dୖୗா\u0BCDௗ\u0C4D\u0C55\u0C56\u0CBCೂ\u0CCDೕೖ" +
    "ാ\u0D4Dൗ\u0DCAාෟ\u0E38-\u0E3A\u0E48-\u0E4B\u0EB8\u0EB9\u0EC8-\u0ECB\u0F18\u0F19\u0F35\u0F37\u0F39\u0F71\u0F72\u0F74" +
    "\u0F7A-\u0F7D\u0F80\u0F82-\u0F84\u0F86\u0F87\u0FC6ီ\u1037\u1039\u103A\u108D\u135D-\u135F\u1714\u1734\u17D2\u17DD\u18A9\u1939-\u193B" +
    "\u1A17\u1A18\u1A60\u1A75-\u1A7C\u1A7F\u1B34ᬵ\u1B44\u1B6B-\u1B73\u1BAA\u1BAB\u1BE6\u1BF2\u1BF3\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1CF4" +
    "\u1DC0-\u1DE6\u1DFC-\u1DFF\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F\uA674-\uA67D\uA69F\uA6F0\uA6F1\uA806\uA8C4" +
    "\uA8E0-\uA8F1\uA92B-\uA92D\uA953\uA9B3\uA9C0\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAF6\uABED\uFB1E\uFE20-\uFE26\u{101FD}\u{10A0D}" +
    "\u{10A0F}\u{10A38}-\u{10A3A}\u{10A3F}\u{11046}\u{110B9}\u{110BA}\u{11100}-\u{11102}\u{11127}\u{11133}\u{11134}\u{111C0}\u{116B6}\u{116B7}\u{1D165}-\u{1D169}\u{1D16D}-\u{1D172}\u{1D17B}-\u{1D182}\u{1D185}-\u{1D18B}\u{1D1AA}-\u{1D1AD}\u{1D242}-\u{1D244}]+
    |  # precomposed Hangul syllables
    [\352\260\200-\355\236\244]
  "
  REGEXP_C_STRING = "  # composition exclusions
    [\u0340\u0341\u0343\u0344ʹ;·क़-य़ড়ঢ়য়ਲ਼ਸ਼ਖ਼-ਜ਼ਫ਼ଡ଼ଢ଼གྷཌྷདྷ" +
    "བྷཛྷཀྵཱཱིུྲྀླཱྀྀྒྷྜྷྡྷྦྷྫྷྐྵάέή" +
    "ίόύώΆιΈΉΐΊΰΎ΅`ΌΏ´" +
    "  ΩKÅ〈〉⫝̸豈-嗀塚晴凞-羽蘒諸逸都飯-舘並-龎יִײַ" +
    "שׁ-זּטּ-לּמּנּסּףּפּצּ-פֿ\u{1D15E}-\u{1D164}\u{1D1BB}-\u{1D1C0}\u{2F800}-\u{2FA1D}]\[\u0300-\u034E\u0350-\u036F\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711" +
    "\u0730-\u074A\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08E4-\u08FE\u093C\u094D\u0951-\u0954\u09BCা\u09CDৗ\u0A3C" +
    "\u0A4D\u0ABC\u0ACD\u0B3Cା\u0B4Dୖୗா\u0BCDௗ\u0C4D\u0C55\u0C56\u0CBCೂ\u0CCDೕೖ" +
    "ാ\u0D4Dൗ\u0DCAාෟ\u0E38-\u0E3A\u0E48-\u0E4B\u0EB8\u0EB9\u0EC8-\u0ECB\u0F18\u0F19\u0F35\u0F37\u0F39\u0F71\u0F72\u0F74" +
    "\u0F7A-\u0F7D\u0F80\u0F82-\u0F84\u0F86\u0F87\u0FC6ီ\u1037\u1039\u103A\u108D\u135D-\u135F\u1714\u1734\u17D2\u17DD\u18A9\u1939-\u193B" +
    "\u1A17\u1A18\u1A60\u1A75-\u1A7C\u1A7F\u1B34ᬵ\u1B44\u1B6B-\u1B73\u1BAA\u1BAB\u1BE6\u1BF2\u1BF3\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1CF4" +
    "\u1DC0-\u1DE6\u1DFC-\u1DFF\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F\uA674-\uA67D\uA69F\uA6F0\uA6F1\uA806\uA8C4" +
    "\uA8E0-\uA8F1\uA92B-\uA92D\uA953\uA9B3\uA9C0\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAF6\uABED\uFB1E\uFE20-\uFE26\u{101FD}\u{10A0D}" +
    "\u{10A0F}\u{10A38}-\u{10A3A}\u{10A3F}\u{11046}\u{110B9}\u{110BA}\u{11100}-\u{11102}\u{11127}\u{11133}\u{11134}\u{111C0}\u{116B6}\u{116B7}\u{1D165}-\u{1D169}\u{1D16D}-\u{1D172}\u{1D17B}-\u{1D182}\u{1D185}-\u{1D18B}\u{1D1AA}-\u{1D1AD}\u{1D242}-\u{1D244}]*
    |  # composition starters and characters that can be the result of a composition
    [<->A-PR-Za-pr-z¨À-ÏÑ-ÖØ-Ýà-ïñ-öø-ýÿ-ďĒ-ĥĨ-İĴ-ķ" +
    "Ĺ-ľŃ-ňŌ-őŔ-ťŨ-ſƠơƯưƷǍ-ǜǞ-ǣǦ-ǰǴǵǸ-țȞȟȦ-ȳʒ" +
    "΅ΆΈ-ΊΌΎ-ΑΕΗΙΟΡΥΩ-αεηιορ" +
    "υω-ώϒ-ϔЀЁЃІЇЌ-ЎАГЕ-КОУЧЫЭа" +
    "ге-коучыэѐёѓіїќ-ўѴ-ѷӁӂӐ-ӓӖ-ӟӢ-ӵ" +
    "Ӹӹآ-اويۀ-ۂےۓەनऩरऱळऴেোৌେୈୋୌஒஔ" +
    "ெேொ-ௌెైಿೀೆ-ೈೊೋെേൊ-ൌෙේො-ෞဥဦᬅ-ᬎᬑᬒᬺ-ᭃḀ-ẙ" +
    "ẛẠ-ỹἀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ὰὲὴὶὸὺ" +
    "ὼᾀ-ᾴᾶ-Ὰᾼ᾿῁-ῄῆ-ῈῊῌ-ῒῖ-Ὶ῝-ῢῤ-ῪῬ῭ῲ-ῴῶ-ῸῺ" +
    "ῼ῾←→↔↚↛↮⇍-⇐⇒⇔∃∄∈∉∋∌∣-∦∼≁" +
    "≃-≅≇-≉≍≠-≢≤≥≭-≽⊀-⊉⊑⊒⊢⊨⊩⊫-⊯⊲-⊵⋠-⋣⋪-⋭うか-ぢ" +
    "つ-どは-ぽゔゝゞウカ-ヂツ-ドハ-ポワ-ヲヴヷ-ヺヽヾ\u{11099}-\u{1109C}\u{110A5}\u{110AB}\u{1112E}\u{1112F}" +
    "\u{11131}\u{11132}]?\[\u0300-\u034E\u0350-\u036F\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711" +
    "\u0730-\u074A\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08E4-\u08FE\u093C\u094D\u0951-\u0954\u09BCা\u09CDৗ\u0A3C" +
    "\u0A4D\u0ABC\u0ACD\u0B3Cା\u0B4Dୖୗா\u0BCDௗ\u0C4D\u0C55\u0C56\u0CBCೂ\u0CCDೕೖ" +
    "ാ\u0D4Dൗ\u0DCAාෟ\u0E38-\u0E3A\u0E48-\u0E4B\u0EB8\u0EB9\u0EC8-\u0ECB\u0F18\u0F19\u0F35\u0F37\u0F39\u0F71\u0F72\u0F74" +
    "\u0F7A-\u0F7D\u0F80\u0F82-\u0F84\u0F86\u0F87\u0FC6ီ\u1037\u1039\u103A\u108D\u135D-\u135F\u1714\u1734\u17D2\u17DD\u18A9\u1939-\u193B" +
    "\u1A17\u1A18\u1A60\u1A75-\u1A7C\u1A7F\u1B34ᬵ\u1B44\u1B6B-\u1B73\u1BAA\u1BAB\u1BE6\u1BF2\u1BF3\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1CF4" +
    "\u1DC0-\u1DE6\u1DFC-\u1DFF\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F\uA674-\uA67D\uA69F\uA6F0\uA6F1\uA806\uA8C4" +
    "\uA8E0-\uA8F1\uA92B-\uA92D\uA953\uA9B3\uA9C0\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAF6\uABED\uFB1E\uFE20-\uFE26\u{101FD}\u{10A0D}" +
    "\u{10A0F}\u{10A38}-\u{10A3A}\u{10A3F}\u{11046}\u{110B9}\u{110BA}\u{11100}-\u{11102}\u{11127}\u{11133}\u{11134}\u{111C0}\u{116B6}\u{116B7}\u{1D165}-\u{1D169}\u{1D16D}-\u{1D172}\u{1D17B}-\u{1D182}\u{1D185}-\u{1D18B}\u{1D1AA}-\u{1D1AD}\u{1D242}-\u{1D244}]+
    |  # Hangul syllables with separate trailer
    [가개갸걔거게겨계고과괘괴교구궈궤" +
    "귀규그긔기까깨꺄꺠꺼께껴꼐꼬꽈꽤" +
    "꾀꾜꾸꿔꿰뀌뀨끄끠끼나내냐냬너네" +
    "녀녜노놔놰뇌뇨누눠눼뉘뉴느늬니다" +
    "대댜댸더데뎌뎨도돠돼되됴두둬뒈뒤" +
    "듀드듸디따때땨떄떠떼뗘뗴또똬뙈뙤" +
    "뚀뚜뚸뛔뛰뜌뜨띄띠라래랴럐러레려" +
    "례로롸뢔뢰료루뤄뤠뤼류르릐리마매" +
    "먀먜머메며몌모뫄뫠뫼묘무뭐뭬뮈뮤" +
    "므믜미바배뱌뱨버베벼볘보봐봬뵈뵤" +
    "부붜붸뷔뷰브븨비빠빼뺘뺴뻐뻬뼈뼤" +
    "뽀뽜뽸뾔뾰뿌뿨쀄쀠쀼쁘쁴삐사새샤" +
    "섀서세셔셰소솨쇄쇠쇼수숴쉐쉬슈스" +
    "싀시싸쌔쌰썌써쎄쎠쎼쏘쏴쐐쐬쑈쑤" +
    "쒀쒜쒸쓔쓰씌씨아애야얘어에여예오" +
    "와왜외요우워웨위유으의이자재쟈쟤" +
    "저제져졔조좌좨죄죠주줘줴쥐쥬즈즤" +
    "지짜째쨔쨰쩌쩨쪄쪠쪼쫘쫴쬐쬬쭈쭤" +
    "쮀쮜쮸쯔쯰찌차채챠챼처체쳐쳬초촤" +
    "쵀최쵸추춰췌취츄츠츼치카캐캬컈커" +
    "케켜켸코콰쾌쾨쿄쿠쿼퀘퀴큐크킈키" +
    "타태탸턔터테텨톄토톼퇘퇴툐투퉈퉤" +
    "튀튜트틔티파패퍄퍠퍼페펴폐포퐈퐤" +
    "푀표푸풔풰퓌퓨프픠피하해햐햬허헤" +
    "혀혜호화홰회효후훠훼휘휴흐희히][\341\206\250-\341\207\202]
    |  # decomposed Hangul syllables
    [\341\204\200-\341\204\222][\341\205\241-\341\205\265][\341\206\250-\341\207\202]?
  "
  REGEXP_K_STRING = "
    [ ¨ª¯²-µ¸-º¼-¾ĲĳĿŀŉſǄ-ǌǱ-ǳʰ-ʸ˘-˝ˠ-ˤ" +
    "ͺ΄΅ϐ-ϖϰ-ϲϴϵϹևٵ-ٸำຳໜໝ༌ཷཹჼᴬ-ᴮ" +
    "ᴰ-ᴺᴼ-ᵍᵏ-ᵪᵸᶛ-ᶿẚẛ᾽᾿-῁῍-῏῝-῟῭΅´῾ - ‑‗․-…" +
    " ″‴‶‷‼‾⁇-⁉⁗ ⁰ⁱ⁴-₎ₐ-ₜ₨℀-℃℅-ℇ℉-ℓℕ№" +
    "ℙ-ℝ℠-™ℤℨℬℭℯ-ℱℳ-ℹ℻-⅀ⅅ-ⅉ⅐-ⅿ↉∬∭∯∰①-⓪⨌⩴-⩶" +
    "ⱼⱽⵯ⺟⻳⼀-⿕　〶〸-〺゛゜ゟヿㄱ-ㆎ㆒-㆟㈀-㈞㈠-㉇㉐-㉾" +
    "㊀-㋾㌀-㏿ꝰꟸꟹﬀ-ﬆﬓ-ﬗﬠ-﬩ﭏ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-﷼︐-︙︰-﹄﹇-﹒﹔-﹦" +
    "﹨-﹫ﹰ-ﹲﹴﹶ-ﻼ！-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ￠-￦￨-￮\u{1D400}-\u{1D454}\u{1D456}-\u{1D49C}\u{1D49E}\u{1D49F}\u{1D4A2}\u{1D4A5}\u{1D4A6}" +
    "\u{1D4A9}-\u{1D4AC}\u{1D4AE}-\u{1D4B9}\u{1D4BB}\u{1D4BD}-\u{1D4C3}\u{1D4C5}-\u{1D505}\u{1D507}-\u{1D50A}\u{1D50D}-\u{1D514}\u{1D516}-\u{1D51C}\u{1D51E}-\u{1D539}\u{1D53B}-\u{1D53E}\u{1D540}-\u{1D544}\u{1D546}\u{1D54A}-\u{1D550}\u{1D552}-\u{1D6A5}\u{1D6A8}-\u{1D7CB}\u{1D7CE}-\u{1D7FF}" +
    "\u{1EE00}-\u{1EE03}\u{1EE05}-\u{1EE1F}\u{1EE21}\u{1EE22}\u{1EE24}\u{1EE27}\u{1EE29}-\u{1EE32}\u{1EE34}-\u{1EE37}\u{1EE39}\u{1EE3B}\u{1EE42}\u{1EE47}\u{1EE49}\u{1EE4B}\u{1EE4D}-\u{1EE4F}\u{1EE51}\u{1EE52}\u{1EE54}" +
    "\u{1EE57}\u{1EE59}\u{1EE5B}\u{1EE5D}\u{1EE5F}\u{1EE61}\u{1EE62}\u{1EE64}\u{1EE67}-\u{1EE6A}\u{1EE6C}-\u{1EE72}\u{1EE74}-\u{1EE77}\u{1EE79}-\u{1EE7C}\u{1EE7E}\u{1EE80}-\u{1EE89}\u{1EE8B}-\u{1EE9B}\u{1EEA1}-\u{1EEA3}\u{1EEA5}-\u{1EEA9}" +
    "\u{1EEAB}-\u{1EEBB}\u{1F100}-\u{1F10A}\u{1F110}-\u{1F12E}\u{1F130}-\u{1F14F}\u{1F16A}\u{1F16B}\u{1F190}\u{1F200}-\u{1F202}\u{1F210}-\u{1F23A}\u{1F240}-\u{1F248}\u{1F250}\u{1F251}]
  "

  CLASS_TABLE = {
    "\u0300"=>230, "\u0301"=>230, "\u0302"=>230, "\u0303"=>230, "\u0304"=>230, "\u0305"=>230, "\u0306"=>230, "\u0307"=>230, "\u0308"=>230, "\u0309"=>230, "\u030A"=>230, "\u030B"=>230, "\u030C"=>230, "\u030D"=>230, "\u030E"=>230, "\u030F"=>230, 
    "\u0310"=>230, "\u0311"=>230, "\u0312"=>230, "\u0313"=>230, "\u0314"=>230, "\u0315"=>232, "\u0316"=>220, "\u0317"=>220, "\u0318"=>220, "\u0319"=>220, "\u031A"=>232, "\u031B"=>216, "\u031C"=>220, "\u031D"=>220, "\u031E"=>220, "\u031F"=>220, 
    "\u0320"=>220, "\u0321"=>202, "\u0322"=>202, "\u0323"=>220, "\u0324"=>220, "\u0325"=>220, "\u0326"=>220, "\u0327"=>202, "\u0328"=>202, "\u0329"=>220, "\u032A"=>220, "\u032B"=>220, "\u032C"=>220, "\u032D"=>220, "\u032E"=>220, "\u032F"=>220, 
    "\u0330"=>220, "\u0331"=>220, "\u0332"=>220, "\u0333"=>220, "\u0334"=>1, "\u0335"=>1, "\u0336"=>1, "\u0337"=>1, "\u0338"=>1, "\u0339"=>220, "\u033A"=>220, "\u033B"=>220, "\u033C"=>220, "\u033D"=>230, "\u033E"=>230, "\u033F"=>230, 
    "\u0340"=>230, "\u0341"=>230, "\u0342"=>230, "\u0343"=>230, "\u0344"=>230, "\u0345"=>240, "\u0346"=>230, "\u0347"=>220, "\u0348"=>220, "\u0349"=>220, "\u034A"=>230, "\u034B"=>230, "\u034C"=>230, "\u034D"=>220, "\u034E"=>220, "\u0350"=>230, 
    "\u0351"=>230, "\u0352"=>230, "\u0353"=>220, "\u0354"=>220, "\u0355"=>220, "\u0356"=>220, "\u0357"=>230, "\u0358"=>232, "\u0359"=>220, "\u035A"=>220, "\u035B"=>230, "\u035C"=>233, "\u035D"=>234, "\u035E"=>234, "\u035F"=>233, "\u0360"=>234, 
    "\u0361"=>234, "\u0362"=>233, "\u0363"=>230, "\u0364"=>230, "\u0365"=>230, "\u0366"=>230, "\u0367"=>230, "\u0368"=>230, "\u0369"=>230, "\u036A"=>230, "\u036B"=>230, "\u036C"=>230, "\u036D"=>230, "\u036E"=>230, "\u036F"=>230, "\u0483"=>230, 
    "\u0484"=>230, "\u0485"=>230, "\u0486"=>230, "\u0487"=>230, "\u0591"=>220, "\u0592"=>230, "\u0593"=>230, "\u0594"=>230, "\u0595"=>230, "\u0596"=>220, "\u0597"=>230, "\u0598"=>230, "\u0599"=>230, "\u059A"=>222, "\u059B"=>220, "\u059C"=>230, 
    "\u059D"=>230, "\u059E"=>230, "\u059F"=>230, "\u05A0"=>230, "\u05A1"=>230, "\u05A2"=>220, "\u05A3"=>220, "\u05A4"=>220, "\u05A5"=>220, "\u05A6"=>220, "\u05A7"=>220, "\u05A8"=>230, "\u05A9"=>230, "\u05AA"=>220, "\u05AB"=>230, "\u05AC"=>230, 
    "\u05AD"=>222, "\u05AE"=>228, "\u05AF"=>230, "\u05B0"=>10, "\u05B1"=>11, "\u05B2"=>12, "\u05B3"=>13, "\u05B4"=>14, "\u05B5"=>15, "\u05B6"=>16, "\u05B7"=>17, "\u05B8"=>18, "\u05B9"=>19, "\u05BA"=>19, "\u05BB"=>20, "\u05BC"=>21, 
    "\u05BD"=>22, "\u05BF"=>23, "\u05C1"=>24, "\u05C2"=>25, "\u05C4"=>230, "\u05C5"=>220, "\u05C7"=>18, "\u0610"=>230, "\u0611"=>230, "\u0612"=>230, "\u0613"=>230, "\u0614"=>230, "\u0615"=>230, "\u0616"=>230, "\u0617"=>230, "\u0618"=>30, 
    "\u0619"=>31, "\u061A"=>32, "\u064B"=>27, "\u064C"=>28, "\u064D"=>29, "\u064E"=>30, "\u064F"=>31, "\u0650"=>32, "\u0651"=>33, "\u0652"=>34, "\u0653"=>230, "\u0654"=>230, "\u0655"=>220, "\u0656"=>220, "\u0657"=>230, "\u0658"=>230, 
    "\u0659"=>230, "\u065A"=>230, "\u065B"=>230, "\u065C"=>220, "\u065D"=>230, "\u065E"=>230, "\u065F"=>220, "\u0670"=>35, "\u06D6"=>230, "\u06D7"=>230, "\u06D8"=>230, "\u06D9"=>230, "\u06DA"=>230, "\u06DB"=>230, "\u06DC"=>230, "\u06DF"=>230, 
    "\u06E0"=>230, "\u06E1"=>230, "\u06E2"=>230, "\u06E3"=>220, "\u06E4"=>230, "\u06E7"=>230, "\u06E8"=>230, "\u06EA"=>220, "\u06EB"=>230, "\u06EC"=>230, "\u06ED"=>220, "\u0711"=>36, "\u0730"=>230, "\u0731"=>220, "\u0732"=>230, "\u0733"=>230, 
    "\u0734"=>220, "\u0735"=>230, "\u0736"=>230, "\u0737"=>220, "\u0738"=>220, "\u0739"=>220, "\u073A"=>230, "\u073B"=>220, "\u073C"=>220, "\u073D"=>230, "\u073E"=>220, "\u073F"=>230, "\u0740"=>230, "\u0741"=>230, "\u0742"=>220, "\u0743"=>230, 
    "\u0744"=>220, "\u0745"=>230, "\u0746"=>220, "\u0747"=>230, "\u0748"=>220, "\u0749"=>230, "\u074A"=>230, "\u07EB"=>230, "\u07EC"=>230, "\u07ED"=>230, "\u07EE"=>230, "\u07EF"=>230, "\u07F0"=>230, "\u07F1"=>230, "\u07F2"=>220, "\u07F3"=>230, 
    "\u0816"=>230, "\u0817"=>230, "\u0818"=>230, "\u0819"=>230, "\u081B"=>230, "\u081C"=>230, "\u081D"=>230, "\u081E"=>230, "\u081F"=>230, "\u0820"=>230, "\u0821"=>230, "\u0822"=>230, "\u0823"=>230, "\u0825"=>230, "\u0826"=>230, "\u0827"=>230, 
    "\u0829"=>230, "\u082A"=>230, "\u082B"=>230, "\u082C"=>230, "\u082D"=>230, "\u0859"=>220, "\u085A"=>220, "\u085B"=>220, "\u08E4"=>230, "\u08E5"=>230, "\u08E6"=>220, "\u08E7"=>230, "\u08E8"=>230, "\u08E9"=>220, "\u08EA"=>230, "\u08EB"=>230, 
    "\u08EC"=>230, "\u08ED"=>220, "\u08EE"=>220, "\u08EF"=>220, "\u08F0"=>27, "\u08F1"=>28, "\u08F2"=>29, "\u08F3"=>230, "\u08F4"=>230, "\u08F5"=>230, "\u08F6"=>220, "\u08F7"=>230, "\u08F8"=>230, "\u08F9"=>220, "\u08FA"=>220, "\u08FB"=>230, 
    "\u08FC"=>230, "\u08FD"=>230, "\u08FE"=>230, "\u093C"=>7, "\u094D"=>9, "\u0951"=>230, "\u0952"=>220, "\u0953"=>230, "\u0954"=>230, "\u09BC"=>7, "\u09CD"=>9, "\u0A3C"=>7, "\u0A4D"=>9, "\u0ABC"=>7, "\u0ACD"=>9, "\u0B3C"=>7, 
    "\u0B4D"=>9, "\u0BCD"=>9, "\u0C4D"=>9, "\u0C55"=>84, "\u0C56"=>91, "\u0CBC"=>7, "\u0CCD"=>9, "\u0D4D"=>9, "\u0DCA"=>9, "\u0E38"=>103, "\u0E39"=>103, "\u0E3A"=>9, "\u0E48"=>107, "\u0E49"=>107, "\u0E4A"=>107, "\u0E4B"=>107, 
    "\u0EB8"=>118, "\u0EB9"=>118, "\u0EC8"=>122, "\u0EC9"=>122, "\u0ECA"=>122, "\u0ECB"=>122, "\u0F18"=>220, "\u0F19"=>220, "\u0F35"=>220, "\u0F37"=>220, "\u0F39"=>216, "\u0F71"=>129, "\u0F72"=>130, "\u0F74"=>132, "\u0F7A"=>130, "\u0F7B"=>130, 
    "\u0F7C"=>130, "\u0F7D"=>130, "\u0F80"=>130, "\u0F82"=>230, "\u0F83"=>230, "\u0F84"=>9, "\u0F86"=>230, "\u0F87"=>230, "\u0FC6"=>220, "\u1037"=>7, "\u1039"=>9, "\u103A"=>9, "\u108D"=>220, "\u135D"=>230, "\u135E"=>230, "\u135F"=>230, 
    "\u1714"=>9, "\u1734"=>9, "\u17D2"=>9, "\u17DD"=>230, "\u18A9"=>228, "\u1939"=>222, "\u193A"=>230, "\u193B"=>220, "\u1A17"=>230, "\u1A18"=>220, "\u1A60"=>9, "\u1A75"=>230, "\u1A76"=>230, "\u1A77"=>230, "\u1A78"=>230, "\u1A79"=>230, 
    "\u1A7A"=>230, "\u1A7B"=>230, "\u1A7C"=>230, "\u1A7F"=>220, "\u1B34"=>7, "\u1B44"=>9, "\u1B6B"=>230, "\u1B6C"=>220, "\u1B6D"=>230, "\u1B6E"=>230, "\u1B6F"=>230, "\u1B70"=>230, "\u1B71"=>230, "\u1B72"=>230, "\u1B73"=>230, "\u1BAA"=>9, 
    "\u1BAB"=>9, "\u1BE6"=>7, "\u1BF2"=>9, "\u1BF3"=>9, "\u1C37"=>7, "\u1CD0"=>230, "\u1CD1"=>230, "\u1CD2"=>230, "\u1CD4"=>1, "\u1CD5"=>220, "\u1CD6"=>220, "\u1CD7"=>220, "\u1CD8"=>220, "\u1CD9"=>220, "\u1CDA"=>230, "\u1CDB"=>230, 
    "\u1CDC"=>220, "\u1CDD"=>220, "\u1CDE"=>220, "\u1CDF"=>220, "\u1CE0"=>230, "\u1CE2"=>1, "\u1CE3"=>1, "\u1CE4"=>1, "\u1CE5"=>1, "\u1CE6"=>1, "\u1CE7"=>1, "\u1CE8"=>1, "\u1CED"=>220, "\u1CF4"=>230, "\u1DC0"=>230, "\u1DC1"=>230, 
    "\u1DC2"=>220, "\u1DC3"=>230, "\u1DC4"=>230, "\u1DC5"=>230, "\u1DC6"=>230, "\u1DC7"=>230, "\u1DC8"=>230, "\u1DC9"=>230, "\u1DCA"=>220, "\u1DCB"=>230, "\u1DCC"=>230, "\u1DCD"=>234, "\u1DCE"=>214, "\u1DCF"=>220, "\u1DD0"=>202, "\u1DD1"=>230, 
    "\u1DD2"=>230, "\u1DD3"=>230, "\u1DD4"=>230, "\u1DD5"=>230, "\u1DD6"=>230, "\u1DD7"=>230, "\u1DD8"=>230, "\u1DD9"=>230, "\u1DDA"=>230, "\u1DDB"=>230, "\u1DDC"=>230, "\u1DDD"=>230, "\u1DDE"=>230, "\u1DDF"=>230, "\u1DE0"=>230, "\u1DE1"=>230, 
    "\u1DE2"=>230, "\u1DE3"=>230, "\u1DE4"=>230, "\u1DE5"=>230, "\u1DE6"=>230, "\u1DFC"=>233, "\u1DFD"=>220, "\u1DFE"=>230, "\u1DFF"=>220, "\u20D0"=>230, "\u20D1"=>230, "\u20D2"=>1, "\u20D3"=>1, "\u20D4"=>230, "\u20D5"=>230, "\u20D6"=>230, 
    "\u20D7"=>230, "\u20D8"=>1, "\u20D9"=>1, "\u20DA"=>1, "\u20DB"=>230, "\u20DC"=>230, "\u20E1"=>230, "\u20E5"=>1, "\u20E6"=>1, "\u20E7"=>230, "\u20E8"=>220, "\u20E9"=>230, "\u20EA"=>1, "\u20EB"=>1, "\u20EC"=>220, "\u20ED"=>220, 
    "\u20EE"=>220, "\u20EF"=>220, "\u20F0"=>230, "\u2CEF"=>230, "\u2CF0"=>230, "\u2CF1"=>230, "\u2D7F"=>9, "\u2DE0"=>230, "\u2DE1"=>230, "\u2DE2"=>230, "\u2DE3"=>230, "\u2DE4"=>230, "\u2DE5"=>230, "\u2DE6"=>230, "\u2DE7"=>230, "\u2DE8"=>230, 
    "\u2DE9"=>230, "\u2DEA"=>230, "\u2DEB"=>230, "\u2DEC"=>230, "\u2DED"=>230, "\u2DEE"=>230, "\u2DEF"=>230, "\u2DF0"=>230, "\u2DF1"=>230, "\u2DF2"=>230, "\u2DF3"=>230, "\u2DF4"=>230, "\u2DF5"=>230, "\u2DF6"=>230, "\u2DF7"=>230, "\u2DF8"=>230, 
    "\u2DF9"=>230, "\u2DFA"=>230, "\u2DFB"=>230, "\u2DFC"=>230, "\u2DFD"=>230, "\u2DFE"=>230, "\u2DFF"=>230, "\u302A"=>218, "\u302B"=>228, "\u302C"=>232, "\u302D"=>222, "\u302E"=>224, "\u302F"=>224, "\u3099"=>8, "\u309A"=>8, "\uA66F"=>230, 
    "\uA674"=>230, "\uA675"=>230, "\uA676"=>230, "\uA677"=>230, "\uA678"=>230, "\uA679"=>230, "\uA67A"=>230, "\uA67B"=>230, "\uA67C"=>230, "\uA67D"=>230, "\uA69F"=>230, "\uA6F0"=>230, "\uA6F1"=>230, "\uA806"=>9, "\uA8C4"=>9, "\uA8E0"=>230, 
    "\uA8E1"=>230, "\uA8E2"=>230, "\uA8E3"=>230, "\uA8E4"=>230, "\uA8E5"=>230, "\uA8E6"=>230, "\uA8E7"=>230, "\uA8E8"=>230, "\uA8E9"=>230, "\uA8EA"=>230, "\uA8EB"=>230, "\uA8EC"=>230, "\uA8ED"=>230, "\uA8EE"=>230, "\uA8EF"=>230, "\uA8F0"=>230, 
    "\uA8F1"=>230, "\uA92B"=>220, "\uA92C"=>220, "\uA92D"=>220, "\uA953"=>9, "\uA9B3"=>7, "\uA9C0"=>9, "\uAAB0"=>230, "\uAAB2"=>230, "\uAAB3"=>230, "\uAAB4"=>220, "\uAAB7"=>230, "\uAAB8"=>230, "\uAABE"=>230, "\uAABF"=>230, "\uAAC1"=>230, 
    "\uAAF6"=>9, "\uABED"=>9, "\uFB1E"=>26, "\uFE20"=>230, "\uFE21"=>230, "\uFE22"=>230, "\uFE23"=>230, "\uFE24"=>230, "\uFE25"=>230, "\uFE26"=>230, "\u{101FD}"=>220, "\u{10A0D}"=>220, "\u{10A0F}"=>230, "\u{10A38}"=>230, "\u{10A39}"=>1, "\u{10A3A}"=>220, 
    "\u{10A3F}"=>9, "\u{11046}"=>9, "\u{110B9}"=>9, "\u{110BA}"=>7, "\u{11100}"=>230, "\u{11101}"=>230, "\u{11102}"=>230, "\u{11133}"=>9, "\u{11134}"=>9, "\u{111C0}"=>9, "\u{116B6}"=>9, "\u{116B7}"=>7, "\u{1D165}"=>216, "\u{1D166}"=>216, "\u{1D167}"=>1, "\u{1D168}"=>1, 
    "\u{1D169}"=>1, "\u{1D16D}"=>226, "\u{1D16E}"=>216, "\u{1D16F}"=>216, "\u{1D170}"=>216, "\u{1D171}"=>216, "\u{1D172}"=>216, "\u{1D17B}"=>220, "\u{1D17C}"=>220, "\u{1D17D}"=>220, "\u{1D17E}"=>220, "\u{1D17F}"=>220, "\u{1D180}"=>220, "\u{1D181}"=>220, "\u{1D182}"=>220, "\u{1D185}"=>230, 
    "\u{1D186}"=>230, "\u{1D187}"=>230, "\u{1D188}"=>230, "\u{1D189}"=>230, "\u{1D18A}"=>220, "\u{1D18B}"=>220, "\u{1D1AA}"=>230, "\u{1D1AB}"=>230, "\u{1D1AC}"=>230, "\u{1D1AD}"=>230, "\u{1D242}"=>230, "\u{1D243}"=>230, "\u{1D244}"=>230, 
  }
  CLASS_TABLE.default = 0

  DECOMPOSITION_TABLE = {
    "À"=>"A\u0300", "Á"=>"A\u0301", "Â"=>"A\u0302", "Ã"=>"A\u0303", "Ä"=>"A\u0308", "Å"=>"A\u030A", "Ç"=>"C\u0327", "È"=>"E\u0300", "É"=>"E\u0301", "Ê"=>"E\u0302", "Ë"=>"E\u0308", "Ì"=>"I\u0300", "Í"=>"I\u0301", "Î"=>"I\u0302", "Ï"=>"I\u0308", "Ñ"=>"N\u0303", 
    "Ò"=>"O\u0300", "Ó"=>"O\u0301", "Ô"=>"O\u0302", "Õ"=>"O\u0303", "Ö"=>"O\u0308", "Ù"=>"U\u0300", "Ú"=>"U\u0301", "Û"=>"U\u0302", "Ü"=>"U\u0308", "Ý"=>"Y\u0301", "à"=>"a\u0300", "á"=>"a\u0301", "â"=>"a\u0302", "ã"=>"a\u0303", "ä"=>"a\u0308", "å"=>"a\u030A", 
    "ç"=>"c\u0327", "è"=>"e\u0300", "é"=>"e\u0301", "ê"=>"e\u0302", "ë"=>"e\u0308", "ì"=>"i\u0300", "í"=>"i\u0301", "î"=>"i\u0302", "ï"=>"i\u0308", "ñ"=>"n\u0303", "ò"=>"o\u0300", "ó"=>"o\u0301", "ô"=>"o\u0302", "õ"=>"o\u0303", "ö"=>"o\u0308", "ù"=>"u\u0300", 
    "ú"=>"u\u0301", "û"=>"u\u0302", "ü"=>"u\u0308", "ý"=>"y\u0301", "ÿ"=>"y\u0308", "Ā"=>"A\u0304", "ā"=>"a\u0304", "Ă"=>"A\u0306", "ă"=>"a\u0306", "Ą"=>"A\u0328", "ą"=>"a\u0328", "Ć"=>"C\u0301", "ć"=>"c\u0301", "Ĉ"=>"C\u0302", "ĉ"=>"c\u0302", "Ċ"=>"C\u0307", 
    "ċ"=>"c\u0307", "Č"=>"C\u030C", "č"=>"c\u030C", "Ď"=>"D\u030C", "ď"=>"d\u030C", "Ē"=>"E\u0304", "ē"=>"e\u0304", "Ĕ"=>"E\u0306", "ĕ"=>"e\u0306", "Ė"=>"E\u0307", "ė"=>"e\u0307", "Ę"=>"E\u0328", "ę"=>"e\u0328", "Ě"=>"E\u030C", "ě"=>"e\u030C", "Ĝ"=>"G\u0302", 
    "ĝ"=>"g\u0302", "Ğ"=>"G\u0306", "ğ"=>"g\u0306", "Ġ"=>"G\u0307", "ġ"=>"g\u0307", "Ģ"=>"G\u0327", "ģ"=>"g\u0327", "Ĥ"=>"H\u0302", "ĥ"=>"h\u0302", "Ĩ"=>"I\u0303", "ĩ"=>"i\u0303", "Ī"=>"I\u0304", "ī"=>"i\u0304", "Ĭ"=>"I\u0306", "ĭ"=>"i\u0306", "Į"=>"I\u0328", 
    "į"=>"i\u0328", "İ"=>"I\u0307", "Ĵ"=>"J\u0302", "ĵ"=>"j\u0302", "Ķ"=>"K\u0327", "ķ"=>"k\u0327", "Ĺ"=>"L\u0301", "ĺ"=>"l\u0301", "Ļ"=>"L\u0327", "ļ"=>"l\u0327", "Ľ"=>"L\u030C", "ľ"=>"l\u030C", "Ń"=>"N\u0301", "ń"=>"n\u0301", "Ņ"=>"N\u0327", "ņ"=>"n\u0327", 
    "Ň"=>"N\u030C", "ň"=>"n\u030C", "Ō"=>"O\u0304", "ō"=>"o\u0304", "Ŏ"=>"O\u0306", "ŏ"=>"o\u0306", "Ő"=>"O\u030B", "ő"=>"o\u030B", "Ŕ"=>"R\u0301", "ŕ"=>"r\u0301", "Ŗ"=>"R\u0327", "ŗ"=>"r\u0327", "Ř"=>"R\u030C", "ř"=>"r\u030C", "Ś"=>"S\u0301", "ś"=>"s\u0301", 
    "Ŝ"=>"S\u0302", "ŝ"=>"s\u0302", "Ş"=>"S\u0327", "ş"=>"s\u0327", "Š"=>"S\u030C", "š"=>"s\u030C", "Ţ"=>"T\u0327", "ţ"=>"t\u0327", "Ť"=>"T\u030C", "ť"=>"t\u030C", "Ũ"=>"U\u0303", "ũ"=>"u\u0303", "Ū"=>"U\u0304", "ū"=>"u\u0304", "Ŭ"=>"U\u0306", "ŭ"=>"u\u0306", 
    "Ů"=>"U\u030A", "ů"=>"u\u030A", "Ű"=>"U\u030B", "ű"=>"u\u030B", "Ų"=>"U\u0328", "ų"=>"u\u0328", "Ŵ"=>"W\u0302", "ŵ"=>"w\u0302", "Ŷ"=>"Y\u0302", "ŷ"=>"y\u0302", "Ÿ"=>"Y\u0308", "Ź"=>"Z\u0301", "ź"=>"z\u0301", "Ż"=>"Z\u0307", "ż"=>"z\u0307", "Ž"=>"Z\u030C", 
    "ž"=>"z\u030C", "Ơ"=>"O\u031B", "ơ"=>"o\u031B", "Ư"=>"U\u031B", "ư"=>"u\u031B", "Ǎ"=>"A\u030C", "ǎ"=>"a\u030C", "Ǐ"=>"I\u030C", "ǐ"=>"i\u030C", "Ǒ"=>"O\u030C", "ǒ"=>"o\u030C", "Ǔ"=>"U\u030C", "ǔ"=>"u\u030C", "Ǖ"=>"U\u0308\u0304", "ǖ"=>"u\u0308\u0304", "Ǘ"=>"U\u0308\u0301", 
    "ǘ"=>"u\u0308\u0301", "Ǚ"=>"U\u0308\u030C", "ǚ"=>"u\u0308\u030C", "Ǜ"=>"U\u0308\u0300", "ǜ"=>"u\u0308\u0300", "Ǟ"=>"A\u0308\u0304", "ǟ"=>"a\u0308\u0304", "Ǡ"=>"A\u0307\u0304", "ǡ"=>"a\u0307\u0304", "Ǣ"=>"Æ\u0304", "ǣ"=>"æ\u0304", "Ǧ"=>"G\u030C", "ǧ"=>"g\u030C", "Ǩ"=>"K\u030C", "ǩ"=>"k\u030C", "Ǫ"=>"O\u0328", 
    "ǫ"=>"o\u0328", "Ǭ"=>"O\u0328\u0304", "ǭ"=>"o\u0328\u0304", "Ǯ"=>"Ʒ\u030C", "ǯ"=>"ʒ\u030C", "ǰ"=>"j\u030C", "Ǵ"=>"G\u0301", "ǵ"=>"g\u0301", "Ǹ"=>"N\u0300", "ǹ"=>"n\u0300", "Ǻ"=>"A\u030A\u0301", "ǻ"=>"a\u030A\u0301", "Ǽ"=>"Æ\u0301", "ǽ"=>"æ\u0301", "Ǿ"=>"Ø\u0301", "ǿ"=>"ø\u0301", 
    "Ȁ"=>"A\u030F", "ȁ"=>"a\u030F", "Ȃ"=>"A\u0311", "ȃ"=>"a\u0311", "Ȅ"=>"E\u030F", "ȅ"=>"e\u030F", "Ȇ"=>"E\u0311", "ȇ"=>"e\u0311", "Ȉ"=>"I\u030F", "ȉ"=>"i\u030F", "Ȋ"=>"I\u0311", "ȋ"=>"i\u0311", "Ȍ"=>"O\u030F", "ȍ"=>"o\u030F", "Ȏ"=>"O\u0311", "ȏ"=>"o\u0311", 
    "Ȑ"=>"R\u030F", "ȑ"=>"r\u030F", "Ȓ"=>"R\u0311", "ȓ"=>"r\u0311", "Ȕ"=>"U\u030F", "ȕ"=>"u\u030F", "Ȗ"=>"U\u0311", "ȗ"=>"u\u0311", "Ș"=>"S\u0326", "ș"=>"s\u0326", "Ț"=>"T\u0326", "ț"=>"t\u0326", "Ȟ"=>"H\u030C", "ȟ"=>"h\u030C", "Ȧ"=>"A\u0307", "ȧ"=>"a\u0307", 
    "Ȩ"=>"E\u0327", "ȩ"=>"e\u0327", "Ȫ"=>"O\u0308\u0304", "ȫ"=>"o\u0308\u0304", "Ȭ"=>"O\u0303\u0304", "ȭ"=>"o\u0303\u0304", "Ȯ"=>"O\u0307", "ȯ"=>"o\u0307", "Ȱ"=>"O\u0307\u0304", "ȱ"=>"o\u0307\u0304", "Ȳ"=>"Y\u0304", "ȳ"=>"y\u0304", "\u0340"=>"\u0300", "\u0341"=>"\u0301", "\u0343"=>"\u0313", "\u0344"=>"\u0308\u0301", 
    "ʹ"=>"ʹ", ";"=>";", "΅"=>"¨\u0301", "Ά"=>"Α\u0301", "·"=>"·", "Έ"=>"Ε\u0301", "Ή"=>"Η\u0301", "Ί"=>"Ι\u0301", "Ό"=>"Ο\u0301", "Ύ"=>"Υ\u0301", "Ώ"=>"Ω\u0301", "ΐ"=>"ι\u0308\u0301", "Ϊ"=>"Ι\u0308", "Ϋ"=>"Υ\u0308", "ά"=>"α\u0301", "έ"=>"ε\u0301", 
    "ή"=>"η\u0301", "ί"=>"ι\u0301", "ΰ"=>"υ\u0308\u0301", "ϊ"=>"ι\u0308", "ϋ"=>"υ\u0308", "ό"=>"ο\u0301", "ύ"=>"υ\u0301", "ώ"=>"ω\u0301", "ϓ"=>"ϒ\u0301", "ϔ"=>"ϒ\u0308", "Ѐ"=>"Е\u0300", "Ё"=>"Е\u0308", "Ѓ"=>"Г\u0301", "Ї"=>"І\u0308", "Ќ"=>"К\u0301", "Ѝ"=>"И\u0300", 
    "Ў"=>"У\u0306", "Й"=>"И\u0306", "й"=>"и\u0306", "ѐ"=>"е\u0300", "ё"=>"е\u0308", "ѓ"=>"г\u0301", "ї"=>"і\u0308", "ќ"=>"к\u0301", "ѝ"=>"и\u0300", "ў"=>"у\u0306", "Ѷ"=>"Ѵ\u030F", "ѷ"=>"ѵ\u030F", "Ӂ"=>"Ж\u0306", "ӂ"=>"ж\u0306", "Ӑ"=>"А\u0306", "ӑ"=>"а\u0306", 
    "Ӓ"=>"А\u0308", "ӓ"=>"а\u0308", "Ӗ"=>"Е\u0306", "ӗ"=>"е\u0306", "Ӛ"=>"Ә\u0308", "ӛ"=>"ә\u0308", "Ӝ"=>"Ж\u0308", "ӝ"=>"ж\u0308", "Ӟ"=>"З\u0308", "ӟ"=>"з\u0308", "Ӣ"=>"И\u0304", "ӣ"=>"и\u0304", "Ӥ"=>"И\u0308", "ӥ"=>"и\u0308", "Ӧ"=>"О\u0308", "ӧ"=>"о\u0308", 
    "Ӫ"=>"Ө\u0308", "ӫ"=>"ө\u0308", "Ӭ"=>"Э\u0308", "ӭ"=>"э\u0308", "Ӯ"=>"У\u0304", "ӯ"=>"у\u0304", "Ӱ"=>"У\u0308", "ӱ"=>"у\u0308", "Ӳ"=>"У\u030B", "ӳ"=>"у\u030B", "Ӵ"=>"Ч\u0308", "ӵ"=>"ч\u0308", "Ӹ"=>"Ы\u0308", "ӹ"=>"ы\u0308", "آ"=>"ا\u0653", "أ"=>"ا\u0654", 
    "ؤ"=>"و\u0654", "إ"=>"ا\u0655", "ئ"=>"ي\u0654", "ۀ"=>"ە\u0654", "ۂ"=>"ہ\u0654", "ۓ"=>"ے\u0654", "ऩ"=>"न\u093C", "ऱ"=>"र\u093C", "ऴ"=>"ळ\u093C", "क़"=>"क\u093C", "ख़"=>"ख\u093C", "ग़"=>"ग\u093C", "ज़"=>"ज\u093C", "ड़"=>"ड\u093C", "ढ़"=>"ढ\u093C", "फ़"=>"फ\u093C", 
    "य़"=>"य\u093C", "ো"=>"ো", "ৌ"=>"ৌ", "ড়"=>"ড\u09BC", "ঢ়"=>"ঢ\u09BC", "য়"=>"য\u09BC", "ਲ਼"=>"ਲ\u0A3C", "ਸ਼"=>"ਸ\u0A3C", "ਖ਼"=>"ਖ\u0A3C", "ਗ਼"=>"ਗ\u0A3C", "ਜ਼"=>"ਜ\u0A3C", "ਫ਼"=>"ਫ\u0A3C", "ୈ"=>"ୈ", "ୋ"=>"ୋ", "ୌ"=>"ୌ", "ଡ଼"=>"ଡ\u0B3C", 
    "ଢ଼"=>"ଢ\u0B3C", "ஔ"=>"ஔ", "ொ"=>"ொ", "ோ"=>"ோ", "ௌ"=>"ௌ", "ై"=>"ె\u0C56", "ೀ"=>"ೀ", "ೇ"=>"ೇ", "ೈ"=>"ೈ", "ೊ"=>"ೊ", "ೋ"=>"ೋ", "ൊ"=>"ൊ", "ോ"=>"ോ", "ൌ"=>"ൌ", "ේ"=>"ෙ\u0DCA", "ො"=>"ො", 
    "ෝ"=>"ො\u0DCA", "ෞ"=>"ෞ", "གྷ"=>"གྷ", "ཌྷ"=>"ཌྷ", "དྷ"=>"དྷ", "བྷ"=>"བྷ", "ཛྷ"=>"ཛྷ", "ཀྵ"=>"ཀྵ", "ཱི"=>"\u0F71\u0F72", "ཱུ"=>"\u0F71\u0F74", "ྲྀ"=>"ྲ\u0F80", "ླྀ"=>"ླ\u0F80", "ཱྀ"=>"\u0F71\u0F80", "ྒྷ"=>"ྒྷ", "ྜྷ"=>"ྜྷ", "ྡྷ"=>"ྡྷ", 
    "ྦྷ"=>"ྦྷ", "ྫྷ"=>"ྫྷ", "ྐྵ"=>"ྐྵ", "ဦ"=>"ဦ", "ᬆ"=>"ᬆ", "ᬈ"=>"ᬈ", "ᬊ"=>"ᬊ", "ᬌ"=>"ᬌ", "ᬎ"=>"ᬎ", "ᬒ"=>"ᬒ", "ᬻ"=>"ᬻ", "ᬽ"=>"ᬽ", "ᭀ"=>"ᭀ", "ᭁ"=>"ᭁ", "ᭃ"=>"ᭃ", "Ḁ"=>"A\u0325", 
    "ḁ"=>"a\u0325", "Ḃ"=>"B\u0307", "ḃ"=>"b\u0307", "Ḅ"=>"B\u0323", "ḅ"=>"b\u0323", "Ḇ"=>"B\u0331", "ḇ"=>"b\u0331", "Ḉ"=>"C\u0327\u0301", "ḉ"=>"c\u0327\u0301", "Ḋ"=>"D\u0307", "ḋ"=>"d\u0307", "Ḍ"=>"D\u0323", "ḍ"=>"d\u0323", "Ḏ"=>"D\u0331", "ḏ"=>"d\u0331", "Ḑ"=>"D\u0327", 
    "ḑ"=>"d\u0327", "Ḓ"=>"D\u032D", "ḓ"=>"d\u032D", "Ḕ"=>"E\u0304\u0300", "ḕ"=>"e\u0304\u0300", "Ḗ"=>"E\u0304\u0301", "ḗ"=>"e\u0304\u0301", "Ḙ"=>"E\u032D", "ḙ"=>"e\u032D", "Ḛ"=>"E\u0330", "ḛ"=>"e\u0330", "Ḝ"=>"E\u0327\u0306", "ḝ"=>"e\u0327\u0306", "Ḟ"=>"F\u0307", "ḟ"=>"f\u0307", "Ḡ"=>"G\u0304", 
    "ḡ"=>"g\u0304", "Ḣ"=>"H\u0307", "ḣ"=>"h\u0307", "Ḥ"=>"H\u0323", "ḥ"=>"h\u0323", "Ḧ"=>"H\u0308", "ḧ"=>"h\u0308", "Ḩ"=>"H\u0327", "ḩ"=>"h\u0327", "Ḫ"=>"H\u032E", "ḫ"=>"h\u032E", "Ḭ"=>"I\u0330", "ḭ"=>"i\u0330", "Ḯ"=>"I\u0308\u0301", "ḯ"=>"i\u0308\u0301", "Ḱ"=>"K\u0301", 
    "ḱ"=>"k\u0301", "Ḳ"=>"K\u0323", "ḳ"=>"k\u0323", "Ḵ"=>"K\u0331", "ḵ"=>"k\u0331", "Ḷ"=>"L\u0323", "ḷ"=>"l\u0323", "Ḹ"=>"L\u0323\u0304", "ḹ"=>"l\u0323\u0304", "Ḻ"=>"L\u0331", "ḻ"=>"l\u0331", "Ḽ"=>"L\u032D", "ḽ"=>"l\u032D", "Ḿ"=>"M\u0301", "ḿ"=>"m\u0301", "Ṁ"=>"M\u0307", 
    "ṁ"=>"m\u0307", "Ṃ"=>"M\u0323", "ṃ"=>"m\u0323", "Ṅ"=>"N\u0307", "ṅ"=>"n\u0307", "Ṇ"=>"N\u0323", "ṇ"=>"n\u0323", "Ṉ"=>"N\u0331", "ṉ"=>"n\u0331", "Ṋ"=>"N\u032D", "ṋ"=>"n\u032D", "Ṍ"=>"O\u0303\u0301", "ṍ"=>"o\u0303\u0301", "Ṏ"=>"O\u0303\u0308", "ṏ"=>"o\u0303\u0308", "Ṑ"=>"O\u0304\u0300", 
    "ṑ"=>"o\u0304\u0300", "Ṓ"=>"O\u0304\u0301", "ṓ"=>"o\u0304\u0301", "Ṕ"=>"P\u0301", "ṕ"=>"p\u0301", "Ṗ"=>"P\u0307", "ṗ"=>"p\u0307", "Ṙ"=>"R\u0307", "ṙ"=>"r\u0307", "Ṛ"=>"R\u0323", "ṛ"=>"r\u0323", "Ṝ"=>"R\u0323\u0304", "ṝ"=>"r\u0323\u0304", "Ṟ"=>"R\u0331", "ṟ"=>"r\u0331", "Ṡ"=>"S\u0307", 
    "ṡ"=>"s\u0307", "Ṣ"=>"S\u0323", "ṣ"=>"s\u0323", "Ṥ"=>"S\u0301\u0307", "ṥ"=>"s\u0301\u0307", "Ṧ"=>"S\u030C\u0307", "ṧ"=>"s\u030C\u0307", "Ṩ"=>"S\u0323\u0307", "ṩ"=>"s\u0323\u0307", "Ṫ"=>"T\u0307", "ṫ"=>"t\u0307", "Ṭ"=>"T\u0323", "ṭ"=>"t\u0323", "Ṯ"=>"T\u0331", "ṯ"=>"t\u0331", "Ṱ"=>"T\u032D", 
    "ṱ"=>"t\u032D", "Ṳ"=>"U\u0324", "ṳ"=>"u\u0324", "Ṵ"=>"U\u0330", "ṵ"=>"u\u0330", "Ṷ"=>"U\u032D", "ṷ"=>"u\u032D", "Ṹ"=>"U\u0303\u0301", "ṹ"=>"u\u0303\u0301", "Ṻ"=>"U\u0304\u0308", "ṻ"=>"u\u0304\u0308", "Ṽ"=>"V\u0303", "ṽ"=>"v\u0303", "Ṿ"=>"V\u0323", "ṿ"=>"v\u0323", "Ẁ"=>"W\u0300", 
    "ẁ"=>"w\u0300", "Ẃ"=>"W\u0301", "ẃ"=>"w\u0301", "Ẅ"=>"W\u0308", "ẅ"=>"w\u0308", "Ẇ"=>"W\u0307", "ẇ"=>"w\u0307", "Ẉ"=>"W\u0323", "ẉ"=>"w\u0323", "Ẋ"=>"X\u0307", "ẋ"=>"x\u0307", "Ẍ"=>"X\u0308", "ẍ"=>"x\u0308", "Ẏ"=>"Y\u0307", "ẏ"=>"y\u0307", "Ẑ"=>"Z\u0302", 
    "ẑ"=>"z\u0302", "Ẓ"=>"Z\u0323", "ẓ"=>"z\u0323", "Ẕ"=>"Z\u0331", "ẕ"=>"z\u0331", "ẖ"=>"h\u0331", "ẗ"=>"t\u0308", "ẘ"=>"w\u030A", "ẙ"=>"y\u030A", "ẛ"=>"ſ\u0307", "Ạ"=>"A\u0323", "ạ"=>"a\u0323", "Ả"=>"A\u0309", "ả"=>"a\u0309", "Ấ"=>"A\u0302\u0301", "ấ"=>"a\u0302\u0301", 
    "Ầ"=>"A\u0302\u0300", "ầ"=>"a\u0302\u0300", "Ẩ"=>"A\u0302\u0309", "ẩ"=>"a\u0302\u0309", "Ẫ"=>"A\u0302\u0303", "ẫ"=>"a\u0302\u0303", "Ậ"=>"A\u0323\u0302", "ậ"=>"a\u0323\u0302", "Ắ"=>"A\u0306\u0301", "ắ"=>"a\u0306\u0301", "Ằ"=>"A\u0306\u0300", "ằ"=>"a\u0306\u0300", "Ẳ"=>"A\u0306\u0309", "ẳ"=>"a\u0306\u0309", "Ẵ"=>"A\u0306\u0303", "ẵ"=>"a\u0306\u0303", 
    "Ặ"=>"A\u0323\u0306", "ặ"=>"a\u0323\u0306", "Ẹ"=>"E\u0323", "ẹ"=>"e\u0323", "Ẻ"=>"E\u0309", "ẻ"=>"e\u0309", "Ẽ"=>"E\u0303", "ẽ"=>"e\u0303", "Ế"=>"E\u0302\u0301", "ế"=>"e\u0302\u0301", "Ề"=>"E\u0302\u0300", "ề"=>"e\u0302\u0300", "Ể"=>"E\u0302\u0309", "ể"=>"e\u0302\u0309", "Ễ"=>"E\u0302\u0303", "ễ"=>"e\u0302\u0303", 
    "Ệ"=>"E\u0323\u0302", "ệ"=>"e\u0323\u0302", "Ỉ"=>"I\u0309", "ỉ"=>"i\u0309", "Ị"=>"I\u0323", "ị"=>"i\u0323", "Ọ"=>"O\u0323", "ọ"=>"o\u0323", "Ỏ"=>"O\u0309", "ỏ"=>"o\u0309", "Ố"=>"O\u0302\u0301", "ố"=>"o\u0302\u0301", "Ồ"=>"O\u0302\u0300", "ồ"=>"o\u0302\u0300", "Ổ"=>"O\u0302\u0309", "ổ"=>"o\u0302\u0309", 
    "Ỗ"=>"O\u0302\u0303", "ỗ"=>"o\u0302\u0303", "Ộ"=>"O\u0323\u0302", "ộ"=>"o\u0323\u0302", "Ớ"=>"O\u031B\u0301", "ớ"=>"o\u031B\u0301", "Ờ"=>"O\u031B\u0300", "ờ"=>"o\u031B\u0300", "Ở"=>"O\u031B\u0309", "ở"=>"o\u031B\u0309", "Ỡ"=>"O\u031B\u0303", "ỡ"=>"o\u031B\u0303", "Ợ"=>"O\u031B\u0323", "ợ"=>"o\u031B\u0323", "Ụ"=>"U\u0323", "ụ"=>"u\u0323", 
    "Ủ"=>"U\u0309", "ủ"=>"u\u0309", "Ứ"=>"U\u031B\u0301", "ứ"=>"u\u031B\u0301", "Ừ"=>"U\u031B\u0300", "ừ"=>"u\u031B\u0300", "Ử"=>"U\u031B\u0309", "ử"=>"u\u031B\u0309", "Ữ"=>"U\u031B\u0303", "ữ"=>"u\u031B\u0303", "Ự"=>"U\u031B\u0323", "ự"=>"u\u031B\u0323", "Ỳ"=>"Y\u0300", "ỳ"=>"y\u0300", "Ỵ"=>"Y\u0323", "ỵ"=>"y\u0323", 
    "Ỷ"=>"Y\u0309", "ỷ"=>"y\u0309", "Ỹ"=>"Y\u0303", "ỹ"=>"y\u0303", "ἀ"=>"α\u0313", "ἁ"=>"α\u0314", "ἂ"=>"α\u0313\u0300", "ἃ"=>"α\u0314\u0300", "ἄ"=>"α\u0313\u0301", "ἅ"=>"α\u0314\u0301", "ἆ"=>"α\u0313\u0342", "ἇ"=>"α\u0314\u0342", "Ἀ"=>"Α\u0313", "Ἁ"=>"Α\u0314", "Ἂ"=>"Α\u0313\u0300", "Ἃ"=>"Α\u0314\u0300", 
    "Ἄ"=>"Α\u0313\u0301", "Ἅ"=>"Α\u0314\u0301", "Ἆ"=>"Α\u0313\u0342", "Ἇ"=>"Α\u0314\u0342", "ἐ"=>"ε\u0313", "ἑ"=>"ε\u0314", "ἒ"=>"ε\u0313\u0300", "ἓ"=>"ε\u0314\u0300", "ἔ"=>"ε\u0313\u0301", "ἕ"=>"ε\u0314\u0301", "Ἐ"=>"Ε\u0313", "Ἑ"=>"Ε\u0314", "Ἒ"=>"Ε\u0313\u0300", "Ἓ"=>"Ε\u0314\u0300", "Ἔ"=>"Ε\u0313\u0301", "Ἕ"=>"Ε\u0314\u0301", 
    "ἠ"=>"η\u0313", "ἡ"=>"η\u0314", "ἢ"=>"η\u0313\u0300", "ἣ"=>"η\u0314\u0300", "ἤ"=>"η\u0313\u0301", "ἥ"=>"η\u0314\u0301", "ἦ"=>"η\u0313\u0342", "ἧ"=>"η\u0314\u0342", "Ἠ"=>"Η\u0313", "Ἡ"=>"Η\u0314", "Ἢ"=>"Η\u0313\u0300", "Ἣ"=>"Η\u0314\u0300", "Ἤ"=>"Η\u0313\u0301", "Ἥ"=>"Η\u0314\u0301", "Ἦ"=>"Η\u0313\u0342", "Ἧ"=>"Η\u0314\u0342", 
    "ἰ"=>"ι\u0313", "ἱ"=>"ι\u0314", "ἲ"=>"ι\u0313\u0300", "ἳ"=>"ι\u0314\u0300", "ἴ"=>"ι\u0313\u0301", "ἵ"=>"ι\u0314\u0301", "ἶ"=>"ι\u0313\u0342", "ἷ"=>"ι\u0314\u0342", "Ἰ"=>"Ι\u0313", "Ἱ"=>"Ι\u0314", "Ἲ"=>"Ι\u0313\u0300", "Ἳ"=>"Ι\u0314\u0300", "Ἴ"=>"Ι\u0313\u0301", "Ἵ"=>"Ι\u0314\u0301", "Ἶ"=>"Ι\u0313\u0342", "Ἷ"=>"Ι\u0314\u0342", 
    "ὀ"=>"ο\u0313", "ὁ"=>"ο\u0314", "ὂ"=>"ο\u0313\u0300", "ὃ"=>"ο\u0314\u0300", "ὄ"=>"ο\u0313\u0301", "ὅ"=>"ο\u0314\u0301", "Ὀ"=>"Ο\u0313", "Ὁ"=>"Ο\u0314", "Ὂ"=>"Ο\u0313\u0300", "Ὃ"=>"Ο\u0314\u0300", "Ὄ"=>"Ο\u0313\u0301", "Ὅ"=>"Ο\u0314\u0301", "ὐ"=>"υ\u0313", "ὑ"=>"υ\u0314", "ὒ"=>"υ\u0313\u0300", "ὓ"=>"υ\u0314\u0300", 
    "ὔ"=>"υ\u0313\u0301", "ὕ"=>"υ\u0314\u0301", "ὖ"=>"υ\u0313\u0342", "ὗ"=>"υ\u0314\u0342", "Ὑ"=>"Υ\u0314", "Ὓ"=>"Υ\u0314\u0300", "Ὕ"=>"Υ\u0314\u0301", "Ὗ"=>"Υ\u0314\u0342", "ὠ"=>"ω\u0313", "ὡ"=>"ω\u0314", "ὢ"=>"ω\u0313\u0300", "ὣ"=>"ω\u0314\u0300", "ὤ"=>"ω\u0313\u0301", "ὥ"=>"ω\u0314\u0301", "ὦ"=>"ω\u0313\u0342", "ὧ"=>"ω\u0314\u0342", 
    "Ὠ"=>"Ω\u0313", "Ὡ"=>"Ω\u0314", "Ὢ"=>"Ω\u0313\u0300", "Ὣ"=>"Ω\u0314\u0300", "Ὤ"=>"Ω\u0313\u0301", "Ὥ"=>"Ω\u0314\u0301", "Ὦ"=>"Ω\u0313\u0342", "Ὧ"=>"Ω\u0314\u0342", "ὰ"=>"α\u0300", "ά"=>"α\u0301", "ὲ"=>"ε\u0300", "έ"=>"ε\u0301", "ὴ"=>"η\u0300", "ή"=>"η\u0301", "ὶ"=>"ι\u0300", "ί"=>"ι\u0301", 
    "ὸ"=>"ο\u0300", "ό"=>"ο\u0301", "ὺ"=>"υ\u0300", "ύ"=>"υ\u0301", "ὼ"=>"ω\u0300", "ώ"=>"ω\u0301", "ᾀ"=>"α\u0313\u0345", "ᾁ"=>"α\u0314\u0345", "ᾂ"=>"α\u0313\u0300\u0345", "ᾃ"=>"α\u0314\u0300\u0345", "ᾄ"=>"α\u0313\u0301\u0345", "ᾅ"=>"α\u0314\u0301\u0345", "ᾆ"=>"α\u0313\u0342\u0345", "ᾇ"=>"α\u0314\u0342\u0345", "ᾈ"=>"Α\u0313\u0345", "ᾉ"=>"Α\u0314\u0345", 
    "ᾊ"=>"Α\u0313\u0300\u0345", "ᾋ"=>"Α\u0314\u0300\u0345", "ᾌ"=>"Α\u0313\u0301\u0345", "ᾍ"=>"Α\u0314\u0301\u0345", "ᾎ"=>"Α\u0313\u0342\u0345", "ᾏ"=>"Α\u0314\u0342\u0345", "ᾐ"=>"η\u0313\u0345", "ᾑ"=>"η\u0314\u0345", "ᾒ"=>"η\u0313\u0300\u0345", "ᾓ"=>"η\u0314\u0300\u0345", "ᾔ"=>"η\u0313\u0301\u0345", "ᾕ"=>"η\u0314\u0301\u0345", "ᾖ"=>"η\u0313\u0342\u0345", "ᾗ"=>"η\u0314\u0342\u0345", "ᾘ"=>"Η\u0313\u0345", "ᾙ"=>"Η\u0314\u0345", 
    "ᾚ"=>"Η\u0313\u0300\u0345", "ᾛ"=>"Η\u0314\u0300\u0345", "ᾜ"=>"Η\u0313\u0301\u0345", "ᾝ"=>"Η\u0314\u0301\u0345", "ᾞ"=>"Η\u0313\u0342\u0345", "ᾟ"=>"Η\u0314\u0342\u0345", "ᾠ"=>"ω\u0313\u0345", "ᾡ"=>"ω\u0314\u0345", "ᾢ"=>"ω\u0313\u0300\u0345", "ᾣ"=>"ω\u0314\u0300\u0345", "ᾤ"=>"ω\u0313\u0301\u0345", "ᾥ"=>"ω\u0314\u0301\u0345", "ᾦ"=>"ω\u0313\u0342\u0345", "ᾧ"=>"ω\u0314\u0342\u0345", "ᾨ"=>"Ω\u0313\u0345", "ᾩ"=>"Ω\u0314\u0345", 
    "ᾪ"=>"Ω\u0313\u0300\u0345", "ᾫ"=>"Ω\u0314\u0300\u0345", "ᾬ"=>"Ω\u0313\u0301\u0345", "ᾭ"=>"Ω\u0314\u0301\u0345", "ᾮ"=>"Ω\u0313\u0342\u0345", "ᾯ"=>"Ω\u0314\u0342\u0345", "ᾰ"=>"α\u0306", "ᾱ"=>"α\u0304", "ᾲ"=>"α\u0300\u0345", "ᾳ"=>"α\u0345", "ᾴ"=>"α\u0301\u0345", "ᾶ"=>"α\u0342", "ᾷ"=>"α\u0342\u0345", "Ᾰ"=>"Α\u0306", "Ᾱ"=>"Α\u0304", "Ὰ"=>"Α\u0300", 
    "Ά"=>"Α\u0301", "ᾼ"=>"Α\u0345", "ι"=>"ι", "῁"=>"¨\u0342", "ῂ"=>"η\u0300\u0345", "ῃ"=>"η\u0345", "ῄ"=>"η\u0301\u0345", "ῆ"=>"η\u0342", "ῇ"=>"η\u0342\u0345", "Ὲ"=>"Ε\u0300", "Έ"=>"Ε\u0301", "Ὴ"=>"Η\u0300", "Ή"=>"Η\u0301", "ῌ"=>"Η\u0345", "῍"=>"᾿\u0300", "῎"=>"᾿\u0301", 
    "῏"=>"᾿\u0342", "ῐ"=>"ι\u0306", "ῑ"=>"ι\u0304", "ῒ"=>"ι\u0308\u0300", "ΐ"=>"ι\u0308\u0301", "ῖ"=>"ι\u0342", "ῗ"=>"ι\u0308\u0342", "Ῐ"=>"Ι\u0306", "Ῑ"=>"Ι\u0304", "Ὶ"=>"Ι\u0300", "Ί"=>"Ι\u0301", "῝"=>"῾\u0300", "῞"=>"῾\u0301", "῟"=>"῾\u0342", "ῠ"=>"υ\u0306", "ῡ"=>"υ\u0304", 
    "ῢ"=>"υ\u0308\u0300", "ΰ"=>"υ\u0308\u0301", "ῤ"=>"ρ\u0313", "ῥ"=>"ρ\u0314", "ῦ"=>"υ\u0342", "ῧ"=>"υ\u0308\u0342", "Ῠ"=>"Υ\u0306", "Ῡ"=>"Υ\u0304", "Ὺ"=>"Υ\u0300", "Ύ"=>"Υ\u0301", "Ῥ"=>"Ρ\u0314", "῭"=>"¨\u0300", "΅"=>"¨\u0301", "`"=>"`", "ῲ"=>"ω\u0300\u0345", "ῳ"=>"ω\u0345", 
    "ῴ"=>"ω\u0301\u0345", "ῶ"=>"ω\u0342", "ῷ"=>"ω\u0342\u0345", "Ὸ"=>"Ο\u0300", "Ό"=>"Ο\u0301", "Ὼ"=>"Ω\u0300", "Ώ"=>"Ω\u0301", "ῼ"=>"Ω\u0345", "´"=>"´", " "=>" ", " "=>" ", "Ω"=>"Ω", "K"=>"K", "Å"=>"A\u030A", "↚"=>"←\u0338", "↛"=>"→\u0338", 
    "↮"=>"↔\u0338", "⇍"=>"⇐\u0338", "⇎"=>"⇔\u0338", "⇏"=>"⇒\u0338", "∄"=>"∃\u0338", "∉"=>"∈\u0338", "∌"=>"∋\u0338", "∤"=>"∣\u0338", "∦"=>"∥\u0338", "≁"=>"∼\u0338", "≄"=>"≃\u0338", "≇"=>"≅\u0338", "≉"=>"≈\u0338", "≠"=>"=\u0338", "≢"=>"≡\u0338", "≭"=>"≍\u0338", 
    "≮"=>"<\u0338", "≯"=>">\u0338", "≰"=>"≤\u0338", "≱"=>"≥\u0338", "≴"=>"≲\u0338", "≵"=>"≳\u0338", "≸"=>"≶\u0338", "≹"=>"≷\u0338", "⊀"=>"≺\u0338", "⊁"=>"≻\u0338", "⊄"=>"⊂\u0338", "⊅"=>"⊃\u0338", "⊈"=>"⊆\u0338", "⊉"=>"⊇\u0338", "⊬"=>"⊢\u0338", "⊭"=>"⊨\u0338", 
    "⊮"=>"⊩\u0338", "⊯"=>"⊫\u0338", "⋠"=>"≼\u0338", "⋡"=>"≽\u0338", "⋢"=>"⊑\u0338", "⋣"=>"⊒\u0338", "⋪"=>"⊲\u0338", "⋫"=>"⊳\u0338", "⋬"=>"⊴\u0338", "⋭"=>"⊵\u0338", "〈"=>"〈", "〉"=>"〉", "⫝̸"=>"⫝\u0338", "が"=>"か\u3099", "ぎ"=>"き\u3099", "ぐ"=>"く\u3099", 
    "げ"=>"け\u3099", "ご"=>"こ\u3099", "ざ"=>"さ\u3099", "じ"=>"し\u3099", "ず"=>"す\u3099", "ぜ"=>"せ\u3099", "ぞ"=>"そ\u3099", "だ"=>"た\u3099", "ぢ"=>"ち\u3099", "づ"=>"つ\u3099", "で"=>"て\u3099", "ど"=>"と\u3099", "ば"=>"は\u3099", "ぱ"=>"は\u309A", "び"=>"ひ\u3099", "ぴ"=>"ひ\u309A", 
    "ぶ"=>"ふ\u3099", "ぷ"=>"ふ\u309A", "べ"=>"へ\u3099", "ぺ"=>"へ\u309A", "ぼ"=>"ほ\u3099", "ぽ"=>"ほ\u309A", "ゔ"=>"う\u3099", "ゞ"=>"ゝ\u3099", "ガ"=>"カ\u3099", "ギ"=>"キ\u3099", "グ"=>"ク\u3099", "ゲ"=>"ケ\u3099", "ゴ"=>"コ\u3099", "ザ"=>"サ\u3099", "ジ"=>"シ\u3099", "ズ"=>"ス\u3099", 
    "ゼ"=>"セ\u3099", "ゾ"=>"ソ\u3099", "ダ"=>"タ\u3099", "ヂ"=>"チ\u3099", "ヅ"=>"ツ\u3099", "デ"=>"テ\u3099", "ド"=>"ト\u3099", "バ"=>"ハ\u3099", "パ"=>"ハ\u309A", "ビ"=>"ヒ\u3099", "ピ"=>"ヒ\u309A", "ブ"=>"フ\u3099", "プ"=>"フ\u309A", "ベ"=>"ヘ\u3099", "ペ"=>"ヘ\u309A", "ボ"=>"ホ\u3099", 
    "ポ"=>"ホ\u309A", "ヴ"=>"ウ\u3099", "ヷ"=>"ワ\u3099", "ヸ"=>"ヰ\u3099", "ヹ"=>"ヱ\u3099", "ヺ"=>"ヲ\u3099", "ヾ"=>"ヽ\u3099", "豈"=>"豈", "更"=>"更", "車"=>"車", "賈"=>"賈", "滑"=>"滑", "串"=>"串", "句"=>"句", "龜"=>"龜", "龜"=>"龜", 
    "契"=>"契", "金"=>"金", "喇"=>"喇", "奈"=>"奈", "懶"=>"懶", "癩"=>"癩", "羅"=>"羅", "蘿"=>"蘿", "螺"=>"螺", "裸"=>"裸", "邏"=>"邏", "樂"=>"樂", "洛"=>"洛", "烙"=>"烙", "珞"=>"珞", "落"=>"落", 
    "酪"=>"酪", "駱"=>"駱", "亂"=>"亂", "卵"=>"卵", "欄"=>"欄", "爛"=>"爛", "蘭"=>"蘭", "鸞"=>"鸞", "嵐"=>"嵐", "濫"=>"濫", "藍"=>"藍", "襤"=>"襤", "拉"=>"拉", "臘"=>"臘", "蠟"=>"蠟", "廊"=>"廊", 
    "朗"=>"朗", "浪"=>"浪", "狼"=>"狼", "郎"=>"郎", "來"=>"來", "冷"=>"冷", "勞"=>"勞", "擄"=>"擄", "櫓"=>"櫓", "爐"=>"爐", "盧"=>"盧", "老"=>"老", "蘆"=>"蘆", "虜"=>"虜", "路"=>"路", "露"=>"露", 
    "魯"=>"魯", "鷺"=>"鷺", "碌"=>"碌", "祿"=>"祿", "綠"=>"綠", "菉"=>"菉", "錄"=>"錄", "鹿"=>"鹿", "論"=>"論", "壟"=>"壟", "弄"=>"弄", "籠"=>"籠", "聾"=>"聾", "牢"=>"牢", "磊"=>"磊", "賂"=>"賂", 
    "雷"=>"雷", "壘"=>"壘", "屢"=>"屢", "樓"=>"樓", "淚"=>"淚", "漏"=>"漏", "累"=>"累", "縷"=>"縷", "陋"=>"陋", "勒"=>"勒", "肋"=>"肋", "凜"=>"凜", "凌"=>"凌", "稜"=>"稜", "綾"=>"綾", "菱"=>"菱", 
    "陵"=>"陵", "讀"=>"讀", "拏"=>"拏", "樂"=>"樂", "諾"=>"諾", "丹"=>"丹", "寧"=>"寧", "怒"=>"怒", "率"=>"率", "異"=>"異", "北"=>"北", "磻"=>"磻", "便"=>"便", "復"=>"復", "不"=>"不", "泌"=>"泌", 
    "數"=>"數", "索"=>"索", "參"=>"參", "塞"=>"塞", "省"=>"省", "葉"=>"葉", "說"=>"說", "殺"=>"殺", "辰"=>"辰", "沈"=>"沈", "拾"=>"拾", "若"=>"若", "掠"=>"掠", "略"=>"略", "亮"=>"亮", "兩"=>"兩", 
    "凉"=>"凉", "梁"=>"梁", "糧"=>"糧", "良"=>"良", "諒"=>"諒", "量"=>"量", "勵"=>"勵", "呂"=>"呂", "女"=>"女", "廬"=>"廬", "旅"=>"旅", "濾"=>"濾", "礪"=>"礪", "閭"=>"閭", "驪"=>"驪", "麗"=>"麗", 
    "黎"=>"黎", "力"=>"力", "曆"=>"曆", "歷"=>"歷", "轢"=>"轢", "年"=>"年", "憐"=>"憐", "戀"=>"戀", "撚"=>"撚", "漣"=>"漣", "煉"=>"煉", "璉"=>"璉", "秊"=>"秊", "練"=>"練", "聯"=>"聯", "輦"=>"輦", 
    "蓮"=>"蓮", "連"=>"連", "鍊"=>"鍊", "列"=>"列", "劣"=>"劣", "咽"=>"咽", "烈"=>"烈", "裂"=>"裂", "說"=>"說", "廉"=>"廉", "念"=>"念", "捻"=>"捻", "殮"=>"殮", "簾"=>"簾", "獵"=>"獵", "令"=>"令", 
    "囹"=>"囹", "寧"=>"寧", "嶺"=>"嶺", "怜"=>"怜", "玲"=>"玲", "瑩"=>"瑩", "羚"=>"羚", "聆"=>"聆", "鈴"=>"鈴", "零"=>"零", "靈"=>"靈", "領"=>"領", "例"=>"例", "禮"=>"禮", "醴"=>"醴", "隸"=>"隸", 
    "惡"=>"惡", "了"=>"了", "僚"=>"僚", "寮"=>"寮", "尿"=>"尿", "料"=>"料", "樂"=>"樂", "燎"=>"燎", "療"=>"療", "蓼"=>"蓼", "遼"=>"遼", "龍"=>"龍", "暈"=>"暈", "阮"=>"阮", "劉"=>"劉", "杻"=>"杻", 
    "柳"=>"柳", "流"=>"流", "溜"=>"溜", "琉"=>"琉", "留"=>"留", "硫"=>"硫", "紐"=>"紐", "類"=>"類", "六"=>"六", "戮"=>"戮", "陸"=>"陸", "倫"=>"倫", "崙"=>"崙", "淪"=>"淪", "輪"=>"輪", "律"=>"律", 
    "慄"=>"慄", "栗"=>"栗", "率"=>"率", "隆"=>"隆", "利"=>"利", "吏"=>"吏", "履"=>"履", "易"=>"易", "李"=>"李", "梨"=>"梨", "泥"=>"泥", "理"=>"理", "痢"=>"痢", "罹"=>"罹", "裏"=>"裏", "裡"=>"裡", 
    "里"=>"里", "離"=>"離", "匿"=>"匿", "溺"=>"溺", "吝"=>"吝", "燐"=>"燐", "璘"=>"璘", "藺"=>"藺", "隣"=>"隣", "鱗"=>"鱗", "麟"=>"麟", "林"=>"林", "淋"=>"淋", "臨"=>"臨", "立"=>"立", "笠"=>"笠", 
    "粒"=>"粒", "狀"=>"狀", "炙"=>"炙", "識"=>"識", "什"=>"什", "茶"=>"茶", "刺"=>"刺", "切"=>"切", "度"=>"度", "拓"=>"拓", "糖"=>"糖", "宅"=>"宅", "洞"=>"洞", "暴"=>"暴", "輻"=>"輻", "行"=>"行", 
    "降"=>"降", "見"=>"見", "廓"=>"廓", "兀"=>"兀", "嗀"=>"嗀", "塚"=>"塚", "晴"=>"晴", "凞"=>"凞", "猪"=>"猪", "益"=>"益", "礼"=>"礼", "神"=>"神", "祥"=>"祥", "福"=>"福", "靖"=>"靖", "精"=>"精", 
    "羽"=>"羽", "蘒"=>"蘒", "諸"=>"諸", "逸"=>"逸", "都"=>"都", "飯"=>"飯", "飼"=>"飼", "館"=>"館", "鶴"=>"鶴", "郞"=>"郞", "隷"=>"隷", "侮"=>"侮", "僧"=>"僧", "免"=>"免", "勉"=>"勉", "勤"=>"勤", 
    "卑"=>"卑", "喝"=>"喝", "嘆"=>"嘆", "器"=>"器", "塀"=>"塀", "墨"=>"墨", "層"=>"層", "屮"=>"屮", "悔"=>"悔", "慨"=>"慨", "憎"=>"憎", "懲"=>"懲", "敏"=>"敏", "既"=>"既", "暑"=>"暑", "梅"=>"梅", 
    "海"=>"海", "渚"=>"渚", "漢"=>"漢", "煮"=>"煮", "爫"=>"爫", "琢"=>"琢", "碑"=>"碑", "社"=>"社", "祉"=>"祉", "祈"=>"祈", "祐"=>"祐", "祖"=>"祖", "祝"=>"祝", "禍"=>"禍", "禎"=>"禎", "穀"=>"穀", 
    "突"=>"突", "節"=>"節", "練"=>"練", "縉"=>"縉", "繁"=>"繁", "署"=>"署", "者"=>"者", "臭"=>"臭", "艹"=>"艹", "艹"=>"艹", "著"=>"著", "褐"=>"褐", "視"=>"視", "謁"=>"謁", "謹"=>"謹", "賓"=>"賓", 
    "贈"=>"贈", "辶"=>"辶", "逸"=>"逸", "難"=>"難", "響"=>"響", "頻"=>"頻", "恵"=>"恵", "𤋮"=>"\u{242EE}", "舘"=>"舘", "並"=>"並", "况"=>"况", "全"=>"全", "侀"=>"侀", "充"=>"充", "冀"=>"冀", "勇"=>"勇", 
    "勺"=>"勺", "喝"=>"喝", "啕"=>"啕", "喙"=>"喙", "嗢"=>"嗢", "塚"=>"塚", "墳"=>"墳", "奄"=>"奄", "奔"=>"奔", "婢"=>"婢", "嬨"=>"嬨", "廒"=>"廒", "廙"=>"廙", "彩"=>"彩", "徭"=>"徭", "惘"=>"惘", 
    "慎"=>"慎", "愈"=>"愈", "憎"=>"憎", "慠"=>"慠", "懲"=>"懲", "戴"=>"戴", "揄"=>"揄", "搜"=>"搜", "摒"=>"摒", "敖"=>"敖", "晴"=>"晴", "朗"=>"朗", "望"=>"望", "杖"=>"杖", "歹"=>"歹", "殺"=>"殺", 
    "流"=>"流", "滛"=>"滛", "滋"=>"滋", "漢"=>"漢", "瀞"=>"瀞", "煮"=>"煮", "瞧"=>"瞧", "爵"=>"爵", "犯"=>"犯", "猪"=>"猪", "瑱"=>"瑱", "甆"=>"甆", "画"=>"画", "瘝"=>"瘝", "瘟"=>"瘟", "益"=>"益", 
    "盛"=>"盛", "直"=>"直", "睊"=>"睊", "着"=>"着", "磌"=>"磌", "窱"=>"窱", "節"=>"節", "类"=>"类", "絛"=>"絛", "練"=>"練", "缾"=>"缾", "者"=>"者", "荒"=>"荒", "華"=>"華", "蝹"=>"蝹", "襁"=>"襁", 
    "覆"=>"覆", "視"=>"視", "調"=>"調", "諸"=>"諸", "請"=>"請", "謁"=>"謁", "諾"=>"諾", "諭"=>"諭", "謹"=>"謹", "變"=>"變", "贈"=>"贈", "輸"=>"輸", "遲"=>"遲", "醙"=>"醙", "鉶"=>"鉶", "陼"=>"陼", 
    "難"=>"難", "靖"=>"靖", "韛"=>"韛", "響"=>"響", "頋"=>"頋", "頻"=>"頻", "鬒"=>"鬒", "龜"=>"龜", "𢡊"=>"\u{2284A}", "𢡄"=>"\u{22844}", "𣏕"=>"\u{233D5}", "㮝"=>"㮝", "䀘"=>"䀘", "䀹"=>"䀹", "𥉉"=>"\u{25249}", "𥳐"=>"\u{25CD0}", 
    "𧻓"=>"\u{27ED3}", "齃"=>"齃", "龎"=>"龎", "יִ"=>"י\u05B4", "ײַ"=>"ײ\u05B7", "שׁ"=>"ש\u05C1", "שׂ"=>"ש\u05C2", "שּׁ"=>"ש\u05BC\u05C1", "שּׂ"=>"ש\u05BC\u05C2", "אַ"=>"א\u05B7", "אָ"=>"א\u05B8", "אּ"=>"א\u05BC", "בּ"=>"ב\u05BC", "גּ"=>"ג\u05BC", "דּ"=>"ד\u05BC", "הּ"=>"ה\u05BC", 
    "וּ"=>"ו\u05BC", "זּ"=>"ז\u05BC", "טּ"=>"ט\u05BC", "יּ"=>"י\u05BC", "ךּ"=>"ך\u05BC", "כּ"=>"כ\u05BC", "לּ"=>"ל\u05BC", "מּ"=>"מ\u05BC", "נּ"=>"נ\u05BC", "סּ"=>"ס\u05BC", "ףּ"=>"ף\u05BC", "פּ"=>"פ\u05BC", "צּ"=>"צ\u05BC", "קּ"=>"ק\u05BC", "רּ"=>"ר\u05BC", "שּ"=>"ש\u05BC", 
    "תּ"=>"ת\u05BC", "וֹ"=>"ו\u05B9", "בֿ"=>"ב\u05BF", "כֿ"=>"כ\u05BF", "פֿ"=>"פ\u05BF", "\u{1109A}"=>"\u{11099}\u{110BA}", "\u{1109C}"=>"\u{1109B}\u{110BA}", "\u{110AB}"=>"\u{110A5}\u{110BA}", "\u{1112E}"=>"\u{11131}\u{11127}", "\u{1112F}"=>"\u{11132}\u{11127}", "\u{1D15E}"=>"\u{1D157}\u{1D165}", "\u{1D15F}"=>"\u{1D158}\u{1D165}", "\u{1D160}"=>"\u{1D158}\u{1D165}\u{1D16E}", "\u{1D161}"=>"\u{1D158}\u{1D165}\u{1D16F}", "\u{1D162}"=>"\u{1D158}\u{1D165}\u{1D170}", "\u{1D163}"=>"\u{1D158}\u{1D165}\u{1D171}", 
    "\u{1D164}"=>"\u{1D158}\u{1D165}\u{1D172}", "\u{1D1BB}"=>"\u{1D1B9}\u{1D165}", "\u{1D1BC}"=>"\u{1D1BA}\u{1D165}", "\u{1D1BD}"=>"\u{1D1B9}\u{1D165}\u{1D16E}", "\u{1D1BE}"=>"\u{1D1BA}\u{1D165}\u{1D16E}", "\u{1D1BF}"=>"\u{1D1B9}\u{1D165}\u{1D16F}", "\u{1D1C0}"=>"\u{1D1BA}\u{1D165}\u{1D16F}", "\u{2F800}"=>"丽", "\u{2F801}"=>"丸", "\u{2F802}"=>"乁", "\u{2F803}"=>"\u{20122}", "\u{2F804}"=>"你", "\u{2F805}"=>"侮", "\u{2F806}"=>"侻", "\u{2F807}"=>"倂", "\u{2F808}"=>"偺", 
    "\u{2F809}"=>"備", "\u{2F80A}"=>"僧", "\u{2F80B}"=>"像", "\u{2F80C}"=>"㒞", "\u{2F80D}"=>"\u{2063A}", "\u{2F80E}"=>"免", "\u{2F80F}"=>"兔", "\u{2F810}"=>"兤", "\u{2F811}"=>"具", "\u{2F812}"=>"\u{2051C}", "\u{2F813}"=>"㒹", "\u{2F814}"=>"內", "\u{2F815}"=>"再", "\u{2F816}"=>"\u{2054B}", "\u{2F817}"=>"冗", "\u{2F818}"=>"冤", 
    "\u{2F819}"=>"仌", "\u{2F81A}"=>"冬", "\u{2F81B}"=>"况", "\u{2F81C}"=>"\u{291DF}", "\u{2F81D}"=>"凵", "\u{2F81E}"=>"刃", "\u{2F81F}"=>"㓟", "\u{2F820}"=>"刻", "\u{2F821}"=>"剆", "\u{2F822}"=>"割", "\u{2F823}"=>"剷", "\u{2F824}"=>"㔕", "\u{2F825}"=>"勇", "\u{2F826}"=>"勉", "\u{2F827}"=>"勤", "\u{2F828}"=>"勺", 
    "\u{2F829}"=>"包", "\u{2F82A}"=>"匆", "\u{2F82B}"=>"北", "\u{2F82C}"=>"卉", "\u{2F82D}"=>"卑", "\u{2F82E}"=>"博", "\u{2F82F}"=>"即", "\u{2F830}"=>"卽", "\u{2F831}"=>"卿", "\u{2F832}"=>"卿", "\u{2F833}"=>"卿", "\u{2F834}"=>"\u{20A2C}", "\u{2F835}"=>"灰", "\u{2F836}"=>"及", "\u{2F837}"=>"叟", "\u{2F838}"=>"\u{20B63}", 
    "\u{2F839}"=>"叫", "\u{2F83A}"=>"叱", "\u{2F83B}"=>"吆", "\u{2F83C}"=>"咞", "\u{2F83D}"=>"吸", "\u{2F83E}"=>"呈", "\u{2F83F}"=>"周", "\u{2F840}"=>"咢", "\u{2F841}"=>"哶", "\u{2F842}"=>"唐", "\u{2F843}"=>"啓", "\u{2F844}"=>"啣", "\u{2F845}"=>"善", "\u{2F846}"=>"善", "\u{2F847}"=>"喙", "\u{2F848}"=>"喫", 
    "\u{2F849}"=>"喳", "\u{2F84A}"=>"嗂", "\u{2F84B}"=>"圖", "\u{2F84C}"=>"嘆", "\u{2F84D}"=>"圗", "\u{2F84E}"=>"噑", "\u{2F84F}"=>"噴", "\u{2F850}"=>"切", "\u{2F851}"=>"壮", "\u{2F852}"=>"城", "\u{2F853}"=>"埴", "\u{2F854}"=>"堍", "\u{2F855}"=>"型", "\u{2F856}"=>"堲", "\u{2F857}"=>"報", "\u{2F858}"=>"墬", 
    "\u{2F859}"=>"\u{214E4}", "\u{2F85A}"=>"売", "\u{2F85B}"=>"壷", "\u{2F85C}"=>"夆", "\u{2F85D}"=>"多", "\u{2F85E}"=>"夢", "\u{2F85F}"=>"奢", "\u{2F860}"=>"\u{216A8}", "\u{2F861}"=>"\u{216EA}", "\u{2F862}"=>"姬", "\u{2F863}"=>"娛", "\u{2F864}"=>"娧", "\u{2F865}"=>"姘", "\u{2F866}"=>"婦", "\u{2F867}"=>"㛮", "\u{2F868}"=>"㛼", 
    "\u{2F869}"=>"嬈", "\u{2F86A}"=>"嬾", "\u{2F86B}"=>"嬾", "\u{2F86C}"=>"\u{219C8}", "\u{2F86D}"=>"寃", "\u{2F86E}"=>"寘", "\u{2F86F}"=>"寧", "\u{2F870}"=>"寳", "\u{2F871}"=>"\u{21B18}", "\u{2F872}"=>"寿", "\u{2F873}"=>"将", "\u{2F874}"=>"当", "\u{2F875}"=>"尢", "\u{2F876}"=>"㞁", "\u{2F877}"=>"屠", "\u{2F878}"=>"屮", 
    "\u{2F879}"=>"峀", "\u{2F87A}"=>"岍", "\u{2F87B}"=>"\u{21DE4}", "\u{2F87C}"=>"嵃", "\u{2F87D}"=>"\u{21DE6}", "\u{2F87E}"=>"嵮", "\u{2F87F}"=>"嵫", "\u{2F880}"=>"嵼", "\u{2F881}"=>"巡", "\u{2F882}"=>"巢", "\u{2F883}"=>"㠯", "\u{2F884}"=>"巽", "\u{2F885}"=>"帨", "\u{2F886}"=>"帽", "\u{2F887}"=>"幩", "\u{2F888}"=>"㡢", 
    "\u{2F889}"=>"\u{22183}", "\u{2F88A}"=>"㡼", "\u{2F88B}"=>"庰", "\u{2F88C}"=>"庳", "\u{2F88D}"=>"庶", "\u{2F88E}"=>"廊", "\u{2F88F}"=>"\u{2A392}", "\u{2F890}"=>"廾", "\u{2F891}"=>"\u{22331}", "\u{2F892}"=>"\u{22331}", "\u{2F893}"=>"舁", "\u{2F894}"=>"弢", "\u{2F895}"=>"弢", "\u{2F896}"=>"㣇", "\u{2F897}"=>"\u{232B8}", "\u{2F898}"=>"\u{261DA}", 
    "\u{2F899}"=>"形", "\u{2F89A}"=>"彫", "\u{2F89B}"=>"㣣", "\u{2F89C}"=>"徚", "\u{2F89D}"=>"忍", "\u{2F89E}"=>"志", "\u{2F89F}"=>"忹", "\u{2F8A0}"=>"悁", "\u{2F8A1}"=>"㤺", "\u{2F8A2}"=>"㤜", "\u{2F8A3}"=>"悔", "\u{2F8A4}"=>"\u{226D4}", "\u{2F8A5}"=>"惇", "\u{2F8A6}"=>"慈", "\u{2F8A7}"=>"慌", "\u{2F8A8}"=>"慎", 
    "\u{2F8A9}"=>"慌", "\u{2F8AA}"=>"慺", "\u{2F8AB}"=>"憎", "\u{2F8AC}"=>"憲", "\u{2F8AD}"=>"憤", "\u{2F8AE}"=>"憯", "\u{2F8AF}"=>"懞", "\u{2F8B0}"=>"懲", "\u{2F8B1}"=>"懶", "\u{2F8B2}"=>"成", "\u{2F8B3}"=>"戛", "\u{2F8B4}"=>"扝", "\u{2F8B5}"=>"抱", "\u{2F8B6}"=>"拔", "\u{2F8B7}"=>"捐", "\u{2F8B8}"=>"\u{22B0C}", 
    "\u{2F8B9}"=>"挽", "\u{2F8BA}"=>"拼", "\u{2F8BB}"=>"捨", "\u{2F8BC}"=>"掃", "\u{2F8BD}"=>"揤", "\u{2F8BE}"=>"\u{22BF1}", "\u{2F8BF}"=>"搢", "\u{2F8C0}"=>"揅", "\u{2F8C1}"=>"掩", "\u{2F8C2}"=>"㨮", "\u{2F8C3}"=>"摩", "\u{2F8C4}"=>"摾", "\u{2F8C5}"=>"撝", "\u{2F8C6}"=>"摷", "\u{2F8C7}"=>"㩬", "\u{2F8C8}"=>"敏", 
    "\u{2F8C9}"=>"敬", "\u{2F8CA}"=>"\u{2300A}", "\u{2F8CB}"=>"旣", "\u{2F8CC}"=>"書", "\u{2F8CD}"=>"晉", "\u{2F8CE}"=>"㬙", "\u{2F8CF}"=>"暑", "\u{2F8D0}"=>"㬈", "\u{2F8D1}"=>"㫤", "\u{2F8D2}"=>"冒", "\u{2F8D3}"=>"冕", "\u{2F8D4}"=>"最", "\u{2F8D5}"=>"暜", "\u{2F8D6}"=>"肭", "\u{2F8D7}"=>"䏙", "\u{2F8D8}"=>"朗", 
    "\u{2F8D9}"=>"望", "\u{2F8DA}"=>"朡", "\u{2F8DB}"=>"杞", "\u{2F8DC}"=>"杓", "\u{2F8DD}"=>"\u{233C3}", "\u{2F8DE}"=>"㭉", "\u{2F8DF}"=>"柺", "\u{2F8E0}"=>"枅", "\u{2F8E1}"=>"桒", "\u{2F8E2}"=>"梅", "\u{2F8E3}"=>"\u{2346D}", "\u{2F8E4}"=>"梎", "\u{2F8E5}"=>"栟", "\u{2F8E6}"=>"椔", "\u{2F8E7}"=>"㮝", "\u{2F8E8}"=>"楂", 
    "\u{2F8E9}"=>"榣", "\u{2F8EA}"=>"槪", "\u{2F8EB}"=>"檨", "\u{2F8EC}"=>"\u{236A3}", "\u{2F8ED}"=>"櫛", "\u{2F8EE}"=>"㰘", "\u{2F8EF}"=>"次", "\u{2F8F0}"=>"\u{238A7}", "\u{2F8F1}"=>"歔", "\u{2F8F2}"=>"㱎", "\u{2F8F3}"=>"歲", "\u{2F8F4}"=>"殟", "\u{2F8F5}"=>"殺", "\u{2F8F6}"=>"殻", "\u{2F8F7}"=>"\u{23A8D}", "\u{2F8F8}"=>"\u{21D0B}", 
    "\u{2F8F9}"=>"\u{23AFA}", "\u{2F8FA}"=>"汎", "\u{2F8FB}"=>"\u{23CBC}", "\u{2F8FC}"=>"沿", "\u{2F8FD}"=>"泍", "\u{2F8FE}"=>"汧", "\u{2F8FF}"=>"洖", "\u{2F900}"=>"派", "\u{2F901}"=>"海", "\u{2F902}"=>"流", "\u{2F903}"=>"浩", "\u{2F904}"=>"浸", "\u{2F905}"=>"涅", "\u{2F906}"=>"\u{23D1E}", "\u{2F907}"=>"洴", "\u{2F908}"=>"港", 
    "\u{2F909}"=>"湮", "\u{2F90A}"=>"㴳", "\u{2F90B}"=>"滋", "\u{2F90C}"=>"滇", "\u{2F90D}"=>"\u{23ED1}", "\u{2F90E}"=>"淹", "\u{2F90F}"=>"潮", "\u{2F910}"=>"\u{23F5E}", "\u{2F911}"=>"\u{23F8E}", "\u{2F912}"=>"濆", "\u{2F913}"=>"瀹", "\u{2F914}"=>"瀞", "\u{2F915}"=>"瀛", "\u{2F916}"=>"㶖", "\u{2F917}"=>"灊", "\u{2F918}"=>"災", 
    "\u{2F919}"=>"灷", "\u{2F91A}"=>"炭", "\u{2F91B}"=>"\u{20525}", "\u{2F91C}"=>"煅", "\u{2F91D}"=>"\u{24263}", "\u{2F91E}"=>"熜", "\u{2F91F}"=>"\u{243AB}", "\u{2F920}"=>"爨", "\u{2F921}"=>"爵", "\u{2F922}"=>"牐", "\u{2F923}"=>"\u{24608}", "\u{2F924}"=>"犀", "\u{2F925}"=>"犕", "\u{2F926}"=>"\u{24735}", "\u{2F927}"=>"\u{24814}", "\u{2F928}"=>"獺", 
    "\u{2F929}"=>"王", "\u{2F92A}"=>"㺬", "\u{2F92B}"=>"玥", "\u{2F92C}"=>"㺸", "\u{2F92D}"=>"㺸", "\u{2F92E}"=>"瑇", "\u{2F92F}"=>"瑜", "\u{2F930}"=>"瑱", "\u{2F931}"=>"璅", "\u{2F932}"=>"瓊", "\u{2F933}"=>"㼛", "\u{2F934}"=>"甤", "\u{2F935}"=>"\u{24C36}", "\u{2F936}"=>"甾", "\u{2F937}"=>"\u{24C92}", "\u{2F938}"=>"異", 
    "\u{2F939}"=>"\u{2219F}", "\u{2F93A}"=>"瘐", "\u{2F93B}"=>"\u{24FA1}", "\u{2F93C}"=>"\u{24FB8}", "\u{2F93D}"=>"\u{25044}", "\u{2F93E}"=>"㿼", "\u{2F93F}"=>"䀈", "\u{2F940}"=>"直", "\u{2F941}"=>"\u{250F3}", "\u{2F942}"=>"\u{250F2}", "\u{2F943}"=>"\u{25119}", "\u{2F944}"=>"\u{25133}", "\u{2F945}"=>"眞", "\u{2F946}"=>"真", "\u{2F947}"=>"真", "\u{2F948}"=>"睊", 
    "\u{2F949}"=>"䀹", "\u{2F94A}"=>"瞋", "\u{2F94B}"=>"䁆", "\u{2F94C}"=>"䂖", "\u{2F94D}"=>"\u{2541D}", "\u{2F94E}"=>"硎", "\u{2F94F}"=>"碌", "\u{2F950}"=>"磌", "\u{2F951}"=>"䃣", "\u{2F952}"=>"\u{25626}", "\u{2F953}"=>"祖", "\u{2F954}"=>"\u{2569A}", "\u{2F955}"=>"\u{256C5}", "\u{2F956}"=>"福", "\u{2F957}"=>"秫", "\u{2F958}"=>"䄯", 
    "\u{2F959}"=>"穀", "\u{2F95A}"=>"穊", "\u{2F95B}"=>"穏", "\u{2F95C}"=>"\u{2597C}", "\u{2F95D}"=>"\u{25AA7}", "\u{2F95E}"=>"\u{25AA7}", "\u{2F95F}"=>"竮", "\u{2F960}"=>"䈂", "\u{2F961}"=>"\u{25BAB}", "\u{2F962}"=>"篆", "\u{2F963}"=>"築", "\u{2F964}"=>"䈧", "\u{2F965}"=>"\u{25C80}", "\u{2F966}"=>"糒", "\u{2F967}"=>"䊠", "\u{2F968}"=>"糨", 
    "\u{2F969}"=>"糣", "\u{2F96A}"=>"紀", "\u{2F96B}"=>"\u{25F86}", "\u{2F96C}"=>"絣", "\u{2F96D}"=>"䌁", "\u{2F96E}"=>"緇", "\u{2F96F}"=>"縂", "\u{2F970}"=>"繅", "\u{2F971}"=>"䌴", "\u{2F972}"=>"\u{26228}", "\u{2F973}"=>"\u{26247}", "\u{2F974}"=>"䍙", "\u{2F975}"=>"\u{262D9}", "\u{2F976}"=>"罺", "\u{2F977}"=>"\u{2633E}", "\u{2F978}"=>"羕", 
    "\u{2F979}"=>"翺", "\u{2F97A}"=>"者", "\u{2F97B}"=>"\u{264DA}", "\u{2F97C}"=>"\u{26523}", "\u{2F97D}"=>"聠", "\u{2F97E}"=>"\u{265A8}", "\u{2F97F}"=>"聰", "\u{2F980}"=>"\u{2335F}", "\u{2F981}"=>"䏕", "\u{2F982}"=>"育", "\u{2F983}"=>"脃", "\u{2F984}"=>"䐋", "\u{2F985}"=>"脾", "\u{2F986}"=>"媵", "\u{2F987}"=>"\u{267A7}", "\u{2F988}"=>"\u{267B5}", 
    "\u{2F989}"=>"\u{23393}", "\u{2F98A}"=>"\u{2339C}", "\u{2F98B}"=>"舁", "\u{2F98C}"=>"舄", "\u{2F98D}"=>"辞", "\u{2F98E}"=>"䑫", "\u{2F98F}"=>"芑", "\u{2F990}"=>"芋", "\u{2F991}"=>"芝", "\u{2F992}"=>"劳", "\u{2F993}"=>"花", "\u{2F994}"=>"芳", "\u{2F995}"=>"芽", "\u{2F996}"=>"苦", "\u{2F997}"=>"\u{26B3C}", "\u{2F998}"=>"若", 
    "\u{2F999}"=>"茝", "\u{2F99A}"=>"荣", "\u{2F99B}"=>"莭", "\u{2F99C}"=>"茣", "\u{2F99D}"=>"莽", "\u{2F99E}"=>"菧", "\u{2F99F}"=>"著", "\u{2F9A0}"=>"荓", "\u{2F9A1}"=>"菊", "\u{2F9A2}"=>"菌", "\u{2F9A3}"=>"菜", "\u{2F9A4}"=>"\u{26C36}", "\u{2F9A5}"=>"\u{26D6B}", "\u{2F9A6}"=>"\u{26CD5}", "\u{2F9A7}"=>"䔫", "\u{2F9A8}"=>"蓱", 
    "\u{2F9A9}"=>"蓳", "\u{2F9AA}"=>"蔖", "\u{2F9AB}"=>"\u{273CA}", "\u{2F9AC}"=>"蕤", "\u{2F9AD}"=>"\u{26F2C}", "\u{2F9AE}"=>"䕝", "\u{2F9AF}"=>"䕡", "\u{2F9B0}"=>"\u{26FB1}", "\u{2F9B1}"=>"\u{270D2}", "\u{2F9B2}"=>"䕫", "\u{2F9B3}"=>"虐", "\u{2F9B4}"=>"虜", "\u{2F9B5}"=>"虧", "\u{2F9B6}"=>"虩", "\u{2F9B7}"=>"蚩", "\u{2F9B8}"=>"蚈", 
    "\u{2F9B9}"=>"蜎", "\u{2F9BA}"=>"蛢", "\u{2F9BB}"=>"蝹", "\u{2F9BC}"=>"蜨", "\u{2F9BD}"=>"蝫", "\u{2F9BE}"=>"螆", "\u{2F9BF}"=>"䗗", "\u{2F9C0}"=>"蟡", "\u{2F9C1}"=>"蠁", "\u{2F9C2}"=>"䗹", "\u{2F9C3}"=>"衠", "\u{2F9C4}"=>"衣", "\u{2F9C5}"=>"\u{27667}", "\u{2F9C6}"=>"裗", "\u{2F9C7}"=>"裞", "\u{2F9C8}"=>"䘵", 
    "\u{2F9C9}"=>"裺", "\u{2F9CA}"=>"㒻", "\u{2F9CB}"=>"\u{278AE}", "\u{2F9CC}"=>"\u{27966}", "\u{2F9CD}"=>"䚾", "\u{2F9CE}"=>"䛇", "\u{2F9CF}"=>"誠", "\u{2F9D0}"=>"諭", "\u{2F9D1}"=>"變", "\u{2F9D2}"=>"豕", "\u{2F9D3}"=>"\u{27CA8}", "\u{2F9D4}"=>"貫", "\u{2F9D5}"=>"賁", "\u{2F9D6}"=>"贛", "\u{2F9D7}"=>"起", "\u{2F9D8}"=>"\u{27F2F}", 
    "\u{2F9D9}"=>"\u{20804}", "\u{2F9DA}"=>"跋", "\u{2F9DB}"=>"趼", "\u{2F9DC}"=>"跰", "\u{2F9DD}"=>"\u{208DE}", "\u{2F9DE}"=>"軔", "\u{2F9DF}"=>"輸", "\u{2F9E0}"=>"\u{285D2}", "\u{2F9E1}"=>"\u{285ED}", "\u{2F9E2}"=>"邔", "\u{2F9E3}"=>"郱", "\u{2F9E4}"=>"鄑", "\u{2F9E5}"=>"\u{2872E}", "\u{2F9E6}"=>"鄛", "\u{2F9E7}"=>"鈸", "\u{2F9E8}"=>"鋗", 
    "\u{2F9E9}"=>"鋘", "\u{2F9EA}"=>"鉼", "\u{2F9EB}"=>"鏹", "\u{2F9EC}"=>"鐕", "\u{2F9ED}"=>"\u{28BFA}", "\u{2F9EE}"=>"開", "\u{2F9EF}"=>"䦕", "\u{2F9F0}"=>"閷", "\u{2F9F1}"=>"\u{28D77}", "\u{2F9F2}"=>"䧦", "\u{2F9F3}"=>"雃", "\u{2F9F4}"=>"嶲", "\u{2F9F5}"=>"霣", "\u{2F9F6}"=>"\u{29145}", "\u{2F9F7}"=>"\u{2921A}", "\u{2F9F8}"=>"䩮", 
    "\u{2F9F9}"=>"䩶", "\u{2F9FA}"=>"韠", "\u{2F9FB}"=>"\u{2940A}", "\u{2F9FC}"=>"䪲", "\u{2F9FD}"=>"\u{29496}", "\u{2F9FE}"=>"頋", "\u{2F9FF}"=>"頋", "\u{2FA00}"=>"頩", "\u{2FA01}"=>"\u{295B6}", "\u{2FA02}"=>"飢", "\u{2FA03}"=>"䬳", "\u{2FA04}"=>"餩", "\u{2FA05}"=>"馧", "\u{2FA06}"=>"駂", "\u{2FA07}"=>"駾", "\u{2FA08}"=>"䯎", 
    "\u{2FA09}"=>"\u{29B30}", "\u{2FA0A}"=>"鬒", "\u{2FA0B}"=>"鱀", "\u{2FA0C}"=>"鳽", "\u{2FA0D}"=>"䳎", "\u{2FA0E}"=>"䳭", "\u{2FA0F}"=>"鵧", "\u{2FA10}"=>"\u{2A0CE}", "\u{2FA11}"=>"䳸", "\u{2FA12}"=>"\u{2A105}", "\u{2FA13}"=>"\u{2A20E}", "\u{2FA14}"=>"\u{2A291}", "\u{2FA15}"=>"麻", "\u{2FA16}"=>"䵖", "\u{2FA17}"=>"黹", "\u{2FA18}"=>"黾", 
    "\u{2FA19}"=>"鼅", "\u{2FA1A}"=>"鼏", "\u{2FA1B}"=>"鼖", "\u{2FA1C}"=>"鼻", "\u{2FA1D}"=>"\u{2A600}", 
  }

  KOMPATIBLE_TABLE = {
    " "=>" ", "¨"=>" \u0308", "ª"=>"a", "¯"=>" \u0304", "²"=>"2", "³"=>"3", "´"=>" \u0301", "µ"=>"μ", "¸"=>" \u0327", "¹"=>"1", "º"=>"o", "¼"=>"1⁄4", "½"=>"1⁄2", "¾"=>"3⁄4", "Ĳ"=>"IJ", "ĳ"=>"ij", 
    "Ŀ"=>"L·", "ŀ"=>"l·", "ŉ"=>"ʼn", "ſ"=>"s", "Ǆ"=>"DŽ", "ǅ"=>"Dž", "ǆ"=>"dž", "Ǉ"=>"LJ", "ǈ"=>"Lj", "ǉ"=>"lj", "Ǌ"=>"NJ", "ǋ"=>"Nj", "ǌ"=>"nj", "Ǳ"=>"DZ", "ǲ"=>"Dz", "ǳ"=>"dz", 
    "ʰ"=>"h", "ʱ"=>"ɦ", "ʲ"=>"j", "ʳ"=>"r", "ʴ"=>"ɹ", "ʵ"=>"ɻ", "ʶ"=>"ʁ", "ʷ"=>"w", "ʸ"=>"y", "˘"=>" \u0306", "˙"=>" \u0307", "˚"=>" \u030A", "˛"=>" \u0328", "˜"=>" \u0303", "˝"=>" \u030B", "ˠ"=>"ɣ", 
    "ˡ"=>"l", "ˢ"=>"s", "ˣ"=>"x", "ˤ"=>"ʕ", "ͺ"=>" \u0345", "΄"=>" \u0301", "ϐ"=>"β", "ϑ"=>"θ", "ϒ"=>"Υ", "ϕ"=>"φ", "ϖ"=>"π", "ϰ"=>"κ", "ϱ"=>"ρ", "ϲ"=>"ς", "ϴ"=>"Θ", "ϵ"=>"ε", 
    "Ϲ"=>"Σ", "և"=>"եւ", "ٵ"=>"اٴ", "ٶ"=>"وٴ", "ٷ"=>"ۇٴ", "ٸ"=>"يٴ", "ำ"=>"ํา", "ຳ"=>"ໍາ", "ໜ"=>"ຫນ", "ໝ"=>"ຫມ", "༌"=>"་", "ཷ"=>"ྲཱྀ", "ཹ"=>"ླཱྀ", "ჼ"=>"ნ", "ᴬ"=>"A", "ᴭ"=>"Æ", 
    "ᴮ"=>"B", "ᴰ"=>"D", "ᴱ"=>"E", "ᴲ"=>"Ǝ", "ᴳ"=>"G", "ᴴ"=>"H", "ᴵ"=>"I", "ᴶ"=>"J", "ᴷ"=>"K", "ᴸ"=>"L", "ᴹ"=>"M", "ᴺ"=>"N", "ᴼ"=>"O", "ᴽ"=>"Ȣ", "ᴾ"=>"P", "ᴿ"=>"R", 
    "ᵀ"=>"T", "ᵁ"=>"U", "ᵂ"=>"W", "ᵃ"=>"a", "ᵄ"=>"ɐ", "ᵅ"=>"ɑ", "ᵆ"=>"ᴂ", "ᵇ"=>"b", "ᵈ"=>"d", "ᵉ"=>"e", "ᵊ"=>"ə", "ᵋ"=>"ɛ", "ᵌ"=>"ɜ", "ᵍ"=>"g", "ᵏ"=>"k", "ᵐ"=>"m", 
    "ᵑ"=>"ŋ", "ᵒ"=>"o", "ᵓ"=>"ɔ", "ᵔ"=>"ᴖ", "ᵕ"=>"ᴗ", "ᵖ"=>"p", "ᵗ"=>"t", "ᵘ"=>"u", "ᵙ"=>"ᴝ", "ᵚ"=>"ɯ", "ᵛ"=>"v", "ᵜ"=>"ᴥ", "ᵝ"=>"β", "ᵞ"=>"γ", "ᵟ"=>"δ", "ᵠ"=>"φ", 
    "ᵡ"=>"χ", "ᵢ"=>"i", "ᵣ"=>"r", "ᵤ"=>"u", "ᵥ"=>"v", "ᵦ"=>"β", "ᵧ"=>"γ", "ᵨ"=>"ρ", "ᵩ"=>"φ", "ᵪ"=>"χ", "ᵸ"=>"н", "ᶛ"=>"ɒ", "ᶜ"=>"c", "ᶝ"=>"ɕ", "ᶞ"=>"ð", "ᶟ"=>"ɜ", 
    "ᶠ"=>"f", "ᶡ"=>"ɟ", "ᶢ"=>"ɡ", "ᶣ"=>"ɥ", "ᶤ"=>"ɨ", "ᶥ"=>"ɩ", "ᶦ"=>"ɪ", "ᶧ"=>"ᵻ", "ᶨ"=>"ʝ", "ᶩ"=>"ɭ", "ᶪ"=>"ᶅ", "ᶫ"=>"ʟ", "ᶬ"=>"ɱ", "ᶭ"=>"ɰ", "ᶮ"=>"ɲ", "ᶯ"=>"ɳ", 
    "ᶰ"=>"ɴ", "ᶱ"=>"ɵ", "ᶲ"=>"ɸ", "ᶳ"=>"ʂ", "ᶴ"=>"ʃ", "ᶵ"=>"ƫ", "ᶶ"=>"ʉ", "ᶷ"=>"ʊ", "ᶸ"=>"ᴜ", "ᶹ"=>"ʋ", "ᶺ"=>"ʌ", "ᶻ"=>"z", "ᶼ"=>"ʐ", "ᶽ"=>"ʑ", "ᶾ"=>"ʒ", "ᶿ"=>"θ", 
    "ẚ"=>"aʾ", "᾽"=>" \u0313", "᾿"=>" \u0313", "῀"=>" \u0342", "῾"=>" \u0314", " "=>" ", " "=>" ", " "=>" ", " "=>" ", " "=>" ", " "=>" ", " "=>" ", " "=>" ", " "=>" ", "‑"=>"‐", "‗"=>" \u0333", 
    "․"=>".", "‥"=>"..", "…"=>"...", " "=>" ", "″"=>"′′", "‴"=>"′′′", "‶"=>"‵‵", "‷"=>"‵‵‵", "‼"=>"!!", "‾"=>" \u0305", "⁇"=>"??", "⁈"=>"?!", "⁉"=>"!?", "⁗"=>"′′′′", " "=>" ", "⁰"=>"0", 
    "ⁱ"=>"i", "⁴"=>"4", "⁵"=>"5", "⁶"=>"6", "⁷"=>"7", "⁸"=>"8", "⁹"=>"9", "⁺"=>"+", "⁻"=>"−", "⁼"=>"=", "⁽"=>"(", "⁾"=>")", "ⁿ"=>"n", "₀"=>"0", "₁"=>"1", "₂"=>"2", 
    "₃"=>"3", "₄"=>"4", "₅"=>"5", "₆"=>"6", "₇"=>"7", "₈"=>"8", "₉"=>"9", "₊"=>"+", "₋"=>"−", "₌"=>"=", "₍"=>"(", "₎"=>")", "ₐ"=>"a", "ₑ"=>"e", "ₒ"=>"o", "ₓ"=>"x", 
    "ₔ"=>"ə", "ₕ"=>"h", "ₖ"=>"k", "ₗ"=>"l", "ₘ"=>"m", "ₙ"=>"n", "ₚ"=>"p", "ₛ"=>"s", "ₜ"=>"t", "₨"=>"Rs", "℀"=>"a/c", "℁"=>"a/s", "ℂ"=>"C", "℃"=>"°C", "℅"=>"c/o", "℆"=>"c/u", 
    "ℇ"=>"Ɛ", "℉"=>"°F", "ℊ"=>"g", "ℋ"=>"H", "ℌ"=>"H", "ℍ"=>"H", "ℎ"=>"h", "ℏ"=>"ħ", "ℐ"=>"I", "ℑ"=>"I", "ℒ"=>"L", "ℓ"=>"l", "ℕ"=>"N", "№"=>"No", "ℙ"=>"P", "ℚ"=>"Q", 
    "ℛ"=>"R", "ℜ"=>"R", "ℝ"=>"R", "℠"=>"SM", "℡"=>"TEL", "™"=>"TM", "ℤ"=>"Z", "ℨ"=>"Z", "ℬ"=>"B", "ℭ"=>"C", "ℯ"=>"e", "ℰ"=>"E", "ℱ"=>"F", "ℳ"=>"M", "ℴ"=>"o", "ℵ"=>"א", 
    "ℶ"=>"ב", "ℷ"=>"ג", "ℸ"=>"ד", "ℹ"=>"i", "℻"=>"FAX", "ℼ"=>"π", "ℽ"=>"γ", "ℾ"=>"Γ", "ℿ"=>"Π", "⅀"=>"∑", "ⅅ"=>"D", "ⅆ"=>"d", "ⅇ"=>"e", "ⅈ"=>"i", "ⅉ"=>"j", "⅐"=>"1⁄7", 
    "⅑"=>"1⁄9", "⅒"=>"1⁄10", "⅓"=>"1⁄3", "⅔"=>"2⁄3", "⅕"=>"1⁄5", "⅖"=>"2⁄5", "⅗"=>"3⁄5", "⅘"=>"4⁄5", "⅙"=>"1⁄6", "⅚"=>"5⁄6", "⅛"=>"1⁄8", "⅜"=>"3⁄8", "⅝"=>"5⁄8", "⅞"=>"7⁄8", "⅟"=>"1⁄", "Ⅰ"=>"I", 
    "Ⅱ"=>"II", "Ⅲ"=>"III", "Ⅳ"=>"IV", "Ⅴ"=>"V", "Ⅵ"=>"VI", "Ⅶ"=>"VII", "Ⅷ"=>"VIII", "Ⅸ"=>"IX", "Ⅹ"=>"X", "Ⅺ"=>"XI", "Ⅻ"=>"XII", "Ⅼ"=>"L", "Ⅽ"=>"C", "Ⅾ"=>"D", "Ⅿ"=>"M", "ⅰ"=>"i", 
    "ⅱ"=>"ii", "ⅲ"=>"iii", "ⅳ"=>"iv", "ⅴ"=>"v", "ⅵ"=>"vi", "ⅶ"=>"vii", "ⅷ"=>"viii", "ⅸ"=>"ix", "ⅹ"=>"x", "ⅺ"=>"xi", "ⅻ"=>"xii", "ⅼ"=>"l", "ⅽ"=>"c", "ⅾ"=>"d", "ⅿ"=>"m", "↉"=>"0⁄3", 
    "∬"=>"∫∫", "∭"=>"∫∫∫", "∯"=>"∮∮", "∰"=>"∮∮∮", "①"=>"1", "②"=>"2", "③"=>"3", "④"=>"4", "⑤"=>"5", "⑥"=>"6", "⑦"=>"7", "⑧"=>"8", "⑨"=>"9", "⑩"=>"10", "⑪"=>"11", "⑫"=>"12", 
    "⑬"=>"13", "⑭"=>"14", "⑮"=>"15", "⑯"=>"16", "⑰"=>"17", "⑱"=>"18", "⑲"=>"19", "⑳"=>"20", "⑴"=>"(1)", "⑵"=>"(2)", "⑶"=>"(3)", "⑷"=>"(4)", "⑸"=>"(5)", "⑹"=>"(6)", "⑺"=>"(7)", "⑻"=>"(8)", 
    "⑼"=>"(9)", "⑽"=>"(10)", "⑾"=>"(11)", "⑿"=>"(12)", "⒀"=>"(13)", "⒁"=>"(14)", "⒂"=>"(15)", "⒃"=>"(16)", "⒄"=>"(17)", "⒅"=>"(18)", "⒆"=>"(19)", "⒇"=>"(20)", "⒈"=>"1.", "⒉"=>"2.", "⒊"=>"3.", "⒋"=>"4.", 
    "⒌"=>"5.", "⒍"=>"6.", "⒎"=>"7.", "⒏"=>"8.", "⒐"=>"9.", "⒑"=>"10.", "⒒"=>"11.", "⒓"=>"12.", "⒔"=>"13.", "⒕"=>"14.", "⒖"=>"15.", "⒗"=>"16.", "⒘"=>"17.", "⒙"=>"18.", "⒚"=>"19.", "⒛"=>"20.", 
    "⒜"=>"(a)", "⒝"=>"(b)", "⒞"=>"(c)", "⒟"=>"(d)", "⒠"=>"(e)", "⒡"=>"(f)", "⒢"=>"(g)", "⒣"=>"(h)", "⒤"=>"(i)", "⒥"=>"(j)", "⒦"=>"(k)", "⒧"=>"(l)", "⒨"=>"(m)", "⒩"=>"(n)", "⒪"=>"(o)", "⒫"=>"(p)", 
    "⒬"=>"(q)", "⒭"=>"(r)", "⒮"=>"(s)", "⒯"=>"(t)", "⒰"=>"(u)", "⒱"=>"(v)", "⒲"=>"(w)", "⒳"=>"(x)", "⒴"=>"(y)", "⒵"=>"(z)", "Ⓐ"=>"A", "Ⓑ"=>"B", "Ⓒ"=>"C", "Ⓓ"=>"D", "Ⓔ"=>"E", "Ⓕ"=>"F", 
    "Ⓖ"=>"G", "Ⓗ"=>"H", "Ⓘ"=>"I", "Ⓙ"=>"J", "Ⓚ"=>"K", "Ⓛ"=>"L", "Ⓜ"=>"M", "Ⓝ"=>"N", "Ⓞ"=>"O", "Ⓟ"=>"P", "Ⓠ"=>"Q", "Ⓡ"=>"R", "Ⓢ"=>"S", "Ⓣ"=>"T", "Ⓤ"=>"U", "Ⓥ"=>"V", 
    "Ⓦ"=>"W", "Ⓧ"=>"X", "Ⓨ"=>"Y", "Ⓩ"=>"Z", "ⓐ"=>"a", "ⓑ"=>"b", "ⓒ"=>"c", "ⓓ"=>"d", "ⓔ"=>"e", "ⓕ"=>"f", "ⓖ"=>"g", "ⓗ"=>"h", "ⓘ"=>"i", "ⓙ"=>"j", "ⓚ"=>"k", "ⓛ"=>"l", 
    "ⓜ"=>"m", "ⓝ"=>"n", "ⓞ"=>"o", "ⓟ"=>"p", "ⓠ"=>"q", "ⓡ"=>"r", "ⓢ"=>"s", "ⓣ"=>"t", "ⓤ"=>"u", "ⓥ"=>"v", "ⓦ"=>"w", "ⓧ"=>"x", "ⓨ"=>"y", "ⓩ"=>"z", "⓪"=>"0", "⨌"=>"∫∫∫∫", 
    "⩴"=>"::=", "⩵"=>"==", "⩶"=>"===", "ⱼ"=>"j", "ⱽ"=>"V", "ⵯ"=>"ⵡ", "⺟"=>"母", "⻳"=>"龟", "⼀"=>"一", "⼁"=>"丨", "⼂"=>"丶", "⼃"=>"丿", "⼄"=>"乙", "⼅"=>"亅", "⼆"=>"二", "⼇"=>"亠", 
    "⼈"=>"人", "⼉"=>"儿", "⼊"=>"入", "⼋"=>"八", "⼌"=>"冂", "⼍"=>"冖", "⼎"=>"冫", "⼏"=>"几", "⼐"=>"凵", "⼑"=>"刀", "⼒"=>"力", "⼓"=>"勹", "⼔"=>"匕", "⼕"=>"匚", "⼖"=>"匸", "⼗"=>"十", 
    "⼘"=>"卜", "⼙"=>"卩", "⼚"=>"厂", "⼛"=>"厶", "⼜"=>"又", "⼝"=>"口", "⼞"=>"囗", "⼟"=>"土", "⼠"=>"士", "⼡"=>"夂", "⼢"=>"夊", "⼣"=>"夕", "⼤"=>"大", "⼥"=>"女", "⼦"=>"子", "⼧"=>"宀", 
    "⼨"=>"寸", "⼩"=>"小", "⼪"=>"尢", "⼫"=>"尸", "⼬"=>"屮", "⼭"=>"山", "⼮"=>"巛", "⼯"=>"工", "⼰"=>"己", "⼱"=>"巾", "⼲"=>"干", "⼳"=>"幺", "⼴"=>"广", "⼵"=>"廴", "⼶"=>"廾", "⼷"=>"弋", 
    "⼸"=>"弓", "⼹"=>"彐", "⼺"=>"彡", "⼻"=>"彳", "⼼"=>"心", "⼽"=>"戈", "⼾"=>"戶", "⼿"=>"手", "⽀"=>"支", "⽁"=>"攴", "⽂"=>"文", "⽃"=>"斗", "⽄"=>"斤", "⽅"=>"方", "⽆"=>"无", "⽇"=>"日", 
    "⽈"=>"曰", "⽉"=>"月", "⽊"=>"木", "⽋"=>"欠", "⽌"=>"止", "⽍"=>"歹", "⽎"=>"殳", "⽏"=>"毋", "⽐"=>"比", "⽑"=>"毛", "⽒"=>"氏", "⽓"=>"气", "⽔"=>"水", "⽕"=>"火", "⽖"=>"爪", "⽗"=>"父", 
    "⽘"=>"爻", "⽙"=>"爿", "⽚"=>"片", "⽛"=>"牙", "⽜"=>"牛", "⽝"=>"犬", "⽞"=>"玄", "⽟"=>"玉", "⽠"=>"瓜", "⽡"=>"瓦", "⽢"=>"甘", "⽣"=>"生", "⽤"=>"用", "⽥"=>"田", "⽦"=>"疋", "⽧"=>"疒", 
    "⽨"=>"癶", "⽩"=>"白", "⽪"=>"皮", "⽫"=>"皿", "⽬"=>"目", "⽭"=>"矛", "⽮"=>"矢", "⽯"=>"石", "⽰"=>"示", "⽱"=>"禸", "⽲"=>"禾", "⽳"=>"穴", "⽴"=>"立", "⽵"=>"竹", "⽶"=>"米", "⽷"=>"糸", 
    "⽸"=>"缶", "⽹"=>"网", "⽺"=>"羊", "⽻"=>"羽", "⽼"=>"老", "⽽"=>"而", "⽾"=>"耒", "⽿"=>"耳", "⾀"=>"聿", "⾁"=>"肉", "⾂"=>"臣", "⾃"=>"自", "⾄"=>"至", "⾅"=>"臼", "⾆"=>"舌", "⾇"=>"舛", 
    "⾈"=>"舟", "⾉"=>"艮", "⾊"=>"色", "⾋"=>"艸", "⾌"=>"虍", "⾍"=>"虫", "⾎"=>"血", "⾏"=>"行", "⾐"=>"衣", "⾑"=>"襾", "⾒"=>"見", "⾓"=>"角", "⾔"=>"言", "⾕"=>"谷", "⾖"=>"豆", "⾗"=>"豕", 
    "⾘"=>"豸", "⾙"=>"貝", "⾚"=>"赤", "⾛"=>"走", "⾜"=>"足", "⾝"=>"身", "⾞"=>"車", "⾟"=>"辛", "⾠"=>"辰", "⾡"=>"辵", "⾢"=>"邑", "⾣"=>"酉", "⾤"=>"釆", "⾥"=>"里", "⾦"=>"金", "⾧"=>"長", 
    "⾨"=>"門", "⾩"=>"阜", "⾪"=>"隶", "⾫"=>"隹", "⾬"=>"雨", "⾭"=>"靑", "⾮"=>"非", "⾯"=>"面", "⾰"=>"革", "⾱"=>"韋", "⾲"=>"韭", "⾳"=>"音", "⾴"=>"頁", "⾵"=>"風", "⾶"=>"飛", "⾷"=>"食", 
    "⾸"=>"首", "⾹"=>"香", "⾺"=>"馬", "⾻"=>"骨", "⾼"=>"高", "⾽"=>"髟", "⾾"=>"鬥", "⾿"=>"鬯", "⿀"=>"鬲", "⿁"=>"鬼", "⿂"=>"魚", "⿃"=>"鳥", "⿄"=>"鹵", "⿅"=>"鹿", "⿆"=>"麥", "⿇"=>"麻", 
    "⿈"=>"黃", "⿉"=>"黍", "⿊"=>"黑", "⿋"=>"黹", "⿌"=>"黽", "⿍"=>"鼎", "⿎"=>"鼓", "⿏"=>"鼠", "⿐"=>"鼻", "⿑"=>"齊", "⿒"=>"齒", "⿓"=>"龍", "⿔"=>"龜", "⿕"=>"龠", "　"=>" ", "〶"=>"〒", 
    "〸"=>"十", "〹"=>"卄", "〺"=>"卅", "゛"=>" \u3099", "゜"=>" \u309A", "ゟ"=>"より", "ヿ"=>"コト", "ㄱ"=>"ᄀ", "ㄲ"=>"ᄁ", "ㄳ"=>"ᆪ", "ㄴ"=>"ᄂ", "ㄵ"=>"ᆬ", "ㄶ"=>"ᆭ", "ㄷ"=>"ᄃ", "ㄸ"=>"ᄄ", "ㄹ"=>"ᄅ", 
    "ㄺ"=>"ᆰ", "ㄻ"=>"ᆱ", "ㄼ"=>"ᆲ", "ㄽ"=>"ᆳ", "ㄾ"=>"ᆴ", "ㄿ"=>"ᆵ", "ㅀ"=>"ᄚ", "ㅁ"=>"ᄆ", "ㅂ"=>"ᄇ", "ㅃ"=>"ᄈ", "ㅄ"=>"ᄡ", "ㅅ"=>"ᄉ", "ㅆ"=>"ᄊ", "ㅇ"=>"ᄋ", "ㅈ"=>"ᄌ", "ㅉ"=>"ᄍ", 
    "ㅊ"=>"ᄎ", "ㅋ"=>"ᄏ", "ㅌ"=>"ᄐ", "ㅍ"=>"ᄑ", "ㅎ"=>"ᄒ", "ㅏ"=>"ᅡ", "ㅐ"=>"ᅢ", "ㅑ"=>"ᅣ", "ㅒ"=>"ᅤ", "ㅓ"=>"ᅥ", "ㅔ"=>"ᅦ", "ㅕ"=>"ᅧ", "ㅖ"=>"ᅨ", "ㅗ"=>"ᅩ", "ㅘ"=>"ᅪ", "ㅙ"=>"ᅫ", 
    "ㅚ"=>"ᅬ", "ㅛ"=>"ᅭ", "ㅜ"=>"ᅮ", "ㅝ"=>"ᅯ", "ㅞ"=>"ᅰ", "ㅟ"=>"ᅱ", "ㅠ"=>"ᅲ", "ㅡ"=>"ᅳ", "ㅢ"=>"ᅴ", "ㅣ"=>"ᅵ", "ㅤ"=>"ᅠ", "ㅥ"=>"ᄔ", "ㅦ"=>"ᄕ", "ㅧ"=>"ᇇ", "ㅨ"=>"ᇈ", "ㅩ"=>"ᇌ", 
    "ㅪ"=>"ᇎ", "ㅫ"=>"ᇓ", "ㅬ"=>"ᇗ", "ㅭ"=>"ᇙ", "ㅮ"=>"ᄜ", "ㅯ"=>"ᇝ", "ㅰ"=>"ᇟ", "ㅱ"=>"ᄝ", "ㅲ"=>"ᄞ", "ㅳ"=>"ᄠ", "ㅴ"=>"ᄢ", "ㅵ"=>"ᄣ", "ㅶ"=>"ᄧ", "ㅷ"=>"ᄩ", "ㅸ"=>"ᄫ", "ㅹ"=>"ᄬ", 
    "ㅺ"=>"ᄭ", "ㅻ"=>"ᄮ", "ㅼ"=>"ᄯ", "ㅽ"=>"ᄲ", "ㅾ"=>"ᄶ", "ㅿ"=>"ᅀ", "ㆀ"=>"ᅇ", "ㆁ"=>"ᅌ", "ㆂ"=>"ᇱ", "ㆃ"=>"ᇲ", "ㆄ"=>"ᅗ", "ㆅ"=>"ᅘ", "ㆆ"=>"ᅙ", "ㆇ"=>"ᆄ", "ㆈ"=>"ᆅ", "ㆉ"=>"ᆈ", 
    "ㆊ"=>"ᆑ", "ㆋ"=>"ᆒ", "ㆌ"=>"ᆔ", "ㆍ"=>"ᆞ", "ㆎ"=>"ᆡ", "㆒"=>"一", "㆓"=>"二", "㆔"=>"三", "㆕"=>"四", "㆖"=>"上", "㆗"=>"中", "㆘"=>"下", "㆙"=>"甲", "㆚"=>"乙", "㆛"=>"丙", "㆜"=>"丁", 
    "㆝"=>"天", "㆞"=>"地", "㆟"=>"人", "㈀"=>"(ᄀ)", "㈁"=>"(ᄂ)", "㈂"=>"(ᄃ)", "㈃"=>"(ᄅ)", "㈄"=>"(ᄆ)", "㈅"=>"(ᄇ)", "㈆"=>"(ᄉ)", "㈇"=>"(ᄋ)", "㈈"=>"(ᄌ)", "㈉"=>"(ᄎ)", "㈊"=>"(ᄏ)", "㈋"=>"(ᄐ)", "㈌"=>"(ᄑ)", 
    "㈍"=>"(ᄒ)", "㈎"=>"(가)", "㈏"=>"(나)", "㈐"=>"(다)", "㈑"=>"(라)", "㈒"=>"(마)", "㈓"=>"(바)", "㈔"=>"(사)", "㈕"=>"(아)", "㈖"=>"(자)", "㈗"=>"(차)", "㈘"=>"(카)", "㈙"=>"(타)", "㈚"=>"(파)", "㈛"=>"(하)", "㈜"=>"(주)", 
    "㈝"=>"(오전)", "㈞"=>"(오후)", "㈠"=>"(一)", "㈡"=>"(二)", "㈢"=>"(三)", "㈣"=>"(四)", "㈤"=>"(五)", "㈥"=>"(六)", "㈦"=>"(七)", "㈧"=>"(八)", "㈨"=>"(九)", "㈩"=>"(十)", "㈪"=>"(月)", "㈫"=>"(火)", "㈬"=>"(水)", "㈭"=>"(木)", 
    "㈮"=>"(金)", "㈯"=>"(土)", "㈰"=>"(日)", "㈱"=>"(株)", "㈲"=>"(有)", "㈳"=>"(社)", "㈴"=>"(名)", "㈵"=>"(特)", "㈶"=>"(財)", "㈷"=>"(祝)", "㈸"=>"(労)", "㈹"=>"(代)", "㈺"=>"(呼)", "㈻"=>"(学)", "㈼"=>"(監)", "㈽"=>"(企)", 
    "㈾"=>"(資)", "㈿"=>"(協)", "㉀"=>"(祭)", "㉁"=>"(休)", "㉂"=>"(自)", "㉃"=>"(至)", "㉄"=>"問", "㉅"=>"幼", "㉆"=>"文", "㉇"=>"箏", "㉐"=>"PTE", "㉑"=>"21", "㉒"=>"22", "㉓"=>"23", "㉔"=>"24", "㉕"=>"25", 
    "㉖"=>"26", "㉗"=>"27", "㉘"=>"28", "㉙"=>"29", "㉚"=>"30", "㉛"=>"31", "㉜"=>"32", "㉝"=>"33", "㉞"=>"34", "㉟"=>"35", "㉠"=>"ᄀ", "㉡"=>"ᄂ", "㉢"=>"ᄃ", "㉣"=>"ᄅ", "㉤"=>"ᄆ", "㉥"=>"ᄇ", 
    "㉦"=>"ᄉ", "㉧"=>"ᄋ", "㉨"=>"ᄌ", "㉩"=>"ᄎ", "㉪"=>"ᄏ", "㉫"=>"ᄐ", "㉬"=>"ᄑ", "㉭"=>"ᄒ", "㉮"=>"가", "㉯"=>"나", "㉰"=>"다", "㉱"=>"라", "㉲"=>"마", "㉳"=>"바", "㉴"=>"사", "㉵"=>"아", 
    "㉶"=>"자", "㉷"=>"차", "㉸"=>"카", "㉹"=>"타", "㉺"=>"파", "㉻"=>"하", "㉼"=>"참고", "㉽"=>"주의", "㉾"=>"우", "㊀"=>"一", "㊁"=>"二", "㊂"=>"三", "㊃"=>"四", "㊄"=>"五", "㊅"=>"六", "㊆"=>"七", 
    "㊇"=>"八", "㊈"=>"九", "㊉"=>"十", "㊊"=>"月", "㊋"=>"火", "㊌"=>"水", "㊍"=>"木", "㊎"=>"金", "㊏"=>"土", "㊐"=>"日", "㊑"=>"株", "㊒"=>"有", "㊓"=>"社", "㊔"=>"名", "㊕"=>"特", "㊖"=>"財", 
    "㊗"=>"祝", "㊘"=>"労", "㊙"=>"秘", "㊚"=>"男", "㊛"=>"女", "㊜"=>"適", "㊝"=>"優", "㊞"=>"印", "㊟"=>"注", "㊠"=>"項", "㊡"=>"休", "㊢"=>"写", "㊣"=>"正", "㊤"=>"上", "㊥"=>"中", "㊦"=>"下", 
    "㊧"=>"左", "㊨"=>"右", "㊩"=>"医", "㊪"=>"宗", "㊫"=>"学", "㊬"=>"監", "㊭"=>"企", "㊮"=>"資", "㊯"=>"協", "㊰"=>"夜", "㊱"=>"36", "㊲"=>"37", "㊳"=>"38", "㊴"=>"39", "㊵"=>"40", "㊶"=>"41", 
    "㊷"=>"42", "㊸"=>"43", "㊹"=>"44", "㊺"=>"45", "㊻"=>"46", "㊼"=>"47", "㊽"=>"48", "㊾"=>"49", "㊿"=>"50", "㋀"=>"1月", "㋁"=>"2月", "㋂"=>"3月", "㋃"=>"4月", "㋄"=>"5月", "㋅"=>"6月", "㋆"=>"7月", 
    "㋇"=>"8月", "㋈"=>"9月", "㋉"=>"10月", "㋊"=>"11月", "㋋"=>"12月", "㋌"=>"Hg", "㋍"=>"erg", "㋎"=>"eV", "㋏"=>"LTD", "㋐"=>"ア", "㋑"=>"イ", "㋒"=>"ウ", "㋓"=>"エ", "㋔"=>"オ", "㋕"=>"カ", "㋖"=>"キ", 
    "㋗"=>"ク", "㋘"=>"ケ", "㋙"=>"コ", "㋚"=>"サ", "㋛"=>"シ", "㋜"=>"ス", "㋝"=>"セ", "㋞"=>"ソ", "㋟"=>"タ", "㋠"=>"チ", "㋡"=>"ツ", "㋢"=>"テ", "㋣"=>"ト", "㋤"=>"ナ", "㋥"=>"ニ", "㋦"=>"ヌ", 
    "㋧"=>"ネ", "㋨"=>"ノ", "㋩"=>"ハ", "㋪"=>"ヒ", "㋫"=>"フ", "㋬"=>"ヘ", "㋭"=>"ホ", "㋮"=>"マ", "㋯"=>"ミ", "㋰"=>"ム", "㋱"=>"メ", "㋲"=>"モ", "㋳"=>"ヤ", "㋴"=>"ユ", "㋵"=>"ヨ", "㋶"=>"ラ", 
    "㋷"=>"リ", "㋸"=>"ル", "㋹"=>"レ", "㋺"=>"ロ", "㋻"=>"ワ", "㋼"=>"ヰ", "㋽"=>"ヱ", "㋾"=>"ヲ", "㌀"=>"アパート", "㌁"=>"アルファ", "㌂"=>"アンペア", "㌃"=>"アール", "㌄"=>"イニング", "㌅"=>"インチ", "㌆"=>"ウォン", "㌇"=>"エスクード", 
    "㌈"=>"エーカー", "㌉"=>"オンス", "㌊"=>"オーム", "㌋"=>"カイリ", "㌌"=>"カラット", "㌍"=>"カロリー", "㌎"=>"ガロン", "㌏"=>"ガンマ", "㌐"=>"ギガ", "㌑"=>"ギニー", "㌒"=>"キュリー", "㌓"=>"ギルダー", "㌔"=>"キロ", "㌕"=>"キログラム", "㌖"=>"キロメートル", "㌗"=>"キロワット", 
    "㌘"=>"グラム", "㌙"=>"グラムトン", "㌚"=>"クルゼイロ", "㌛"=>"クローネ", "㌜"=>"ケース", "㌝"=>"コルナ", "㌞"=>"コーポ", "㌟"=>"サイクル", "㌠"=>"サンチーム", "㌡"=>"シリング", "㌢"=>"センチ", "㌣"=>"セント", "㌤"=>"ダース", "㌥"=>"デシ", "㌦"=>"ドル", "㌧"=>"トン", 
    "㌨"=>"ナノ", "㌩"=>"ノット", "㌪"=>"ハイツ", "㌫"=>"パーセント", "㌬"=>"パーツ", "㌭"=>"バーレル", "㌮"=>"ピアストル", "㌯"=>"ピクル", "㌰"=>"ピコ", "㌱"=>"ビル", "㌲"=>"ファラッド", "㌳"=>"フィート", "㌴"=>"ブッシェル", "㌵"=>"フラン", "㌶"=>"ヘクタール", "㌷"=>"ペソ", 
    "㌸"=>"ペニヒ", "㌹"=>"ヘルツ", "㌺"=>"ペンス", "㌻"=>"ページ", "㌼"=>"ベータ", "㌽"=>"ポイント", "㌾"=>"ボルト", "㌿"=>"ホン", "㍀"=>"ポンド", "㍁"=>"ホール", "㍂"=>"ホーン", "㍃"=>"マイクロ", "㍄"=>"マイル", "㍅"=>"マッハ", "㍆"=>"マルク", "㍇"=>"マンション", 
    "㍈"=>"ミクロン", "㍉"=>"ミリ", "㍊"=>"ミリバール", "㍋"=>"メガ", "㍌"=>"メガトン", "㍍"=>"メートル", "㍎"=>"ヤード", "㍏"=>"ヤール", "㍐"=>"ユアン", "㍑"=>"リットル", "㍒"=>"リラ", "㍓"=>"ルピー", "㍔"=>"ルーブル", "㍕"=>"レム", "㍖"=>"レントゲン", "㍗"=>"ワット", 
    "㍘"=>"0点", "㍙"=>"1点", "㍚"=>"2点", "㍛"=>"3点", "㍜"=>"4点", "㍝"=>"5点", "㍞"=>"6点", "㍟"=>"7点", "㍠"=>"8点", "㍡"=>"9点", "㍢"=>"10点", "㍣"=>"11点", "㍤"=>"12点", "㍥"=>"13点", "㍦"=>"14点", "㍧"=>"15点", 
    "㍨"=>"16点", "㍩"=>"17点", "㍪"=>"18点", "㍫"=>"19点", "㍬"=>"20点", "㍭"=>"21点", "㍮"=>"22点", "㍯"=>"23点", "㍰"=>"24点", "㍱"=>"hPa", "㍲"=>"da", "㍳"=>"AU", "㍴"=>"bar", "㍵"=>"oV", "㍶"=>"pc", "㍷"=>"dm", 
    "㍸"=>"dm²", "㍹"=>"dm³", "㍺"=>"IU", "㍻"=>"平成", "㍼"=>"昭和", "㍽"=>"大正", "㍾"=>"明治", "㍿"=>"株式会社", "㎀"=>"pA", "㎁"=>"nA", "㎂"=>"μA", "㎃"=>"mA", "㎄"=>"kA", "㎅"=>"KB", "㎆"=>"MB", "㎇"=>"GB", 
    "㎈"=>"cal", "㎉"=>"kcal", "㎊"=>"pF", "㎋"=>"nF", "㎌"=>"μF", "㎍"=>"μg", "㎎"=>"mg", "㎏"=>"kg", "㎐"=>"Hz", "㎑"=>"kHz", "㎒"=>"MHz", "㎓"=>"GHz", "㎔"=>"THz", "㎕"=>"μℓ", "㎖"=>"mℓ", "㎗"=>"dℓ", 
    "㎘"=>"kℓ", "㎙"=>"fm", "㎚"=>"nm", "㎛"=>"μm", "㎜"=>"mm", "㎝"=>"cm", "㎞"=>"km", "㎟"=>"mm²", "㎠"=>"cm²", "㎡"=>"m²", "㎢"=>"km²", "㎣"=>"mm³", "㎤"=>"cm³", "㎥"=>"m³", "㎦"=>"km³", "㎧"=>"m∕s", 
    "㎨"=>"m∕s²", "㎩"=>"Pa", "㎪"=>"kPa", "㎫"=>"MPa", "㎬"=>"GPa", "㎭"=>"rad", "㎮"=>"rad∕s", "㎯"=>"rad∕s²", "㎰"=>"ps", "㎱"=>"ns", "㎲"=>"μs", "㎳"=>"ms", "㎴"=>"pV", "㎵"=>"nV", "㎶"=>"μV", "㎷"=>"mV", 
    "㎸"=>"kV", "㎹"=>"MV", "㎺"=>"pW", "㎻"=>"nW", "㎼"=>"μW", "㎽"=>"mW", "㎾"=>"kW", "㎿"=>"MW", "㏀"=>"kΩ", "㏁"=>"MΩ", "㏂"=>"a.m.", "㏃"=>"Bq", "㏄"=>"cc", "㏅"=>"cd", "㏆"=>"C∕kg", "㏇"=>"Co.", 
    "㏈"=>"dB", "㏉"=>"Gy", "㏊"=>"ha", "㏋"=>"HP", "㏌"=>"in", "㏍"=>"KK", "㏎"=>"KM", "㏏"=>"kt", "㏐"=>"lm", "㏑"=>"ln", "㏒"=>"log", "㏓"=>"lx", "㏔"=>"mb", "㏕"=>"mil", "㏖"=>"mol", "㏗"=>"PH", 
    "㏘"=>"p.m.", "㏙"=>"PPM", "㏚"=>"PR", "㏛"=>"sr", "㏜"=>"Sv", "㏝"=>"Wb", "㏞"=>"V∕m", "㏟"=>"A∕m", "㏠"=>"1日", "㏡"=>"2日", "㏢"=>"3日", "㏣"=>"4日", "㏤"=>"5日", "㏥"=>"6日", "㏦"=>"7日", "㏧"=>"8日", 
    "㏨"=>"9日", "㏩"=>"10日", "㏪"=>"11日", "㏫"=>"12日", "㏬"=>"13日", "㏭"=>"14日", "㏮"=>"15日", "㏯"=>"16日", "㏰"=>"17日", "㏱"=>"18日", "㏲"=>"19日", "㏳"=>"20日", "㏴"=>"21日", "㏵"=>"22日", "㏶"=>"23日", "㏷"=>"24日", 
    "㏸"=>"25日", "㏹"=>"26日", "㏺"=>"27日", "㏻"=>"28日", "㏼"=>"29日", "㏽"=>"30日", "㏾"=>"31日", "㏿"=>"gal", "ꝰ"=>"ꝯ", "ꟸ"=>"Ħ", "ꟹ"=>"œ", "ﬀ"=>"ff", "ﬁ"=>"fi", "ﬂ"=>"fl", "ﬃ"=>"ffi", "ﬄ"=>"ffl", 
    "ﬅ"=>"ſt", "ﬆ"=>"st", "ﬓ"=>"մն", "ﬔ"=>"մե", "ﬕ"=>"մի", "ﬖ"=>"վն", "ﬗ"=>"մխ", "ﬠ"=>"ע", "ﬡ"=>"א", "ﬢ"=>"ד", "ﬣ"=>"ה", "ﬤ"=>"כ", "ﬥ"=>"ל", "ﬦ"=>"ם", "ﬧ"=>"ר", "ﬨ"=>"ת", 
    "﬩"=>"+", "ﭏ"=>"אל", "ﭐ"=>"ٱ", "ﭑ"=>"ٱ", "ﭒ"=>"ٻ", "ﭓ"=>"ٻ", "ﭔ"=>"ٻ", "ﭕ"=>"ٻ", "ﭖ"=>"پ", "ﭗ"=>"پ", "ﭘ"=>"پ", "ﭙ"=>"پ", "ﭚ"=>"ڀ", "ﭛ"=>"ڀ", "ﭜ"=>"ڀ", "ﭝ"=>"ڀ", 
    "ﭞ"=>"ٺ", "ﭟ"=>"ٺ", "ﭠ"=>"ٺ", "ﭡ"=>"ٺ", "ﭢ"=>"ٿ", "ﭣ"=>"ٿ", "ﭤ"=>"ٿ", "ﭥ"=>"ٿ", "ﭦ"=>"ٹ", "ﭧ"=>"ٹ", "ﭨ"=>"ٹ", "ﭩ"=>"ٹ", "ﭪ"=>"ڤ", "ﭫ"=>"ڤ", "ﭬ"=>"ڤ", "ﭭ"=>"ڤ", 
    "ﭮ"=>"ڦ", "ﭯ"=>"ڦ", "ﭰ"=>"ڦ", "ﭱ"=>"ڦ", "ﭲ"=>"ڄ", "ﭳ"=>"ڄ", "ﭴ"=>"ڄ", "ﭵ"=>"ڄ", "ﭶ"=>"ڃ", "ﭷ"=>"ڃ", "ﭸ"=>"ڃ", "ﭹ"=>"ڃ", "ﭺ"=>"چ", "ﭻ"=>"چ", "ﭼ"=>"چ", "ﭽ"=>"چ", 
    "ﭾ"=>"ڇ", "ﭿ"=>"ڇ", "ﮀ"=>"ڇ", "ﮁ"=>"ڇ", "ﮂ"=>"ڍ", "ﮃ"=>"ڍ", "ﮄ"=>"ڌ", "ﮅ"=>"ڌ", "ﮆ"=>"ڎ", "ﮇ"=>"ڎ", "ﮈ"=>"ڈ", "ﮉ"=>"ڈ", "ﮊ"=>"ژ", "ﮋ"=>"ژ", "ﮌ"=>"ڑ", "ﮍ"=>"ڑ", 
    "ﮎ"=>"ک", "ﮏ"=>"ک", "ﮐ"=>"ک", "ﮑ"=>"ک", "ﮒ"=>"گ", "ﮓ"=>"گ", "ﮔ"=>"گ", "ﮕ"=>"گ", "ﮖ"=>"ڳ", "ﮗ"=>"ڳ", "ﮘ"=>"ڳ", "ﮙ"=>"ڳ", "ﮚ"=>"ڱ", "ﮛ"=>"ڱ", "ﮜ"=>"ڱ", "ﮝ"=>"ڱ", 
    "ﮞ"=>"ں", "ﮟ"=>"ں", "ﮠ"=>"ڻ", "ﮡ"=>"ڻ", "ﮢ"=>"ڻ", "ﮣ"=>"ڻ", "ﮤ"=>"ۀ", "ﮥ"=>"ۀ", "ﮦ"=>"ہ", "ﮧ"=>"ہ", "ﮨ"=>"ہ", "ﮩ"=>"ہ", "ﮪ"=>"ھ", "ﮫ"=>"ھ", "ﮬ"=>"ھ", "ﮭ"=>"ھ", 
    "ﮮ"=>"ے", "ﮯ"=>"ے", "ﮰ"=>"ۓ", "ﮱ"=>"ۓ", "ﯓ"=>"ڭ", "ﯔ"=>"ڭ", "ﯕ"=>"ڭ", "ﯖ"=>"ڭ", "ﯗ"=>"ۇ", "ﯘ"=>"ۇ", "ﯙ"=>"ۆ", "ﯚ"=>"ۆ", "ﯛ"=>"ۈ", "ﯜ"=>"ۈ", "ﯝ"=>"ٷ", "ﯞ"=>"ۋ", 
    "ﯟ"=>"ۋ", "ﯠ"=>"ۅ", "ﯡ"=>"ۅ", "ﯢ"=>"ۉ", "ﯣ"=>"ۉ", "ﯤ"=>"ې", "ﯥ"=>"ې", "ﯦ"=>"ې", "ﯧ"=>"ې", "ﯨ"=>"ى", "ﯩ"=>"ى", "ﯪ"=>"ئا", "ﯫ"=>"ئا", "ﯬ"=>"ئە", "ﯭ"=>"ئە", "ﯮ"=>"ئو", 
    "ﯯ"=>"ئو", "ﯰ"=>"ئۇ", "ﯱ"=>"ئۇ", "ﯲ"=>"ئۆ", "ﯳ"=>"ئۆ", "ﯴ"=>"ئۈ", "ﯵ"=>"ئۈ", "ﯶ"=>"ئې", "ﯷ"=>"ئې", "ﯸ"=>"ئې", "ﯹ"=>"ئى", "ﯺ"=>"ئى", "ﯻ"=>"ئى", "ﯼ"=>"ی", "ﯽ"=>"ی", "ﯾ"=>"ی", 
    "ﯿ"=>"ی", "ﰀ"=>"ئج", "ﰁ"=>"ئح", "ﰂ"=>"ئم", "ﰃ"=>"ئى", "ﰄ"=>"ئي", "ﰅ"=>"بج", "ﰆ"=>"بح", "ﰇ"=>"بخ", "ﰈ"=>"بم", "ﰉ"=>"بى", "ﰊ"=>"بي", "ﰋ"=>"تج", "ﰌ"=>"تح", "ﰍ"=>"تخ", "ﰎ"=>"تم", 
    "ﰏ"=>"تى", "ﰐ"=>"تي", "ﰑ"=>"ثج", "ﰒ"=>"ثم", "ﰓ"=>"ثى", "ﰔ"=>"ثي", "ﰕ"=>"جح", "ﰖ"=>"جم", "ﰗ"=>"حج", "ﰘ"=>"حم", "ﰙ"=>"خج", "ﰚ"=>"خح", "ﰛ"=>"خم", "ﰜ"=>"سج", "ﰝ"=>"سح", "ﰞ"=>"سخ", 
    "ﰟ"=>"سم", "ﰠ"=>"صح", "ﰡ"=>"صم", "ﰢ"=>"ضج", "ﰣ"=>"ضح", "ﰤ"=>"ضخ", "ﰥ"=>"ضم", "ﰦ"=>"طح", "ﰧ"=>"طم", "ﰨ"=>"ظم", "ﰩ"=>"عج", "ﰪ"=>"عم", "ﰫ"=>"غج", "ﰬ"=>"غم", "ﰭ"=>"فج", "ﰮ"=>"فح", 
    "ﰯ"=>"فخ", "ﰰ"=>"فم", "ﰱ"=>"فى", "ﰲ"=>"في", "ﰳ"=>"قح", "ﰴ"=>"قم", "ﰵ"=>"قى", "ﰶ"=>"قي", "ﰷ"=>"كا", "ﰸ"=>"كج", "ﰹ"=>"كح", "ﰺ"=>"كخ", "ﰻ"=>"كل", "ﰼ"=>"كم", "ﰽ"=>"كى", "ﰾ"=>"كي", 
    "ﰿ"=>"لج", "ﱀ"=>"لح", "ﱁ"=>"لخ", "ﱂ"=>"لم", "ﱃ"=>"لى", "ﱄ"=>"لي", "ﱅ"=>"مج", "ﱆ"=>"مح", "ﱇ"=>"مخ", "ﱈ"=>"مم", "ﱉ"=>"مى", "ﱊ"=>"مي", "ﱋ"=>"نج", "ﱌ"=>"نح", "ﱍ"=>"نخ", "ﱎ"=>"نم", 
    "ﱏ"=>"نى", "ﱐ"=>"ني", "ﱑ"=>"هج", "ﱒ"=>"هم", "ﱓ"=>"هى", "ﱔ"=>"هي", "ﱕ"=>"يج", "ﱖ"=>"يح", "ﱗ"=>"يخ", "ﱘ"=>"يم", "ﱙ"=>"يى", "ﱚ"=>"يي", "ﱛ"=>"ذ\u0670", "ﱜ"=>"ر\u0670", "ﱝ"=>"ى\u0670", "ﱞ"=>" \u064C\u0651", 
    "ﱟ"=>" \u064D\u0651", "ﱠ"=>" \u064E\u0651", "ﱡ"=>" \u064F\u0651", "ﱢ"=>" \u0650\u0651", "ﱣ"=>" \u0651\u0670", "ﱤ"=>"ئر", "ﱥ"=>"ئز", "ﱦ"=>"ئم", "ﱧ"=>"ئن", "ﱨ"=>"ئى", "ﱩ"=>"ئي", "ﱪ"=>"بر", "ﱫ"=>"بز", "ﱬ"=>"بم", "ﱭ"=>"بن", "ﱮ"=>"بى", 
    "ﱯ"=>"بي", "ﱰ"=>"تر", "ﱱ"=>"تز", "ﱲ"=>"تم", "ﱳ"=>"تن", "ﱴ"=>"تى", "ﱵ"=>"تي", "ﱶ"=>"ثر", "ﱷ"=>"ثز", "ﱸ"=>"ثم", "ﱹ"=>"ثن", "ﱺ"=>"ثى", "ﱻ"=>"ثي", "ﱼ"=>"فى", "ﱽ"=>"في", "ﱾ"=>"قى", 
    "ﱿ"=>"قي", "ﲀ"=>"كا", "ﲁ"=>"كل", "ﲂ"=>"كم", "ﲃ"=>"كى", "ﲄ"=>"كي", "ﲅ"=>"لم", "ﲆ"=>"لى", "ﲇ"=>"لي", "ﲈ"=>"ما", "ﲉ"=>"مم", "ﲊ"=>"نر", "ﲋ"=>"نز", "ﲌ"=>"نم", "ﲍ"=>"نن", "ﲎ"=>"نى", 
    "ﲏ"=>"ني", "ﲐ"=>"ى\u0670", "ﲑ"=>"ير", "ﲒ"=>"يز", "ﲓ"=>"يم", "ﲔ"=>"ين", "ﲕ"=>"يى", "ﲖ"=>"يي", "ﲗ"=>"ئج", "ﲘ"=>"ئح", "ﲙ"=>"ئخ", "ﲚ"=>"ئم", "ﲛ"=>"ئه", "ﲜ"=>"بج", "ﲝ"=>"بح", "ﲞ"=>"بخ", 
    "ﲟ"=>"بم", "ﲠ"=>"به", "ﲡ"=>"تج", "ﲢ"=>"تح", "ﲣ"=>"تخ", "ﲤ"=>"تم", "ﲥ"=>"ته", "ﲦ"=>"ثم", "ﲧ"=>"جح", "ﲨ"=>"جم", "ﲩ"=>"حج", "ﲪ"=>"حم", "ﲫ"=>"خج", "ﲬ"=>"خم", "ﲭ"=>"سج", "ﲮ"=>"سح", 
    "ﲯ"=>"سخ", "ﲰ"=>"سم", "ﲱ"=>"صح", "ﲲ"=>"صخ", "ﲳ"=>"صم", "ﲴ"=>"ضج", "ﲵ"=>"ضح", "ﲶ"=>"ضخ", "ﲷ"=>"ضم", "ﲸ"=>"طح", "ﲹ"=>"ظم", "ﲺ"=>"عج", "ﲻ"=>"عم", "ﲼ"=>"غج", "ﲽ"=>"غم", "ﲾ"=>"فج", 
    "ﲿ"=>"فح", "ﳀ"=>"فخ", "ﳁ"=>"فم", "ﳂ"=>"قح", "ﳃ"=>"قم", "ﳄ"=>"كج", "ﳅ"=>"كح", "ﳆ"=>"كخ", "ﳇ"=>"كل", "ﳈ"=>"كم", "ﳉ"=>"لج", "ﳊ"=>"لح", "ﳋ"=>"لخ", "ﳌ"=>"لم", "ﳍ"=>"له", "ﳎ"=>"مج", 
    "ﳏ"=>"مح", "ﳐ"=>"مخ", "ﳑ"=>"مم", "ﳒ"=>"نج", "ﳓ"=>"نح", "ﳔ"=>"نخ", "ﳕ"=>"نم", "ﳖ"=>"نه", "ﳗ"=>"هج", "ﳘ"=>"هم", "ﳙ"=>"ه\u0670", "ﳚ"=>"يج", "ﳛ"=>"يح", "ﳜ"=>"يخ", "ﳝ"=>"يم", "ﳞ"=>"يه", 
    "ﳟ"=>"ئم", "ﳠ"=>"ئه", "ﳡ"=>"بم", "ﳢ"=>"به", "ﳣ"=>"تم", "ﳤ"=>"ته", "ﳥ"=>"ثم", "ﳦ"=>"ثه", "ﳧ"=>"سم", "ﳨ"=>"سه", "ﳩ"=>"شم", "ﳪ"=>"شه", "ﳫ"=>"كل", "ﳬ"=>"كم", "ﳭ"=>"لم", "ﳮ"=>"نم", 
    "ﳯ"=>"نه", "ﳰ"=>"يم", "ﳱ"=>"يه", "ﳲ"=>"ـ\u064E\u0651", "ﳳ"=>"ـ\u064F\u0651", "ﳴ"=>"ـ\u0650\u0651", "ﳵ"=>"طى", "ﳶ"=>"طي", "ﳷ"=>"عى", "ﳸ"=>"عي", "ﳹ"=>"غى", "ﳺ"=>"غي", "ﳻ"=>"سى", "ﳼ"=>"سي", "ﳽ"=>"شى", "ﳾ"=>"شي", 
    "ﳿ"=>"حى", "ﴀ"=>"حي", "ﴁ"=>"جى", "ﴂ"=>"جي", "ﴃ"=>"خى", "ﴄ"=>"خي", "ﴅ"=>"صى", "ﴆ"=>"صي", "ﴇ"=>"ضى", "ﴈ"=>"ضي", "ﴉ"=>"شج", "ﴊ"=>"شح", "ﴋ"=>"شخ", "ﴌ"=>"شم", "ﴍ"=>"شر", "ﴎ"=>"سر", 
    "ﴏ"=>"صر", "ﴐ"=>"ضر", "ﴑ"=>"طى", "ﴒ"=>"طي", "ﴓ"=>"عى", "ﴔ"=>"عي", "ﴕ"=>"غى", "ﴖ"=>"غي", "ﴗ"=>"سى", "ﴘ"=>"سي", "ﴙ"=>"شى", "ﴚ"=>"شي", "ﴛ"=>"حى", "ﴜ"=>"حي", "ﴝ"=>"جى", "ﴞ"=>"جي", 
    "ﴟ"=>"خى", "ﴠ"=>"خي", "ﴡ"=>"صى", "ﴢ"=>"صي", "ﴣ"=>"ضى", "ﴤ"=>"ضي", "ﴥ"=>"شج", "ﴦ"=>"شح", "ﴧ"=>"شخ", "ﴨ"=>"شم", "ﴩ"=>"شر", "ﴪ"=>"سر", "ﴫ"=>"صر", "ﴬ"=>"ضر", "ﴭ"=>"شج", "ﴮ"=>"شح", 
    "ﴯ"=>"شخ", "ﴰ"=>"شم", "ﴱ"=>"سه", "ﴲ"=>"شه", "ﴳ"=>"طم", "ﴴ"=>"سج", "ﴵ"=>"سح", "ﴶ"=>"سخ", "ﴷ"=>"شج", "ﴸ"=>"شح", "ﴹ"=>"شخ", "ﴺ"=>"طم", "ﴻ"=>"ظم", "ﴼ"=>"ا\u064B", "ﴽ"=>"ا\u064B", "ﵐ"=>"تجم", 
    "ﵑ"=>"تحج", "ﵒ"=>"تحج", "ﵓ"=>"تحم", "ﵔ"=>"تخم", "ﵕ"=>"تمج", "ﵖ"=>"تمح", "ﵗ"=>"تمخ", "ﵘ"=>"جمح", "ﵙ"=>"جمح", "ﵚ"=>"حمي", "ﵛ"=>"حمى", "ﵜ"=>"سحج", "ﵝ"=>"سجح", "ﵞ"=>"سجى", "ﵟ"=>"سمح", "ﵠ"=>"سمح", 
    "ﵡ"=>"سمج", "ﵢ"=>"سمم", "ﵣ"=>"سمم", "ﵤ"=>"صحح", "ﵥ"=>"صحح", "ﵦ"=>"صمم", "ﵧ"=>"شحم", "ﵨ"=>"شحم", "ﵩ"=>"شجي", "ﵪ"=>"شمخ", "ﵫ"=>"شمخ", "ﵬ"=>"شمم", "ﵭ"=>"شمم", "ﵮ"=>"ضحى", "ﵯ"=>"ضخم", "ﵰ"=>"ضخم", 
    "ﵱ"=>"طمح", "ﵲ"=>"طمح", "ﵳ"=>"طمم", "ﵴ"=>"طمي", "ﵵ"=>"عجم", "ﵶ"=>"عمم", "ﵷ"=>"عمم", "ﵸ"=>"عمى", "ﵹ"=>"غمم", "ﵺ"=>"غمي", "ﵻ"=>"غمى", "ﵼ"=>"فخم", "ﵽ"=>"فخم", "ﵾ"=>"قمح", "ﵿ"=>"قمم", "ﶀ"=>"لحم", 
    "ﶁ"=>"لحي", "ﶂ"=>"لحى", "ﶃ"=>"لجج", "ﶄ"=>"لجج", "ﶅ"=>"لخم", "ﶆ"=>"لخم", "ﶇ"=>"لمح", "ﶈ"=>"لمح", "ﶉ"=>"محج", "ﶊ"=>"محم", "ﶋ"=>"محي", "ﶌ"=>"مجح", "ﶍ"=>"مجم", "ﶎ"=>"مخج", "ﶏ"=>"مخم", "ﶒ"=>"مجخ", 
    "ﶓ"=>"همج", "ﶔ"=>"همم", "ﶕ"=>"نحم", "ﶖ"=>"نحى", "ﶗ"=>"نجم", "ﶘ"=>"نجم", "ﶙ"=>"نجى", "ﶚ"=>"نمي", "ﶛ"=>"نمى", "ﶜ"=>"يمم", "ﶝ"=>"يمم", "ﶞ"=>"بخي", "ﶟ"=>"تجي", "ﶠ"=>"تجى", "ﶡ"=>"تخي", "ﶢ"=>"تخى", 
    "ﶣ"=>"تمي", "ﶤ"=>"تمى", "ﶥ"=>"جمي", "ﶦ"=>"جحى", "ﶧ"=>"جمى", "ﶨ"=>"سخى", "ﶩ"=>"صحي", "ﶪ"=>"شحي", "ﶫ"=>"ضحي", "ﶬ"=>"لجي", "ﶭ"=>"لمي", "ﶮ"=>"يحي", "ﶯ"=>"يجي", "ﶰ"=>"يمي", "ﶱ"=>"ممي", "ﶲ"=>"قمي", 
    "ﶳ"=>"نحي", "ﶴ"=>"قمح", "ﶵ"=>"لحم", "ﶶ"=>"عمي", "ﶷ"=>"كمي", "ﶸ"=>"نجح", "ﶹ"=>"مخي", "ﶺ"=>"لجم", "ﶻ"=>"كمم", "ﶼ"=>"لجم", "ﶽ"=>"نجح", "ﶾ"=>"جحي", "ﶿ"=>"حجي", "ﷀ"=>"مجي", "ﷁ"=>"فمي", "ﷂ"=>"بحي", 
    "ﷃ"=>"كمم", "ﷄ"=>"عجم", "ﷅ"=>"صمم", "ﷆ"=>"سخي", "ﷇ"=>"نجي", "ﷰ"=>"صلے", "ﷱ"=>"قلے", "ﷲ"=>"الله", "ﷳ"=>"اكبر", "ﷴ"=>"محمد", "ﷵ"=>"صلعم", "ﷶ"=>"رسول", "ﷷ"=>"عليه", "ﷸ"=>"وسلم", "ﷹ"=>"صلى", "ﷺ"=>"صلى الله عليه وسلم", 
    "ﷻ"=>"جل جلاله", "﷼"=>"ریال", "︐"=>",", "︑"=>"、", "︒"=>"。", "︓"=>":", "︔"=>";", "︕"=>"!", "︖"=>"?", "︗"=>"〖", "︘"=>"〗", "︙"=>"…", "︰"=>"‥", "︱"=>"—", "︲"=>"–", "︳"=>"_", 
    "︴"=>"_", "︵"=>"(", "︶"=>")", "︷"=>"{", "︸"=>"}", "︹"=>"〔", "︺"=>"〕", "︻"=>"【", "︼"=>"】", "︽"=>"《", "︾"=>"》", "︿"=>"〈", "﹀"=>"〉", "﹁"=>"「", "﹂"=>"」", "﹃"=>"『", 
    "﹄"=>"』", "﹇"=>"[", "﹈"=>"]", "﹉"=>"‾", "﹊"=>"‾", "﹋"=>"‾", "﹌"=>"‾", "﹍"=>"_", "﹎"=>"_", "﹏"=>"_", "﹐"=>",", "﹑"=>"、", "﹒"=>".", "﹔"=>";", "﹕"=>":", "﹖"=>"?", 
    "﹗"=>"!", "﹘"=>"—", "﹙"=>"(", "﹚"=>")", "﹛"=>"{", "﹜"=>"}", "﹝"=>"〔", "﹞"=>"〕", "﹟"=>"#", "﹠"=>"&", "﹡"=>"*", "﹢"=>"+", "﹣"=>"-", "﹤"=>"<", "﹥"=>">", "﹦"=>"=", 
    "﹨"=>"\u005C", "﹩"=>"$", "﹪"=>"%", "﹫"=>"@", "ﹰ"=>" \u064B", "ﹱ"=>"ـ\u064B", "ﹲ"=>" \u064C", "ﹴ"=>" \u064D", "ﹶ"=>" \u064E", "ﹷ"=>"ـ\u064E", "ﹸ"=>" \u064F", "ﹹ"=>"ـ\u064F", "ﹺ"=>" \u0650", "ﹻ"=>"ـ\u0650", "ﹼ"=>" \u0651", "ﹽ"=>"ـ\u0651", 
    "ﹾ"=>" \u0652", "ﹿ"=>"ـ\u0652", "ﺀ"=>"ء", "ﺁ"=>"آ", "ﺂ"=>"آ", "ﺃ"=>"أ", "ﺄ"=>"أ", "ﺅ"=>"ؤ", "ﺆ"=>"ؤ", "ﺇ"=>"إ", "ﺈ"=>"إ", "ﺉ"=>"ئ", "ﺊ"=>"ئ", "ﺋ"=>"ئ", "ﺌ"=>"ئ", "ﺍ"=>"ا", 
    "ﺎ"=>"ا", "ﺏ"=>"ب", "ﺐ"=>"ب", "ﺑ"=>"ب", "ﺒ"=>"ب", "ﺓ"=>"ة", "ﺔ"=>"ة", "ﺕ"=>"ت", "ﺖ"=>"ت", "ﺗ"=>"ت", "ﺘ"=>"ت", "ﺙ"=>"ث", "ﺚ"=>"ث", "ﺛ"=>"ث", "ﺜ"=>"ث", "ﺝ"=>"ج", 
    "ﺞ"=>"ج", "ﺟ"=>"ج", "ﺠ"=>"ج", "ﺡ"=>"ح", "ﺢ"=>"ح", "ﺣ"=>"ح", "ﺤ"=>"ح", "ﺥ"=>"خ", "ﺦ"=>"خ", "ﺧ"=>"خ", "ﺨ"=>"خ", "ﺩ"=>"د", "ﺪ"=>"د", "ﺫ"=>"ذ", "ﺬ"=>"ذ", "ﺭ"=>"ر", 
    "ﺮ"=>"ر", "ﺯ"=>"ز", "ﺰ"=>"ز", "ﺱ"=>"س", "ﺲ"=>"س", "ﺳ"=>"س", "ﺴ"=>"س", "ﺵ"=>"ش", "ﺶ"=>"ش", "ﺷ"=>"ش", "ﺸ"=>"ش", "ﺹ"=>"ص", "ﺺ"=>"ص", "ﺻ"=>"ص", "ﺼ"=>"ص", "ﺽ"=>"ض", 
    "ﺾ"=>"ض", "ﺿ"=>"ض", "ﻀ"=>"ض", "ﻁ"=>"ط", "ﻂ"=>"ط", "ﻃ"=>"ط", "ﻄ"=>"ط", "ﻅ"=>"ظ", "ﻆ"=>"ظ", "ﻇ"=>"ظ", "ﻈ"=>"ظ", "ﻉ"=>"ع", "ﻊ"=>"ع", "ﻋ"=>"ع", "ﻌ"=>"ع", "ﻍ"=>"غ", 
    "ﻎ"=>"غ", "ﻏ"=>"غ", "ﻐ"=>"غ", "ﻑ"=>"ف", "ﻒ"=>"ف", "ﻓ"=>"ف", "ﻔ"=>"ف", "ﻕ"=>"ق", "ﻖ"=>"ق", "ﻗ"=>"ق", "ﻘ"=>"ق", "ﻙ"=>"ك", "ﻚ"=>"ك", "ﻛ"=>"ك", "ﻜ"=>"ك", "ﻝ"=>"ل", 
    "ﻞ"=>"ل", "ﻟ"=>"ل", "ﻠ"=>"ل", "ﻡ"=>"م", "ﻢ"=>"م", "ﻣ"=>"م", "ﻤ"=>"م", "ﻥ"=>"ن", "ﻦ"=>"ن", "ﻧ"=>"ن", "ﻨ"=>"ن", "ﻩ"=>"ه", "ﻪ"=>"ه", "ﻫ"=>"ه", "ﻬ"=>"ه", "ﻭ"=>"و", 
    "ﻮ"=>"و", "ﻯ"=>"ى", "ﻰ"=>"ى", "ﻱ"=>"ي", "ﻲ"=>"ي", "ﻳ"=>"ي", "ﻴ"=>"ي", "ﻵ"=>"لآ", "ﻶ"=>"لآ", "ﻷ"=>"لأ", "ﻸ"=>"لأ", "ﻹ"=>"لإ", "ﻺ"=>"لإ", "ﻻ"=>"لا", "ﻼ"=>"لا", "！"=>"!", 
    "＂"=>"\u0022", "＃"=>"#", "＄"=>"$", "％"=>"%", "＆"=>"&", "＇"=>"'", "（"=>"(", "）"=>")", "＊"=>"*", "＋"=>"+", "，"=>",", "－"=>"-", "．"=>".", "／"=>"/", "０"=>"0", "１"=>"1", 
    "２"=>"2", "３"=>"3", "４"=>"4", "５"=>"5", "６"=>"6", "７"=>"7", "８"=>"8", "９"=>"9", "："=>":", "；"=>";", "＜"=>"<", "＝"=>"=", "＞"=>">", "？"=>"?", "＠"=>"@", "Ａ"=>"A", 
    "Ｂ"=>"B", "Ｃ"=>"C", "Ｄ"=>"D", "Ｅ"=>"E", "Ｆ"=>"F", "Ｇ"=>"G", "Ｈ"=>"H", "Ｉ"=>"I", "Ｊ"=>"J", "Ｋ"=>"K", "Ｌ"=>"L", "Ｍ"=>"M", "Ｎ"=>"N", "Ｏ"=>"O", "Ｐ"=>"P", "Ｑ"=>"Q", 
    "Ｒ"=>"R", "Ｓ"=>"S", "Ｔ"=>"T", "Ｕ"=>"U", "Ｖ"=>"V", "Ｗ"=>"W", "Ｘ"=>"X", "Ｙ"=>"Y", "Ｚ"=>"Z", "［"=>"[", "＼"=>"\u005C", "］"=>"]", "＾"=>"^", "＿"=>"_", "｀"=>"`", "ａ"=>"a", 
    "ｂ"=>"b", "ｃ"=>"c", "ｄ"=>"d", "ｅ"=>"e", "ｆ"=>"f", "ｇ"=>"g", "ｈ"=>"h", "ｉ"=>"i", "ｊ"=>"j", "ｋ"=>"k", "ｌ"=>"l", "ｍ"=>"m", "ｎ"=>"n", "ｏ"=>"o", "ｐ"=>"p", "ｑ"=>"q", 
    "ｒ"=>"r", "ｓ"=>"s", "ｔ"=>"t", "ｕ"=>"u", "ｖ"=>"v", "ｗ"=>"w", "ｘ"=>"x", "ｙ"=>"y", "ｚ"=>"z", "｛"=>"{", "｜"=>"|", "｝"=>"}", "～"=>"~", "｟"=>"⦅", "｠"=>"⦆", "｡"=>"。", 
    "｢"=>"「", "｣"=>"」", "､"=>"、", "･"=>"・", "ｦ"=>"ヲ", "ｧ"=>"ァ", "ｨ"=>"ィ", "ｩ"=>"ゥ", "ｪ"=>"ェ", "ｫ"=>"ォ", "ｬ"=>"ャ", "ｭ"=>"ュ", "ｮ"=>"ョ", "ｯ"=>"ッ", "ｰ"=>"ー", "ｱ"=>"ア", 
    "ｲ"=>"イ", "ｳ"=>"ウ", "ｴ"=>"エ", "ｵ"=>"オ", "ｶ"=>"カ", "ｷ"=>"キ", "ｸ"=>"ク", "ｹ"=>"ケ", "ｺ"=>"コ", "ｻ"=>"サ", "ｼ"=>"シ", "ｽ"=>"ス", "ｾ"=>"セ", "ｿ"=>"ソ", "ﾀ"=>"タ", "ﾁ"=>"チ", 
    "ﾂ"=>"ツ", "ﾃ"=>"テ", "ﾄ"=>"ト", "ﾅ"=>"ナ", "ﾆ"=>"ニ", "ﾇ"=>"ヌ", "ﾈ"=>"ネ", "ﾉ"=>"ノ", "ﾊ"=>"ハ", "ﾋ"=>"ヒ", "ﾌ"=>"フ", "ﾍ"=>"ヘ", "ﾎ"=>"ホ", "ﾏ"=>"マ", "ﾐ"=>"ミ", "ﾑ"=>"ム", 
    "ﾒ"=>"メ", "ﾓ"=>"モ", "ﾔ"=>"ヤ", "ﾕ"=>"ユ", "ﾖ"=>"ヨ", "ﾗ"=>"ラ", "ﾘ"=>"リ", "ﾙ"=>"ル", "ﾚ"=>"レ", "ﾛ"=>"ロ", "ﾜ"=>"ワ", "ﾝ"=>"ン", "ﾞ"=>"\u3099", "ﾟ"=>"\u309A", "ﾠ"=>"ㅤ", "ﾡ"=>"ㄱ", 
    "ﾢ"=>"ㄲ", "ﾣ"=>"ㄳ", "ﾤ"=>"ㄴ", "ﾥ"=>"ㄵ", "ﾦ"=>"ㄶ", "ﾧ"=>"ㄷ", "ﾨ"=>"ㄸ", "ﾩ"=>"ㄹ", "ﾪ"=>"ㄺ", "ﾫ"=>"ㄻ", "ﾬ"=>"ㄼ", "ﾭ"=>"ㄽ", "ﾮ"=>"ㄾ", "ﾯ"=>"ㄿ", "ﾰ"=>"ㅀ", "ﾱ"=>"ㅁ", 
    "ﾲ"=>"ㅂ", "ﾳ"=>"ㅃ", "ﾴ"=>"ㅄ", "ﾵ"=>"ㅅ", "ﾶ"=>"ㅆ", "ﾷ"=>"ㅇ", "ﾸ"=>"ㅈ", "ﾹ"=>"ㅉ", "ﾺ"=>"ㅊ", "ﾻ"=>"ㅋ", "ﾼ"=>"ㅌ", "ﾽ"=>"ㅍ", "ﾾ"=>"ㅎ", "ￂ"=>"ㅏ", "ￃ"=>"ㅐ", "ￄ"=>"ㅑ", 
    "ￅ"=>"ㅒ", "ￆ"=>"ㅓ", "ￇ"=>"ㅔ", "ￊ"=>"ㅕ", "ￋ"=>"ㅖ", "ￌ"=>"ㅗ", "ￍ"=>"ㅘ", "ￎ"=>"ㅙ", "ￏ"=>"ㅚ", "ￒ"=>"ㅛ", "ￓ"=>"ㅜ", "ￔ"=>"ㅝ", "ￕ"=>"ㅞ", "ￖ"=>"ㅟ", "ￗ"=>"ㅠ", "ￚ"=>"ㅡ", 
    "ￛ"=>"ㅢ", "ￜ"=>"ㅣ", "￠"=>"¢", "￡"=>"£", "￢"=>"¬", "￣"=>"¯", "￤"=>"¦", "￥"=>"¥", "￦"=>"₩", "￨"=>"│", "￩"=>"←", "￪"=>"↑", "￫"=>"→", "￬"=>"↓", "￭"=>"■", "￮"=>"○", 
    "\u{1D400}"=>"A", "\u{1D401}"=>"B", "\u{1D402}"=>"C", "\u{1D403}"=>"D", "\u{1D404}"=>"E", "\u{1D405}"=>"F", "\u{1D406}"=>"G", "\u{1D407}"=>"H", "\u{1D408}"=>"I", "\u{1D409}"=>"J", "\u{1D40A}"=>"K", "\u{1D40B}"=>"L", "\u{1D40C}"=>"M", "\u{1D40D}"=>"N", "\u{1D40E}"=>"O", "\u{1D40F}"=>"P", 
    "\u{1D410}"=>"Q", "\u{1D411}"=>"R", "\u{1D412}"=>"S", "\u{1D413}"=>"T", "\u{1D414}"=>"U", "\u{1D415}"=>"V", "\u{1D416}"=>"W", "\u{1D417}"=>"X", "\u{1D418}"=>"Y", "\u{1D419}"=>"Z", "\u{1D41A}"=>"a", "\u{1D41B}"=>"b", "\u{1D41C}"=>"c", "\u{1D41D}"=>"d", "\u{1D41E}"=>"e", "\u{1D41F}"=>"f", 
    "\u{1D420}"=>"g", "\u{1D421}"=>"h", "\u{1D422}"=>"i", "\u{1D423}"=>"j", "\u{1D424}"=>"k", "\u{1D425}"=>"l", "\u{1D426}"=>"m", "\u{1D427}"=>"n", "\u{1D428}"=>"o", "\u{1D429}"=>"p", "\u{1D42A}"=>"q", "\u{1D42B}"=>"r", "\u{1D42C}"=>"s", "\u{1D42D}"=>"t", "\u{1D42E}"=>"u", "\u{1D42F}"=>"v", 
    "\u{1D430}"=>"w", "\u{1D431}"=>"x", "\u{1D432}"=>"y", "\u{1D433}"=>"z", "\u{1D434}"=>"A", "\u{1D435}"=>"B", "\u{1D436}"=>"C", "\u{1D437}"=>"D", "\u{1D438}"=>"E", "\u{1D439}"=>"F", "\u{1D43A}"=>"G", "\u{1D43B}"=>"H", "\u{1D43C}"=>"I", "\u{1D43D}"=>"J", "\u{1D43E}"=>"K", "\u{1D43F}"=>"L", 
    "\u{1D440}"=>"M", "\u{1D441}"=>"N", "\u{1D442}"=>"O", "\u{1D443}"=>"P", "\u{1D444}"=>"Q", "\u{1D445}"=>"R", "\u{1D446}"=>"S", "\u{1D447}"=>"T", "\u{1D448}"=>"U", "\u{1D449}"=>"V", "\u{1D44A}"=>"W", "\u{1D44B}"=>"X", "\u{1D44C}"=>"Y", "\u{1D44D}"=>"Z", "\u{1D44E}"=>"a", "\u{1D44F}"=>"b", 
    "\u{1D450}"=>"c", "\u{1D451}"=>"d", "\u{1D452}"=>"e", "\u{1D453}"=>"f", "\u{1D454}"=>"g", "\u{1D456}"=>"i", "\u{1D457}"=>"j", "\u{1D458}"=>"k", "\u{1D459}"=>"l", "\u{1D45A}"=>"m", "\u{1D45B}"=>"n", "\u{1D45C}"=>"o", "\u{1D45D}"=>"p", "\u{1D45E}"=>"q", "\u{1D45F}"=>"r", "\u{1D460}"=>"s", 
    "\u{1D461}"=>"t", "\u{1D462}"=>"u", "\u{1D463}"=>"v", "\u{1D464}"=>"w", "\u{1D465}"=>"x", "\u{1D466}"=>"y", "\u{1D467}"=>"z", "\u{1D468}"=>"A", "\u{1D469}"=>"B", "\u{1D46A}"=>"C", "\u{1D46B}"=>"D", "\u{1D46C}"=>"E", "\u{1D46D}"=>"F", "\u{1D46E}"=>"G", "\u{1D46F}"=>"H", "\u{1D470}"=>"I", 
    "\u{1D471}"=>"J", "\u{1D472}"=>"K", "\u{1D473}"=>"L", "\u{1D474}"=>"M", "\u{1D475}"=>"N", "\u{1D476}"=>"O", "\u{1D477}"=>"P", "\u{1D478}"=>"Q", "\u{1D479}"=>"R", "\u{1D47A}"=>"S", "\u{1D47B}"=>"T", "\u{1D47C}"=>"U", "\u{1D47D}"=>"V", "\u{1D47E}"=>"W", "\u{1D47F}"=>"X", "\u{1D480}"=>"Y", 
    "\u{1D481}"=>"Z", "\u{1D482}"=>"a", "\u{1D483}"=>"b", "\u{1D484}"=>"c", "\u{1D485}"=>"d", "\u{1D486}"=>"e", "\u{1D487}"=>"f", "\u{1D488}"=>"g", "\u{1D489}"=>"h", "\u{1D48A}"=>"i", "\u{1D48B}"=>"j", "\u{1D48C}"=>"k", "\u{1D48D}"=>"l", "\u{1D48E}"=>"m", "\u{1D48F}"=>"n", "\u{1D490}"=>"o", 
    "\u{1D491}"=>"p", "\u{1D492}"=>"q", "\u{1D493}"=>"r", "\u{1D494}"=>"s", "\u{1D495}"=>"t", "\u{1D496}"=>"u", "\u{1D497}"=>"v", "\u{1D498}"=>"w", "\u{1D499}"=>"x", "\u{1D49A}"=>"y", "\u{1D49B}"=>"z", "\u{1D49C}"=>"A", "\u{1D49E}"=>"C", "\u{1D49F}"=>"D", "\u{1D4A2}"=>"G", "\u{1D4A5}"=>"J", 
    "\u{1D4A6}"=>"K", "\u{1D4A9}"=>"N", "\u{1D4AA}"=>"O", "\u{1D4AB}"=>"P", "\u{1D4AC}"=>"Q", "\u{1D4AE}"=>"S", "\u{1D4AF}"=>"T", "\u{1D4B0}"=>"U", "\u{1D4B1}"=>"V", "\u{1D4B2}"=>"W", "\u{1D4B3}"=>"X", "\u{1D4B4}"=>"Y", "\u{1D4B5}"=>"Z", "\u{1D4B6}"=>"a", "\u{1D4B7}"=>"b", "\u{1D4B8}"=>"c", 
    "\u{1D4B9}"=>"d", "\u{1D4BB}"=>"f", "\u{1D4BD}"=>"h", "\u{1D4BE}"=>"i", "\u{1D4BF}"=>"j", "\u{1D4C0}"=>"k", "\u{1D4C1}"=>"l", "\u{1D4C2}"=>"m", "\u{1D4C3}"=>"n", "\u{1D4C5}"=>"p", "\u{1D4C6}"=>"q", "\u{1D4C7}"=>"r", "\u{1D4C8}"=>"s", "\u{1D4C9}"=>"t", "\u{1D4CA}"=>"u", "\u{1D4CB}"=>"v", 
    "\u{1D4CC}"=>"w", "\u{1D4CD}"=>"x", "\u{1D4CE}"=>"y", "\u{1D4CF}"=>"z", "\u{1D4D0}"=>"A", "\u{1D4D1}"=>"B", "\u{1D4D2}"=>"C", "\u{1D4D3}"=>"D", "\u{1D4D4}"=>"E", "\u{1D4D5}"=>"F", "\u{1D4D6}"=>"G", "\u{1D4D7}"=>"H", "\u{1D4D8}"=>"I", "\u{1D4D9}"=>"J", "\u{1D4DA}"=>"K", "\u{1D4DB}"=>"L", 
    "\u{1D4DC}"=>"M", "\u{1D4DD}"=>"N", "\u{1D4DE}"=>"O", "\u{1D4DF}"=>"P", "\u{1D4E0}"=>"Q", "\u{1D4E1}"=>"R", "\u{1D4E2}"=>"S", "\u{1D4E3}"=>"T", "\u{1D4E4}"=>"U", "\u{1D4E5}"=>"V", "\u{1D4E6}"=>"W", "\u{1D4E7}"=>"X", "\u{1D4E8}"=>"Y", "\u{1D4E9}"=>"Z", "\u{1D4EA}"=>"a", "\u{1D4EB}"=>"b", 
    "\u{1D4EC}"=>"c", "\u{1D4ED}"=>"d", "\u{1D4EE}"=>"e", "\u{1D4EF}"=>"f", "\u{1D4F0}"=>"g", "\u{1D4F1}"=>"h", "\u{1D4F2}"=>"i", "\u{1D4F3}"=>"j", "\u{1D4F4}"=>"k", "\u{1D4F5}"=>"l", "\u{1D4F6}"=>"m", "\u{1D4F7}"=>"n", "\u{1D4F8}"=>"o", "\u{1D4F9}"=>"p", "\u{1D4FA}"=>"q", "\u{1D4FB}"=>"r", 
    "\u{1D4FC}"=>"s", "\u{1D4FD}"=>"t", "\u{1D4FE}"=>"u", "\u{1D4FF}"=>"v", "\u{1D500}"=>"w", "\u{1D501}"=>"x", "\u{1D502}"=>"y", "\u{1D503}"=>"z", "\u{1D504}"=>"A", "\u{1D505}"=>"B", "\u{1D507}"=>"D", "\u{1D508}"=>"E", "\u{1D509}"=>"F", "\u{1D50A}"=>"G", "\u{1D50D}"=>"J", "\u{1D50E}"=>"K", 
    "\u{1D50F}"=>"L", "\u{1D510}"=>"M", "\u{1D511}"=>"N", "\u{1D512}"=>"O", "\u{1D513}"=>"P", "\u{1D514}"=>"Q", "\u{1D516}"=>"S", "\u{1D517}"=>"T", "\u{1D518}"=>"U", "\u{1D519}"=>"V", "\u{1D51A}"=>"W", "\u{1D51B}"=>"X", "\u{1D51C}"=>"Y", "\u{1D51E}"=>"a", "\u{1D51F}"=>"b", "\u{1D520}"=>"c", 
    "\u{1D521}"=>"d", "\u{1D522}"=>"e", "\u{1D523}"=>"f", "\u{1D524}"=>"g", "\u{1D525}"=>"h", "\u{1D526}"=>"i", "\u{1D527}"=>"j", "\u{1D528}"=>"k", "\u{1D529}"=>"l", "\u{1D52A}"=>"m", "\u{1D52B}"=>"n", "\u{1D52C}"=>"o", "\u{1D52D}"=>"p", "\u{1D52E}"=>"q", "\u{1D52F}"=>"r", "\u{1D530}"=>"s", 
    "\u{1D531}"=>"t", "\u{1D532}"=>"u", "\u{1D533}"=>"v", "\u{1D534}"=>"w", "\u{1D535}"=>"x", "\u{1D536}"=>"y", "\u{1D537}"=>"z", "\u{1D538}"=>"A", "\u{1D539}"=>"B", "\u{1D53B}"=>"D", "\u{1D53C}"=>"E", "\u{1D53D}"=>"F", "\u{1D53E}"=>"G", "\u{1D540}"=>"I", "\u{1D541}"=>"J", "\u{1D542}"=>"K", 
    "\u{1D543}"=>"L", "\u{1D544}"=>"M", "\u{1D546}"=>"O", "\u{1D54A}"=>"S", "\u{1D54B}"=>"T", "\u{1D54C}"=>"U", "\u{1D54D}"=>"V", "\u{1D54E}"=>"W", "\u{1D54F}"=>"X", "\u{1D550}"=>"Y", "\u{1D552}"=>"a", "\u{1D553}"=>"b", "\u{1D554}"=>"c", "\u{1D555}"=>"d", "\u{1D556}"=>"e", "\u{1D557}"=>"f", 
    "\u{1D558}"=>"g", "\u{1D559}"=>"h", "\u{1D55A}"=>"i", "\u{1D55B}"=>"j", "\u{1D55C}"=>"k", "\u{1D55D}"=>"l", "\u{1D55E}"=>"m", "\u{1D55F}"=>"n", "\u{1D560}"=>"o", "\u{1D561}"=>"p", "\u{1D562}"=>"q", "\u{1D563}"=>"r", "\u{1D564}"=>"s", "\u{1D565}"=>"t", "\u{1D566}"=>"u", "\u{1D567}"=>"v", 
    "\u{1D568}"=>"w", "\u{1D569}"=>"x", "\u{1D56A}"=>"y", "\u{1D56B}"=>"z", "\u{1D56C}"=>"A", "\u{1D56D}"=>"B", "\u{1D56E}"=>"C", "\u{1D56F}"=>"D", "\u{1D570}"=>"E", "\u{1D571}"=>"F", "\u{1D572}"=>"G", "\u{1D573}"=>"H", "\u{1D574}"=>"I", "\u{1D575}"=>"J", "\u{1D576}"=>"K", "\u{1D577}"=>"L", 
    "\u{1D578}"=>"M", "\u{1D579}"=>"N", "\u{1D57A}"=>"O", "\u{1D57B}"=>"P", "\u{1D57C}"=>"Q", "\u{1D57D}"=>"R", "\u{1D57E}"=>"S", "\u{1D57F}"=>"T", "\u{1D580}"=>"U", "\u{1D581}"=>"V", "\u{1D582}"=>"W", "\u{1D583}"=>"X", "\u{1D584}"=>"Y", "\u{1D585}"=>"Z", "\u{1D586}"=>"a", "\u{1D587}"=>"b", 
    "\u{1D588}"=>"c", "\u{1D589}"=>"d", "\u{1D58A}"=>"e", "\u{1D58B}"=>"f", "\u{1D58C}"=>"g", "\u{1D58D}"=>"h", "\u{1D58E}"=>"i", "\u{1D58F}"=>"j", "\u{1D590}"=>"k", "\u{1D591}"=>"l", "\u{1D592}"=>"m", "\u{1D593}"=>"n", "\u{1D594}"=>"o", "\u{1D595}"=>"p", "\u{1D596}"=>"q", "\u{1D597}"=>"r", 
    "\u{1D598}"=>"s", "\u{1D599}"=>"t", "\u{1D59A}"=>"u", "\u{1D59B}"=>"v", "\u{1D59C}"=>"w", "\u{1D59D}"=>"x", "\u{1D59E}"=>"y", "\u{1D59F}"=>"z", "\u{1D5A0}"=>"A", "\u{1D5A1}"=>"B", "\u{1D5A2}"=>"C", "\u{1D5A3}"=>"D", "\u{1D5A4}"=>"E", "\u{1D5A5}"=>"F", "\u{1D5A6}"=>"G", "\u{1D5A7}"=>"H", 
    "\u{1D5A8}"=>"I", "\u{1D5A9}"=>"J", "\u{1D5AA}"=>"K", "\u{1D5AB}"=>"L", "\u{1D5AC}"=>"M", "\u{1D5AD}"=>"N", "\u{1D5AE}"=>"O", "\u{1D5AF}"=>"P", "\u{1D5B0}"=>"Q", "\u{1D5B1}"=>"R", "\u{1D5B2}"=>"S", "\u{1D5B3}"=>"T", "\u{1D5B4}"=>"U", "\u{1D5B5}"=>"V", "\u{1D5B6}"=>"W", "\u{1D5B7}"=>"X", 
    "\u{1D5B8}"=>"Y", "\u{1D5B9}"=>"Z", "\u{1D5BA}"=>"a", "\u{1D5BB}"=>"b", "\u{1D5BC}"=>"c", "\u{1D5BD}"=>"d", "\u{1D5BE}"=>"e", "\u{1D5BF}"=>"f", "\u{1D5C0}"=>"g", "\u{1D5C1}"=>"h", "\u{1D5C2}"=>"i", "\u{1D5C3}"=>"j", "\u{1D5C4}"=>"k", "\u{1D5C5}"=>"l", "\u{1D5C6}"=>"m", "\u{1D5C7}"=>"n", 
    "\u{1D5C8}"=>"o", "\u{1D5C9}"=>"p", "\u{1D5CA}"=>"q", "\u{1D5CB}"=>"r", "\u{1D5CC}"=>"s", "\u{1D5CD}"=>"t", "\u{1D5CE}"=>"u", "\u{1D5CF}"=>"v", "\u{1D5D0}"=>"w", "\u{1D5D1}"=>"x", "\u{1D5D2}"=>"y", "\u{1D5D3}"=>"z", "\u{1D5D4}"=>"A", "\u{1D5D5}"=>"B", "\u{1D5D6}"=>"C", "\u{1D5D7}"=>"D", 
    "\u{1D5D8}"=>"E", "\u{1D5D9}"=>"F", "\u{1D5DA}"=>"G", "\u{1D5DB}"=>"H", "\u{1D5DC}"=>"I", "\u{1D5DD}"=>"J", "\u{1D5DE}"=>"K", "\u{1D5DF}"=>"L", "\u{1D5E0}"=>"M", "\u{1D5E1}"=>"N", "\u{1D5E2}"=>"O", "\u{1D5E3}"=>"P", "\u{1D5E4}"=>"Q", "\u{1D5E5}"=>"R", "\u{1D5E6}"=>"S", "\u{1D5E7}"=>"T", 
    "\u{1D5E8}"=>"U", "\u{1D5E9}"=>"V", "\u{1D5EA}"=>"W", "\u{1D5EB}"=>"X", "\u{1D5EC}"=>"Y", "\u{1D5ED}"=>"Z", "\u{1D5EE}"=>"a", "\u{1D5EF}"=>"b", "\u{1D5F0}"=>"c", "\u{1D5F1}"=>"d", "\u{1D5F2}"=>"e", "\u{1D5F3}"=>"f", "\u{1D5F4}"=>"g", "\u{1D5F5}"=>"h", "\u{1D5F6}"=>"i", "\u{1D5F7}"=>"j", 
    "\u{1D5F8}"=>"k", "\u{1D5F9}"=>"l", "\u{1D5FA}"=>"m", "\u{1D5FB}"=>"n", "\u{1D5FC}"=>"o", "\u{1D5FD}"=>"p", "\u{1D5FE}"=>"q", "\u{1D5FF}"=>"r", "\u{1D600}"=>"s", "\u{1D601}"=>"t", "\u{1D602}"=>"u", "\u{1D603}"=>"v", "\u{1D604}"=>"w", "\u{1D605}"=>"x", "\u{1D606}"=>"y", "\u{1D607}"=>"z", 
    "\u{1D608}"=>"A", "\u{1D609}"=>"B", "\u{1D60A}"=>"C", "\u{1D60B}"=>"D", "\u{1D60C}"=>"E", "\u{1D60D}"=>"F", "\u{1D60E}"=>"G", "\u{1D60F}"=>"H", "\u{1D610}"=>"I", "\u{1D611}"=>"J", "\u{1D612}"=>"K", "\u{1D613}"=>"L", "\u{1D614}"=>"M", "\u{1D615}"=>"N", "\u{1D616}"=>"O", "\u{1D617}"=>"P", 
    "\u{1D618}"=>"Q", "\u{1D619}"=>"R", "\u{1D61A}"=>"S", "\u{1D61B}"=>"T", "\u{1D61C}"=>"U", "\u{1D61D}"=>"V", "\u{1D61E}"=>"W", "\u{1D61F}"=>"X", "\u{1D620}"=>"Y", "\u{1D621}"=>"Z", "\u{1D622}"=>"a", "\u{1D623}"=>"b", "\u{1D624}"=>"c", "\u{1D625}"=>"d", "\u{1D626}"=>"e", "\u{1D627}"=>"f", 
    "\u{1D628}"=>"g", "\u{1D629}"=>"h", "\u{1D62A}"=>"i", "\u{1D62B}"=>"j", "\u{1D62C}"=>"k", "\u{1D62D}"=>"l", "\u{1D62E}"=>"m", "\u{1D62F}"=>"n", "\u{1D630}"=>"o", "\u{1D631}"=>"p", "\u{1D632}"=>"q", "\u{1D633}"=>"r", "\u{1D634}"=>"s", "\u{1D635}"=>"t", "\u{1D636}"=>"u", "\u{1D637}"=>"v", 
    "\u{1D638}"=>"w", "\u{1D639}"=>"x", "\u{1D63A}"=>"y", "\u{1D63B}"=>"z", "\u{1D63C}"=>"A", "\u{1D63D}"=>"B", "\u{1D63E}"=>"C", "\u{1D63F}"=>"D", "\u{1D640}"=>"E", "\u{1D641}"=>"F", "\u{1D642}"=>"G", "\u{1D643}"=>"H", "\u{1D644}"=>"I", "\u{1D645}"=>"J", "\u{1D646}"=>"K", "\u{1D647}"=>"L", 
    "\u{1D648}"=>"M", "\u{1D649}"=>"N", "\u{1D64A}"=>"O", "\u{1D64B}"=>"P", "\u{1D64C}"=>"Q", "\u{1D64D}"=>"R", "\u{1D64E}"=>"S", "\u{1D64F}"=>"T", "\u{1D650}"=>"U", "\u{1D651}"=>"V", "\u{1D652}"=>"W", "\u{1D653}"=>"X", "\u{1D654}"=>"Y", "\u{1D655}"=>"Z", "\u{1D656}"=>"a", "\u{1D657}"=>"b", 
    "\u{1D658}"=>"c", "\u{1D659}"=>"d", "\u{1D65A}"=>"e", "\u{1D65B}"=>"f", "\u{1D65C}"=>"g", "\u{1D65D}"=>"h", "\u{1D65E}"=>"i", "\u{1D65F}"=>"j", "\u{1D660}"=>"k", "\u{1D661}"=>"l", "\u{1D662}"=>"m", "\u{1D663}"=>"n", "\u{1D664}"=>"o", "\u{1D665}"=>"p", "\u{1D666}"=>"q", "\u{1D667}"=>"r", 
    "\u{1D668}"=>"s", "\u{1D669}"=>"t", "\u{1D66A}"=>"u", "\u{1D66B}"=>"v", "\u{1D66C}"=>"w", "\u{1D66D}"=>"x", "\u{1D66E}"=>"y", "\u{1D66F}"=>"z", "\u{1D670}"=>"A", "\u{1D671}"=>"B", "\u{1D672}"=>"C", "\u{1D673}"=>"D", "\u{1D674}"=>"E", "\u{1D675}"=>"F", "\u{1D676}"=>"G", "\u{1D677}"=>"H", 
    "\u{1D678}"=>"I", "\u{1D679}"=>"J", "\u{1D67A}"=>"K", "\u{1D67B}"=>"L", "\u{1D67C}"=>"M", "\u{1D67D}"=>"N", "\u{1D67E}"=>"O", "\u{1D67F}"=>"P", "\u{1D680}"=>"Q", "\u{1D681}"=>"R", "\u{1D682}"=>"S", "\u{1D683}"=>"T", "\u{1D684}"=>"U", "\u{1D685}"=>"V", "\u{1D686}"=>"W", "\u{1D687}"=>"X", 
    "\u{1D688}"=>"Y", "\u{1D689}"=>"Z", "\u{1D68A}"=>"a", "\u{1D68B}"=>"b", "\u{1D68C}"=>"c", "\u{1D68D}"=>"d", "\u{1D68E}"=>"e", "\u{1D68F}"=>"f", "\u{1D690}"=>"g", "\u{1D691}"=>"h", "\u{1D692}"=>"i", "\u{1D693}"=>"j", "\u{1D694}"=>"k", "\u{1D695}"=>"l", "\u{1D696}"=>"m", "\u{1D697}"=>"n", 
    "\u{1D698}"=>"o", "\u{1D699}"=>"p", "\u{1D69A}"=>"q", "\u{1D69B}"=>"r", "\u{1D69C}"=>"s", "\u{1D69D}"=>"t", "\u{1D69E}"=>"u", "\u{1D69F}"=>"v", "\u{1D6A0}"=>"w", "\u{1D6A1}"=>"x", "\u{1D6A2}"=>"y", "\u{1D6A3}"=>"z", "\u{1D6A4}"=>"ı", "\u{1D6A5}"=>"ȷ", "\u{1D6A8}"=>"Α", "\u{1D6A9}"=>"Β", 
    "\u{1D6AA}"=>"Γ", "\u{1D6AB}"=>"Δ", "\u{1D6AC}"=>"Ε", "\u{1D6AD}"=>"Ζ", "\u{1D6AE}"=>"Η", "\u{1D6AF}"=>"Θ", "\u{1D6B0}"=>"Ι", "\u{1D6B1}"=>"Κ", "\u{1D6B2}"=>"Λ", "\u{1D6B3}"=>"Μ", "\u{1D6B4}"=>"Ν", "\u{1D6B5}"=>"Ξ", "\u{1D6B6}"=>"Ο", "\u{1D6B7}"=>"Π", "\u{1D6B8}"=>"Ρ", "\u{1D6B9}"=>"ϴ", 
    "\u{1D6BA}"=>"Σ", "\u{1D6BB}"=>"Τ", "\u{1D6BC}"=>"Υ", "\u{1D6BD}"=>"Φ", "\u{1D6BE}"=>"Χ", "\u{1D6BF}"=>"Ψ", "\u{1D6C0}"=>"Ω", "\u{1D6C1}"=>"∇", "\u{1D6C2}"=>"α", "\u{1D6C3}"=>"β", "\u{1D6C4}"=>"γ", "\u{1D6C5}"=>"δ", "\u{1D6C6}"=>"ε", "\u{1D6C7}"=>"ζ", "\u{1D6C8}"=>"η", "\u{1D6C9}"=>"θ", 
    "\u{1D6CA}"=>"ι", "\u{1D6CB}"=>"κ", "\u{1D6CC}"=>"λ", "\u{1D6CD}"=>"μ", "\u{1D6CE}"=>"ν", "\u{1D6CF}"=>"ξ", "\u{1D6D0}"=>"ο", "\u{1D6D1}"=>"π", "\u{1D6D2}"=>"ρ", "\u{1D6D3}"=>"ς", "\u{1D6D4}"=>"σ", "\u{1D6D5}"=>"τ", "\u{1D6D6}"=>"υ", "\u{1D6D7}"=>"φ", "\u{1D6D8}"=>"χ", "\u{1D6D9}"=>"ψ", 
    "\u{1D6DA}"=>"ω", "\u{1D6DB}"=>"∂", "\u{1D6DC}"=>"ϵ", "\u{1D6DD}"=>"ϑ", "\u{1D6DE}"=>"ϰ", "\u{1D6DF}"=>"ϕ", "\u{1D6E0}"=>"ϱ", "\u{1D6E1}"=>"ϖ", "\u{1D6E2}"=>"Α", "\u{1D6E3}"=>"Β", "\u{1D6E4}"=>"Γ", "\u{1D6E5}"=>"Δ", "\u{1D6E6}"=>"Ε", "\u{1D6E7}"=>"Ζ", "\u{1D6E8}"=>"Η", "\u{1D6E9}"=>"Θ", 
    "\u{1D6EA}"=>"Ι", "\u{1D6EB}"=>"Κ", "\u{1D6EC}"=>"Λ", "\u{1D6ED}"=>"Μ", "\u{1D6EE}"=>"Ν", "\u{1D6EF}"=>"Ξ", "\u{1D6F0}"=>"Ο", "\u{1D6F1}"=>"Π", "\u{1D6F2}"=>"Ρ", "\u{1D6F3}"=>"ϴ", "\u{1D6F4}"=>"Σ", "\u{1D6F5}"=>"Τ", "\u{1D6F6}"=>"Υ", "\u{1D6F7}"=>"Φ", "\u{1D6F8}"=>"Χ", "\u{1D6F9}"=>"Ψ", 
    "\u{1D6FA}"=>"Ω", "\u{1D6FB}"=>"∇", "\u{1D6FC}"=>"α", "\u{1D6FD}"=>"β", "\u{1D6FE}"=>"γ", "\u{1D6FF}"=>"δ", "\u{1D700}"=>"ε", "\u{1D701}"=>"ζ", "\u{1D702}"=>"η", "\u{1D703}"=>"θ", "\u{1D704}"=>"ι", "\u{1D705}"=>"κ", "\u{1D706}"=>"λ", "\u{1D707}"=>"μ", "\u{1D708}"=>"ν", "\u{1D709}"=>"ξ", 
    "\u{1D70A}"=>"ο", "\u{1D70B}"=>"π", "\u{1D70C}"=>"ρ", "\u{1D70D}"=>"ς", "\u{1D70E}"=>"σ", "\u{1D70F}"=>"τ", "\u{1D710}"=>"υ", "\u{1D711}"=>"φ", "\u{1D712}"=>"χ", "\u{1D713}"=>"ψ", "\u{1D714}"=>"ω", "\u{1D715}"=>"∂", "\u{1D716}"=>"ϵ", "\u{1D717}"=>"ϑ", "\u{1D718}"=>"ϰ", "\u{1D719}"=>"ϕ", 
    "\u{1D71A}"=>"ϱ", "\u{1D71B}"=>"ϖ", "\u{1D71C}"=>"Α", "\u{1D71D}"=>"Β", "\u{1D71E}"=>"Γ", "\u{1D71F}"=>"Δ", "\u{1D720}"=>"Ε", "\u{1D721}"=>"Ζ", "\u{1D722}"=>"Η", "\u{1D723}"=>"Θ", "\u{1D724}"=>"Ι", "\u{1D725}"=>"Κ", "\u{1D726}"=>"Λ", "\u{1D727}"=>"Μ", "\u{1D728}"=>"Ν", "\u{1D729}"=>"Ξ", 
    "\u{1D72A}"=>"Ο", "\u{1D72B}"=>"Π", "\u{1D72C}"=>"Ρ", "\u{1D72D}"=>"ϴ", "\u{1D72E}"=>"Σ", "\u{1D72F}"=>"Τ", "\u{1D730}"=>"Υ", "\u{1D731}"=>"Φ", "\u{1D732}"=>"Χ", "\u{1D733}"=>"Ψ", "\u{1D734}"=>"Ω", "\u{1D735}"=>"∇", "\u{1D736}"=>"α", "\u{1D737}"=>"β", "\u{1D738}"=>"γ", "\u{1D739}"=>"δ", 
    "\u{1D73A}"=>"ε", "\u{1D73B}"=>"ζ", "\u{1D73C}"=>"η", "\u{1D73D}"=>"θ", "\u{1D73E}"=>"ι", "\u{1D73F}"=>"κ", "\u{1D740}"=>"λ", "\u{1D741}"=>"μ", "\u{1D742}"=>"ν", "\u{1D743}"=>"ξ", "\u{1D744}"=>"ο", "\u{1D745}"=>"π", "\u{1D746}"=>"ρ", "\u{1D747}"=>"ς", "\u{1D748}"=>"σ", "\u{1D749}"=>"τ", 
    "\u{1D74A}"=>"υ", "\u{1D74B}"=>"φ", "\u{1D74C}"=>"χ", "\u{1D74D}"=>"ψ", "\u{1D74E}"=>"ω", "\u{1D74F}"=>"∂", "\u{1D750}"=>"ϵ", "\u{1D751}"=>"ϑ", "\u{1D752}"=>"ϰ", "\u{1D753}"=>"ϕ", "\u{1D754}"=>"ϱ", "\u{1D755}"=>"ϖ", "\u{1D756}"=>"Α", "\u{1D757}"=>"Β", "\u{1D758}"=>"Γ", "\u{1D759}"=>"Δ", 
    "\u{1D75A}"=>"Ε", "\u{1D75B}"=>"Ζ", "\u{1D75C}"=>"Η", "\u{1D75D}"=>"Θ", "\u{1D75E}"=>"Ι", "\u{1D75F}"=>"Κ", "\u{1D760}"=>"Λ", "\u{1D761}"=>"Μ", "\u{1D762}"=>"Ν", "\u{1D763}"=>"Ξ", "\u{1D764}"=>"Ο", "\u{1D765}"=>"Π", "\u{1D766}"=>"Ρ", "\u{1D767}"=>"ϴ", "\u{1D768}"=>"Σ", "\u{1D769}"=>"Τ", 
    "\u{1D76A}"=>"Υ", "\u{1D76B}"=>"Φ", "\u{1D76C}"=>"Χ", "\u{1D76D}"=>"Ψ", "\u{1D76E}"=>"Ω", "\u{1D76F}"=>"∇", "\u{1D770}"=>"α", "\u{1D771}"=>"β", "\u{1D772}"=>"γ", "\u{1D773}"=>"δ", "\u{1D774}"=>"ε", "\u{1D775}"=>"ζ", "\u{1D776}"=>"η", "\u{1D777}"=>"θ", "\u{1D778}"=>"ι", "\u{1D779}"=>"κ", 
    "\u{1D77A}"=>"λ", "\u{1D77B}"=>"μ", "\u{1D77C}"=>"ν", "\u{1D77D}"=>"ξ", "\u{1D77E}"=>"ο", "\u{1D77F}"=>"π", "\u{1D780}"=>"ρ", "\u{1D781}"=>"ς", "\u{1D782}"=>"σ", "\u{1D783}"=>"τ", "\u{1D784}"=>"υ", "\u{1D785}"=>"φ", "\u{1D786}"=>"χ", "\u{1D787}"=>"ψ", "\u{1D788}"=>"ω", "\u{1D789}"=>"∂", 
    "\u{1D78A}"=>"ϵ", "\u{1D78B}"=>"ϑ", "\u{1D78C}"=>"ϰ", "\u{1D78D}"=>"ϕ", "\u{1D78E}"=>"ϱ", "\u{1D78F}"=>"ϖ", "\u{1D790}"=>"Α", "\u{1D791}"=>"Β", "\u{1D792}"=>"Γ", "\u{1D793}"=>"Δ", "\u{1D794}"=>"Ε", "\u{1D795}"=>"Ζ", "\u{1D796}"=>"Η", "\u{1D797}"=>"Θ", "\u{1D798}"=>"Ι", "\u{1D799}"=>"Κ", 
    "\u{1D79A}"=>"Λ", "\u{1D79B}"=>"Μ", "\u{1D79C}"=>"Ν", "\u{1D79D}"=>"Ξ", "\u{1D79E}"=>"Ο", "\u{1D79F}"=>"Π", "\u{1D7A0}"=>"Ρ", "\u{1D7A1}"=>"ϴ", "\u{1D7A2}"=>"Σ", "\u{1D7A3}"=>"Τ", "\u{1D7A4}"=>"Υ", "\u{1D7A5}"=>"Φ", "\u{1D7A6}"=>"Χ", "\u{1D7A7}"=>"Ψ", "\u{1D7A8}"=>"Ω", "\u{1D7A9}"=>"∇", 
    "\u{1D7AA}"=>"α", "\u{1D7AB}"=>"β", "\u{1D7AC}"=>"γ", "\u{1D7AD}"=>"δ", "\u{1D7AE}"=>"ε", "\u{1D7AF}"=>"ζ", "\u{1D7B0}"=>"η", "\u{1D7B1}"=>"θ", "\u{1D7B2}"=>"ι", "\u{1D7B3}"=>"κ", "\u{1D7B4}"=>"λ", "\u{1D7B5}"=>"μ", "\u{1D7B6}"=>"ν", "\u{1D7B7}"=>"ξ", "\u{1D7B8}"=>"ο", "\u{1D7B9}"=>"π", 
    "\u{1D7BA}"=>"ρ", "\u{1D7BB}"=>"ς", "\u{1D7BC}"=>"σ", "\u{1D7BD}"=>"τ", "\u{1D7BE}"=>"υ", "\u{1D7BF}"=>"φ", "\u{1D7C0}"=>"χ", "\u{1D7C1}"=>"ψ", "\u{1D7C2}"=>"ω", "\u{1D7C3}"=>"∂", "\u{1D7C4}"=>"ϵ", "\u{1D7C5}"=>"ϑ", "\u{1D7C6}"=>"ϰ", "\u{1D7C7}"=>"ϕ", "\u{1D7C8}"=>"ϱ", "\u{1D7C9}"=>"ϖ", 
    "\u{1D7CA}"=>"Ϝ", "\u{1D7CB}"=>"ϝ", "\u{1D7CE}"=>"0", "\u{1D7CF}"=>"1", "\u{1D7D0}"=>"2", "\u{1D7D1}"=>"3", "\u{1D7D2}"=>"4", "\u{1D7D3}"=>"5", "\u{1D7D4}"=>"6", "\u{1D7D5}"=>"7", "\u{1D7D6}"=>"8", "\u{1D7D7}"=>"9", "\u{1D7D8}"=>"0", "\u{1D7D9}"=>"1", "\u{1D7DA}"=>"2", "\u{1D7DB}"=>"3", 
    "\u{1D7DC}"=>"4", "\u{1D7DD}"=>"5", "\u{1D7DE}"=>"6", "\u{1D7DF}"=>"7", "\u{1D7E0}"=>"8", "\u{1D7E1}"=>"9", "\u{1D7E2}"=>"0", "\u{1D7E3}"=>"1", "\u{1D7E4}"=>"2", "\u{1D7E5}"=>"3", "\u{1D7E6}"=>"4", "\u{1D7E7}"=>"5", "\u{1D7E8}"=>"6", "\u{1D7E9}"=>"7", "\u{1D7EA}"=>"8", "\u{1D7EB}"=>"9", 
    "\u{1D7EC}"=>"0", "\u{1D7ED}"=>"1", "\u{1D7EE}"=>"2", "\u{1D7EF}"=>"3", "\u{1D7F0}"=>"4", "\u{1D7F1}"=>"5", "\u{1D7F2}"=>"6", "\u{1D7F3}"=>"7", "\u{1D7F4}"=>"8", "\u{1D7F5}"=>"9", "\u{1D7F6}"=>"0", "\u{1D7F7}"=>"1", "\u{1D7F8}"=>"2", "\u{1D7F9}"=>"3", "\u{1D7FA}"=>"4", "\u{1D7FB}"=>"5", 
    "\u{1D7FC}"=>"6", "\u{1D7FD}"=>"7", "\u{1D7FE}"=>"8", "\u{1D7FF}"=>"9", "\u{1EE00}"=>"ا", "\u{1EE01}"=>"ب", "\u{1EE02}"=>"ج", "\u{1EE03}"=>"د", "\u{1EE05}"=>"و", "\u{1EE06}"=>"ز", "\u{1EE07}"=>"ح", "\u{1EE08}"=>"ط", "\u{1EE09}"=>"ي", "\u{1EE0A}"=>"ك", "\u{1EE0B}"=>"ل", "\u{1EE0C}"=>"م", 
    "\u{1EE0D}"=>"ن", "\u{1EE0E}"=>"س", "\u{1EE0F}"=>"ع", "\u{1EE10}"=>"ف", "\u{1EE11}"=>"ص", "\u{1EE12}"=>"ق", "\u{1EE13}"=>"ر", "\u{1EE14}"=>"ش", "\u{1EE15}"=>"ت", "\u{1EE16}"=>"ث", "\u{1EE17}"=>"خ", "\u{1EE18}"=>"ذ", "\u{1EE19}"=>"ض", "\u{1EE1A}"=>"ظ", "\u{1EE1B}"=>"غ", "\u{1EE1C}"=>"ٮ", 
    "\u{1EE1D}"=>"ں", "\u{1EE1E}"=>"ڡ", "\u{1EE1F}"=>"ٯ", "\u{1EE21}"=>"ب", "\u{1EE22}"=>"ج", "\u{1EE24}"=>"ه", "\u{1EE27}"=>"ح", "\u{1EE29}"=>"ي", "\u{1EE2A}"=>"ك", "\u{1EE2B}"=>"ل", "\u{1EE2C}"=>"م", "\u{1EE2D}"=>"ن", "\u{1EE2E}"=>"س", "\u{1EE2F}"=>"ع", "\u{1EE30}"=>"ف", "\u{1EE31}"=>"ص", 
    "\u{1EE32}"=>"ق", "\u{1EE34}"=>"ش", "\u{1EE35}"=>"ت", "\u{1EE36}"=>"ث", "\u{1EE37}"=>"خ", "\u{1EE39}"=>"ض", "\u{1EE3B}"=>"غ", "\u{1EE42}"=>"ج", "\u{1EE47}"=>"ح", "\u{1EE49}"=>"ي", "\u{1EE4B}"=>"ل", "\u{1EE4D}"=>"ن", "\u{1EE4E}"=>"س", "\u{1EE4F}"=>"ع", "\u{1EE51}"=>"ص", "\u{1EE52}"=>"ق", 
    "\u{1EE54}"=>"ش", "\u{1EE57}"=>"خ", "\u{1EE59}"=>"ض", "\u{1EE5B}"=>"غ", "\u{1EE5D}"=>"ں", "\u{1EE5F}"=>"ٯ", "\u{1EE61}"=>"ب", "\u{1EE62}"=>"ج", "\u{1EE64}"=>"ه", "\u{1EE67}"=>"ح", "\u{1EE68}"=>"ط", "\u{1EE69}"=>"ي", "\u{1EE6A}"=>"ك", "\u{1EE6C}"=>"م", "\u{1EE6D}"=>"ن", "\u{1EE6E}"=>"س", 
    "\u{1EE6F}"=>"ع", "\u{1EE70}"=>"ف", "\u{1EE71}"=>"ص", "\u{1EE72}"=>"ق", "\u{1EE74}"=>"ش", "\u{1EE75}"=>"ت", "\u{1EE76}"=>"ث", "\u{1EE77}"=>"خ", "\u{1EE79}"=>"ض", "\u{1EE7A}"=>"ظ", "\u{1EE7B}"=>"غ", "\u{1EE7C}"=>"ٮ", "\u{1EE7E}"=>"ڡ", "\u{1EE80}"=>"ا", "\u{1EE81}"=>"ب", "\u{1EE82}"=>"ج", 
    "\u{1EE83}"=>"د", "\u{1EE84}"=>"ه", "\u{1EE85}"=>"و", "\u{1EE86}"=>"ز", "\u{1EE87}"=>"ح", "\u{1EE88}"=>"ط", "\u{1EE89}"=>"ي", "\u{1EE8B}"=>"ل", "\u{1EE8C}"=>"م", "\u{1EE8D}"=>"ن", "\u{1EE8E}"=>"س", "\u{1EE8F}"=>"ع", "\u{1EE90}"=>"ف", "\u{1EE91}"=>"ص", "\u{1EE92}"=>"ق", "\u{1EE93}"=>"ر", 
    "\u{1EE94}"=>"ش", "\u{1EE95}"=>"ت", "\u{1EE96}"=>"ث", "\u{1EE97}"=>"خ", "\u{1EE98}"=>"ذ", "\u{1EE99}"=>"ض", "\u{1EE9A}"=>"ظ", "\u{1EE9B}"=>"غ", "\u{1EEA1}"=>"ب", "\u{1EEA2}"=>"ج", "\u{1EEA3}"=>"د", "\u{1EEA5}"=>"و", "\u{1EEA6}"=>"ز", "\u{1EEA7}"=>"ح", "\u{1EEA8}"=>"ط", "\u{1EEA9}"=>"ي", 
    "\u{1EEAB}"=>"ل", "\u{1EEAC}"=>"م", "\u{1EEAD}"=>"ن", "\u{1EEAE}"=>"س", "\u{1EEAF}"=>"ع", "\u{1EEB0}"=>"ف", "\u{1EEB1}"=>"ص", "\u{1EEB2}"=>"ق", "\u{1EEB3}"=>"ر", "\u{1EEB4}"=>"ش", "\u{1EEB5}"=>"ت", "\u{1EEB6}"=>"ث", "\u{1EEB7}"=>"خ", "\u{1EEB8}"=>"ذ", "\u{1EEB9}"=>"ض", "\u{1EEBA}"=>"ظ", 
    "\u{1EEBB}"=>"غ", "\u{1F100}"=>"0.", "\u{1F101}"=>"0,", "\u{1F102}"=>"1,", "\u{1F103}"=>"2,", "\u{1F104}"=>"3,", "\u{1F105}"=>"4,", "\u{1F106}"=>"5,", "\u{1F107}"=>"6,", "\u{1F108}"=>"7,", "\u{1F109}"=>"8,", "\u{1F10A}"=>"9,", "\u{1F110}"=>"(A)", "\u{1F111}"=>"(B)", "\u{1F112}"=>"(C)", "\u{1F113}"=>"(D)", 
    "\u{1F114}"=>"(E)", "\u{1F115}"=>"(F)", "\u{1F116}"=>"(G)", "\u{1F117}"=>"(H)", "\u{1F118}"=>"(I)", "\u{1F119}"=>"(J)", "\u{1F11A}"=>"(K)", "\u{1F11B}"=>"(L)", "\u{1F11C}"=>"(M)", "\u{1F11D}"=>"(N)", "\u{1F11E}"=>"(O)", "\u{1F11F}"=>"(P)", "\u{1F120}"=>"(Q)", "\u{1F121}"=>"(R)", "\u{1F122}"=>"(S)", "\u{1F123}"=>"(T)", 
    "\u{1F124}"=>"(U)", "\u{1F125}"=>"(V)", "\u{1F126}"=>"(W)", "\u{1F127}"=>"(X)", "\u{1F128}"=>"(Y)", "\u{1F129}"=>"(Z)", "\u{1F12A}"=>"〔S〕", "\u{1F12B}"=>"C", "\u{1F12C}"=>"R", "\u{1F12D}"=>"CD", "\u{1F12E}"=>"WZ", "\u{1F130}"=>"A", "\u{1F131}"=>"B", "\u{1F132}"=>"C", "\u{1F133}"=>"D", "\u{1F134}"=>"E", 
    "\u{1F135}"=>"F", "\u{1F136}"=>"G", "\u{1F137}"=>"H", "\u{1F138}"=>"I", "\u{1F139}"=>"J", "\u{1F13A}"=>"K", "\u{1F13B}"=>"L", "\u{1F13C}"=>"M", "\u{1F13D}"=>"N", "\u{1F13E}"=>"O", "\u{1F13F}"=>"P", "\u{1F140}"=>"Q", "\u{1F141}"=>"R", "\u{1F142}"=>"S", "\u{1F143}"=>"T", "\u{1F144}"=>"U", 
    "\u{1F145}"=>"V", "\u{1F146}"=>"W", "\u{1F147}"=>"X", "\u{1F148}"=>"Y", "\u{1F149}"=>"Z", "\u{1F14A}"=>"HV", "\u{1F14B}"=>"MV", "\u{1F14C}"=>"SD", "\u{1F14D}"=>"SS", "\u{1F14E}"=>"PPV", "\u{1F14F}"=>"WC", "\u{1F16A}"=>"MC", "\u{1F16B}"=>"MD", "\u{1F190}"=>"DJ", "\u{1F200}"=>"ほか", "\u{1F201}"=>"ココ", 
    "\u{1F202}"=>"サ", "\u{1F210}"=>"手", "\u{1F211}"=>"字", "\u{1F212}"=>"双", "\u{1F213}"=>"デ", "\u{1F214}"=>"二", "\u{1F215}"=>"多", "\u{1F216}"=>"解", "\u{1F217}"=>"天", "\u{1F218}"=>"交", "\u{1F219}"=>"映", "\u{1F21A}"=>"無", "\u{1F21B}"=>"料", "\u{1F21C}"=>"前", "\u{1F21D}"=>"後", "\u{1F21E}"=>"再", 
    "\u{1F21F}"=>"新", "\u{1F220}"=>"初", "\u{1F221}"=>"終", "\u{1F222}"=>"生", "\u{1F223}"=>"販", "\u{1F224}"=>"声", "\u{1F225}"=>"吹", "\u{1F226}"=>"演", "\u{1F227}"=>"投", "\u{1F228}"=>"捕", "\u{1F229}"=>"一", "\u{1F22A}"=>"三", "\u{1F22B}"=>"遊", "\u{1F22C}"=>"左", "\u{1F22D}"=>"中", "\u{1F22E}"=>"右", 
    "\u{1F22F}"=>"指", "\u{1F230}"=>"走", "\u{1F231}"=>"打", "\u{1F232}"=>"禁", "\u{1F233}"=>"空", "\u{1F234}"=>"合", "\u{1F235}"=>"満", "\u{1F236}"=>"有", "\u{1F237}"=>"月", "\u{1F238}"=>"申", "\u{1F239}"=>"割", "\u{1F23A}"=>"営", "\u{1F240}"=>"〔本〕", "\u{1F241}"=>"〔三〕", "\u{1F242}"=>"〔二〕", "\u{1F243}"=>"〔安〕", 
    "\u{1F244}"=>"〔点〕", "\u{1F245}"=>"〔打〕", "\u{1F246}"=>"〔盗〕", "\u{1F247}"=>"〔勝〕", "\u{1F248}"=>"〔敗〕", "\u{1F250}"=>"得", "\u{1F251}"=>"可", "΅"=>" \u0308\u0301", "ϓ"=>"Υ\u0301", "ϔ"=>"Υ\u0308", "ẛ"=>"s\u0307", "῁"=>" \u0308\u0342", "῍"=>" \u0313\u0300", "῎"=>" \u0313\u0301", "῏"=>" \u0313\u0342", "῝"=>" \u0314\u0300", 
    "῞"=>" \u0314\u0301", "῟"=>" \u0314\u0342", "῭"=>" \u0308\u0300", "΅"=>" \u0308\u0301", "´"=>" \u0301", " "=>" ", " "=>" ", 
  }

  COMPOSITION_TABLE = {
    "A\u0300"=>"À", "A\u0301"=>"Á", "A\u0302"=>"Â", "A\u0303"=>"Ã", "A\u0308"=>"Ä", "A\u030A"=>"Å", "C\u0327"=>"Ç", "E\u0300"=>"È", "E\u0301"=>"É", "E\u0302"=>"Ê", "E\u0308"=>"Ë", "I\u0300"=>"Ì", "I\u0301"=>"Í", "I\u0302"=>"Î", "I\u0308"=>"Ï", "N\u0303"=>"Ñ", 
    "O\u0300"=>"Ò", "O\u0301"=>"Ó", "O\u0302"=>"Ô", "O\u0303"=>"Õ", "O\u0308"=>"Ö", "U\u0300"=>"Ù", "U\u0301"=>"Ú", "U\u0302"=>"Û", "U\u0308"=>"Ü", "Y\u0301"=>"Ý", "a\u0300"=>"à", "a\u0301"=>"á", "a\u0302"=>"â", "a\u0303"=>"ã", "a\u0308"=>"ä", "a\u030A"=>"å", 
    "c\u0327"=>"ç", "e\u0300"=>"è", "e\u0301"=>"é", "e\u0302"=>"ê", "e\u0308"=>"ë", "i\u0300"=>"ì", "i\u0301"=>"í", "i\u0302"=>"î", "i\u0308"=>"ï", "n\u0303"=>"ñ", "o\u0300"=>"ò", "o\u0301"=>"ó", "o\u0302"=>"ô", "o\u0303"=>"õ", "o\u0308"=>"ö", "u\u0300"=>"ù", 
    "u\u0301"=>"ú", "u\u0302"=>"û", "u\u0308"=>"ü", "y\u0301"=>"ý", "y\u0308"=>"ÿ", "A\u0304"=>"Ā", "a\u0304"=>"ā", "A\u0306"=>"Ă", "a\u0306"=>"ă", "A\u0328"=>"Ą", "a\u0328"=>"ą", "C\u0301"=>"Ć", "c\u0301"=>"ć", "C\u0302"=>"Ĉ", "c\u0302"=>"ĉ", "C\u0307"=>"Ċ", 
    "c\u0307"=>"ċ", "C\u030C"=>"Č", "c\u030C"=>"č", "D\u030C"=>"Ď", "d\u030C"=>"ď", "E\u0304"=>"Ē", "e\u0304"=>"ē", "E\u0306"=>"Ĕ", "e\u0306"=>"ĕ", "E\u0307"=>"Ė", "e\u0307"=>"ė", "E\u0328"=>"Ę", "e\u0328"=>"ę", "E\u030C"=>"Ě", "e\u030C"=>"ě", "G\u0302"=>"Ĝ", 
    "g\u0302"=>"ĝ", "G\u0306"=>"Ğ", "g\u0306"=>"ğ", "G\u0307"=>"Ġ", "g\u0307"=>"ġ", "G\u0327"=>"Ģ", "g\u0327"=>"ģ", "H\u0302"=>"Ĥ", "h\u0302"=>"ĥ", "I\u0303"=>"Ĩ", "i\u0303"=>"ĩ", "I\u0304"=>"Ī", "i\u0304"=>"ī", "I\u0306"=>"Ĭ", "i\u0306"=>"ĭ", "I\u0328"=>"Į", 
    "i\u0328"=>"į", "I\u0307"=>"İ", "J\u0302"=>"Ĵ", "j\u0302"=>"ĵ", "K\u0327"=>"Ķ", "k\u0327"=>"ķ", "L\u0301"=>"Ĺ", "l\u0301"=>"ĺ", "L\u0327"=>"Ļ", "l\u0327"=>"ļ", "L\u030C"=>"Ľ", "l\u030C"=>"ľ", "N\u0301"=>"Ń", "n\u0301"=>"ń", "N\u0327"=>"Ņ", "n\u0327"=>"ņ", 
    "N\u030C"=>"Ň", "n\u030C"=>"ň", "O\u0304"=>"Ō", "o\u0304"=>"ō", "O\u0306"=>"Ŏ", "o\u0306"=>"ŏ", "O\u030B"=>"Ő", "o\u030B"=>"ő", "R\u0301"=>"Ŕ", "r\u0301"=>"ŕ", "R\u0327"=>"Ŗ", "r\u0327"=>"ŗ", "R\u030C"=>"Ř", "r\u030C"=>"ř", "S\u0301"=>"Ś", "s\u0301"=>"ś", 
    "S\u0302"=>"Ŝ", "s\u0302"=>"ŝ", "S\u0327"=>"Ş", "s\u0327"=>"ş", "S\u030C"=>"Š", "s\u030C"=>"š", "T\u0327"=>"Ţ", "t\u0327"=>"ţ", "T\u030C"=>"Ť", "t\u030C"=>"ť", "U\u0303"=>"Ũ", "u\u0303"=>"ũ", "U\u0304"=>"Ū", "u\u0304"=>"ū", "U\u0306"=>"Ŭ", "u\u0306"=>"ŭ", 
    "U\u030A"=>"Ů", "u\u030A"=>"ů", "U\u030B"=>"Ű", "u\u030B"=>"ű", "U\u0328"=>"Ų", "u\u0328"=>"ų", "W\u0302"=>"Ŵ", "w\u0302"=>"ŵ", "Y\u0302"=>"Ŷ", "y\u0302"=>"ŷ", "Y\u0308"=>"Ÿ", "Z\u0301"=>"Ź", "z\u0301"=>"ź", "Z\u0307"=>"Ż", "z\u0307"=>"ż", "Z\u030C"=>"Ž", 
    "z\u030C"=>"ž", "O\u031B"=>"Ơ", "o\u031B"=>"ơ", "U\u031B"=>"Ư", "u\u031B"=>"ư", "A\u030C"=>"Ǎ", "a\u030C"=>"ǎ", "I\u030C"=>"Ǐ", "i\u030C"=>"ǐ", "O\u030C"=>"Ǒ", "o\u030C"=>"ǒ", "U\u030C"=>"Ǔ", "u\u030C"=>"ǔ", "Ü\u0304"=>"Ǖ", "ü\u0304"=>"ǖ", "Ü\u0301"=>"Ǘ", 
    "ü\u0301"=>"ǘ", "Ü\u030C"=>"Ǚ", "ü\u030C"=>"ǚ", "Ü\u0300"=>"Ǜ", "ü\u0300"=>"ǜ", "Ä\u0304"=>"Ǟ", "ä\u0304"=>"ǟ", "Ȧ\u0304"=>"Ǡ", "ȧ\u0304"=>"ǡ", "Æ\u0304"=>"Ǣ", "æ\u0304"=>"ǣ", "G\u030C"=>"Ǧ", "g\u030C"=>"ǧ", "K\u030C"=>"Ǩ", "k\u030C"=>"ǩ", "O\u0328"=>"Ǫ", 
    "o\u0328"=>"ǫ", "Ǫ\u0304"=>"Ǭ", "ǫ\u0304"=>"ǭ", "Ʒ\u030C"=>"Ǯ", "ʒ\u030C"=>"ǯ", "j\u030C"=>"ǰ", "G\u0301"=>"Ǵ", "g\u0301"=>"ǵ", "N\u0300"=>"Ǹ", "n\u0300"=>"ǹ", "Å\u0301"=>"Ǻ", "å\u0301"=>"ǻ", "Æ\u0301"=>"Ǽ", "æ\u0301"=>"ǽ", "Ø\u0301"=>"Ǿ", "ø\u0301"=>"ǿ", 
    "A\u030F"=>"Ȁ", "a\u030F"=>"ȁ", "A\u0311"=>"Ȃ", "a\u0311"=>"ȃ", "E\u030F"=>"Ȅ", "e\u030F"=>"ȅ", "E\u0311"=>"Ȇ", "e\u0311"=>"ȇ", "I\u030F"=>"Ȉ", "i\u030F"=>"ȉ", "I\u0311"=>"Ȋ", "i\u0311"=>"ȋ", "O\u030F"=>"Ȍ", "o\u030F"=>"ȍ", "O\u0311"=>"Ȏ", "o\u0311"=>"ȏ", 
    "R\u030F"=>"Ȑ", "r\u030F"=>"ȑ", "R\u0311"=>"Ȓ", "r\u0311"=>"ȓ", "U\u030F"=>"Ȕ", "u\u030F"=>"ȕ", "U\u0311"=>"Ȗ", "u\u0311"=>"ȗ", "S\u0326"=>"Ș", "s\u0326"=>"ș", "T\u0326"=>"Ț", "t\u0326"=>"ț", "H\u030C"=>"Ȟ", "h\u030C"=>"ȟ", "A\u0307"=>"Ȧ", "a\u0307"=>"ȧ", 
    "E\u0327"=>"Ȩ", "e\u0327"=>"ȩ", "Ö\u0304"=>"Ȫ", "ö\u0304"=>"ȫ", "Õ\u0304"=>"Ȭ", "õ\u0304"=>"ȭ", "O\u0307"=>"Ȯ", "o\u0307"=>"ȯ", "Ȯ\u0304"=>"Ȱ", "ȯ\u0304"=>"ȱ", "Y\u0304"=>"Ȳ", "y\u0304"=>"ȳ", "¨\u0301"=>"΅", "Α\u0301"=>"Ά", "Ε\u0301"=>"Έ", "Η\u0301"=>"Ή", 
    "Ι\u0301"=>"Ί", "Ο\u0301"=>"Ό", "Υ\u0301"=>"Ύ", "Ω\u0301"=>"Ώ", "ϊ\u0301"=>"ΐ", "Ι\u0308"=>"Ϊ", "Υ\u0308"=>"Ϋ", "α\u0301"=>"ά", "ε\u0301"=>"έ", "η\u0301"=>"ή", "ι\u0301"=>"ί", "ϋ\u0301"=>"ΰ", "ι\u0308"=>"ϊ", "υ\u0308"=>"ϋ", "ο\u0301"=>"ό", "υ\u0301"=>"ύ", 
    "ω\u0301"=>"ώ", "ϒ\u0301"=>"ϓ", "ϒ\u0308"=>"ϔ", "Е\u0300"=>"Ѐ", "Е\u0308"=>"Ё", "Г\u0301"=>"Ѓ", "І\u0308"=>"Ї", "К\u0301"=>"Ќ", "И\u0300"=>"Ѝ", "У\u0306"=>"Ў", "И\u0306"=>"Й", "и\u0306"=>"й", "е\u0300"=>"ѐ", "е\u0308"=>"ё", "г\u0301"=>"ѓ", "і\u0308"=>"ї", 
    "к\u0301"=>"ќ", "и\u0300"=>"ѝ", "у\u0306"=>"ў", "Ѵ\u030F"=>"Ѷ", "ѵ\u030F"=>"ѷ", "Ж\u0306"=>"Ӂ", "ж\u0306"=>"ӂ", "А\u0306"=>"Ӑ", "а\u0306"=>"ӑ", "А\u0308"=>"Ӓ", "а\u0308"=>"ӓ", "Е\u0306"=>"Ӗ", "е\u0306"=>"ӗ", "Ә\u0308"=>"Ӛ", "ә\u0308"=>"ӛ", "Ж\u0308"=>"Ӝ", 
    "ж\u0308"=>"ӝ", "З\u0308"=>"Ӟ", "з\u0308"=>"ӟ", "И\u0304"=>"Ӣ", "и\u0304"=>"ӣ", "И\u0308"=>"Ӥ", "и\u0308"=>"ӥ", "О\u0308"=>"Ӧ", "о\u0308"=>"ӧ", "Ө\u0308"=>"Ӫ", "ө\u0308"=>"ӫ", "Э\u0308"=>"Ӭ", "э\u0308"=>"ӭ", "У\u0304"=>"Ӯ", "у\u0304"=>"ӯ", "У\u0308"=>"Ӱ", 
    "у\u0308"=>"ӱ", "У\u030B"=>"Ӳ", "у\u030B"=>"ӳ", "Ч\u0308"=>"Ӵ", "ч\u0308"=>"ӵ", "Ы\u0308"=>"Ӹ", "ы\u0308"=>"ӹ", "ا\u0653"=>"آ", "ا\u0654"=>"أ", "و\u0654"=>"ؤ", "ا\u0655"=>"إ", "ي\u0654"=>"ئ", "ە\u0654"=>"ۀ", "ہ\u0654"=>"ۂ", "ے\u0654"=>"ۓ", "न\u093C"=>"ऩ", 
    "र\u093C"=>"ऱ", "ळ\u093C"=>"ऴ", "ো"=>"ো", "ৌ"=>"ৌ", "ୈ"=>"ୈ", "ୋ"=>"ୋ", "ୌ"=>"ୌ", "ஔ"=>"ஔ", "ொ"=>"ொ", "ோ"=>"ோ", "ௌ"=>"ௌ", "ె\u0C56"=>"ై", "ೀ"=>"ೀ", "ೇ"=>"ೇ", "ೈ"=>"ೈ", "ೊ"=>"ೊ", 
    "ೋ"=>"ೋ", "ൊ"=>"ൊ", "ോ"=>"ോ", "ൌ"=>"ൌ", "ෙ\u0DCA"=>"ේ", "ො"=>"ො", "ො\u0DCA"=>"ෝ", "ෞ"=>"ෞ", "ဦ"=>"ဦ", "ᬆ"=>"ᬆ", "ᬈ"=>"ᬈ", "ᬊ"=>"ᬊ", "ᬌ"=>"ᬌ", "ᬎ"=>"ᬎ", "ᬒ"=>"ᬒ", "ᬻ"=>"ᬻ", 
    "ᬽ"=>"ᬽ", "ᭀ"=>"ᭀ", "ᭁ"=>"ᭁ", "ᭃ"=>"ᭃ", "A\u0325"=>"Ḁ", "a\u0325"=>"ḁ", "B\u0307"=>"Ḃ", "b\u0307"=>"ḃ", "B\u0323"=>"Ḅ", "b\u0323"=>"ḅ", "B\u0331"=>"Ḇ", "b\u0331"=>"ḇ", "Ç\u0301"=>"Ḉ", "ç\u0301"=>"ḉ", "D\u0307"=>"Ḋ", "d\u0307"=>"ḋ", 
    "D\u0323"=>"Ḍ", "d\u0323"=>"ḍ", "D\u0331"=>"Ḏ", "d\u0331"=>"ḏ", "D\u0327"=>"Ḑ", "d\u0327"=>"ḑ", "D\u032D"=>"Ḓ", "d\u032D"=>"ḓ", "Ē\u0300"=>"Ḕ", "ē\u0300"=>"ḕ", "Ē\u0301"=>"Ḗ", "ē\u0301"=>"ḗ", "E\u032D"=>"Ḙ", "e\u032D"=>"ḙ", "E\u0330"=>"Ḛ", "e\u0330"=>"ḛ", 
    "Ȩ\u0306"=>"Ḝ", "ȩ\u0306"=>"ḝ", "F\u0307"=>"Ḟ", "f\u0307"=>"ḟ", "G\u0304"=>"Ḡ", "g\u0304"=>"ḡ", "H\u0307"=>"Ḣ", "h\u0307"=>"ḣ", "H\u0323"=>"Ḥ", "h\u0323"=>"ḥ", "H\u0308"=>"Ḧ", "h\u0308"=>"ḧ", "H\u0327"=>"Ḩ", "h\u0327"=>"ḩ", "H\u032E"=>"Ḫ", "h\u032E"=>"ḫ", 
    "I\u0330"=>"Ḭ", "i\u0330"=>"ḭ", "Ï\u0301"=>"Ḯ", "ï\u0301"=>"ḯ", "K\u0301"=>"Ḱ", "k\u0301"=>"ḱ", "K\u0323"=>"Ḳ", "k\u0323"=>"ḳ", "K\u0331"=>"Ḵ", "k\u0331"=>"ḵ", "L\u0323"=>"Ḷ", "l\u0323"=>"ḷ", "Ḷ\u0304"=>"Ḹ", "ḷ\u0304"=>"ḹ", "L\u0331"=>"Ḻ", "l\u0331"=>"ḻ", 
    "L\u032D"=>"Ḽ", "l\u032D"=>"ḽ", "M\u0301"=>"Ḿ", "m\u0301"=>"ḿ", "M\u0307"=>"Ṁ", "m\u0307"=>"ṁ", "M\u0323"=>"Ṃ", "m\u0323"=>"ṃ", "N\u0307"=>"Ṅ", "n\u0307"=>"ṅ", "N\u0323"=>"Ṇ", "n\u0323"=>"ṇ", "N\u0331"=>"Ṉ", "n\u0331"=>"ṉ", "N\u032D"=>"Ṋ", "n\u032D"=>"ṋ", 
    "Õ\u0301"=>"Ṍ", "õ\u0301"=>"ṍ", "Õ\u0308"=>"Ṏ", "õ\u0308"=>"ṏ", "Ō\u0300"=>"Ṑ", "ō\u0300"=>"ṑ", "Ō\u0301"=>"Ṓ", "ō\u0301"=>"ṓ", "P\u0301"=>"Ṕ", "p\u0301"=>"ṕ", "P\u0307"=>"Ṗ", "p\u0307"=>"ṗ", "R\u0307"=>"Ṙ", "r\u0307"=>"ṙ", "R\u0323"=>"Ṛ", "r\u0323"=>"ṛ", 
    "Ṛ\u0304"=>"Ṝ", "ṛ\u0304"=>"ṝ", "R\u0331"=>"Ṟ", "r\u0331"=>"ṟ", "S\u0307"=>"Ṡ", "s\u0307"=>"ṡ", "S\u0323"=>"Ṣ", "s\u0323"=>"ṣ", "Ś\u0307"=>"Ṥ", "ś\u0307"=>"ṥ", "Š\u0307"=>"Ṧ", "š\u0307"=>"ṧ", "Ṣ\u0307"=>"Ṩ", "ṣ\u0307"=>"ṩ", "T\u0307"=>"Ṫ", "t\u0307"=>"ṫ", 
    "T\u0323"=>"Ṭ", "t\u0323"=>"ṭ", "T\u0331"=>"Ṯ", "t\u0331"=>"ṯ", "T\u032D"=>"Ṱ", "t\u032D"=>"ṱ", "U\u0324"=>"Ṳ", "u\u0324"=>"ṳ", "U\u0330"=>"Ṵ", "u\u0330"=>"ṵ", "U\u032D"=>"Ṷ", "u\u032D"=>"ṷ", "Ũ\u0301"=>"Ṹ", "ũ\u0301"=>"ṹ", "Ū\u0308"=>"Ṻ", "ū\u0308"=>"ṻ", 
    "V\u0303"=>"Ṽ", "v\u0303"=>"ṽ", "V\u0323"=>"Ṿ", "v\u0323"=>"ṿ", "W\u0300"=>"Ẁ", "w\u0300"=>"ẁ", "W\u0301"=>"Ẃ", "w\u0301"=>"ẃ", "W\u0308"=>"Ẅ", "w\u0308"=>"ẅ", "W\u0307"=>"Ẇ", "w\u0307"=>"ẇ", "W\u0323"=>"Ẉ", "w\u0323"=>"ẉ", "X\u0307"=>"Ẋ", "x\u0307"=>"ẋ", 
    "X\u0308"=>"Ẍ", "x\u0308"=>"ẍ", "Y\u0307"=>"Ẏ", "y\u0307"=>"ẏ", "Z\u0302"=>"Ẑ", "z\u0302"=>"ẑ", "Z\u0323"=>"Ẓ", "z\u0323"=>"ẓ", "Z\u0331"=>"Ẕ", "z\u0331"=>"ẕ", "h\u0331"=>"ẖ", "t\u0308"=>"ẗ", "w\u030A"=>"ẘ", "y\u030A"=>"ẙ", "ſ\u0307"=>"ẛ", "A\u0323"=>"Ạ", 
    "a\u0323"=>"ạ", "A\u0309"=>"Ả", "a\u0309"=>"ả", "Â\u0301"=>"Ấ", "â\u0301"=>"ấ", "Â\u0300"=>"Ầ", "â\u0300"=>"ầ", "Â\u0309"=>"Ẩ", "â\u0309"=>"ẩ", "Â\u0303"=>"Ẫ", "â\u0303"=>"ẫ", "Ạ\u0302"=>"Ậ", "ạ\u0302"=>"ậ", "Ă\u0301"=>"Ắ", "ă\u0301"=>"ắ", "Ă\u0300"=>"Ằ", 
    "ă\u0300"=>"ằ", "Ă\u0309"=>"Ẳ", "ă\u0309"=>"ẳ", "Ă\u0303"=>"Ẵ", "ă\u0303"=>"ẵ", "Ạ\u0306"=>"Ặ", "ạ\u0306"=>"ặ", "E\u0323"=>"Ẹ", "e\u0323"=>"ẹ", "E\u0309"=>"Ẻ", "e\u0309"=>"ẻ", "E\u0303"=>"Ẽ", "e\u0303"=>"ẽ", "Ê\u0301"=>"Ế", "ê\u0301"=>"ế", "Ê\u0300"=>"Ề", 
    "ê\u0300"=>"ề", "Ê\u0309"=>"Ể", "ê\u0309"=>"ể", "Ê\u0303"=>"Ễ", "ê\u0303"=>"ễ", "Ẹ\u0302"=>"Ệ", "ẹ\u0302"=>"ệ", "I\u0309"=>"Ỉ", "i\u0309"=>"ỉ", "I\u0323"=>"Ị", "i\u0323"=>"ị", "O\u0323"=>"Ọ", "o\u0323"=>"ọ", "O\u0309"=>"Ỏ", "o\u0309"=>"ỏ", "Ô\u0301"=>"Ố", 
    "ô\u0301"=>"ố", "Ô\u0300"=>"Ồ", "ô\u0300"=>"ồ", "Ô\u0309"=>"Ổ", "ô\u0309"=>"ổ", "Ô\u0303"=>"Ỗ", "ô\u0303"=>"ỗ", "Ọ\u0302"=>"Ộ", "ọ\u0302"=>"ộ", "Ơ\u0301"=>"Ớ", "ơ\u0301"=>"ớ", "Ơ\u0300"=>"Ờ", "ơ\u0300"=>"ờ", "Ơ\u0309"=>"Ở", "ơ\u0309"=>"ở", "Ơ\u0303"=>"Ỡ", 
    "ơ\u0303"=>"ỡ", "Ơ\u0323"=>"Ợ", "ơ\u0323"=>"ợ", "U\u0323"=>"Ụ", "u\u0323"=>"ụ", "U\u0309"=>"Ủ", "u\u0309"=>"ủ", "Ư\u0301"=>"Ứ", "ư\u0301"=>"ứ", "Ư\u0300"=>"Ừ", "ư\u0300"=>"ừ", "Ư\u0309"=>"Ử", "ư\u0309"=>"ử", "Ư\u0303"=>"Ữ", "ư\u0303"=>"ữ", "Ư\u0323"=>"Ự", 
    "ư\u0323"=>"ự", "Y\u0300"=>"Ỳ", "y\u0300"=>"ỳ", "Y\u0323"=>"Ỵ", "y\u0323"=>"ỵ", "Y\u0309"=>"Ỷ", "y\u0309"=>"ỷ", "Y\u0303"=>"Ỹ", "y\u0303"=>"ỹ", "α\u0313"=>"ἀ", "α\u0314"=>"ἁ", "ἀ\u0300"=>"ἂ", "ἁ\u0300"=>"ἃ", "ἀ\u0301"=>"ἄ", "ἁ\u0301"=>"ἅ", "ἀ\u0342"=>"ἆ", 
    "ἁ\u0342"=>"ἇ", "Α\u0313"=>"Ἀ", "Α\u0314"=>"Ἁ", "Ἀ\u0300"=>"Ἂ", "Ἁ\u0300"=>"Ἃ", "Ἀ\u0301"=>"Ἄ", "Ἁ\u0301"=>"Ἅ", "Ἀ\u0342"=>"Ἆ", "Ἁ\u0342"=>"Ἇ", "ε\u0313"=>"ἐ", "ε\u0314"=>"ἑ", "ἐ\u0300"=>"ἒ", "ἑ\u0300"=>"ἓ", "ἐ\u0301"=>"ἔ", "ἑ\u0301"=>"ἕ", "Ε\u0313"=>"Ἐ", 
    "Ε\u0314"=>"Ἑ", "Ἐ\u0300"=>"Ἒ", "Ἑ\u0300"=>"Ἓ", "Ἐ\u0301"=>"Ἔ", "Ἑ\u0301"=>"Ἕ", "η\u0313"=>"ἠ", "η\u0314"=>"ἡ", "ἠ\u0300"=>"ἢ", "ἡ\u0300"=>"ἣ", "ἠ\u0301"=>"ἤ", "ἡ\u0301"=>"ἥ", "ἠ\u0342"=>"ἦ", "ἡ\u0342"=>"ἧ", "Η\u0313"=>"Ἠ", "Η\u0314"=>"Ἡ", "Ἠ\u0300"=>"Ἢ", 
    "Ἡ\u0300"=>"Ἣ", "Ἠ\u0301"=>"Ἤ", "Ἡ\u0301"=>"Ἥ", "Ἠ\u0342"=>"Ἦ", "Ἡ\u0342"=>"Ἧ", "ι\u0313"=>"ἰ", "ι\u0314"=>"ἱ", "ἰ\u0300"=>"ἲ", "ἱ\u0300"=>"ἳ", "ἰ\u0301"=>"ἴ", "ἱ\u0301"=>"ἵ", "ἰ\u0342"=>"ἶ", "ἱ\u0342"=>"ἷ", "Ι\u0313"=>"Ἰ", "Ι\u0314"=>"Ἱ", "Ἰ\u0300"=>"Ἲ", 
    "Ἱ\u0300"=>"Ἳ", "Ἰ\u0301"=>"Ἴ", "Ἱ\u0301"=>"Ἵ", "Ἰ\u0342"=>"Ἶ", "Ἱ\u0342"=>"Ἷ", "ο\u0313"=>"ὀ", "ο\u0314"=>"ὁ", "ὀ\u0300"=>"ὂ", "ὁ\u0300"=>"ὃ", "ὀ\u0301"=>"ὄ", "ὁ\u0301"=>"ὅ", "Ο\u0313"=>"Ὀ", "Ο\u0314"=>"Ὁ", "Ὀ\u0300"=>"Ὂ", "Ὁ\u0300"=>"Ὃ", "Ὀ\u0301"=>"Ὄ", 
    "Ὁ\u0301"=>"Ὅ", "υ\u0313"=>"ὐ", "υ\u0314"=>"ὑ", "ὐ\u0300"=>"ὒ", "ὑ\u0300"=>"ὓ", "ὐ\u0301"=>"ὔ", "ὑ\u0301"=>"ὕ", "ὐ\u0342"=>"ὖ", "ὑ\u0342"=>"ὗ", "Υ\u0314"=>"Ὑ", "Ὑ\u0300"=>"Ὓ", "Ὑ\u0301"=>"Ὕ", "Ὑ\u0342"=>"Ὗ", "ω\u0313"=>"ὠ", "ω\u0314"=>"ὡ", "ὠ\u0300"=>"ὢ", 
    "ὡ\u0300"=>"ὣ", "ὠ\u0301"=>"ὤ", "ὡ\u0301"=>"ὥ", "ὠ\u0342"=>"ὦ", "ὡ\u0342"=>"ὧ", "Ω\u0313"=>"Ὠ", "Ω\u0314"=>"Ὡ", "Ὠ\u0300"=>"Ὢ", "Ὡ\u0300"=>"Ὣ", "Ὠ\u0301"=>"Ὤ", "Ὡ\u0301"=>"Ὥ", "Ὠ\u0342"=>"Ὦ", "Ὡ\u0342"=>"Ὧ", "α\u0300"=>"ὰ", "ε\u0300"=>"ὲ", "η\u0300"=>"ὴ", 
    "ι\u0300"=>"ὶ", "ο\u0300"=>"ὸ", "υ\u0300"=>"ὺ", "ω\u0300"=>"ὼ", "ἀ\u0345"=>"ᾀ", "ἁ\u0345"=>"ᾁ", "ἂ\u0345"=>"ᾂ", "ἃ\u0345"=>"ᾃ", "ἄ\u0345"=>"ᾄ", "ἅ\u0345"=>"ᾅ", "ἆ\u0345"=>"ᾆ", "ἇ\u0345"=>"ᾇ", "Ἀ\u0345"=>"ᾈ", "Ἁ\u0345"=>"ᾉ", "Ἂ\u0345"=>"ᾊ", "Ἃ\u0345"=>"ᾋ", 
    "Ἄ\u0345"=>"ᾌ", "Ἅ\u0345"=>"ᾍ", "Ἆ\u0345"=>"ᾎ", "Ἇ\u0345"=>"ᾏ", "ἠ\u0345"=>"ᾐ", "ἡ\u0345"=>"ᾑ", "ἢ\u0345"=>"ᾒ", "ἣ\u0345"=>"ᾓ", "ἤ\u0345"=>"ᾔ", "ἥ\u0345"=>"ᾕ", "ἦ\u0345"=>"ᾖ", "ἧ\u0345"=>"ᾗ", "Ἠ\u0345"=>"ᾘ", "Ἡ\u0345"=>"ᾙ", "Ἢ\u0345"=>"ᾚ", "Ἣ\u0345"=>"ᾛ", 
    "Ἤ\u0345"=>"ᾜ", "Ἥ\u0345"=>"ᾝ", "Ἦ\u0345"=>"ᾞ", "Ἧ\u0345"=>"ᾟ", "ὠ\u0345"=>"ᾠ", "ὡ\u0345"=>"ᾡ", "ὢ\u0345"=>"ᾢ", "ὣ\u0345"=>"ᾣ", "ὤ\u0345"=>"ᾤ", "ὥ\u0345"=>"ᾥ", "ὦ\u0345"=>"ᾦ", "ὧ\u0345"=>"ᾧ", "Ὠ\u0345"=>"ᾨ", "Ὡ\u0345"=>"ᾩ", "Ὢ\u0345"=>"ᾪ", "Ὣ\u0345"=>"ᾫ", 
    "Ὤ\u0345"=>"ᾬ", "Ὥ\u0345"=>"ᾭ", "Ὦ\u0345"=>"ᾮ", "Ὧ\u0345"=>"ᾯ", "α\u0306"=>"ᾰ", "α\u0304"=>"ᾱ", "ὰ\u0345"=>"ᾲ", "α\u0345"=>"ᾳ", "ά\u0345"=>"ᾴ", "α\u0342"=>"ᾶ", "ᾶ\u0345"=>"ᾷ", "Α\u0306"=>"Ᾰ", "Α\u0304"=>"Ᾱ", "Α\u0300"=>"Ὰ", "Α\u0345"=>"ᾼ", "¨\u0342"=>"῁", 
    "ὴ\u0345"=>"ῂ", "η\u0345"=>"ῃ", "ή\u0345"=>"ῄ", "η\u0342"=>"ῆ", "ῆ\u0345"=>"ῇ", "Ε\u0300"=>"Ὲ", "Η\u0300"=>"Ὴ", "Η\u0345"=>"ῌ", "᾿\u0300"=>"῍", "᾿\u0301"=>"῎", "᾿\u0342"=>"῏", "ι\u0306"=>"ῐ", "ι\u0304"=>"ῑ", "ϊ\u0300"=>"ῒ", "ι\u0342"=>"ῖ", "ϊ\u0342"=>"ῗ", 
    "Ι\u0306"=>"Ῐ", "Ι\u0304"=>"Ῑ", "Ι\u0300"=>"Ὶ", "῾\u0300"=>"῝", "῾\u0301"=>"῞", "῾\u0342"=>"῟", "υ\u0306"=>"ῠ", "υ\u0304"=>"ῡ", "ϋ\u0300"=>"ῢ", "ρ\u0313"=>"ῤ", "ρ\u0314"=>"ῥ", "υ\u0342"=>"ῦ", "ϋ\u0342"=>"ῧ", "Υ\u0306"=>"Ῠ", "Υ\u0304"=>"Ῡ", "Υ\u0300"=>"Ὺ", 
    "Ρ\u0314"=>"Ῥ", "¨\u0300"=>"῭", "ὼ\u0345"=>"ῲ", "ω\u0345"=>"ῳ", "ώ\u0345"=>"ῴ", "ω\u0342"=>"ῶ", "ῶ\u0345"=>"ῷ", "Ο\u0300"=>"Ὸ", "Ω\u0300"=>"Ὼ", "Ω\u0345"=>"ῼ", "←\u0338"=>"↚", "→\u0338"=>"↛", "↔\u0338"=>"↮", "⇐\u0338"=>"⇍", "⇔\u0338"=>"⇎", "⇒\u0338"=>"⇏", 
    "∃\u0338"=>"∄", "∈\u0338"=>"∉", "∋\u0338"=>"∌", "∣\u0338"=>"∤", "∥\u0338"=>"∦", "∼\u0338"=>"≁", "≃\u0338"=>"≄", "≅\u0338"=>"≇", "≈\u0338"=>"≉", "=\u0338"=>"≠", "≡\u0338"=>"≢", "≍\u0338"=>"≭", "<\u0338"=>"≮", ">\u0338"=>"≯", "≤\u0338"=>"≰", "≥\u0338"=>"≱", 
    "≲\u0338"=>"≴", "≳\u0338"=>"≵", "≶\u0338"=>"≸", "≷\u0338"=>"≹", "≺\u0338"=>"⊀", "≻\u0338"=>"⊁", "⊂\u0338"=>"⊄", "⊃\u0338"=>"⊅", "⊆\u0338"=>"⊈", "⊇\u0338"=>"⊉", "⊢\u0338"=>"⊬", "⊨\u0338"=>"⊭", "⊩\u0338"=>"⊮", "⊫\u0338"=>"⊯", "≼\u0338"=>"⋠", "≽\u0338"=>"⋡", 
    "⊑\u0338"=>"⋢", "⊒\u0338"=>"⋣", "⊲\u0338"=>"⋪", "⊳\u0338"=>"⋫", "⊴\u0338"=>"⋬", "⊵\u0338"=>"⋭", "か\u3099"=>"が", "き\u3099"=>"ぎ", "く\u3099"=>"ぐ", "け\u3099"=>"げ", "こ\u3099"=>"ご", "さ\u3099"=>"ざ", "し\u3099"=>"じ", "す\u3099"=>"ず", "せ\u3099"=>"ぜ", "そ\u3099"=>"ぞ", 
    "た\u3099"=>"だ", "ち\u3099"=>"ぢ", "つ\u3099"=>"づ", "て\u3099"=>"で", "と\u3099"=>"ど", "は\u3099"=>"ば", "は\u309A"=>"ぱ", "ひ\u3099"=>"び", "ひ\u309A"=>"ぴ", "ふ\u3099"=>"ぶ", "ふ\u309A"=>"ぷ", "へ\u3099"=>"べ", "へ\u309A"=>"ぺ", "ほ\u3099"=>"ぼ", "ほ\u309A"=>"ぽ", "う\u3099"=>"ゔ", 
    "ゝ\u3099"=>"ゞ", "カ\u3099"=>"ガ", "キ\u3099"=>"ギ", "ク\u3099"=>"グ", "ケ\u3099"=>"ゲ", "コ\u3099"=>"ゴ", "サ\u3099"=>"ザ", "シ\u3099"=>"ジ", "ス\u3099"=>"ズ", "セ\u3099"=>"ゼ", "ソ\u3099"=>"ゾ", "タ\u3099"=>"ダ", "チ\u3099"=>"ヂ", "ツ\u3099"=>"ヅ", "テ\u3099"=>"デ", "ト\u3099"=>"ド", 
    "ハ\u3099"=>"バ", "ハ\u309A"=>"パ", "ヒ\u3099"=>"ビ", "ヒ\u309A"=>"ピ", "フ\u3099"=>"ブ", "フ\u309A"=>"プ", "ヘ\u3099"=>"ベ", "ヘ\u309A"=>"ペ", "ホ\u3099"=>"ボ", "ホ\u309A"=>"ポ", "ウ\u3099"=>"ヴ", "ワ\u3099"=>"ヷ", "ヰ\u3099"=>"ヸ", "ヱ\u3099"=>"ヹ", "ヲ\u3099"=>"ヺ", "ヽ\u3099"=>"ヾ", 
    "\u{11099}\u{110BA}"=>"\u{1109A}", "\u{1109B}\u{110BA}"=>"\u{1109C}", "\u{110A5}\u{110BA}"=>"\u{110AB}", "\u{11131}\u{11127}"=>"\u{1112E}", "\u{11132}\u{11127}"=>"\u{1112F}", 
  }

end