/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.view.facelets.html;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.validator.BeanValidator;
import javax.faces.validator.Validator;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import org.richfaces.component.AbstractGraphValidator;
import org.richfaces.validator.FacesBeanValidator;
import org.richfaces.view.facelets.html.SetupValidatorsParameter;

public class GraphValidatorHandler
extends ComponentHandler {
    private static final Joiner GROUPS_JOINER = Joiner.on(",");
    private static final Function<Class<?>, String> CLASS_TO_NAME = new Function<Class<?>, String>(){

        @Override
        public String apply(Class<?> input) {
            return input.getName();
        }
    };

    public GraphValidatorHandler(ComponentConfig config) {
        super(config);
    }

    private Class<? extends Validator> getBuiltInBeanValidatorClass(FacesContext context) {
        try {
            Validator beanValidator = context.getApplication().createValidator("javax.faces.Bean");
            return beanValidator.getClass();
        }
        catch (FacesException e) {
            return null;
        }
    }

    private void setupValidators(SetupValidatorsParameter parameterObject, UIComponent component) {
        if (component.getChildCount() == 0 && component.getFacetCount() == 0) {
            return;
        }
        Iterator<UIComponent> facetsAndChildren = component.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent child = facetsAndChildren.next();
            if (child instanceof EditableValueHolder) {
                EditableValueHolder input = (EditableValueHolder)((Object)child);
                this.setupValidator(parameterObject, input);
            }
            if (child instanceof AbstractGraphValidator) continue;
            this.setupValidators(parameterObject, child);
        }
    }

    private void setupValidator(SetupValidatorsParameter parameterObject, EditableValueHolder input) {
        boolean addBeanValidator = true;
        Validator defaultValidator = null;
        Validator beanValidator = parameterObject.getValidator();
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator nextValidator = validators[i];
            if (nextValidator.getClass().equals(beanValidator.getClass())) {
                addBeanValidator = false;
                continue;
            }
            if (!nextValidator.getClass().equals(parameterObject.getDefaultValidatorClass())) continue;
            defaultValidator = nextValidator;
        }
        if (defaultValidator != null && defaultValidator instanceof BeanValidator) {
            if (beanValidator instanceof FacesBeanValidator) {
                FacesBeanValidator facesBeanValidator = (FacesBeanValidator)beanValidator;
                facesBeanValidator.setValidateFields(false);
            }
            BeanValidator defaultBeanValidator = (BeanValidator)defaultValidator;
            Class<?>[] groups = parameterObject.getGroups();
            if (null == defaultBeanValidator.getValidationGroups() && null != groups && groups.length > 0) {
                defaultBeanValidator.setValidationGroups(GROUPS_JOINER.join(Iterables.transform(Arrays.asList(groups), CLASS_TO_NAME)));
            }
        }
        if (addBeanValidator) {
            input.addValidator(beanValidator);
        }
    }

    @Override
    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        super.applyNextHandler(ctx, c);
        if (c instanceof AbstractGraphValidator) {
            AbstractGraphValidator graphValidator = (AbstractGraphValidator)c;
            FacesContext facesContext = ctx.getFacesContext();
            SetupValidatorsParameter parameterObject = new SetupValidatorsParameter(graphValidator, this.getBuiltInBeanValidatorClass(facesContext), graphValidator.getGroups());
            if (c.isInView()) {
                this.setupValidators(parameterObject, c);
            } else {
                c.subscribeToEvent(PostAddToViewEvent.class, new FacesBeanValidatorAddListener(parameterObject));
            }
        }
    }

    private class FacesBeanValidatorAddListener
    implements ComponentSystemEventListener,
    StateHolder {
        private final SetupValidatorsParameter parameterObject;

        public FacesBeanValidatorAddListener(SetupValidatorsParameter parameterObject) {
            this.parameterObject = parameterObject;
        }

        @Override
        public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
            GraphValidatorHandler.this.setupValidators(this.parameterObject, event.getComponent());
        }

        @Override
        public Object saveState(FacesContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void restoreState(FacesContext context, Object state) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public void setTransient(boolean newTransientValue) {
            throw new UnsupportedOperationException();
        }
    }
}

