/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import org.richfaces.component.AbstractCalendar;

public final class CalendarHelper {
    protected CalendarHelper() {
    }

    public static Date getAsDate(FacesContext facesContext, AbstractCalendar calendar, Object date) {
        if (date == null) {
            return null;
        }
        Date value = null;
        Converter converter = calendar.getConverter();
        if (converter == null) {
            Application application = facesContext.getApplication();
            converter = application.createConverter(date.getClass());
        }
        if (date instanceof Date) {
            value = (Date)date;
        } else if (date instanceof Calendar) {
            value = ((Calendar)date).getTime();
        } else if (converter != null) {
            value = CalendarHelper.convertStringToDate(facesContext, calendar, converter.getAsString(facesContext, calendar, date));
        } else if (date instanceof String) {
            value = CalendarHelper.convertStringToDate(facesContext, calendar, (String)date);
        } else {
            throw new FacesException("Wrong attibute type or there is no converter for custom attibute type");
        }
        return value;
    }

    public static Date getFormattedDefaultTime(AbstractCalendar calendar) {
        if (calendar == null || calendar.getDefaultTime() == null) {
            return null;
        }
        Object defaultTime = calendar.getDefaultTime();
        if (defaultTime == null) {
            defaultTime = AbstractCalendar.getDefaultValueOfDefaultTime(null, null);
        }
        Date result = null;
        if (defaultTime instanceof Calendar) {
            result = ((Calendar)defaultTime).getTime();
        } else if (defaultTime instanceof Date) {
            result = (Date)defaultTime;
        } else {
            String defaultTimeString = defaultTime.toString();
            String datePattern = CalendarHelper.getDatePatternOrDefault(calendar);
            Pattern pattern = Pattern.compile("\\s*[hHkKma]+[\\W&&\\S]+[hHkKma]+[\\W&&\\S]*[s]*\\s*");
            Matcher matcher = pattern.matcher(datePattern);
            String subTimePattern = "HH:mm:ss";
            if (matcher.find()) {
                subTimePattern = matcher.group().trim();
            }
            SimpleDateFormat format = new SimpleDateFormat(subTimePattern);
            try {
                result = format.parse(defaultTimeString);
            }
            catch (ParseException parseException) {
                result = null;
            }
        }
        return result;
    }

    public static Locale getAsLocale(FacesContext facesContext, UIComponent component) {
        AbstractCalendar calendar = (AbstractCalendar)component;
        if (calendar == null || facesContext == null) {
            return null;
        }
        Object locale = calendar.getLocale();
        return CalendarHelper.getAsLocale(facesContext, calendar, locale);
    }

    public static Locale getAsLocale(FacesContext facesContext, AbstractCalendar calendar, Object locale) {
        if (calendar == null || facesContext == null) {
            return null;
        }
        Locale localeValue = null;
        if (locale instanceof Locale) {
            localeValue = (Locale)locale;
        } else if (locale instanceof String) {
            localeValue = CalendarHelper.parseLocale((String)locale);
        } else if (locale != null) {
            Application application = facesContext.getApplication();
            Converter converter = application.createConverter(locale.getClass());
            if (null != converter) {
                localeValue = CalendarHelper.parseLocale(converter.getAsString(facesContext, calendar, locale));
            } else {
                throw new FacesException("Wrong locale attibute type or there is no converter for custom attibute type");
            }
        }
        return localeValue;
    }

    public static Locale parseLocale(String localeStr) {
        if (null == localeStr || localeStr.trim().length() < 2) {
            return Locale.getDefault();
        }
        int index1 = localeStr.indexOf("_");
        String language = null;
        if (index1 == -1) {
            return new Locale(localeStr);
        }
        language = localeStr.substring(0, index1);
        int index2 = localeStr.indexOf("_", index1 + 1);
        String country = null;
        if (index2 != -1) {
            country = localeStr.substring(index1 + 1, index2);
            String variant = localeStr.substring(index2 + 1);
            return new Locale(language, country, variant);
        }
        country = localeStr.substring(index1 + 1);
        return new Locale(language, country);
    }

    public static Date convertCurrentDate(String currentDateString, FacesContext facesContext, AbstractCalendar calendar) {
        Calendar calendarInner = CalendarHelper.getCalendar(facesContext, calendar);
        calendarInner.clear();
        calendarInner.set(5, 1);
        int idx = currentDateString.indexOf(47);
        Date date = null;
        if (idx != -1) {
            calendarInner.set(2, Integer.parseInt(currentDateString.substring(0, idx)) - 1);
            calendarInner.set(1, Integer.parseInt(currentDateString.substring(idx + 1)));
            date = calendarInner.getTime();
        }
        return date;
    }

    public static Calendar getCalendar(FacesContext facesContext, AbstractCalendar calendar) {
        if (calendar == null || facesContext == null) {
            return Calendar.getInstance();
        }
        return Calendar.getInstance(CalendarHelper.getTimeZoneOrDefault(calendar), CalendarHelper.getAsLocale(facesContext, calendar));
    }

    public static Date convertStringToDate(FacesContext facesContext, AbstractCalendar calendar, String date) {
        DateTimeConverter converter = new DateTimeConverter();
        converter.setPattern(CalendarHelper.getDatePatternOrDefault(calendar));
        converter.setLocale(CalendarHelper.getAsLocale(facesContext, calendar));
        converter.setTimeZone(CalendarHelper.getTimeZoneOrDefault(calendar));
        return (Date)converter.getAsObject(facesContext, calendar, date);
    }

    public static Date getCurrentDateOrDefault(FacesContext facesContext, AbstractCalendar calendar) {
        if (calendar == null || facesContext == null) {
            return null;
        }
        Date date = CalendarHelper.getAsDate(facesContext, calendar, calendar.getCurrentDate());
        if (date == null) {
            date = CalendarHelper.getAsDate(facesContext, calendar, calendar.getValue());
        }
        if (date == null) {
            date = CalendarHelper.getCalendar(facesContext, calendar).getTime();
        }
        return date;
    }

    public static TimeZone getTimeZoneOrDefault(AbstractCalendar calendar) {
        TimeZone value = calendar.getTimeZone();
        if (value == null) {
            value = TimeZone.getDefault();
        }
        return value;
    }

    public static String getDatePatternOrDefault(AbstractCalendar calendar) {
        String value = calendar.getDatePattern();
        if (value == null || "".equals(value)) {
            value = "MMM d, yyyy";
        }
        return value;
    }
}

