/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.util;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;

public final class RequestStateManager {
    private static final String CONTEXT_ATTRIBUTE_NAME = RequestStateManager.class.getName();

    private RequestStateManager() {
    }

    private static Map<String, Object> getStateMap(FacesContext context, boolean create) {
        Map<Object, Object> attributesMap = context.getAttributes();
        HashMap result = (HashMap)attributesMap.get(CONTEXT_ATTRIBUTE_NAME);
        if (create && result == null) {
            result = new HashMap();
            attributesMap.put(CONTEXT_ATTRIBUTE_NAME, result);
        }
        return result;
    }

    public static boolean containsKey(FacesContext context, String key) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        Map<String, Object> stateMap = RequestStateManager.getStateMap(context, false);
        if (stateMap != null) {
            return stateMap.containsKey(key);
        }
        return false;
    }

    public static Object get(FacesContext context, String key) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        Map<String, Object> stateMap = RequestStateManager.getStateMap(context, false);
        if (stateMap != null) {
            return stateMap.get(key);
        }
        return null;
    }

    public static void set(FacesContext context, String key, Object value) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value != null) {
            Map<String, Object> stateMap = RequestStateManager.getStateMap(context, true);
            stateMap.put(key, value);
        } else {
            Map<String, Object> stateMap = RequestStateManager.getStateMap(context, false);
            if (stateMap != null) {
                stateMap.remove(key);
            }
        }
    }

    public static enum BooleanRequestStateVariable {
        LegacyResourceRequest("org.richfaces.LEGACY_RESOURCE_REQUEST"),
        ResourceRequest("org.richfaces.RESOURCE_REQUEST");

        private String attributeName;

        private BooleanRequestStateVariable(String attributeName) {
            this.attributeName = attributeName;
        }

        public Boolean get(FacesContext context) {
            return (Boolean)RequestStateManager.get(context, this.attributeName);
        }

        public void set(FacesContext context, Boolean value) {
            RequestStateManager.set(context, this.attributeName, value);
        }
    }
}

