/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.task;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import javax.activation.MimetypesFileTypeMap;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.richfaces.log.Logger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceSkinUtils;
import org.richfaces.resource.optimizer.Faces;
import org.richfaces.resource.optimizer.ResourceTaskFactory;
import org.richfaces.resource.optimizer.ResourceWriter;
import org.richfaces.resource.optimizer.faces.CurrentResourceContext;
import org.richfaces.resource.optimizer.resource.util.ResourceConstants;
import org.richfaces.resource.optimizer.resource.util.ResourceUtil;
import org.richfaces.util.StreamUtils;

public class ResourceTaskFactoryImpl
implements ResourceTaskFactory {
    private Logger log;
    private Faces faces;
    private ResourceWriter resourceWriter;
    private CompletionService<Object> completionService;
    private String[] skins = new String[0];
    private Predicate<Resource> filter = Predicates.alwaysTrue();
    private String packName;

    public ResourceTaskFactoryImpl(Faces faces, String packName) {
        this.faces = faces;
        this.packName = packName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsELExpression(Resource resource) {
        InputStream is = null;
        try {
            is = resource.getInputStream();
            byte[] bs = StreamUtils.toByteArray(is);
            for (int i = 0; i < bs.length; ++i) {
                byte b = bs[i];
                if (b != 35 || i + 1 >= bs.length || bs[i + 1] != 123) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private boolean shouldCheckForEL(Resource resource) {
        String resourceName = resource.getResourceName();
        return resourceName.endsWith(".js") || resourceName.endsWith(".css");
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    @Override
    public void setResourceWriter(ResourceWriter resourceWriter) {
        this.resourceWriter = resourceWriter;
    }

    @Override
    public void setSkins(String[] skins) {
        this.skins = skins;
    }

    @Override
    public void setCompletionService(CompletionService<Object> completionService) {
        this.completionService = completionService;
    }

    @Override
    public void setFilter(Predicate<Resource> filter) {
        this.filter = filter;
    }

    @Override
    public void submit(Iterable<ResourceKey> locators) {
        for (ResourceKey locator : locators) {
            this.completionService.submit(new ResourcesRendererCallable(locator));
        }
    }

    private class ResourcesRendererCallable
    implements Callable<Object> {
        private ResourceKey resourceKey;
        private boolean skinDependent;
        private boolean skipped = false;

        ResourcesRendererCallable(ResourceKey resourceKey) {
            this.resourceKey = resourceKey;
            if (ResourceTaskFactoryImpl.this.packName != null && ResourceConstants.JSF_COMPRESSED.equals(resourceKey)) {
                this.resourceKey = ResourceConstants.JSF_UNCOMPRESSED;
            }
        }

        private Resource createResource(FacesContext facesContext, ResourceKey resourceInfo) {
            ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
            return resourceHandler.createResource(resourceInfo.getResourceName(), resourceInfo.getLibraryName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renderResource(String skin) {
            ResourceTaskFactoryImpl.this.log.debug("rendering " + this.resourceKey + " (" + skin + ")");
            try {
                FacesContext facesContext = ResourceTaskFactoryImpl.this.faces.startRequest();
                if (skin != null) {
                    ResourceTaskFactoryImpl.this.faces.setSkin(skin);
                }
                Resource resource = this.createResource(facesContext, this.resourceKey);
                CurrentResourceContext.getInstance(facesContext).setResource(resource);
                if (ResourceTaskFactoryImpl.this.shouldCheckForEL(resource) && ResourceTaskFactoryImpl.this.containsELExpression(resource)) {
                    ResourceTaskFactoryImpl.this.log.info(MessageFormat.format("Skipping {0} because it contains EL-expressions", this.resourceKey));
                    return;
                }
                if (ResourceTaskFactoryImpl.this.packName != null) {
                    ResourceTaskFactoryImpl.this.resourceWriter.writePackedResource(ResourceTaskFactoryImpl.this.packName, skin, resource);
                } else {
                    ResourceTaskFactoryImpl.this.resourceWriter.writeResource(skin, resource);
                }
                ResourceTaskFactoryImpl.this.log.debug("rendered " + this.resourceKey + " (" + skin + ")");
            }
            catch (Exception e) {
                ResourceTaskFactoryImpl.this.log.debug("not rendered " + this.resourceKey + " (" + skin + ") - cought exception");
                if (skin != null) {
                    ResourceTaskFactoryImpl.this.log.error(MessageFormat.format("Exception rendering resorce {0} using skin {1}: {2}", this.resourceKey, skin, e.getMessage()), e);
                } else {
                    ResourceTaskFactoryImpl.this.log.error(MessageFormat.format("Exception rendering resorce {0}: {1}", this.resourceKey, e.getMessage()), e);
                }
            }
            finally {
                ResourceTaskFactoryImpl.this.faces.setSkin(null);
                ResourceTaskFactoryImpl.this.faces.stopRequest();
            }
        }

        private void checkResource() {
            ResourceTaskFactoryImpl.this.log.debug("checking " + this.resourceKey);
            try {
                FacesContext facesContext = ResourceTaskFactoryImpl.this.faces.startRequest();
                ResourceTaskFactoryImpl.this.faces.setSkin("DEFAULT");
                Resource resource = this.createResource(facesContext, this.resourceKey);
                if (resource == null) {
                    ResourceTaskFactoryImpl.this.log.warn("null resource for resource key " + this.resourceKey + " (resource rendering will be skipped)");
                    this.skipped = true;
                    return;
                }
                if (!ResourceTaskFactoryImpl.this.filter.apply(resource)) {
                    ResourceTaskFactoryImpl.this.log.debug("filtered out resource: " + this.resourceKey + " (resource rendering will be skipped)");
                    ResourceTaskFactoryImpl.this.log.debug(" - content-type: " + resource.getContentType() + ", qualifier: " + ResourceUtil.getResourceQualifier(resource));
                    this.skipped = true;
                    return;
                }
                String contentType = resource.getContentType();
                if (contentType == null) {
                    ResourceTaskFactoryImpl.this.log.warn("null content type for resource key " + this.resourceKey + " (resource rendering will be skipped)");
                    this.skipped = true;
                    return;
                }
                this.skinDependent = ResourceSkinUtils.isSkinDependent(resource.getRequestPath());
            }
            catch (Exception e) {
                throw (RuntimeException)e;
            }
            finally {
                ResourceTaskFactoryImpl.this.log.debug("checked " + this.resourceKey + ": skinDependent: " + this.skinDependent + ", skipped: " + this.skipped);
                ResourceTaskFactoryImpl.this.faces.setSkin(null);
                ResourceTaskFactoryImpl.this.faces.stopRequest();
            }
        }

        @Override
        public Object call() throws Exception {
            this.checkResource();
            if (this.skipped) {
                ResourceTaskFactoryImpl.this.log.debug("Skipped resource rendering: " + this.resourceKey);
            } else {
                if (this.skinDependent) {
                    for (String skin : ResourceTaskFactoryImpl.this.skins) {
                        if (this.shouldSkipResourceRenderingForSkin(skin)) continue;
                        this.renderResource(skin);
                    }
                } else {
                    this.renderResource(null);
                }
                ResourceTaskFactoryImpl.this.log.debug("Resource rendered: " + this.resourceKey);
            }
            return null;
        }

        private boolean shouldSkipResourceRenderingForSkin(String skin) {
            if ("plain".equals(skin)) {
                File resourceFileName = new File(this.resourceKey.getResourceName());
                String mimeType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(resourceFileName);
                if (mimeType.startsWith("image/")) {
                    ResourceTaskFactoryImpl.this.log.debug(String.format("Skipped rendering of %s as it is image that isn't required by skin %s", this.resourceKey, skin));
                    return true;
                }
            }
            return false;
        }
    }
}

