/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.scan.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import org.reflections.Configuration;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;
import org.richfaces.log.Logger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.optimizer.ResourceLibraryExpander;
import org.richfaces.resource.optimizer.ordering.IllegalPartialOrderingException;
import org.richfaces.resource.optimizer.ordering.PartialOrderToCompleteOrder;
import org.richfaces.resource.optimizer.resource.scan.ResourcesScanner;
import org.richfaces.resource.optimizer.resource.scan.impl.reflections.ReflectionsExt;
import org.richfaces.resource.optimizer.vfs.VFSRoot;
import org.richfaces.resource.optimizer.vfs.VFSType;

public class ResourceOrderingScanner
implements ResourcesScanner {
    private static final Function<ResourceDependency, ResourceKey> RESOURCE_DEPENDENCY_TO_KEY = new Function<ResourceDependency, ResourceKey>(){

        @Override
        public ResourceKey apply(ResourceDependency resourceDependency) {
            return new ResourceKey(resourceDependency.name(), resourceDependency.library());
        }
    };
    private static final Predicate<ResourceDependency> RESOURCE_DEPENDENCY_NOT_BODY = new Predicate<ResourceDependency>(){

        @Override
        public boolean apply(ResourceDependency resourceDependency) {
            return !"body".equals(resourceDependency.target());
        }
    };
    private Collection<ResourceKey> resources = Lists.newLinkedList();
    private PartialOrderToCompleteOrder<ResourceKey> ordering = new PartialOrderToCompleteOrder();
    private Collection<VFSRoot> cpFiles;
    private Logger log;

    public ResourceOrderingScanner(Collection<VFSRoot> cpFiles, Logger log) {
        this.cpFiles = cpFiles;
        this.log = log;
    }

    @Override
    public void scan() throws IOException {
        HashSet<URL> urls = Sets.newHashSet();
        for (VFSRoot cpFile : this.cpFiles) {
            if (cpFile.getType() == VFSType.zip && cpFile.getChild("META-INF/faces-config.xml") == null) continue;
            URL url = cpFile.toURL();
            urls.add(url);
        }
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setUrls(urls);
        configurationBuilder.setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()});
        ReflectionsExt refl = new ReflectionsExt((Configuration)configurationBuilder);
        HashSet<Class<?>> allClasses = Sets.newHashSet();
        this.addAnnotatedClasses(ResourceDependencies.class, refl, allClasses);
        this.addAnnotatedClasses(ResourceDependency.class, refl, allClasses);
        for (Class clazz : allClasses) {
            LinkedList<ResourceDependency> resourceDependencies = Lists.newLinkedList();
            if (clazz.getAnnotation(ResourceDependency.class) != null) {
                resourceDependencies.add(clazz.getAnnotation(ResourceDependency.class));
            }
            if (clazz.getAnnotation(ResourceDependencies.class) != null) {
                resourceDependencies.addAll(Arrays.asList(clazz.getAnnotation(ResourceDependencies.class).value()));
            }
            try {
                this.log.debug(clazz.toString());
                this.addResourceDependencies(resourceDependencies);
            }
            catch (IllegalPartialOrderingException e) {
                throw new IllegalStateException("Exception caught when scanning " + clazz, e);
            }
        }
        this.resources = this.ordering.getCompletelyOrderedItems();
    }

    private void addResourceDependencies(List<ResourceDependency> resourceDependencies) {
        Collection<ResourceDependency> filteredResourceDependencies = Collections2.filter(resourceDependencies, RESOURCE_DEPENDENCY_NOT_BODY);
        Collection<ResourceKey> resourceKeys = Collections2.transform(filteredResourceDependencies, RESOURCE_DEPENDENCY_TO_KEY);
        resourceKeys = new ResourceLibraryExpander().expandResourceLibraries(resourceKeys);
        this.log.debug(resourceKeys.toString());
        this.ordering.addPartialOrdering(resourceKeys);
    }

    private void addAnnotatedClasses(Class<? extends Annotation> annotationClass, ReflectionsExt refl, Collection<Class<?>> allClasses) {
        for (Class annotatedClass : refl.getTypesAnnotatedWith(annotationClass)) {
            allClasses.add(annotatedClass);
        }
    }

    @Override
    public Collection<ResourceKey> getResources() {
        return this.resources;
    }

    public Ordering<ResourceKey> getCompleteOrdering() {
        return this.ordering.getCompleteOrdering();
    }
}

