/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.scan.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.reflections.Configuration;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;
import org.richfaces.resource.DynamicUserResource;
import org.richfaces.resource.ResourceFactory;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.optimizer.resource.scan.ResourcesScanner;
import org.richfaces.resource.optimizer.resource.scan.impl.reflections.MarkerResourcesScanner;
import org.richfaces.resource.optimizer.resource.scan.impl.reflections.ReflectionsExt;
import org.richfaces.resource.optimizer.vfs.VFSRoot;
import org.richfaces.resource.optimizer.vfs.VFSType;

public class DynamicResourcesScanner
implements ResourcesScanner {
    private static final Function<Class<?>, ResourceKey> RESOURCE_LOCATOR_FUNCTION = new Function<Class<?>, ResourceKey>(){

        @Override
        public ResourceKey apply(Class<?> from) {
            ResourceKey key = ResourceKey.create(from.getName());
            return key;
        }
    };
    private static final Predicate<Class<?>> UNINSTANTIATABLE_CLASSES_PREDICATE = new Predicate<Class<?>>(){

        @Override
        public boolean apply(Class<?> input) {
            return !input.isInterface() && !Modifier.isAbstract(input.getModifiers());
        }
    };
    private Collection<ResourceKey> resources = Sets.newHashSet();
    private Collection<VFSRoot> cpFiles;
    private ResourceFactory resourceFactory;

    public DynamicResourcesScanner(Collection<VFSRoot> cpFiles, ResourceFactory resourceFactory) {
        this.cpFiles = cpFiles;
        this.resourceFactory = resourceFactory;
    }

    @Override
    public void scan() throws IOException {
        HashSet<URL> urls = Sets.newHashSet();
        for (VFSRoot cpFile : this.cpFiles) {
            if (cpFile.getType() == VFSType.zip && cpFile.getChild("META-INF/faces-config.xml") == null) continue;
            URL url = cpFile.toURL();
            urls.add(url);
        }
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setUrls(urls);
        configurationBuilder.setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner(), new MarkerResourcesScanner()});
        ReflectionsExt refl = new ReflectionsExt((Configuration)configurationBuilder);
        Collection<Class<?>> allClasses = Sets.newHashSet();
        this.addAnnotatedClasses(DynamicUserResource.class, refl, allClasses);
        allClasses.addAll(refl.getMarkedClasses());
        allClasses = Collections2.filter(allClasses, UNINSTANTIATABLE_CLASSES_PREDICATE);
        this.resources.addAll(Collections2.transform(allClasses, RESOURCE_LOCATOR_FUNCTION));
        this.resources.addAll(this.resourceFactory.getMappedDynamicResourceKeys());
    }

    private void addAnnotatedClasses(Class<? extends Annotation> annotationClass, ReflectionsExt refl, Collection<Class<?>> allClasses) {
        for (Class annotatedClass : refl.getTypesAnnotatedWith(annotationClass)) {
            allClasses.add(annotatedClass);
            allClasses.addAll(refl.getSubTypesOf(annotatedClass));
        }
    }

    @Override
    public Collection<ResourceKey> getResources() {
        return this.resources;
    }
}

