/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.handler.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.richfaces.application.ServiceTracker;
import org.richfaces.resource.ResourceSkinUtils;
import org.richfaces.resource.optimizer.FileNameMapper;
import org.richfaces.resource.optimizer.strings.Constants;

public class DynamicResourceWrapper
extends Resource {
    private static final String ECSS_EXTENSION = ".ecss";
    private Resource resource;

    public DynamicResourceWrapper(Resource resource) {
        this.resource = resource;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    @Override
    public String getContentType() {
        return this.resource.getContentType();
    }

    @Override
    public void setContentType(String contentType) {
        this.resource.setContentType(contentType);
    }

    @Override
    public String getLibraryName() {
        return this.resource.getLibraryName();
    }

    @Override
    public void setLibraryName(String libraryName) {
        this.resource.setLibraryName(libraryName);
    }

    @Override
    public String getResourceName() {
        return this.resource.getResourceName();
    }

    @Override
    public void setResourceName(String resourceName) {
        this.resource.setResourceName(resourceName);
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    private FileNameMapper getFileNameMapper() {
        return ServiceTracker.getService(FileNameMapper.class);
    }

    @Override
    public String getRequestPath() {
        String resourceExtension = this.getResourceExtension();
        String resourceName = this.getResourceName();
        if (resourceName.endsWith(ECSS_EXTENSION)) {
            resourceName = resourceName.substring(0, resourceName.length() - ECSS_EXTENSION.length());
        }
        if (resourceExtension != null && !resourceName.endsWith(resourceExtension)) {
            resourceName = resourceName + resourceExtension;
        }
        String resourcePath = Constants.SLASH_JOINER.join(this.getLibraryName(), resourceName, new Object[0]);
        String filename = this.getFileNameMapper().createName(resourcePath);
        String filenameWithSkinPlaceholder = ResourceSkinUtils.prefixPathWithSkinPlaceholder(filename);
        return filenameWithSkinPlaceholder;
    }

    @Override
    public URL getURL() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean userAgentNeedsUpdate(FacesContext context) {
        throw new UnsupportedOperationException();
    }

    protected String getResourceExtension() {
        String[] split;
        String contentType = this.getContentType();
        if (contentType == null) {
            return null;
        }
        if ((contentType.startsWith("text/") || contentType.startsWith("image/")) && (split = contentType.split("/")).length == 2) {
            return '.' + split[1];
        }
        return null;
    }
}

