/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.mapping;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.richfaces.application.ServiceTracker;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.mapping.ResourceMapping;
import org.richfaces.resource.mapping.ResourceMappingConfiguration;
import org.richfaces.resource.mapping.ResourcePath;

public class ResourceServletMapping
implements ResourceMapping {
    private static final Pattern LN_PATTERN = Pattern.compile("(.*(?:^|&))ln=([^&]*)((?:$|&).*)");
    private static final Pattern AMP_CLEANUP_PATTERN = Pattern.compile("(.*)(?:^&|&$|&+(&))(.*)");
    private final ResourceKey resourceKey;
    private final ResourcePath resourcePath;

    public ResourceServletMapping(ResourceKey resourceKey) {
        if (resourceKey == null) {
            throw new NullPointerException("resourceKey can't be null");
        }
        this.resourceKey = resourceKey;
        this.resourcePath = null;
    }

    public ResourceServletMapping(ResourcePath resourcePath) {
        if (resourcePath == null) {
            throw new NullPointerException("resourceKey can't be null");
        }
        this.resourceKey = null;
        this.resourcePath = resourcePath;
    }

    @Override
    public ResourcePath getResourcePath(FacesContext context) {
        ResourceMappingConfiguration service = ServiceTracker.getService(ResourceMappingConfiguration.class);
        String location = service.getLocation();
        String mappedPath = this.getMappedPath(context);
        return new ResourcePath(location + mappedPath);
    }

    private String getMappedPath(FacesContext context) {
        if (this.resourcePath != null) {
            return this.resourcePath.toExternalForm();
        }
        Resource resource = context.getApplication().getResourceHandler().createResource(this.resourceKey.getResourceName(), this.resourceKey.getLibraryName());
        if (resource == null) {
            return "RESOURCE_NOT_FOUND";
        }
        return ResourceServletMapping.getResourcePath(resource);
    }

    static String getResourcePath(Resource resource) {
        StringBuffer buffer = new StringBuffer();
        String ln = Strings.nullToEmpty(resource.getLibraryName());
        if (!ln.isEmpty()) {
            buffer.append(ln).append("/");
        }
        buffer.append(resource.getResourceName());
        try {
            URI originalRequestPath = new URI("path://" + resource.getRequestPath());
            String query = originalRequestPath.getQuery();
            Matcher matcher = LN_PATTERN.matcher(query);
            if (matcher.matches()) {
                ln = matcher.group(2);
                query = matcher.replaceFirst("$1$3");
                if ((matcher = AMP_CLEANUP_PATTERN.matcher(query)).matches()) {
                    query = matcher.replaceAll("$1$2$3");
                }
            }
            if (!query.isEmpty()) {
                buffer.append("?").append(query);
            }
            return buffer.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(String.format("Failed to parse requestPath '%s' for resource '%s': %s", resource.getRequestPath(), ResourceKey.create(resource), e.getMessage()), e);
        }
    }
}

