/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.ajax4jsf.io.ByteBuffer;
import org.ajax4jsf.io.FastBufferInputStream;
import org.ajax4jsf.io.FastBufferOutputStream;
import org.ajax4jsf.util.HtmlColor;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.renderkit.util.HtmlDimensions;
import org.richfaces.resource.BaseResourceWrapper;
import org.richfaces.resource.ImageType;
import org.richfaces.resource.Java2DUserResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public class Java2DUserResourceWrapperImpl
extends BaseResourceWrapper<Java2DUserResource> {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();

    public Java2DUserResourceWrapperImpl(Java2DUserResource resourceObject, boolean cacheable, boolean versioned) {
        super(resourceObject, cacheable, versioned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        FastBufferOutputStream fbos = new FastBufferOutputStream();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(fbos);
        try {
            this.paintAndWrite(imageOutputStream);
        }
        finally {
            if (imageOutputStream != null) {
                try {
                    imageOutputStream.close();
                }
                catch (IOException e) {
                    LOGGER.debug(e.getMessage(), e);
                }
                try {
                    fbos.close();
                }
                catch (IOException e) {}
            }
        }
        ByteBuffer buffer = fbos.getFirstBuffer();
        buffer.compact();
        return new FastBufferInputStream(buffer);
    }

    protected void write(BufferedImage image, String formatName, ImageOutputStream imageOutputStream) throws IOException {
        ImageIO.write((RenderedImage)image, formatName, imageOutputStream);
    }

    @Override
    public String getContentType() {
        return ((Java2DUserResource)this.getWrapped()).getImageType().getMimeType();
    }

    protected String getValueParameter(FacesContext context, String name) {
        SkinFactory skinFactory = SkinFactory.getInstance(context);
        Skin skin = skinFactory.getSkin(context);
        String value = (String)skin.getParameter(context, name);
        if (value == null || value.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            value = (String)skin.getParameter(context, name);
        }
        return value;
    }

    protected Integer getColorValueParameter(FacesContext context, String name, boolean useDefault) {
        Skin skin = useDefault ? SkinFactory.getInstance(context).getDefaultSkin(context) : SkinFactory.getInstance(context).getSkin(context);
        return this.decodeColor((String)skin.getParameter(context, name));
    }

    protected Integer getHeight(FacesContext context, String heightParamName) {
        SkinFactory skinFactory = SkinFactory.getInstance(context);
        Skin skin = skinFactory.getSkin(context);
        String height = (String)skin.getParameter(context, heightParamName);
        if (height == null || height.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            height = (String)skin.getParameter(context, heightParamName);
        }
        if (height != null && height.length() != 0) {
            return HtmlDimensions.decode(height).intValue();
        }
        return 16;
    }

    protected Integer decodeColor(String value) {
        if (value != null && value.length() != 0) {
            return HtmlColor.decode(value).getRGB();
        }
        return null;
    }

    @Override
    protected Map<String, String> getWrappedResourceResponseHeaders() {
        return ((Java2DUserResource)this.getWrapped()).getResponseHeaders();
    }

    @Override
    protected Date getLastModified(FacesContext context) {
        return ((Java2DUserResource)this.getWrapped()).getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintAndWrite(ImageOutputStream outputStream) throws IOException {
        Java2DUserResource resource = (Java2DUserResource)this.getWrapped();
        ImageType imageType = resource.getImageType();
        BufferedImage image = imageType.createImage(resource.getDimension());
        Graphics2D g2d = null;
        try {
            g2d = this.createGraphics(image);
            resource.paint(g2d);
            ImageIO.write((RenderedImage)image, imageType.getFormatName(), outputStream);
        }
        finally {
            if (g2d != null) {
                g2d.dispose();
            }
        }
    }

    protected Graphics2D createGraphics(BufferedImage image) {
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return g2d;
    }
}

