/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.Uptime;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceCodec;
import org.richfaces.resource.ResourceUtils;
import org.richfaces.resource.VersionedResource;

public abstract class AbstractBaseResource
extends Resource {
    public static final String URL_PROTOCOL = "jsfresource";
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private Date lastModified = null;

    protected AbstractBaseResource() {
    }

    protected int getContentLength(FacesContext context) {
        return -1;
    }

    protected Date getLastModified(FacesContext context) {
        if (this.lastModified == null) {
            this.lastModified = this.getLastModifiedBySource();
        }
        if (this.lastModified == null) {
            this.lastModified = ServiceTracker.getService(Uptime.class).getStartTime();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(MessageFormat.format("Using resource handler start time as last modified date: {0,date,dd MMM yyyy HH:mm:ss zzz}", this.lastModified));
            }
        }
        return this.lastModified;
    }

    private Date getLastModifiedBySource() {
        block8: {
            ClassLoader classLoader = this.getClassLoader();
            if (classLoader == null) {
                return null;
            }
            URL classResource = classLoader.getResource(this.getClass().getName().replace('.', '/') + ".class");
            if (classResource != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(MessageFormat.format("Located source for the resource class: {0}", classResource));
                }
                try {
                    URLConnection connection = classResource.openConnection();
                    connection.setUseCaches(false);
                    long classLastModifiedDate = connection.getLastModified();
                    if (classLastModifiedDate <= 0L) break block8;
                    this.lastModified = new Date(classLastModifiedDate);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(MessageFormat.format("Last source modification date is: {0,date}", this.lastModified));
                    }
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), e);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Source for the resource class has not been located");
            }
        }
        return null;
    }

    protected ClassLoader getClassLoader() {
        Class<?> thisClass = this.getClass();
        ClassLoader classLoader = thisClass.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private String getResourceVersion() {
        if (this instanceof VersionedResource) {
            return ((VersionedResource)((Object)this)).getVersion();
        }
        return null;
    }

    @Override
    public String getRequestPath() {
        FacesContext context = FacesContext.getCurrentInstance();
        ResourceCodec resourceCodec = ServiceTracker.getService(context, ResourceCodec.class);
        String libraryName = this.getLibraryName();
        String resourceName = this.getResourceName();
        Object resourceData = ResourceUtils.saveResourceState(context, this);
        String resourceVersion = this.getResourceVersion();
        String resourceUri = resourceCodec.encodeResourceRequestPath(context, libraryName, resourceName, resourceData, resourceVersion);
        resourceUri = resourceCodec.encodeJSFMapping(context, resourceUri);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(MessageFormat.format("Request path for {0} resource is: {1}", String.valueOf(resourceName), String.valueOf(resourceUri)));
        }
        return resourceUri;
    }

    boolean isResourceRequest() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().getResourceHandler().isResourceRequest(facesContext);
    }

    long getCurrentTime() {
        return System.currentTimeMillis();
    }

    protected void addNoCacheResponseHeaders(FacesContext facesContext, Map<String, String> headers) {
        headers.put("Expires", "0");
        headers.put("Cache-Control", "max-age=0, no-store, no-cache");
        headers.put("Pragma", "no-cache");
    }

    protected void addCacheControlResponseHeaders(FacesContext facesContext, Map<String, String> headers) {
        this.addNoCacheResponseHeaders(facesContext, headers);
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (this.isResourceRequest()) {
            Date lastModified;
            String contentType;
            int contentLength = this.getContentLength(facesContext);
            if (contentLength >= 0) {
                headers.put("Content-Length", String.valueOf(contentLength));
            }
            if ((contentType = this.getContentType()) != null) {
                headers.put("Content-Type", contentType);
            }
            if ((lastModified = this.getLastModified(facesContext)) != null) {
                headers.put("Last-Modified", ResourceUtils.formatHttpDate(lastModified));
            }
            headers.put("Date", ResourceUtils.formatHttpDate(this.getCurrentTime()));
            this.addCacheControlResponseHeaders(facesContext, headers);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created set of response headers");
                for (Map.Entry entry : headers.entrySet()) {
                    LOGGER.debug(MessageFormat.format("\t{0}={1}", entry.getKey(), entry.getValue()));
                }
            }
        }
        return headers;
    }

    @Override
    public URL getURL() {
        try {
            return new URL(URL_PROTOCOL, null, -1, this.getResourceName(), new MyURLStreamHandler());
        }
        catch (MalformedURLException e) {
            throw new FacesException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public boolean userAgentNeedsUpdate(FacesContext context) {
        return true;
    }

    private class MyURLStreamHandler
    extends URLStreamHandler {
        private MyURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new MyURLConnection(u);
        }
    }

    private class MyURLConnection
    extends URLConnection {
        MyURLConnection(URL u) {
            super(u);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public int getContentLength() {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return AbstractBaseResource.this.getContentLength(facesContext);
        }

        @Override
        public String getContentType() {
            return AbstractBaseResource.this.getContentType();
        }

        @Override
        public long getExpiration() {
            return 0L;
        }

        @Override
        public long getLastModified() {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Date date = AbstractBaseResource.this.getLastModified(facesContext);
            if (date != null) {
                return date.getTime();
            }
            return 0L;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return AbstractBaseResource.this.getInputStream();
        }
    }
}

