/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.GifRenderer;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.Zipper;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public class TabStripeImage
extends Java2Dresource {
    private int width = 1;
    private int height = 200;

    public TabStripeImage() {
        this.setRenderer(new GifRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        String colorParameterName;
        Skin skin = SkinFactory.getInstance().getSkin(context);
        String color = (String)skin.getParameter(context, colorParameterName = "panelBorderColor");
        if (color == null || color.length() == 0) {
            Skin defaultSkin = SkinFactory.getInstance().getDefaultSkin(context);
            color = (String)defaultSkin.getParameter(context, colorParameterName);
        }
        if (color == null) {
            return null;
        }
        byte[] ret = new byte[3];
        Zipper.zip(ret, HtmlColor.decode(color).getRGB(), 0);
        return ret;
    }

    protected Dimension getDimensions(ResourceContext resourceContext) {
        return this.getDimensions(null, this.restoreData(resourceContext));
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        return new Dimension(this.width, this.height);
    }

    protected Object deserializeData(byte[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        return new Integer(Zipper.unzip(objectArray, 0));
    }

    protected void paint(ResourceContext context, Graphics2D graphics2D) {
        super.paint(context, graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        Integer tabData = (Integer)this.restoreData(context);
        if (tabData != null) {
            Dimension dimension = this.getDimensions(context);
            Rectangle2D.Double region = new Rectangle2D.Double(0.0, 1.0, dimension.getWidth(), dimension.getHeight() - 1.0);
            graphics2D.setColor(new Color(tabData));
            graphics2D.fill(region);
        }
    }
}

