/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Serializable;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.GifRenderer;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.HtmlDimensions;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.component.UISeparator;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public class SimpleSeparatorImage
extends Java2Dresource {
    private static final int LINE_TYPE_DOTTED = 1;
    private static final int LINE_TYPE_DASHED = 2;
    private static final int LINE_TYPE_DOUBLE = 3;
    private static final int LINE_TYPE_SOLID = 4;

    public SimpleSeparatorImage() {
        this.setRenderer(new GifRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    protected RenderedImage getImage(ResourceContext context) {
        SimpleSeparatorData separatorData = (SimpleSeparatorData)this.restoreData(context);
        Color color = new Color(separatorData.getColor());
        int height = separatorData.getHeight();
        int lineType = separatorData.getLineType();
        if (height <= 0) {
            height = 1;
        }
        Graphics2D g2d = null;
        switch (lineType) {
            case 1: {
                BufferedImage bufferedImage = new BufferedImage(3 * height, height, 2);
                g2d = bufferedImage.createGraphics();
                g2d.setColor(color);
                g2d.fillRect(0, 0, height, height);
                return bufferedImage;
            }
            case 2: {
                BufferedImage bufferedImage = new BufferedImage(4 * height, height, 2);
                g2d = bufferedImage.createGraphics();
                g2d.setColor(color);
                g2d.fillRect(0, 0, 3 * height, height);
                return bufferedImage;
            }
            case 3: {
                BufferedImage bufferedImage = new BufferedImage(1, height, 2);
                int lineHeight = Math.round((float)height / 3.0f);
                g2d = bufferedImage.createGraphics();
                g2d.setColor(color);
                g2d.fillRect(0, 0, 1, lineHeight);
                g2d.fillRect(0, height - lineHeight, 1, lineHeight);
                return bufferedImage;
            }
            case 4: {
                BufferedImage bufferedImage = new BufferedImage(1, height, 2);
                g2d = bufferedImage.createGraphics();
                g2d.setColor(color);
                g2d.fillRect(0, 0, 1, height);
                return bufferedImage;
            }
        }
        return null;
    }

    protected Object deserializeData(byte[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        SimpleSeparatorData separatorData = new SimpleSeparatorData();
        Zipper2 zipper2 = new Zipper2(objectArray);
        separatorData.setHeight(zipper2.nextShort());
        separatorData.setColor(zipper2.nextIntColor());
        separatorData.setLineType(zipper2.nextByte());
        return separatorData;
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        Skin skin = SkinFactory.getInstance().getSkin(context);
        byte[] ret = new byte[6];
        String tmp = (String)((UIComponent)data).getAttributes().get("height");
        int height = tmp == null || "".equals(tmp) ? 6 : HtmlDimensions.decode(tmp).intValue();
        Zipper2 zipper2 = new Zipper2(ret).addShort((short)height);
        String skinParameter = "headerBackgroundColor";
        tmp = (String)skin.getParameter(context, skinParameter);
        if (null == tmp || "".equals(tmp)) {
            Skin defaultSkin = SkinFactory.getInstance().getDefaultSkin(context);
            tmp = (String)defaultSkin.getParameter(context, skinParameter);
        }
        zipper2.addColor(HtmlColor.decode(tmp == null ? "#4169E1" : tmp).getRGB());
        tmp = ((UISeparator)data).getLineType();
        int lineType = 4;
        if (tmp.equalsIgnoreCase("dotted")) {
            lineType = 1;
        } else if (tmp.equalsIgnoreCase("dashed")) {
            lineType = 2;
        } else if (tmp.equalsIgnoreCase("double") && height > 2) {
            lineType = 3;
        }
        zipper2.addByte((byte)lineType);
        return ret;
    }

    protected static class SimpleSeparatorData
    implements Serializable {
        private static final long serialVersionUID = -4420043779436390358L;
        private int height;
        private int color;
        private int lineType;

        protected SimpleSeparatorData() {
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getColor() {
            return this.color;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public int getLineType() {
            return this.lineType;
        }

        public void setLineType(int lineType) {
            this.lineType = lineType;
        }
    }
}

