/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.TooltipMode;
import org.richfaces.application.ServiceTracker;
import org.richfaces.component.AbstractTooltip;
import org.richfaces.component.Positioning;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.html.DivPanelRenderer;
import org.richfaces.renderkit.html.TogglePanelRenderer;
import org.richfaces.renderkit.util.RendererUtils;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="jquery.position.js"), @ResourceDependency(library="org.richfaces", name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="popup.js"), @ResourceDependency(library="org.richfaces", name="tooltip.js"), @ResourceDependency(library="org.richfaces", name="tooltip.ecss")})
public class TooltipRenderer
extends DivPanelRenderer
implements MetaComponentRenderer {
    public static final String HIDE = "hide";
    public static final String SHOW = "show";
    public static final String BEFORE_HIDE = "beforehide";
    public static final String BEFORE_SHOW = "beforeshow";
    private static final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        String compClientId;
        AbstractTooltip tooltip = (AbstractTooltip)component;
        Map<String, String> requestMap = context.getExternalContext().getRequestParameterMap();
        String clientId = requestMap.get(compClientId = component.getClientId(context));
        if (clientId != null && clientId.equals(compClientId)) {
            context.getPartialViewContext().getRenderIds().add(tooltip.getContentClientId(context));
            this.addOnCompleteParam(context, tooltip.getClientId(context));
            context.renderResponse();
        }
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractTooltip tooltip = (AbstractTooltip)component;
        writer.startElement(this.getMarkupElement(tooltip), component);
        writer.writeAttribute("id", component.getClientId(context), "clientId");
        writer.writeAttribute("style", "display: none;", null);
        writer.startElement(this.getMarkupElement(tooltip), component);
        writer.writeAttribute("id", component.getClientId(context) + ":wrp", null);
        writer.writeAttribute("class", this.getStyleClass(component), null);
        int zindex = tooltip.getZindex();
        String style = this.concatStyles("z-index:" + zindex, this.getStyle(component));
        if (style != null && style.trim().length() > 0) {
            writer.writeAttribute("style", style, null);
        }
        RenderKitUtils.renderPassThroughAttributes(context, component, this.getPassThroughAttributes());
        writer.startElement(this.getMarkupElement(tooltip), component);
        writer.writeAttribute("id", component.getClientId(context) + ":cntr", null);
        writer.writeAttribute("class", "rf-tt-cntr", null);
        if (tooltip.getMode() == TooltipMode.ajax) {
            this.encodeLoading(writer, context, tooltip);
        }
        this.encodeContentBegin(writer, context, tooltip);
    }

    private void encodeContentBegin(ResponseWriter writer, FacesContext context, AbstractTooltip tooltip) throws IOException {
        writer.startElement(this.getMarkupElement(tooltip), tooltip);
        writer.writeAttribute("id", tooltip.getClientId(context) + ":content", null);
        writer.writeAttribute("class", "rf-tt-cnt", null);
        Object value = tooltip.getValue();
        if (tooltip.getChildCount() == 0 && value != null) {
            writer.write(value.toString());
        }
    }

    private void encodeLoading(ResponseWriter writer, FacesContext context, AbstractTooltip tooltip) throws IOException {
        writer.startElement(this.getMarkupElement(tooltip), tooltip);
        writer.writeAttribute("id", tooltip.getClientId(context) + ":loading", null);
        writer.writeAttribute("class", "rf-tt-loading", null);
        UIComponent loading = tooltip.getFacet("loading");
        if (loading != null && loading.isRendered()) {
            loading.encodeAll(context);
        } else {
            writer.writeText("Loading...", null);
        }
        writer.endElement(this.getMarkupElement(tooltip));
    }

    private String getMarkupElement(AbstractTooltip component) {
        switch (component.getLayout()) {
            case block: {
                return "div";
            }
            case inline: {
                return "span";
            }
        }
        throw new IllegalStateException("Unknown tooltip layout (=" + (Object)((Object)component.getLayout()) + ")");
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return this.concatClasses("rf-tt", TooltipRenderer.attributeAsString(component, "styleClass"));
    }

    @Override
    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.Tooltip", component.getClientId(context), this.getScriptObjectOptions(context, component));
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        Positioning direction;
        AbstractTooltip tooltip = (AbstractTooltip)component;
        HashMap<String, Object> options = new HashMap<String, Object>();
        RenderKitUtils.addToScriptHash(options, "ajax", TogglePanelRenderer.getAjaxOptions(context, tooltip), (Object)TooltipMode.DEFAULT);
        Positioning jointPoint = tooltip.getJointPoint();
        if (jointPoint == null) {
            jointPoint = Positioning.DEFAULT;
        }
        if ((direction = tooltip.getDirection()) == null) {
            direction = Positioning.DEFAULT;
        }
        RenderKitUtils.addToScriptHash(options, "jointPoint", jointPoint.getValue(), Positioning.DEFAULT.getValue());
        RenderKitUtils.addToScriptHash(options, "direction", direction.getValue(), Positioning.DEFAULT.getValue());
        RenderKitUtils.addToScriptHash(options, "attached", tooltip.isAttached(), true);
        RenderKitUtils.addToScriptHash(options, "offset", this.getOffset(tooltip));
        RenderKitUtils.addToScriptHash(options, "mode", (Object)tooltip.getMode(), (Object)TooltipMode.DEFAULT);
        RenderKitUtils.addToScriptHash(options, "hideDelay", tooltip.getHideDelay(), 0);
        RenderKitUtils.addToScriptHash(options, "hideEvent", tooltip.getHideEvent(), "mouseleave");
        RenderKitUtils.addToScriptHash(options, "showDelay", tooltip.getShowDelay(), 0);
        RenderKitUtils.addToScriptHash(options, "showEvent", tooltip.getShowEvent(), "mouseenter");
        RenderKitUtils.addToScriptHash(options, "followMouse", tooltip.isFollowMouse(), true);
        String target = tooltip.getTarget();
        UIComponent targetComponent = RENDERER_UTILS.findComponentFor(component, target);
        if (targetComponent != null) {
            target = targetComponent.getClientId();
        }
        RenderKitUtils.addToScriptHash(options, "target", target);
        TogglePanelRenderer.addEventOption(context, tooltip, options, HIDE);
        TogglePanelRenderer.addEventOption(context, tooltip, options, SHOW);
        TogglePanelRenderer.addEventOption(context, tooltip, options, BEFORE_HIDE);
        TogglePanelRenderer.addEventOption(context, tooltip, options, BEFORE_SHOW);
        return options;
    }

    public Integer[] getOffset(AbstractTooltip tooltip) {
        int horizontalOffset = tooltip.getHorizontalOffset();
        int verticalOffset = tooltip.getVerticalOffset();
        if (horizontalOffset == Integer.MIN_VALUE) {
            horizontalOffset = 10;
        }
        if (verticalOffset == Integer.MIN_VALUE) {
            verticalOffset = 10;
        }
        return new Integer[]{horizontalOffset, verticalOffset};
    }

    private void encodeContentEnd(ResponseWriter writer, FacesContext context, AbstractTooltip tooltip) throws IOException {
        writer.endElement(this.getMarkupElement(tooltip));
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.encodeContentEnd(writer, context, (AbstractTooltip)component);
        writer.endElement(this.getMarkupElement((AbstractTooltip)component));
        writer.endElement(this.getMarkupElement((AbstractTooltip)component));
        this.writeJavaScript(writer, context, component);
        writer.endElement(this.getMarkupElement((AbstractTooltip)component));
    }

    @Override
    protected void writeJavaScript(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        JSObject script = this.getScriptObject(context, component);
        if (script == null) {
            return;
        }
        JavaScriptService javaScriptService = ServiceTracker.getService(JavaScriptService.class);
        javaScriptService.addScript(context, script);
    }

    @Override
    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        if ("content".equals(metaComponentId)) {
            AbstractTooltip tooltip = (AbstractTooltip)component;
            PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
            writer.startUpdate(tooltip.getClientId(context) + ":" + "content");
            this.encodeContentBegin(writer, context, tooltip);
            for (UIComponent child : tooltip.getChildren()) {
                child.encodeAll(context);
            }
            this.encodeContentEnd(writer, context, tooltip);
            writer.endUpdate();
        }
    }

    @Override
    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractTooltip.class;
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractTooltip tooltip = (AbstractTooltip)component;
        if (tooltip.getMode() == TooltipMode.client && tooltip.getChildCount() > 0) {
            for (UIComponent kid : tooltip.getChildren()) {
                kid.encodeAll(context);
            }
        }
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }
}

