/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.AbstractToolbar;
import org.richfaces.component.AbstractToolbarGroup;
import org.richfaces.renderkit.html.ToolbarRendererBase;

public class ToolbarGroupRenderer
extends ToolbarRendererBase {
    public static final String RENDERER_TYPE = "org.richfaces.ToolbarGroupRenderer";

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractToolbarGroup.class;
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void doEncodeChildren(ResponseWriter writer, FacesContext facesContext, UIComponent component) throws IOException {
        AbstractToolbarGroup toolbarGroup = (AbstractToolbarGroup)component;
        List<UIComponent> renderedChildren = toolbarGroup.getRenderedChildren();
        if (renderedChildren.size() <= 0) {
            return;
        }
        this.renderChild(facesContext, toolbarGroup, writer, renderedChildren.get(0));
        for (int i = 1; i < renderedChildren.size(); ++i) {
            this.insertSeparatorIfNeed(facesContext, toolbarGroup, writer);
            this.renderChild(facesContext, toolbarGroup, writer, renderedChildren.get(i));
        }
    }

    private void renderChild(FacesContext facesContext, AbstractToolbarGroup toolbarGroup, ResponseWriter writer, UIComponent child) throws IOException {
        writer.startElement("td", toolbarGroup);
        writer.writeAttribute("id", this.encodeClientItemID(child), null);
        this.writeClassValue(toolbarGroup, writer);
        this.writeStyleValue(toolbarGroup, writer);
        child.encodeAll(facesContext);
        writer.endElement("td");
    }

    private void writeStyleValue(AbstractToolbarGroup toolbarGroup, ResponseWriter writer) throws IOException {
        String style = this.getStringAttribute(toolbarGroup, "style");
        String toolbarStyle = this.getStringAttribute(this.getParentToolBar(toolbarGroup), "itemStyle");
        String tooolbarGroupStyle = this.getStringAttribute(toolbarGroup, "itemStyle");
        String value = tooolbarGroupStyle != null && !tooolbarGroupStyle.equals("") ? this.concatStyles(tooolbarGroupStyle, style) : this.concatStyles(toolbarStyle, style);
        if (this.isPropertyRendered(value)) {
            writer.writeAttribute("style", value, null);
        }
    }

    private void writeClassValue(AbstractToolbarGroup toolbarGroup, ResponseWriter writer) throws IOException {
        String styleClass = this.getStringAttribute(toolbarGroup, "styleClass");
        String toolbarClass = this.getStringAttribute(this.getParentToolBar(toolbarGroup), "itemClass");
        String toolbarGroupClass = this.getStringAttribute(toolbarGroup, "itemClass");
        String itemClass = toolbarGroupClass != null && !toolbarGroupClass.equals("") ? toolbarGroupClass : toolbarClass;
        writer.writeAttribute("class", this.concatClasses("rf-tb-itm", itemClass, styleClass), null);
    }

    private String getStringAttribute(UIComponent toolbarGroup, String attribute) {
        String value = (String)toolbarGroup.getAttributes().get(attribute);
        return null == value ? "" : value;
    }

    public AbstractToolbar getParentToolBar(UIComponent component) {
        return component instanceof AbstractToolbarGroup ? ((AbstractToolbarGroup)component).getToolBar() : null;
    }
}

