/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSObject;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractTogglePanel;
import org.richfaces.component.AbstractTogglePanelItemInterface;
import org.richfaces.component.TogglePanelVisitCallback;
import org.richfaces.component.TogglePanelVisitState;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.AjaxOptions;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.html.DivPanelRenderer;
import org.richfaces.renderkit.util.AjaxRendererUtils;
import org.richfaces.renderkit.util.FormUtil;
import org.richfaces.renderkit.util.HandlersChain;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="togglePanel.js")})
public class TogglePanelRenderer
extends DivPanelRenderer
implements MetaComponentRenderer {
    public static final String VALUE_POSTFIX = "-value";
    protected static final String ITEM_CHANGE = "itemchange";
    protected static final String BEFORE_ITEM_CHANGE = "beforeitemchange";
    private static final String ON = "on";
    private static final String EVENT_TARGET_CHECKER = "if (event.target != event.currentTarget) {return;}";

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        Map<String, String> requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String newValue = requestParameterMap.get(TogglePanelRenderer.getValueRequestParamName(context, component));
        if (newValue != null) {
            panel.setSubmittedActiveItem(newValue);
            if (this.isSubmitted(context, panel)) {
                PartialViewContext pvc = context.getPartialViewContext();
                pvc.getRenderIds().add(component.getClientId(context) + '@' + "activeItem");
            }
        }
    }

    protected boolean isSubmitted(FacesContext context, AbstractTogglePanel panel) {
        Map<String, String> parameterMap = context.getExternalContext().getRequestParameterMap();
        return parameterMap.get(panel.getClientId(context)) != null;
    }

    static String getValueRequestParamName(FacesContext context, UIComponent component) {
        return component.getClientId(context) + VALUE_POSTFIX;
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        FormUtil.throwEnclFormReqExceptionIfNeed(context, component);
        super.doEncodeBegin(writer, context, component);
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        writer.startElement("input", component);
        writer.writeAttribute("id", TogglePanelRenderer.getValueRequestParamName(context, component), null);
        writer.writeAttribute("name", TogglePanelRenderer.getValueRequestParamName(context, component), null);
        writer.writeAttribute("type", "hidden", null);
        writer.writeAttribute("value", panel.getActiveItem(), null);
        writer.endElement("input");
        this.writeJavaScript(writer, context, component);
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return HtmlUtil.concatClasses("rf-tgp", TogglePanelRenderer.attributeAsString(component, "styleClass"));
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.renderChildren(context, component);
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement("div");
    }

    @Override
    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.TogglePanel", component.getClientId(context), this.getScriptObjectOptions(context, component));
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("activeItem", panel.getActiveItem());
        options.put("cycledSwitching", panel.isCycledSwitching());
        options.put("ajax", TogglePanelRenderer.getAjaxOptions(context, panel));
        TogglePanelRenderer.addEventOption(context, panel, options, ITEM_CHANGE);
        TogglePanelRenderer.addEventOption(context, panel, options, BEFORE_ITEM_CHANGE);
        return options;
    }

    public static void addEventOption(FacesContext context, UIComponent component, Map<String, Object> options, String eventName) {
        HandlersChain handlersChain = new HandlersChain(context, component);
        handlersChain.addInlineHandlerFromAttribute(ON + eventName);
        handlersChain.addBehaviors(eventName);
        String handler = handlersChain.toScript();
        if (handler != null) {
            options.put(ON + eventName, new JSFunctionDefinition(JSReference.EVENT).addToBody(EVENT_TARGET_CHECKER).addToBody(handler));
        }
    }

    public static AjaxOptions getAjaxOptions(FacesContext context, UIComponent panel) {
        return AjaxRendererUtils.buildEventOptions(context, panel);
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractTogglePanel.class;
    }

    @Override
    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        if ("activeItem".equals(metaComponentId)) {
            AbstractTogglePanel panel = (AbstractTogglePanel)component;
            int itemIndex = panel.getIndexByName(panel.getActiveItem());
            if (itemIndex >= 0) {
                this.encodeActiveItem(panel, itemIndex);
            } else {
                this.partialStart(context, component.getClientId(context));
                component.encodeAll(context);
                this.partialEnd(context);
                this.addOnCompleteParam(context, panel.getActiveItem(), panel.getClientId(context));
            }
        } else {
            throw new IllegalArgumentException(metaComponentId);
        }
    }

    private String encodeActiveItem(final AbstractTogglePanel panel, final int activeIndex) {
        panel.visitTogglePanelItems(panel, new TogglePanelVisitCallback(){

            @Override
            public VisitResult visit(FacesContext context, TogglePanelVisitState visitState) {
                if (activeIndex == visitState.getCount()) {
                    AbstractTogglePanelItemInterface item = visitState.getItem();
                    String itemName = item.getName();
                    try {
                        TogglePanelRenderer.this.partialStart(context, ((UIComponent)((Object)item)).getClientId(context));
                        ((UIComponent)((Object)item)).encodeAll(context);
                        TogglePanelRenderer.this.partialEnd(context);
                        TogglePanelRenderer.this.addOnCompleteParam(context, itemName, panel.getClientId(context));
                    }
                    catch (IOException e) {
                        throw new FacesException(e);
                    }
                    return VisitResult.COMPLETE;
                }
                return VisitResult.ACCEPT;
            }
        });
        return null;
    }

    @Override
    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
    }

    protected void partialStart(FacesContext facesContext, String id) throws IOException {
        facesContext.getPartialViewContext().getPartialResponseWriter().startUpdate(id);
    }

    protected void partialEnd(FacesContext facesContext) throws IOException {
        facesContext.getPartialViewContext().getPartialResponseWriter().endUpdate();
    }
}

