/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.AjaxSupport;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.UISimpleTogglePanel;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.event.SimpleToggleEvent;
import org.richfaces.event.SimpleTogglePanelSwitchEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTogglePanelRenderer
extends HeaderResourcesRendererBase {
    static final String NONE = "none";
    static final String EMPTY = "";

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return UISimpleTogglePanel.class;
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    public void writeEventHandlerFunction(FacesContext context, UIComponent component, String eventName) throws IOException {
        RendererUtils.writeEventHandlerFunction(context, component, eventName);
    }

    @Override
    public void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        ExternalContext exCtx = context.getExternalContext();
        Map<String, String> rqMap = exCtx.getRequestParameterMap();
        String clnId = rqMap.get(component.getClientId(context));
        UISimpleTogglePanel panel = (UISimpleTogglePanel)component;
        if (clnId != null) {
            boolean currentState = panel.isOpened();
            boolean submittedState = false;
            String switchType = panel.getSwitchType();
            if ("client".equals(switchType)) {
                submittedState = Boolean.parseBoolean(clnId);
            } else {
                boolean bl = submittedState = !currentState;
            }
            if (currentState != submittedState) {
                SimpleToggleEvent event = new SimpleToggleEvent(panel, submittedState);
                event.queue();
                SimpleTogglePanelSwitchEvent stateEvent = new SimpleTogglePanelSwitchEvent(panel, submittedState);
                stateEvent.queue();
            }
            if (AjaxRendererUtils.isAjaxRequest(context) && panel.getSwitchType().equals("ajax")) {
                AjaxRendererUtils.addRegionByName(context, panel, panel.getId());
                AjaxRendererUtils.addRegionsFromComponent(panel, context);
                AjaxContext.getCurrentInstance(context).addAreasToProcessFromComponent(context, panel);
            }
        }
    }

    public String getdivdisplay(FacesContext context, UIComponent component) {
        UISimpleTogglePanel simpleTogglePanel = (UISimpleTogglePanel)component;
        return simpleTogglePanel.isOpened() ? EMPTY : NONE;
    }

    public String getOnClick(FacesContext context, UIComponent component) {
        UISimpleTogglePanel tgComp = (UISimpleTogglePanel)component;
        String switchType = tgComp.getSwitchType();
        StringBuffer onClick = new StringBuffer();
        JSReference eventRef = new JSReference("event");
        String panelId = tgComp.getClientId(context);
        if ("client".equals(switchType)) {
            JSFunction function = new JSFunction("SimpleTogglePanelManager.toggleOnClient", new Object[0]);
            function.addParameter(eventRef);
            function.addParameter(panelId);
            function.appendScript(onClick);
            onClick.append(";");
        } else if ("ajax".equals(switchType)) {
            AjaxSupport support;
            JSFunction function = new JSFunction("SimpleTogglePanelManager.toggleOnAjax", new Object[0]);
            function.addParameter(eventRef);
            function.addParameter(panelId);
            function.appendScript(onClick);
            onClick.append(";");
            JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(tgComp, context);
            ajaxFunction.addParameter(AjaxRendererUtils.buildEventOptions(context, (UIComponent)tgComp, true));
            ajaxFunction.appendScript(onClick);
            if (tgComp instanceof AjaxSupport && (support = (AjaxSupport)((Object)tgComp)).isDisableDefault()) {
                onClick.append("; return false;");
            }
        } else {
            JSFunction function = new JSFunction("SimpleTogglePanelManager.toggleOnServer", new Object[0]);
            function.addParameter(eventRef);
            function.addParameter(panelId);
            function.appendScript(onClick);
            onClick.append(";");
        }
        return onClick.toString();
    }

    protected String getValueAsString(FacesContext context, UISimpleTogglePanel Panel) {
        return this.getUtils().getValueAsString(context, Panel);
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UISimpleTogglePanel comp = (UISimpleTogglePanel)component;
        String switchType = comp.getSwitchType();
        if ("client".equals(switchType) || comp.isOpened()) {
            super.encodeChildren(context, component);
        }
    }

    public void encodeDivStart(ResponseWriter writer, FacesContext context, UISimpleTogglePanel component) throws IOException {
        String clientId = component.getClientId(context);
        writer.startElement("div", component);
        this.getUtils().writeAttribute(writer, "class", "rich-stglpanel " + this.convertToString(component.getAttributes().get("styleClass")));
        this.getUtils().writeAttribute(writer, "id", clientId);
        String style = this.convertToString(component.getAttributes().get("style"));
        String width = this.convertToString(component.getAttributes().get("width"));
        if (!this.isEmpty(width)) {
            width = "width: " + this.convertToString(width);
        }
        if (!this.isEmpty(style = HtmlUtil.concatStyles((String[])new String[]{style, width}))) {
            this.getUtils().writeAttribute(writer, "style", style);
        }
        this.getUtils().encodeAttributesFromArray(context, component, new String[]{"align", "dir", "lang", "onclick", "ondblclick", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "title", "xml:lang"});
    }

    public void encodeBodyDivStart(ResponseWriter writer, FacesContext context, UISimpleTogglePanel component) throws IOException {
        String style;
        String height;
        String clientId = component.getClientId(context);
        writer.startElement("div", component);
        this.getUtils().writeAttribute(writer, "class", "rich-stglpanel-body " + this.convertToString(component.getAttributes().get("bodyClass")));
        this.getUtils().writeAttribute(writer, "id", this.convertToString(clientId) + "_body");
        String display = EMPTY;
        if (!component.isOpened()) {
            display = "display: none";
        }
        if (!this.isEmpty(height = this.convertToString(component.getAttributes().get("height")))) {
            height = "height: " + height;
        }
        if (!this.isEmpty(style = HtmlUtil.concatStyles((String[])new String[]{display, height}))) {
            this.getUtils().writeAttribute(writer, "style", style);
        }
    }

    public void encodeSwitchOnDivStart(ResponseWriter writer, FacesContext context, UISimpleTogglePanel component) throws IOException {
        this.encodeSwitchDivStart(writer, context, component, true);
    }

    public void encodeSwitchOffDivStart(ResponseWriter writer, FacesContext context, UISimpleTogglePanel component) throws IOException {
        this.encodeSwitchDivStart(writer, context, component, false);
    }

    private void encodeSwitchDivStart(ResponseWriter writer, FacesContext context, UISimpleTogglePanel component, boolean isSwitchOn) throws IOException {
        String clientId = component.getClientId(context);
        writer.startElement("div", component);
        this.getUtils().writeAttribute(writer, "class", "rich-stglpnl-marker");
        this.getUtils().writeAttribute(writer, "id", this.convertToString(clientId) + "_switch_" + (isSwitchOn ? "on" : "off"));
        String display = this.convertToString(this.getSwitchStatus(context, component, isSwitchOn)).trim();
        if (!this.isEmpty(display)) {
            display = "display: " + display;
        }
        this.getUtils().writeAttribute(writer, "style", display);
    }

    public String getSwitchStatus(FacesContext context, UIComponent component, boolean isSwitchOn) {
        return ((UISimpleTogglePanel)component).isOpened() ^ isSwitchOn ? NONE : EMPTY;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private String convertToString(Object obj) {
        return obj == null ? EMPTY : obj.toString();
    }

    public void encodeDivEnd(ResponseWriter writer) throws IOException {
        writer.endElement("div");
    }
}

