/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.UIRichMessages;
import org.richfaces.renderkit.RichMessageBaseRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRichMessagesRenderer
extends RichMessageBaseRenderer {
    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        Iterator<FacesMessage> messagesIter;
        UIRichMessages uiMessages = (UIRichMessages)component;
        String layout = null;
        String forIds = null;
        String forClientId = uiMessages.getFor();
        if (null != forClientId) {
            forIds = forClientId;
        }
        if (uiMessages.isGlobalOnly()) {
            if (null == forClientId) {
                forIds = "";
            } else {
                throw new FacesException("The rich:messages component must specify only one of 'for' or 'globalOnly' atribbute");
            }
        }
        boolean isDisplayNone = !(messagesIter = uiMessages.getMessages(context)).hasNext();
        boolean isWroteTable = false;
        layout = (String)uiMessages.getAttributes().get("layout");
        if (layout != null && layout.equals("table")) {
            writer.startElement("table", uiMessages);
            this.getUtils().writeAttribute(writer, "id", uiMessages.getClientId(context));
            this.getUtils().writeAttribute(writer, "cellpadding", "0");
            this.getUtils().writeAttribute(writer, "cellspacing", "0");
            this.renderComponentOuterStyles(uiMessages, context, writer, isDisplayNone);
            writer.startElement("tbody", uiMessages);
            isWroteTable = true;
        } else if (layout != null && layout.equals("list")) {
            isWroteTable = false;
            writer.startElement("dl", uiMessages);
            this.getUtils().writeAttribute(writer, "id", uiMessages.getClientId(context));
            this.renderComponentOuterStyles(uiMessages, context, writer, isDisplayNone);
        }
        if (!messagesIter.hasNext()) {
            this.renderBody(uiMessages, context, writer, null, isWroteTable);
        } else {
            while (messagesIter.hasNext()) {
                FacesMessage facesMsg = messagesIter.next();
                this.renderBody(uiMessages, context, writer, facesMsg, isWroteTable);
            }
        }
        if (isWroteTable) {
            writer.endElement("tbody");
            writer.endElement("table");
        } else {
            writer.endElement("dl");
        }
    }

    @Override
    public void renderLabelHtml(UIComponent component, FacesContext context, ResponseWriter writer, FacesMessage facesMsg, String labelClass, String labelStyle, String passLabel) throws IOException {
        String summary = null;
        String detail = null;
        String title = null;
        UIRichMessages uiMessages = null;
        if (!(component instanceof UIRichMessages)) {
            return;
        }
        uiMessages = (UIRichMessages)component;
        boolean isTooltip = this.getUtils().isBooleanAttribute(uiMessages, "tooltip");
        boolean showSummary = uiMessages.isShowSummary();
        boolean showDetail = uiMessages.isShowDetail();
        if (facesMsg != null) {
            summary = facesMsg.getSummary();
            summary = null != summary ? summary : "";
            detail = facesMsg.getDetail();
            detail = null != detail ? detail : "";
        }
        labelClass = labelClass == null ? "rich-messages-label" : "rich-messages-label " + labelClass;
        writer.startElement("span", uiMessages);
        this.getUtils().writeAttribute(writer, "class", labelClass);
        this.getUtils().writeAttribute(writer, "style", labelStyle);
        title = (String)component.getAttributes().get("title");
        if (title != null) {
            writer.writeAttribute("title", title, "title");
        }
        if (facesMsg != null) {
            boolean wroteTooltip = false;
            if (showSummary && showDetail && isTooltip) {
                if (title == null || title.length() == 0) {
                    writer.writeAttribute("title", summary, "title");
                }
                wroteTooltip = true;
            }
            if (!wroteTooltip && showSummary) {
                writer.writeText(summary, component, null);
            }
            if (showDetail) {
                writer.writeText(detail, component, null);
            }
        } else if (passLabel != null) {
            writer.writeText(passLabel, null);
            writer.writeText("\t", null);
        }
        writer.endElement("span");
    }

    @Override
    public void renderMarkerHtml(UIComponent component, UIComponent markerFacet, FacesContext context, ResponseWriter writer, String markerClass, String markerStyle) throws IOException {
        UIRichMessages uiMessages = null;
        if (!(component instanceof UIRichMessages)) {
            return;
        }
        uiMessages = (UIRichMessages)component;
        writer.startElement("span", uiMessages);
        String classes = markerClass == null ? "rich-messages-marker" : "rich-messages-marker " + markerClass;
        this.getUtils().writeAttribute(writer, "class", classes);
        this.getUtils().writeAttribute(writer, "style", markerStyle);
        this.renderChild(context, markerFacet);
        writer.endElement("span");
    }

    public void renderComponentOuterStyles(UIComponent component, FacesContext context, ResponseWriter writer, boolean isDisplayNone) throws IOException {
        UIRichMessages uiMessages = null;
        if (!(component instanceof UIRichMessages)) {
            return;
        }
        uiMessages = (UIRichMessages)component;
        String parentStyle = (String)uiMessages.getAttributes().get("style");
        String parentClass = (String)uiMessages.getAttributes().get("styleClass");
        parentStyle = (isDisplayNone ? "display: none; " : "") + (parentStyle != null ? parentStyle : "");
        String richMessageClass = "rich-messages";
        parentClass = parentClass != null ? richMessageClass + " " + parentClass : richMessageClass;
        this.getUtils().writeAttribute(writer, "class", parentClass);
        this.getUtils().writeAttribute(writer, "style", parentStyle);
    }

    @Override
    public void renderOuterStyles(UIComponent component, FacesContext context, ResponseWriter writer, String outerStyle, String outerClass) throws IOException {
        String richMessageClass = null != outerClass ? outerClass : "";
        String richMessageStyle = null != outerStyle ? outerStyle : "";
        this.getUtils().writeAttribute(writer, "class", richMessageClass);
        this.getUtils().writeAttribute(writer, "style", richMessageStyle);
    }

    public void renderBody(UIRichMessages uiMessages, FacesContext context, ResponseWriter writer, FacesMessage facesMsg, boolean isWroteTable) throws IOException {
        if (isWroteTable) {
            writer.startElement("tr", uiMessages);
            writer.startElement("td", uiMessages);
        } else {
            writer.startElement("dt", uiMessages);
        }
        if (facesMsg != null) {
            this.outerStyles(uiMessages, context, writer, facesMsg);
            this.renderMarkerFacet(uiMessages, context, writer, facesMsg);
            this.renderLabel(uiMessages, context, writer, facesMsg);
        }
        if (isWroteTable) {
            writer.endElement("td");
            writer.endElement("tr");
        } else {
            writer.endElement("dt");
        }
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return UIMessages.class;
    }
}

