/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.AbstractColumn;
import org.richfaces.component.SortOrder;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.model.SortMode;
import org.richfaces.renderkit.AbstractRowsRenderer;
import org.richfaces.validator.MessageFactory;

public abstract class SortingFilteringRowsRenderer
extends AbstractRowsRenderer {
    private static final String FILTERING_STRING = "rich:filtering";
    private static final String SORTING_STRING = "rich:sorting";
    private static final String FILTER_VALUE_STRING = "filterValue";
    private static final String SORT_ORDER_STRING = "sortOrder";
    private static final String SORT_PRIORITY_STRING = "sortPriority";
    private static final String SEPARATOR = ":";

    protected void decodeSortingFiltering(FacesContext context, UIComponent component) {
        if (component instanceof UIDataTableBase) {
            String sorting;
            String clientId;
            UIDataTableBase dataTableBase = (UIDataTableBase)component;
            Map<String, String> requestMap = context.getExternalContext().getRequestParameterMap();
            String filtering = requestMap.get((clientId = dataTableBase.getClientId(context)) + FILTERING_STRING);
            if (filtering != null && filtering.trim().length() > 0) {
                this.decodeFiltering(context, dataTableBase, filtering);
            }
            if ((sorting = requestMap.get(clientId + SORTING_STRING)) != null && sorting.trim().length() > 0) {
                this.decodeSorting(context, dataTableBase, sorting);
            }
        }
    }

    protected void decodeFiltering(FacesContext context, UIDataTableBase dataTableBase, String value) {
        String[] values = value.split(SEPARATOR);
        if (Boolean.parseBoolean(values[2])) {
            Iterator<UIComponent> iterator = dataTableBase.columns();
            while (iterator.hasNext()) {
                UIComponent column = iterator.next();
                if (values[0].equals(column.getId())) {
                    this.updateAttribute(context, column, FILTER_VALUE_STRING, values[1]);
                    continue;
                }
                this.updateAttribute(context, column, FILTER_VALUE_STRING, null);
            }
        } else {
            UIComponent child = dataTableBase.findComponent(values[0]);
            try {
                this.updateAttribute(context, child, FILTER_VALUE_STRING, values[1]);
            }
            catch (FacesException e) {
                if (child instanceof AbstractColumn) {
                    AbstractColumn cfr_ignored_0 = (AbstractColumn)child;
                    if (AbstractColumn.isBuiltInFilterControlsEnabled() && e.getCause() instanceof ELException) {
                        this.addFilterConverterErrorMessage(context, (AbstractColumn)child, values[1], e);
                    }
                }
                throw e;
            }
        }
        context.getPartialViewContext().getRenderIds().add(dataTableBase.getSortingAndFilteringRenderTargetId(context));
    }

    private void addFilterConverterErrorMessage(FacesContext context, AbstractColumn column, String submittedValue, Exception exception) {
        FacesMessage message;
        column.getAttributes().put("submittedFilterValue", submittedValue);
        String converterMessageString = column.getFilterConverterMessage();
        if (null != converterMessageString) {
            message = new FacesMessage(FacesMessage.SEVERITY_ERROR, converterMessageString, converterMessageString);
        } else {
            message = MessageFactory.createMessage(context, "org.richfaces.BUILT_IN_FILTER_VALUE_CONVERSION_ERROR");
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            message.setDetail(exception.getCause().getLocalizedMessage());
        }
        context.addMessage(column.getClientId(), message);
    }

    protected void decodeSorting(FacesContext context, UIDataTableBase dataTableBase, String value) {
        LinkedHashSet<Object> sortPriority = new LinkedHashSet<Object>();
        String[] values = value.split(SEPARATOR);
        String columnId = values[0];
        String sortOrder = values[1];
        boolean isClear = Boolean.parseBoolean(values[2]);
        if (isClear || SortMode.single.equals((Object)dataTableBase.getSortMode())) {
            Iterator<UIComponent> iterator = dataTableBase.columns();
            while (iterator.hasNext()) {
                UIComponent column = iterator.next();
                if (columnId.equals(column.getId())) {
                    this.updateSortOrder(context, column, sortOrder);
                    sortPriority.add(columnId);
                    continue;
                }
                this.updateAttribute(context, column, SORT_ORDER_STRING, (Object)SortOrder.unsorted);
            }
        } else {
            this.updateSortOrder(context, dataTableBase.findComponent(columnId), sortOrder);
            Collection<Object> priority = dataTableBase.getSortPriority();
            if (priority != null) {
                priority.remove(columnId);
                sortPriority.addAll(priority);
            }
            sortPriority.add(columnId);
        }
        this.updateAttribute(context, dataTableBase, SORT_PRIORITY_STRING, sortPriority);
        context.getPartialViewContext().getRenderIds().add(dataTableBase.getSortingAndFilteringRenderTargetId(context));
    }

    private void updateSortOrder(FacesContext context, UIComponent component, String value) {
        SortOrder sortOrder;
        block2: {
            sortOrder = SortOrder.ascending;
            try {
                sortOrder = SortOrder.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                if (!SortOrder.ascending.equals(component.getAttributes().get(SORT_ORDER_STRING))) break block2;
                sortOrder = SortOrder.descending;
            }
        }
        this.updateAttribute(context, component, SORT_ORDER_STRING, (Object)sortOrder);
    }

    protected void updateAttribute(FacesContext context, UIComponent component, String attribute, Object value) {
        Object oldValue = component.getAttributes().get(attribute);
        if (oldValue != null && !oldValue.equals(value) || oldValue == null && value != null) {
            ELContext elContext = context.getELContext();
            ValueExpression ve = component.getValueExpression(attribute);
            if (ve != null && !ve.isReadOnly(elContext)) {
                component.getAttributes().put(attribute, null);
                try {
                    ve.setValue(elContext, value);
                }
                catch (ELException e) {
                    throw new FacesException(e);
                }
            } else {
                component.getAttributes().put(attribute, value);
            }
        }
    }

    protected void renderFilterRow(FacesContext context, UIDataTableBase table, Iterator<UIComponent> columns, String cssPrefix) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        writer.startElement("tr", table);
        writer.writeAttribute("class", String.format("%s-flt", cssPrefix), null);
        while (columns.hasNext()) {
            UIComponent column = columns.next();
            if (!column.isRendered()) continue;
            writer.startElement("td", column);
            writer.writeAttribute("class", String.format("%1$s-flt-c %1$s-td-%2$s", cssPrefix, column.getId()), null);
            writer.startElement("div", column);
            writer.writeAttribute("class", String.format("%1$s-flt-cnt %1$s-c-%2$s", cssPrefix, column.getId()), null);
            if (column.getAttributes().get("filterField") != null && !"custom".equals(column.getAttributes().get("filterType"))) {
                writer.startElement("input", column);
                writer.writeAttribute("id", clientId + SEPARATOR + column.getId() + ":flt", null);
                writer.writeAttribute("name", clientId + SEPARATOR + column.getId() + ":flt", null);
                String inputClass = String.format("%s-flt-i", cssPrefix);
                List<FacesMessage> messages = context.getMessageList(column.getClientId());
                if (!messages.isEmpty()) {
                    inputClass = inputClass + String.format(" %s-flt-i-err", cssPrefix);
                    writer.writeAttribute("value", column.getAttributes().get("submittedFilterValue"), null);
                } else {
                    writer.writeAttribute("value", column.getAttributes().get(FILTER_VALUE_STRING), null);
                }
                writer.writeAttribute("class", inputClass, null);
                writer.writeAttribute("data-columnid", column.getId(), null);
                writer.endElement("input");
            }
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    protected void renderSortButton(FacesContext context, UIComponent column, String cssPrefix) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", column);
        String classAttr = String.format("%1$s-srt %1$s-srt-btn ", cssPrefix);
        SortOrder sortOrder = (SortOrder)((Object)column.getAttributes().get(SORT_ORDER_STRING));
        if (sortOrder == null || sortOrder == SortOrder.unsorted) {
            classAttr = classAttr + String.format("%s-srt-uns", cssPrefix);
        } else if (sortOrder == SortOrder.ascending) {
            classAttr = classAttr + String.format("%s-srt-asc", cssPrefix);
        } else if (sortOrder == SortOrder.descending) {
            classAttr = classAttr + String.format("%s-srt-des", cssPrefix);
        }
        writer.writeAttribute("class", classAttr, null);
        writer.writeAttribute("data-columnid", column.getId(), null);
        writer.endElement("span");
    }

    protected boolean isFilterRowRequiredForColumn(String facetName, UIComponent column) {
        return "header".equals(facetName) && column instanceof AbstractColumn && ((AbstractColumn)column).useBuiltInFilter();
    }

    protected boolean isBuiltInSortRequiredFocColumn(String facetName, UIComponent column) {
        return "header".equals(facetName) && column instanceof AbstractColumn && ((AbstractColumn)column).useBuiltInSort();
    }
}

