/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.LinkedHashSet;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.AjaxScript;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.UIProgressBar;
import org.richfaces.renderkit.AbstractProgressBarRenderer;

public class ProgressBarRenderer
extends AbstractProgressBarRenderer {
    private final InternetResource[] styles = new InternetResource[]{this.getResource("/org/richfaces/renderkit/html/css/progressBar.xcss")};
    private InternetResource[] stylesAll = null;
    private final InternetResource[] scripts = new InternetResource[]{new PrototypeScript(), new AjaxScript(), this.getResource("/org/richfaces/renderkit/html/scripts/utils.js"), this.getResource("/org/richfaces/renderkit/html/scripts/json/json-dom.js"), this.getResource("/org/richfaces/renderkit/html/js/progressBar.js")};
    private InternetResource[] scriptsAll = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternetResource[] getStyles() {
        ProgressBarRenderer progressBarRenderer = this;
        synchronized (progressBarRenderer) {
            if (this.stylesAll == null) {
                boolean ignoreThis;
                InternetResource[] rsrcs = super.getStyles();
                boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
                boolean bl = ignoreThis = this.styles == null || this.styles.length == 0;
                if (ignoreSuper) {
                    this.stylesAll = ignoreThis ? new InternetResource[0] : this.styles;
                } else if (ignoreThis) {
                    this.stylesAll = rsrcs;
                } else {
                    int i;
                    LinkedHashSet<InternetResource> rsrcsSet = new LinkedHashSet<InternetResource>();
                    for (i = 0; i < rsrcs.length; ++i) {
                        rsrcsSet.add(rsrcs[i]);
                    }
                    for (i = 0; i < this.styles.length; ++i) {
                        rsrcsSet.add(this.styles[i]);
                    }
                    this.stylesAll = rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
                }
            }
        }
        return this.stylesAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternetResource[] getScripts() {
        ProgressBarRenderer progressBarRenderer = this;
        synchronized (progressBarRenderer) {
            if (this.scriptsAll == null) {
                boolean ignoreThis;
                InternetResource[] rsrcs = super.getScripts();
                boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
                boolean bl = ignoreThis = this.scripts == null || this.scripts.length == 0;
                if (ignoreSuper) {
                    this.scriptsAll = ignoreThis ? new InternetResource[0] : this.scripts;
                } else if (ignoreThis) {
                    this.scriptsAll = rsrcs;
                } else {
                    int i;
                    LinkedHashSet<InternetResource> rsrcsSet = new LinkedHashSet<InternetResource>();
                    for (i = 0; i < rsrcs.length; ++i) {
                        rsrcsSet.add(rsrcs[i]);
                    }
                    for (i = 0; i < this.scripts.length; ++i) {
                        rsrcsSet.add(this.scripts[i]);
                    }
                    this.scriptsAll = rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
                }
            }
        }
        return this.scriptsAll;
    }

    private String convertToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    private String convertToString(boolean b) {
        return String.valueOf(b);
    }

    private String convertToString(int b) {
        return b != Integer.MIN_VALUE ? String.valueOf(b) : "";
    }

    private String convertToString(long b) {
        return b != Long.MIN_VALUE ? String.valueOf(b) : "";
    }

    protected Class getComponentClass() {
        return UIProgressBar.class;
    }

    public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIProgressBar component, ComponentVariables variables) throws IOException {
        String clientId = component.getClientId(context);
        String mode = (String)component.getAttributes().get("mode");
        boolean isAjax = "ajax".equalsIgnoreCase(mode);
        if (!mode.equalsIgnoreCase("client") && !mode.equalsIgnoreCase("ajax")) {
            throw new IOException("Mode attribute should have 'client' or 'ajax' value");
        }
        Number minValue = this.getNumber(component.getAttributes().get("minValue"));
        Number maxValue = this.getNumber(component.getAttributes().get("maxValue"));
        Number value = this.getNumber(component.getAttributes().get("value"));
        Number percent = this.calculatePercent(value, minValue, maxValue);
        variables.setVariable("percent", percent);
        variables.setVariable("value", value);
        variables.setVariable("style", (String)component.getAttributes().get("style"));
        variables.setVariable("styleClass", (String)component.getAttributes().get("styleClass"));
        String forcedState = this.getForcedState(context, component);
        if (forcedState != null) {
            this.renderForcedState(forcedState, context, component);
        }
        if (!isAjax) {
            this.encodeClientMode(context, component, value, minValue, maxValue);
        } else if (value.doubleValue() <= minValue.doubleValue()) {
            this.encodeInitialState(context, component, true);
        } else if (value.doubleValue() > maxValue.doubleValue()) {
            this.encodeCompletedState(context, component, true);
        } else {
            this.encodeProgressState(context, component, true);
        }
    }

    public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
        this.doEncodeEnd(writer, context, (UIProgressBar)component, variables);
        ComponentsVariableResolver.removeVariables(this, component);
    }
}

