/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptStringBase;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.util.SelectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIPickList;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.json.XML;
import org.richfaces.renderkit.ConvertedSelectItem;
import org.richfaces.renderkit.OrderingComponentRendererBase;
import org.richfaces.renderkit.PickListControlsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickListRenderer
extends HeaderResourcesRendererBase {
    private static Log logger = LogFactory.getLog(PickListRenderer.class);
    private static final String HIDDEN_SUFFIX = "valueKeeper";
    private static final String MESSAGE_BUNDLE_NAME = PickListRenderer.class.getPackage().getName() + ".pickList";
    private static final String SHOW_LABELS_ATTRIBUTE_NAME = "showButtonsLabel";
    private static final OrderingComponentRendererBase.ControlsHelper[] SHUTTLE_HELPERS = PickListControlsHelper.HELPERS;

    protected List<ConvertedSelectItem> selectItemsForSelectedList(List<ConvertedSelectItem> selectItems) {
        ArrayList<ConvertedSelectItem> result = new ArrayList<ConvertedSelectItem>();
        for (ConvertedSelectItem selectItem : selectItems) {
            if (!selectItem.isSelected()) continue;
            result.add(selectItem);
        }
        return result;
    }

    protected List<Object> getValuesList(UIPickList pickList) {
        ArrayList<Object> valuesList = new ArrayList<Object>();
        Object value = this.getCurrentValue(FacesContext.getCurrentInstance(), pickList);
        if (null == value || "".equals(value)) {
            return valuesList;
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                Object localValue = Array.get(value, i);
                if (localValue == null) continue;
                valuesList.add(localValue);
            }
            return valuesList;
        }
        if (value instanceof List) {
            valuesList.addAll((List)value);
            return valuesList;
        }
        throw new IllegalArgumentException("Error: value of UIPickList component is not of type Array or List");
    }

    protected Object getCurrentValue(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component instanceof UIInput && (submittedValue = ((UIInput)component).getSubmittedValue()) != null) {
            return submittedValue;
        }
        return ((UIPickList)component).getValue();
    }

    protected List<ConvertedSelectItem> selectItemsForAvailableList(List<ConvertedSelectItem> selectItems) {
        ArrayList<ConvertedSelectItem> result = new ArrayList<ConvertedSelectItem>();
        for (ConvertedSelectItem selectItem : selectItems) {
            if (selectItem.isSelected()) continue;
            result.add(selectItem);
        }
        return result;
    }

    protected List<SelectItem> getSelectItemsList(FacesContext context, UIComponent component) {
        return SelectUtils.getSelectItems(context, component);
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        UIPickList picklist = (UIPickList)component;
        if (!(picklist instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + picklist.getClientId(context) + " is not an EditableValueHolder");
        }
        String hiddenClientId = picklist.getClientId(context) + HIDDEN_SUFFIX;
        Map<String, String> paramMap = context.getExternalContext().getRequestParameterMap();
        if (picklist.isDisabled()) {
            return;
        }
        String value = paramMap.get(hiddenClientId);
        if (value != null) {
            if (value.trim().equals("")) {
                picklist.setSubmittedValue(new String[0]);
            } else {
                String[] reqValues = value.split(",");
                picklist.setSubmittedValue(reqValues);
            }
        } else {
            picklist.setSubmittedValue(new String[0]);
        }
    }

    private static boolean isTrue(Object obj) {
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Object convertedValue = null;
        if (component instanceof UIPickList) {
            UIPickList pickList = (UIPickList)component;
            convertedValue = SelectUtils.getConvertedUISelectManyValue(context, pickList, (String[])submittedValue);
        }
        return convertedValue;
    }

    private void encodeRows(FacesContext context, UIPickList pickList, boolean source, ListStateFlags flags, List<ConvertedSelectItem> selectItemList) throws IOException {
        for (ConvertedSelectItem item : selectItemList) {
            this.encodeItem(context, pickList, item, source);
        }
    }

    public void encodeItem(FacesContext context, UIComponent component, ConvertedSelectItem selectItem, boolean source) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", component);
        String clientId = component.getClientId(context);
        if (source) {
            clientId = clientId + ":source:";
        }
        String id = clientId + ":" + selectItem.getSuffix();
        writer.writeAttribute("id", id, null);
        StringBuffer rowClassName = new StringBuffer();
        StringBuffer cellClassName = new StringBuffer();
        if (source) {
            rowClassName.append("rich-picklist-source-row");
            cellClassName.append("rich-picklist-source-cell");
        } else {
            rowClassName.append("rich-picklist-target-row");
            cellClassName.append("rich-picklist-target-cell");
        }
        writer.writeAttribute("class", rowClassName.toString(), null);
        writer.startElement("td", component);
        writer.writeAttribute("class", cellClassName, null);
        Object width = component.getAttributes().get("width");
        if (width != null) {
            writer.writeAttribute("style", "width: " + HtmlUtil.qualifySize((String)width.toString()), null);
        }
        this.encodeSpacer(context, component, writer);
        boolean escape = PickListRenderer.isTrue(component.getAttributes().get("escape"));
        if (escape) {
            writer.writeText(selectItem.getItem().getLabel(), null);
        } else {
            writer.write(XML.escape(selectItem.getItem().getLabel()));
        }
        this.encodeItemValue(context, component, writer, id, selectItem.getConvertedValue());
        writer.endElement("td");
        writer.endElement("tr");
    }

    public void encodeTargetRows(FacesContext context, UIPickList pickList, ListStateFlags flags, List<ConvertedSelectItem> convertedItems) throws IOException {
        List<ConvertedSelectItem> selectItemsForSelectedValues = this.selectItemsForSelectedList(convertedItems);
        flags.isSelectedList = !selectItemsForSelectedValues.isEmpty();
        flags.isAvailableList = selectItemsForSelectedValues.size() != convertedItems.size();
        this.encodeRows(context, pickList, false, flags, selectItemsForSelectedValues);
    }

    public void encodeSourceRows(FacesContext context, UIPickList pickList, ListStateFlags flags, List<ConvertedSelectItem> convertedItems) throws IOException {
        List<ConvertedSelectItem> selectItemsForAvailableList = this.selectItemsForAvailableList(convertedItems);
        flags.isSelectedList = selectItemsForAvailableList.size() != convertedItems.size();
        flags.isAvailableList = !selectItemsForAvailableList.isEmpty();
        this.encodeRows(context, pickList, true, flags, selectItemsForAvailableList);
    }

    private void encodeItemValue(FacesContext context, UIComponent component, ResponseWriter writer, String id, String itemValue) throws IOException {
        writer.startElement("input", component);
        writer.writeAttribute("type", RendererUtils.HTML.INPUT_TYPE_HIDDEN, null);
        writer.writeAttribute("autocomplete", "off", null);
        writer.writeAttribute("name", id, null);
        StringBuffer value = new StringBuffer();
        value.append(itemValue);
        writer.writeAttribute("value", value.toString(), null);
        writer.writeAttribute("id", id + "StateInput", null);
        writer.endElement("input");
    }

    protected void encodeSpacer(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        writer.startElement("img", component);
        writer.writeAttribute("src", this.getResource("/org/richfaces/renderkit/html/images/spacer.gif").getUri(context, null), null);
        writer.writeAttribute("alt", " ", null);
        writer.writeAttribute("style", "width:1px;height:1px;", null);
        writer.endElement("img");
    }

    public void encodeHiddenField(FacesContext context, UIPickList component, List<ConvertedSelectItem> lookupList) throws IOException {
        String hiddenFieldCliendId = component.getClientId(context) + HIDDEN_SUFFIX;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", component);
        writer.writeAttribute("type", "hidden", "type");
        writer.writeAttribute("autocomplete", "off", null);
        writer.writeAttribute("id", hiddenFieldCliendId, "id");
        writer.writeAttribute("name", hiddenFieldCliendId, null);
        StringBuffer sb = new StringBuffer();
        int n = 0;
        Iterator<ConvertedSelectItem> i = this.selectItemsForSelectedList(lookupList).iterator();
        while (i.hasNext()) {
            if (n > 0) {
                sb.append(",");
            }
            ConvertedSelectItem value = i.next();
            sb.append(value.getConvertedValue());
            ++n;
        }
        writer.writeAttribute("value", sb.toString(), null);
        writer.endElement("input");
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return UIPickList.class;
    }

    public String getAsEventHandler(FacesContext context, UIComponent component, String attributeName) {
        String event = (String)component.getAttributes().get(attributeName);
        ScriptStringBase result = JSReference.NULL;
        if (event != null && (event = event.trim()).length() != 0) {
            JSFunctionDefinition function = new JSFunctionDefinition(new Object[0]);
            function.addParameter("event");
            function.addToBody(event);
            result = function;
        }
        return ScriptUtils.toScript(result);
    }

    public String getColumnClassesAsJSArray(FacesContext context, UIComponent component) {
        return ScriptUtils.toScript(this.getClassesAsList(context, component, "columnClasses"));
    }

    public String getRowClassesAsJSArray(FacesContext context, UIComponent component) {
        return ScriptUtils.toScript(this.getClassesAsList(context, component, "rowClasses"));
    }

    protected List<String> getClassesAsList(FacesContext context, UIComponent component, String attr) {
        String value = (String)component.getAttributes().get(attr);
        if (value != null && value.length() != 0) {
            ArrayList<String> result = new ArrayList<String>();
            for (String val : value.split(",")) {
                result.add(val);
            }
            return result;
        }
        return null;
    }

    public void encodePickListControlsFacets(FacesContext context, UIComponent component, ListStateFlags listStateFlags) throws IOException {
        boolean needsStrut = true;
        String clientId = component.getClientId(context);
        boolean enable = false;
        ResponseWriter writer = context.getResponseWriter();
        boolean componentDisabled = ((UIPickList)component).isDisabled();
        for (int i = 0; i < SHUTTLE_HELPERS.length; ++i) {
            if (!SHUTTLE_HELPERS[i].isRendered(context, component)) continue;
            needsStrut = false;
            OrderingComponentRendererBase.ControlsHelper helper = SHUTTLE_HELPERS[i];
            boolean isDisabled = helper.getButtonStyleClass().equals("-disabled");
            enable = helper.getBundlePropertyName().equals("RICH_PICK_LIST_REMOVE_ALL_LABEL") ? (enable = listStateFlags.isSelectedList) != isDisabled || isDisabled && componentDisabled : (helper.getBundlePropertyName().equals("RICH_PICK_LIST_COPY_ALL_LABEL") ? (enable = listStateFlags.isAvailableList) != isDisabled || isDisabled && componentDisabled : helper.getButtonStyleClass().equals("-disabled"));
            this.encodeControlFacet(context, component, SHUTTLE_HELPERS[i], clientId, writer, enable, "rich-list-picklist-button", " rich-picklist-control");
        }
        if (needsStrut) {
            writer.startElement("span", component);
            writer.endElement("span");
        }
    }

    protected void encodeControlFacet(FacesContext context, UIComponent component, OrderingComponentRendererBase.ControlsHelper helper, String clientId, ResponseWriter writer, boolean enabled, String baseStyle, String baseControlStyle) throws IOException {
        this.renderDefaultControl(context, component, writer, helper, clientId, enabled, baseStyle, baseControlStyle);
    }

    public List<ConvertedSelectItem> getConvertedItems(FacesContext context, UIPickList pickList) {
        ArrayList<ConvertedSelectItem> convertedItems = new ArrayList<ConvertedSelectItem>();
        List<SelectItem> selectItems = SelectUtils.getSelectItems(context, pickList);
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem item = selectItems.get(i);
            if (item instanceof SelectItemGroup) {
                SelectItem[] groupItems = ((SelectItemGroup)item).getSelectItems();
                for (int j = 0; j < groupItems.length; ++j) {
                    convertedItems.add(ConvertedSelectItem.get(context, pickList, groupItems[j], "group:" + j));
                }
                continue;
            }
            convertedItems.add(ConvertedSelectItem.get(context, pickList, item, Integer.toString(i)));
        }
        List<Object> valueItems = this.getValuesList(pickList);
        block2: for (ConvertedSelectItem item : convertedItems) {
            for (Object selectedValue : valueItems) {
                if (!item.getValue().equals(selectedValue)) continue;
                item.setSelected();
                continue block2;
            }
        }
        return convertedItems;
    }

    protected ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    protected String findLocalisedLabel(FacesContext context, String propertyId, String bundleName) {
        String label;
        block9: {
            label = null;
            Locale locale = null;
            String userBundleName = null;
            ResourceBundle bundle = null;
            UIViewRoot viewRoot = context.getViewRoot();
            locale = viewRoot != null ? viewRoot.getLocale() : Locale.getDefault();
            if (locale != null) {
                block8: {
                    try {
                        userBundleName = context.getApplication().getMessageBundle();
                        if (null != userBundleName && (bundle = ResourceBundle.getBundle(userBundleName, locale, this.getCurrentLoader(userBundleName))) != null) {
                            label = bundle.getString(propertyId);
                        }
                    }
                    catch (MissingResourceException e) {
                        if (!logger.isDebugEnabled()) break block8;
                        logger.debug("Can't find bundle properties file " + userBundleName + " " + locale.getLanguage() + " " + locale.getCountry());
                    }
                }
                if (label == null && bundleName != null) {
                    try {
                        bundle = ResourceBundle.getBundle(bundleName, locale, this.getCurrentLoader(bundleName));
                        if (bundle != null) {
                            label = bundle.getString(propertyId);
                        }
                    }
                    catch (MissingResourceException e) {
                        if (!logger.isDebugEnabled()) break block9;
                        logger.debug("Can't find bundle properties file " + bundleName + " " + locale.getLanguage() + " " + locale.getCountry());
                    }
                }
            }
        }
        return label;
    }

    protected void renderDefaultControl(FacesContext context, UIComponent component, ResponseWriter writer, OrderingComponentRendererBase.ControlsHelper helper, String clientId, boolean enabled, String baseStyle, String baseControlStyle) throws IOException {
        UIComponent facet = component.getFacet(this.getAltAttribbute(helper));
        boolean useFacet = facet != null && facet.isRendered();
        String customEvent = null;
        Map<String, Object> attributes = component.getAttributes();
        if (helper.customEvent != null) {
            customEvent = (String)attributes.get(helper.customEvent);
        }
        String styleFromAttribute = (String)attributes.get(helper.styleFromAttribute);
        String baseStyleLight = baseStyle.concat("-light");
        String baseStylePress = baseStyle.concat("-press");
        String currentStyle = baseControlStyle + helper.getStyleClassName();
        if (styleFromAttribute != null) {
            currentStyle = styleFromAttribute.concat(currentStyle);
        }
        String controlId = clientId + helper.getIdSuffix();
        writer.startElement("div", component);
        writer.writeAttribute("id", controlId, null);
        writer.writeAttribute("class", currentStyle, null);
        String style = enabled ? "display:block;" : "display:none;";
        writer.writeAttribute("style", style, null);
        if (!useFacet) {
            writer.startElement("div", component);
            writer.writeAttribute("class", baseStyle + helper.getButtonStyleClass(), null);
            if (helper.enable) {
                writer.writeAttribute("onmouseover", "this.className='" + baseStyleLight + "'", null);
                writer.writeAttribute("onmousedown", "this.className='" + baseStylePress + "'", null);
                writer.writeAttribute("onmouseup", "this.className='" + baseStyle + "'", null);
                writer.writeAttribute("onmouseout", "this.className='" + baseStyle + "'", null);
            }
            if (helper.enable) {
                writer.startElement("a", component);
                writer.writeAttribute("id", controlId + "link", null);
                writer.writeAttribute("onclick", "return false;", null);
                writer.writeAttribute("class", baseStyle + "-selection", null);
                writer.writeAttribute("onblur", "Richfaces.Control.onblur(this);", null);
                writer.writeAttribute("onfocus", "Richfaces.Control.onfocus(this);", null);
            }
            writer.startElement("div", component);
            writer.writeAttribute("class", baseStyle + "-content", null);
        }
        if (customEvent != null) {
            writer.writeAttribute("onclick", customEvent, null);
        }
        if (useFacet) {
            this.renderChild(context, facet);
        } else {
            writer.startElement("img", component);
            writer.writeAttribute("class", "rich-picklist-control-img", null);
            writer.writeAttribute("alt", component.getAttributes().get(helper.getTitle()), null);
            writer.writeAttribute("src", this.getResource(helper.getImageURI()).getUri(context, null), null);
            writer.endElement("img");
            if (this.getUtils().isBooleanAttribute(component, SHOW_LABELS_ATTRIBUTE_NAME)) {
                String label = (String)attributes.get(helper.getLabelAttributeName());
                if (label == null || label.equals("")) {
                    label = this.findLocalisedLabel(context, helper.getBundlePropertyName(), MESSAGE_BUNDLE_NAME);
                }
                if (label == null || label.equals("")) {
                    label = helper.getDefaultText();
                }
                writer.write(label);
            }
        }
        if (!useFacet) {
            writer.endElement("div");
            if (helper.enable) {
                writer.endElement("a");
            }
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    private String getAltAttribbute(OrderingComponentRendererBase.ControlsHelper helper) {
        return helper.getFacetName() != null ? helper.getFacetName() : " ";
    }

    public void reRenderScript(FacesContext context, UIComponent component) throws IOException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
        Set<String> areas = ajaxContext.getAjaxRenderedAreas();
        String clientId = component.getClientId(context);
        if (ajaxContext.isAjaxRequest() && areas.contains(clientId)) {
            areas.add(clientId + "script");
        }
    }

    protected static final class ListStateFlags {
        protected boolean isSelectedList;
        protected boolean isAvailableList;
    }
}

