/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.resource.CountingOutputWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIProgressBar;
import org.richfaces.renderkit.TemplateEncoderRendererBase;

public class AbstractProgressBarRenderer
extends TemplateEncoderRendererBase {
    private static final Log log = LogFactory.getLog(AbstractProgressBarRenderer.class);
    private static final String AJAX_POLL_FUNCTION = "A4J.AJAX.Poll";

    protected void doDecode(FacesContext facesContext, UIComponent uiComponent) {
        new AjaxEvent(uiComponent).queue();
    }

    public void renderForcedState(String state, FacesContext context, UIComponent component) throws IOException {
        if ("initialState".equals(state)) {
            this.encodeInitialState(context, component, true);
        } else if ("progressState".equals(state)) {
            this.encodeProgressState(context, component, true);
        } else if ("completeState".equals(state)) {
            this.encodeCompletedState(context, component, true);
        }
        component.getAttributes().remove("forcePercent");
    }

    public String getForcedState(FacesContext context, UIComponent component) {
        String forcedState = null;
        Map<String, String> params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey("forcePercent")) {
            forcedState = params.get("forcePercent");
        }
        return forcedState;
    }

    public StringBuffer getMarkup(FacesContext context, UIComponent component) {
        StringBuffer result = new StringBuffer();
        CountingOutputWriter customWriter = new CountingOutputWriter();
        try {
            if (this.hasChildren(component)) {
                ResponseWriter writer = context.getResponseWriter();
                String defaultRenderKitId = context.getApplication().getDefaultRenderKitId();
                if (null == defaultRenderKitId) {
                    defaultRenderKitId = "HTML_BASIC";
                }
                RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
                RenderKit renderKit = renderKitFactory.getRenderKit(context, defaultRenderKitId);
                ResponseWriter responseWriter = renderKit.createResponseWriter(customWriter, null, "UTF-8");
                context.setResponseWriter(responseWriter);
                this.writeScriptBody(context, component, true);
                result = customWriter.getContent();
                if (writer != null) {
                    context.setResponseWriter(writer);
                } else {
                    HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
                    PrintWriter wr = response.getWriter();
                    if (wr != null) {
                        context.setResponseWriter(renderKit.createResponseWriter(wr, null, "UTF-8"));
                    }
                }
            } else {
                this.writeScriptBody(customWriter, (String)component.getAttributes().get("label"));
                result = customWriter.getContent();
            }
        }
        catch (Exception e) {
            log.error("Error occurred during rendering of progress bar label. It switched to empty string", e);
        }
        return result;
    }

    public void encodePollScript(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIProgressBar progressBar = (UIProgressBar)component;
        String clientId = component.getClientId(context);
        StringBuffer pollScript = new StringBuffer("\n");
        StringBuffer script = new StringBuffer("\n");
        if (this.isAjaxMode(component) && progressBar.isEnabled()) {
            JSFunction function = AjaxRendererUtils.buildAjaxFunction(component, context, AJAX_POLL_FUNCTION);
            function.addParameter(new JSReference("$('" + clientId + "').component.options"));
            function.appendScript(script);
            pollScript.append(script);
        } else {
            pollScript.append(this.getStopPollScript(clientId));
        }
        pollScript.append(";\n");
        writer.writeText(pollScript.toString(), null);
    }

    public void encodeRenderStateScript(FacesContext context, UIComponent component, String state) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringBuffer script = new StringBuffer("\n");
        script.append("$('" + component.getClientId(context) + "').component.renderState('").append(state).append("');");
        writer.write(script.toString());
    }

    public void encodeLabelScript(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringBuffer script = new StringBuffer("\n");
        script.append("$('" + component.getClientId(context) + "').component.renderLabel(").append(this.getMarkup(context, component)).append(",null);\n");
        writer.append(script.toString());
    }

    public void encodeInitialScript(FacesContext context, UIComponent component, String state) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIProgressBar progressBar = (UIProgressBar)component;
        ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
        StringBuffer script = new StringBuffer();
        HashMap<String, Object> options = new HashMap<String, Object>();
        RendererUtils utils = this.getUtils();
        String clientId = component.getClientId(context);
        utils.addToScriptHash(options, "mode", component.getAttributes().get("mode"), "ajax");
        utils.addToScriptHash(options, "minValue", component.getAttributes().get("minValue"), "0");
        utils.addToScriptHash(options, "maxValue", component.getAttributes().get("maxValue"), "100");
        utils.addToScriptHash(options, "context", this.getContext(component));
        StringBuffer markup = this.getMarkup(context, component);
        utils.addToScriptHash(options, "markup", markup != null ? new JSLiteral(markup.toString()) : null);
        utils.addToScriptHash(options, "options", this.buildAjaxOptions(clientId, progressBar, context));
        utils.addToScriptHash(options, "progressVar", component.getAttributes().get("progressVar"));
        utils.addToScriptHash(options, "state", state, "initialState");
        utils.addToScriptHash(options, "value", variables.getVariable("value"));
        script.append("new ProgressBar('").append(clientId).append("'");
        if (!options.isEmpty()) {
            script.append(",").append(ScriptUtils.toScript(options));
        }
        script.append(")\n;");
        writer.write(script.toString());
    }

    private Map buildAjaxOptions(String clientId, UIProgressBar progressBar, FacesContext context) {
        Map<String, Object> options = AjaxRendererUtils.buildEventOptions(context, (UIComponent)progressBar, true);
        Integer interval = new Integer(progressBar.getInterval());
        options.put("pollId", clientId);
        options.put("pollinterval", interval);
        JSFunctionDefinition onsubmit = this.getUtils().getAsEventHandler(context, progressBar, "onsubmit", "");
        if (onsubmit != null) {
            options.put("onsubmit", onsubmit);
        }
        if (progressBar.getAttributes().containsKey("ignoreDupResponses")) {
            options.put("ignoreDupResponses", progressBar.getAttributes().get("ignoreDupResponses"));
        }
        Map parameters = (Map)options.get("parameters");
        parameters.put("percent", "percent");
        parameters.put(clientId, clientId);
        parameters.put("ajaxSingle", clientId);
        return options;
    }

    private boolean isAjaxMode(UIComponent component) {
        String mode = (String)component.getAttributes().get("mode");
        return "ajax".equalsIgnoreCase(mode);
    }

    public void encodeClientMode(FacesContext context, UIComponent component, Number value, Number min, Number max) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        String state = value.doubleValue() <= min.doubleValue() ? "initialState" : (value.doubleValue() >= max.doubleValue() ? "completeState" : "progressState");
        writer.startElement("div", component);
        writer.writeAttribute("id", clientId, null);
        this.encodeInitialState(context, component, false);
        this.encodeProgressState(context, component, false);
        this.encodeCompletedState(context, component, false);
        this.startScript(writer, component);
        this.encodeInitialScript(context, component, state);
        this.encodeLabelScript(context, component);
        this.encodeRenderStateScript(context, component, state);
        this.endScript(writer, component);
        writer.endElement("div");
    }

    public void encodeInitialState(FacesContext context, UIComponent component, boolean isAjaxMode) throws IOException {
        String clientId = component.getClientId(context);
        String initialClass = (String)component.getAttributes().get("initialClass");
        String style = (String)component.getAttributes().get("style");
        if (null == style) {
            style = "";
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", component);
        this.getUtils().writeAttribute(writer, "class", initialClass);
        this.getUtils().writeAttribute(writer, "style", style + (!isAjaxMode ? "display: none" : ""));
        writer.writeAttribute("id", isAjaxMode ? clientId : clientId + ":initialState", null);
        UIComponent initial = component.getFacet("initial");
        if (initial != null) {
            this.renderChild(context, initial);
        }
        if (isAjaxMode) {
            this.startScript(writer, component);
            this.encodeInitialScript(context, component, "initialState");
            this.encodePollScript(context, component);
            this.endScript(writer, component);
        }
        writer.endElement("div");
    }

    public void encodeProgressState(FacesContext context, UIComponent component, boolean isAjaxMode) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
        String clientId = component.getClientId(context);
        String styleClass = (String)variables.getVariable("styleClass");
        boolean isSimple = this.isSimpleMarkup(component);
        String style = (String)component.getAttributes().get("style");
        if (null == style) {
            style = "";
        }
        String shellClass = !isSimple ? "rich-progress-bar-shell-dig " : "rich-progress-bar-shell ";
        writer.startElement("div", component);
        this.getUtils().writeAttribute(writer, "class", "rich-progress-bar-block rich-progress-bar-width " + shellClass + (styleClass != null ? styleClass : ""));
        this.getUtils().writeAttribute(writer, "id", isAjaxMode ? clientId : clientId + ":progressState");
        this.getUtils().writeAttribute(writer, "style", style + (!isAjaxMode ? "display: none" : ""));
        this.getUtils().encodePassThruWithExclusions(context, component, "onsubmit");
        this.encodeProgressBar(context, component, isSimple);
        if (isAjaxMode) {
            this.startScript(writer, component);
            this.encodeInitialScript(context, component, "progressState");
            this.encodeLabelScript(context, component);
            this.encodePollScript(context, component);
            this.endScript(writer, component);
        }
        writer.endElement("div");
    }

    public void encodeProgressBar(FacesContext context, UIComponent component, boolean isSimple) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
        Number value = (Number)variables.getVariable("percent");
        String width = String.valueOf(value.intValue());
        String style = (String)component.getAttributes().get("style");
        if (null == style) {
            style = "";
        }
        String completeClass = (String)component.getAttributes().get("completeClass");
        String remainClass = (String)component.getAttributes().get("remainClass");
        if (!isSimple) {
            writer.startElement("div", component);
            this.getUtils().writeAttribute(writer, "class", "rich-progress-bar-width rich-progress-bar-remained rich-progress-bar-padding " + remainClass);
            this.getUtils().writeAttribute(writer, "id", clientId + ":remain");
            this.getUtils().writeAttribute(writer, "style", style);
            writer.endElement("div");
            writer.startElement("div", component);
            this.getUtils().writeAttribute(writer, "class", "rich-progress-bar-uploaded-dig");
            this.getUtils().writeAttribute(writer, "id", clientId + ":upload");
            this.getUtils().writeAttribute(writer, "style", (style != null ? style + ";" : "") + " width: " + width + "%;");
            writer.startElement("div", component);
            this.getUtils().writeAttribute(writer, "class", "rich-progress-bar-height-dig rich-progress-bar-width rich-progress-bar-completed rich-progress-bar-padding " + completeClass);
            this.getUtils().writeAttribute(writer, "id", clientId + ":complete");
            this.getUtils().writeAttribute(writer, "style", style);
            writer.endElement("div");
            writer.endElement("div");
        } else {
            writer.startElement("div", component);
            this.getUtils().writeAttribute(writer, "class", "rich-progress-bar-height rich-progress-bar-uploaded " + completeClass);
            this.getUtils().writeAttribute(writer, "id", clientId + ":upload");
            this.getUtils().writeAttribute(writer, "style", (style != null ? style + ";" : "") + " width: " + width + "%;");
            writer.write(" ");
            writer.endElement("div");
        }
    }

    public String getParameters(UIComponent component) {
        String parameters = (String)component.getAttributes().get("parameters");
        return parameters;
    }

    private void startScript(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("span", component);
        writer.writeAttribute("style", "display: none;", null);
        writer.startElement("script", component);
        writer.writeAttribute("type", "text/javascript", null);
    }

    private void endScript(ResponseWriter writer, UIComponent component) throws IOException {
        writer.endElement("script");
        writer.endElement("span");
    }

    private JSLiteral getContext(UIComponent component) {
        StringBuffer buffer = new StringBuffer();
        String parameters = this.getParameters(component);
        JSLiteral literal = null;
        if (parameters != null) {
            buffer.append("{").append(parameters).append("}");
            literal = new JSLiteral(buffer.toString());
        }
        return literal;
    }

    private boolean hasChildren(UIComponent component) {
        return component.getChildCount() != 0;
    }

    public boolean isSimpleMarkup(UIComponent component) {
        if (this.hasChildren(component)) {
            return false;
        }
        return component.getAttributes().get("label") == null;
    }

    public void encodeCompletedState(FacesContext context, UIComponent component, boolean isAjaxMode) throws IOException {
        String clientId = component.getClientId(context);
        String finishClass = (String)component.getAttributes().get("finishClass");
        String style = (String)component.getAttributes().get("style");
        if (null == style) {
            style = "";
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", component);
        writer.writeAttribute("id", isAjaxMode ? clientId : clientId + ":completeState", null);
        this.getUtils().writeAttribute(writer, "class", finishClass);
        this.getUtils().writeAttribute(writer, "style", style + (!isAjaxMode ? "display: none" : ""));
        UIComponent completed = component.getFacet("complete");
        if (completed != null) {
            this.renderChild(context, completed);
        }
        if (isAjaxMode) {
            this.startScript(writer, component);
            this.encodeInitialScript(context, component, "completeState");
            writer.write(this.getStopPollScript(clientId).toString());
            this.endScript(writer, component);
        }
        writer.endElement("div");
    }

    public Number getNumber(Object v) {
        Number result = null;
        if (v != null) {
            try {
                if (v instanceof String) {
                    result = Double.parseDouble((String)v);
                } else {
                    Number n = (Number)v;
                    if (n instanceof BigDecimal || n instanceof Double || n instanceof Float) {
                        result = Float.valueOf(n.floatValue());
                    } else if (n instanceof Integer || n instanceof Long) {
                        result = n.longValue();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
        return new Integer(0);
    }

    public Number calculatePercent(Number value, Number minValue, Number maxValue) {
        if (minValue.doubleValue() < value.doubleValue() && value.doubleValue() < maxValue.doubleValue()) {
            return (value.doubleValue() - minValue.doubleValue()) * 100.0 / (maxValue.doubleValue() - minValue.doubleValue());
        }
        if (value.doubleValue() <= minValue.doubleValue()) {
            return 0;
        }
        if (value.doubleValue() >= maxValue.doubleValue()) {
            return 100;
        }
        return 0;
    }

    private StringBuffer getStopPollScript(String clientId) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("A4J.AJAX.StopPoll('").append(clientId).append("');\n");
        return buffer;
    }

    protected Class getComponentClass() {
        return UIProgressBar.class;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }
}

