/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.el;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.el.CapturingELResolver;
import org.richfaces.el.ELContextWrapper;
import org.richfaces.el.GenericsIntrospectionService;

public class GenericsIntrospectionServiceImpl
implements GenericsIntrospectionService {
    private final LoadingCache<Class<?>, GenericsCacheEntry> cache = CacheBuilder.newBuilder().weakKeys().softValues().build(CacheLoader.from(new Function<Class<?>, GenericsCacheEntry>(){

        @Override
        public GenericsCacheEntry apply(Class<?> input) {
            return new GenericsCacheEntry(input);
        }
    }));

    private Class<?> getGenericCollectionType(FacesContext context, Object base, String propertyName) {
        Class<?> beanClass;
        Class<?> genericPropertyClass = null;
        if (base != null && propertyName != null && !Map.class.isAssignableFrom(beanClass = base.getClass()) && !ResourceBundle.class.isAssignableFrom(beanClass)) {
            try {
                return this.cache.get(beanClass).getContainerClass(propertyName);
            }
            catch (ExecutionException e) {
                throw new FacesException(String.format("Can't resolve the beanClass '%s' from propertyName '%s'", beanClass, propertyName), e);
            }
        }
        return genericPropertyClass;
    }

    @Override
    public Class<?> getContainerClass(FacesContext facesContext, ValueExpression expression) {
        CapturingELResolver capturingELResolver;
        ELContext initialELContext = facesContext.getELContext();
        Class<?> type = expression.getType(new ELContextWrapper(initialELContext, capturingELResolver = new CapturingELResolver(initialELContext.getELResolver())));
        Class<?> containerType = type.getComponentType();
        if (containerType == null && type != null && Collection.class.isAssignableFrom(type)) {
            Object base = capturingELResolver.getBase();
            Object property = capturingELResolver.getProperty();
            if (base != null && property != null) {
                containerType = this.getGenericCollectionType(facesContext, base, property.toString());
            }
        }
        return containerType;
    }

    private static final class GenericsCacheEntry {
        private Class<?> beanClass;
        private LoadingCache<String, Class<?>> containerClassesMap = CacheBuilder.newBuilder().initialCapacity(2).build(CacheLoader.from(new Function<String, Class<?>>(){

            @Override
            public Class<?> apply(String input) {
                PropertyDescriptor propertyDescriptor = GenericsCacheEntry.this.getPropertyDescriptor(input);
                return GenericsCacheEntry.this.getGenericContainerClass(propertyDescriptor);
            }
        }));

        public GenericsCacheEntry(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        private Class<?> resolveType(Type type) {
            Type actualType;
            ParameterizedType parameterizedType;
            Type[] types;
            Class result = Object.class;
            if (type instanceof ParameterizedType && (types = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()) != null && types.length != 0 && (actualType = types[0]) instanceof Class) {
                result = (Class)actualType;
            }
            return result;
        }

        private Class<?> getGenericContainerClass(PropertyDescriptor pd) {
            if (pd == null) {
                return null;
            }
            Method readMethod = pd.getReadMethod();
            if (readMethod == null) {
                return null;
            }
            return this.resolveType(readMethod.getGenericReturnType());
        }

        private PropertyDescriptor getPropertyDescriptor(String propertyName) {
            PropertyDescriptor[] propertyDescriptorsArray;
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(this.beanClass);
            }
            catch (IntrospectionException e) {
                throw new FacesException(e.getMessage(), e);
            }
            finally {
                Introspector.flushFromCaches(this.beanClass);
            }
            if (beanInfo == null) {
                return null;
            }
            for (PropertyDescriptor pd : propertyDescriptorsArray = beanInfo.getPropertyDescriptors()) {
                if (!propertyName.equals(pd.getName())) continue;
                return pd;
            }
            return null;
        }

        public Class<?> getContainerClass(String propertyName) throws ExecutionException {
            return this.containerClassesMap.get(propertyName);
        }
    }
}

