/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import com.google.common.collect.Lists;
import java.util.Collection;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

final class RowsFunctionContextCallback
implements ContextCallback {
    private final String image;
    private UIComponent component;
    private Collection<String> convertedKeys = Lists.newArrayList();

    RowsFunctionContextCallback(String image) {
        this.image = image;
    }

    @Override
    public void invokeContextCallback(FacesContext context, UIComponent target) {
        this.component = target;
        Converter rowKeyConverter = (Converter)target.getAttributes().get("rowKeyConverter");
        Collection keys = (Collection)context.getApplication().evaluateExpressionGet(context, "#{" + this.image + "}", Object.class);
        if (keys == null) {
            return;
        }
        for (Object key : keys) {
            String convertedKey = rowKeyConverter != null ? rowKeyConverter.getAsString(context, target, key) : key.toString();
            this.convertedKeys.add(convertedKey);
        }
    }

    public UIComponent getComponent() {
        return this.component;
    }

    public Collection<String> getConvertedKeys() {
        return this.convertedKeys;
    }
}

