/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextWrapper;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.util.FastJoiner;

public abstract class ExtendedVisitContext
extends VisitContextWrapper {
    public static final String META_COMPONENT_ID = "org.richfaces.MetaComponentId";
    private static final FastJoiner META_COMPONENT_SEPARATOR_JOINER = FastJoiner.on('@');
    private final FacesContext facesContext;
    private final ExtendedVisitContextMode visitMode;
    private final VisitContext wrappedVisitContext;

    @Override
    public VisitContext getWrapped() {
        return this.wrappedVisitContext;
    }

    protected ExtendedVisitContext(VisitContext visitContextToWrap, FacesContext facesContext, ExtendedVisitContextMode visitMode) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        this.facesContext = facesContext;
        this.visitMode = visitMode;
        this.wrappedVisitContext = visitContextToWrap;
    }

    public ExtendedVisitContextMode getVisitMode() {
        return this.visitMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisitResult invokeMetaComponentVisitCallback(UIComponent component, VisitCallback callback, String metaComponentId) {
        if (metaComponentId != null) {
            Map<Object, Object> attributes = this.getFacesContext().getAttributes();
            try {
                attributes.put(META_COMPONENT_ID, metaComponentId);
                VisitResult visitResult = this.invokeVisitCallback(component, callback);
                return visitResult;
            }
            finally {
                attributes.remove(META_COMPONENT_ID);
            }
        }
        return this.invokeVisitCallback(component, callback);
    }

    public String buildExtendedClientId(UIComponent component) {
        String metaComponentId = (String)this.facesContext.getAttributes().get(META_COMPONENT_ID);
        return META_COMPONENT_SEPARATOR_JOINER.join(component.getClientId(this.facesContext), metaComponentId);
    }

    public String buildExtendedComponentId(UIComponent component) {
        String metaComponentId = (String)this.facesContext.getAttributes().get(META_COMPONENT_ID);
        return META_COMPONENT_SEPARATOR_JOINER.join(component.getId(), metaComponentId);
    }

    @Override
    public FacesContext getFacesContext() {
        return this.facesContext;
    }

    public abstract Collection<String> getDirectSubtreeIdsToVisit(UIComponent var1);

    public abstract VisitContext createNamingContainerVisitContext(UIComponent var1, Collection<String> var2);
}

