/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.util;

import java.io.Serializable;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

public final class PartialStateHolderUtil {
    private PartialStateHolderUtil() {
    }

    public static Object saveState(FacesContext context, UIComponent component, Object objectToSave) {
        Object savedState = null;
        boolean nullDelta = true;
        boolean converterHasPartialState = false;
        if (component.initialStateMarked()) {
            if (objectToSave != null) {
                if (objectToSave instanceof PartialStateHolder) {
                    StateHolder holder = (StateHolder)objectToSave;
                    if (!holder.isTransient()) {
                        Object attachedState = holder.saveState(context);
                        if (attachedState != null) {
                            nullDelta = false;
                            savedState = attachedState;
                        }
                        converterHasPartialState = true;
                    } else {
                        savedState = null;
                    }
                } else {
                    savedState = UIComponentBase.saveAttachedState(context, objectToSave);
                    nullDelta = false;
                }
            }
            if (savedState == null && nullDelta) {
                return null;
            }
        } else {
            savedState = UIComponentBase.saveAttachedState(context, objectToSave);
        }
        return new StateHolderObject(converterHasPartialState, savedState);
    }

    public static Object restoreState(FacesContext context, Object savedState, Object existingObject) {
        if (savedState != null) {
            StateHolderObject stateHolderObject = (StateHolderObject)savedState;
            if (stateHolderObject.isPartialState()) {
                ((StateHolder)existingObject).restoreState(context, stateHolderObject.getSavedState());
                return existingObject;
            }
            return UIComponentBase.restoreAttachedState(context, stateHolderObject.getSavedState());
        }
        return null;
    }

    private static final class StateHolderObject
    implements Serializable {
        private static final long serialVersionUID = 6157742187482213801L;
        private boolean partialState;
        private Object savedState;

        public StateHolderObject(boolean partialState, Object savedState) {
            this.partialState = partialState;
            this.savedState = savedState;
        }

        public boolean isPartialState() {
            return this.partialState;
        }

        public Object getSavedState() {
            return this.savedState;
        }
    }
}

