/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.Iterator;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.component.AjaxActionComponent;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.component.IterationStateHolder;
import org.ajax4jsf.event.AjaxSource;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.event.SimpleTogglePanelSwitchEvent;

public abstract class UISimpleTogglePanel
extends AjaxActionComponent
implements AjaxComponent,
AjaxSource,
ActionSource,
IterationStateHolder {
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    public static final String SERVER_SWITCH_TYPE = "server";
    public static final String CLIENT_SWITCH_TYPE = "client";
    public static final String AJAX_SWITCH_TYPE = "ajax";
    @Deprecated
    public static final boolean COLLAPSED = false;
    @Deprecated
    public static final boolean EXPANDED = true;
    private transient Boolean wasOpened = Boolean.FALSE;
    private Object value;

    protected void setWasOpened(Boolean wasOpened) {
        this.wasOpened = wasOpened;
    }

    protected boolean isWasOpened() {
        return this.wasOpened;
    }

    public abstract void setSwitchType(String var1);

    public abstract String getSwitchType();

    public void setOpened(boolean opened) {
        this.setValue(new Boolean(opened).toString());
    }

    public boolean isOpened() {
        Object value = this.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            return Boolean.parseBoolean(s);
        }
        return true;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.setWasOpened(CLIENT_SWITCH_TYPE.equals(this.getSwitchType()) || this.isOpened());
        if (this.isWasOpened()) {
            Iterator<UIComponent> kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                kid.processDecodes(context);
            }
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        if (this.isWasOpened()) {
            Iterator<UIComponent> kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                kid.processValidators(context);
            }
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        if (this.isWasOpened()) {
            Iterator<UIComponent> kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                kid.processUpdates(context);
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof SimpleTogglePanelSwitchEvent && this.equals(event.getComponent())) {
            SimpleTogglePanelSwitchEvent switchEvent = (SimpleTogglePanelSwitchEvent)event;
            if (this.isImmediate()) {
                this.setOpened(switchEvent.isOpened());
            }
            switchEvent.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
        }
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof SimpleTogglePanelSwitchEvent) {
            SimpleTogglePanelSwitchEvent switchEvent = (SimpleTogglePanelSwitchEvent)event;
            this.setOpened(switchEvent.isOpened());
            try {
                this.updateModel();
            }
            catch (RuntimeException e) {
                this.getFacesContext().renderResponse();
                throw e;
            }
        }
    }

    protected Object getLocalValue() {
        return this.value;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        ValueExpression ve = this.getValueExpression("value");
        if (ve != null) {
            FacesContext context = this.getFacesContext();
            try {
                return ve.getValue(context.getELContext());
            }
            catch (ELException e) {
                throw new FacesException(e);
            }
        }
        return null;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.value};
        return state;
    }

    public void restoreState(FacesContext context, Object stateObject) {
        Object[] state = (Object[])stateObject;
        super.restoreState(context, state[0]);
        this.value = state[1];
    }

    public Object getIterationState() {
        Object[] state = new Object[]{this.value, this.wasOpened};
        return state;
    }

    public void setIterationState(Object stateObject) {
        if (stateObject != null) {
            Object[] state = (Object[])stateObject;
            this.value = state[0];
            this.wasOpened = (Boolean)state[1];
        } else {
            this.value = null;
            this.wasOpened = null;
        }
    }

    protected void updateModel() {
        Object value = this.getLocalValue();
        if (value != null) {
            ValueExpression ve = this.getValueExpression("value");
            FacesContext context = this.getFacesContext();
            if (ve != null && !ve.isReadOnly(context.getELContext())) {
                try {
                    ve.setValue(context.getELContext(), value);
                    this.setValue(null);
                }
                catch (ELException e) {
                    Throwable result;
                    String messageStr = e.getMessage();
                    for (result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                        messageStr = result.getMessage();
                    }
                    FacesMessage message = null == messageStr ? MessageUtil.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)}) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                    context.getExternalContext().log(message.getSummary(), result);
                    context.addMessage(this.getClientId(context), message);
                    context.renderResponse();
                }
                catch (IllegalArgumentException e) {
                    FacesMessage message = MessageUtil.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)});
                    context.getExternalContext().log(message.getSummary(), e);
                    context.addMessage(this.getClientId(context), message);
                    context.renderResponse();
                }
                catch (Exception e) {
                    FacesMessage message = MessageUtil.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)});
                    context.getExternalContext().log(message.getSummary(), e);
                    context.addMessage(this.getClientId(context), message);
                    context.renderResponse();
                }
            }
        }
    }
}

