/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.iterators.IteratorChain;
import org.richfaces.component.UITreeNodesAdaptor;
import org.richfaces.model.StackingTreeModel;
import org.richfaces.model.StackingTreeModelDataProvider;
import org.richfaces.model.VisualStackingTreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIRecursiveTreeNodesAdaptor
extends UITreeNodesAdaptor {
    protected static final String FIRST = "first";
    protected static final String LAST = "last";
    public static final String COMPONENT_TYPE = "org.richfaces.RecursiveTreeNodesAdaptor";
    public static final String COMPONENT_FAMILY = "org.richfaces.RecursiveTreeNodesAdaptor";

    public abstract Object getRoots();

    public abstract void setRoots(Object var1);

    public abstract boolean isIncluded();

    public abstract void setIncluded(boolean var1);

    public abstract boolean isIncludedRoot();

    public abstract void setIncludedRoot(boolean var1);

    public abstract String getRecursionOrder();

    public abstract void setRecursionOrder(String var1);

    @Override
    protected boolean includeNode() {
        return this.isIncluded() && this.isIncludedRoot();
    }

    @Override
    public Object getData() {
        return this.getRoots();
    }

    @Override
    public abstract String getVar();

    @Override
    public abstract void setVar(String var1);

    protected StackingTreeModel createRecursiveModel() {
        VisualStackingTreeModel recursiveModel = new VisualStackingTreeModel(this.getId(), this.getVar(), new StackingTreeModelDataProvider(){

            public Object getData() {
                return UIRecursiveTreeNodesAdaptor.this.getNodes();
            }
        }, this){

            @Override
            public StackingTreeModel getModelById(String id) {
                StackingTreeModel model = super.getModelById(id);
                if (model == null) {
                    model = this.getParent().getModelById(id);
                }
                return model;
            }

            @Override
            public Iterator<StackingTreeModel> getModelsIterator() {
                IteratorChain chain = new IteratorChain();
                chain.addIterator(super.getModelsIterator());
                chain.addIterator(this.getParent().getModelsIterator());
                return chain;
            }

            @Override
            protected boolean isActive() {
                return UIRecursiveTreeNodesAdaptor.this.isRendered();
            }

            @Override
            protected boolean isActiveData() {
                return UIRecursiveTreeNodesAdaptor.this.isIncluded() && UIRecursiveTreeNodesAdaptor.this.isIncludedNode();
            }
        };
        return recursiveModel;
    }

    @Override
    protected void addChildModels(StackingTreeModel model, List<StackingTreeModel> childModels) {
        String recursionOrder = this.getRecursionOrder();
        if (recursionOrder == null) {
            recursionOrder = LAST;
        }
        ArrayList<StackingTreeModel> newModelsList = new ArrayList<StackingTreeModel>(childModels.size() + 1);
        boolean recursiveModelInserted = false;
        for (StackingTreeModel childModel : childModels) {
            newModelsList.add(childModel);
            if (!recursionOrder.equals(childModel.getId())) continue;
            recursiveModelInserted = true;
            newModelsList.add(this.createRecursiveModel());
        }
        if (!recursiveModelInserted) {
            if (LAST.equals(recursionOrder)) {
                newModelsList.add(this.createRecursiveModel());
            } else if (FIRST.equals(recursionOrder)) {
                newModelsList.add(0, this.createRecursiveModel());
            } else {
                throw new IllegalArgumentException("Recursion order: [" + recursionOrder + "] cannot be processed by component " + this.getClientId(this.getFacesContext()) + "!");
            }
        }
        super.addChildModels(model, newModelsList);
    }
}

